
# MMApatScale.py

"""
	This module is an integeral part of the program 
	MMA - Musical Midi Accompaniment.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	Bob van der Poel <bvdp@uniserve.com>
	
"""
	



import random
from MMAharmony import harmonize
import MMAglobals;  gbl = MMAglobals
from MMAcommon import *
from MMApat import PC


class Scale(PC):
	""" Pattern class for a Scale track. """

	vtype = 'SCALE'
	
	lastScale = None
	lastType = 'x'
	lastDirect = 1
	lastRange = 0
	sOffset = 0
	notes = None
	dirfact = 1

	def getPgroup(self, ev):
		""" Get group for scale patterns.
		
			Tuples: [start, length, volume]
		"""

		a = struct()
		if len(ev) != 3:	
			error("There must be at exactly 3 items in each group " 
				"in a Scale definition, not <%s>." % ' '.join(ev))
			
		a.vol = stoi(ev[2],"Type error in Scale definition")

		a.duration = getNoteLen(ev[1])				
					
		a.offset = self.setBarOffset(ev[0])	
					
		return a
	
	def getScale(self, c, root, len):
		if c == 'm':
			s = [0, 2, 3, 5, 7, 8, 10, 12]	# natural minor
		elif c == 'M':
			s = [0, 2, 4, 5, 7, 9, 11, 12]	# major
		elif c == 'c':
			s = range(0,12)
		
		scale=[]
		for t in range(len):
			for n in s:
				scale.append(n + t*12)
			

		return [root + x for x in scale]
	

	def trackBar(self, pattern, ctable):
		""" Do a scale bar.
		
			Called from self.bar()
		"""
	
		sc = self.seq
		direct = self.direction[sc]
		unify = self.unify[sc]
		
		# Set/check any difference in the range setting between
		# this and the previous bar.

		t = self.chordRange[sc]
		if t != self.lastRange:
			self.lastRange = t
			self.notes = None
			
		if self.lastDirect != direct:
			self.lastDirect = direct
			self.notes = None

		for p in pattern:
		
			tb = self.getChordInPos(p.offset, ctable)
			
			if tb.scaleZ:
				continue
			
			root = tb.chord.root()	 		# root note of chord
			ctype = tb.chord.type()			# M, m, 7, m6,  etc.
			scale = tb.chord.scale()		# C, Eb, etc		

			
			# We set a new run of notes if the chordtype changes between
			# major and minor or if there isn't a note run.
			# This also resets the sOffset, the current position
			# in the run.
			
			if (ctype[0] == 'm' and self.lastType[0] != 'm') or \
					(ctype[0] != 'm' and self.lastType[0] == 'm') or \
					(not self.notes):
				
				self.lastScale = scale
				self.lastType = ctype
	
				ocount = 3
				
				if self.chordRange[sc]:
					ocount = self.chordRange[sc]

				stype = self.scaleType[sc]
				
				if stype == "CHROMATIC":
					self.notes = self.getScale('c', root, ocount)
				elif stype == 'MAJOR':
					self.notes = self.getScale('M', root, ocount)
				elif stype == 'MINOR':
					self.notes = self.getScale('m', root, ocount)
				else:
					if ctype[0] == 'm':
						self.notes=self.getScale('m', root, ocount)
					else:
						self.notes=self.getScale('M', root, ocount)

				if direct == 'DOWN':
					self.dirfact = -1
					self.sOffset = len(self.notes)-1
				else:
					self.dirfact = 1
					self.sOffset = 0


			# Keep offset into note list in range
			
			if self.sOffset >= len(self.notes):
				if direct == 'BOTH':
					self.dirfact = -1
					self.sOffset = len(self.notes)-2
				else:
					self.sOffset = 0
					
			elif self.sOffset < 0:
				if direct == 'BOTH':
					self.dirfact = 1
					self.sOffset = 1
				else:
					self.sOffset = len(self.notes)-1
					
			if direct == 'RANDOM':
				note = random.choice(self.notes)
			else:
				note = self.notes[self.sOffset] 
				self.sOffset += self.dirfact
			
			v=self.adjustVolume(p.vol, p.offset)
			if not v:
				continue

			if not self.harmonyOnly[sc]:
				gbl.mtrks[self.channel].addPairToTrack(
					p.offset,
					self.rTime[sc],
					self.getDur(p.duration),
					self.adjustNote(note),
					v, unify )
	
			if self.duplicate[sc]:
				n = self.adjustNote(note) + self.duplicate[sc]
				if n>=0 and n<128:
					gbl.mtrks[self.channel].addPairToTrack(
						p.offset,
						self.rTime[sc],
						self.getDur(p.duration),
						n,	v, unify )

			if self.harmony[sc]:
				ch = self.getChordInPos(p.offset, ctable).chord.notes()
				h = harmonize(self.harmony[sc], note, ch)
				for n in h:
					gbl.mtrks[self.channel].addPairToTrack(
						p.offset,
						self.rTime[sc],
						self.getDur(p.duration),
						self.adjustNote(n), 
						self.adjustVolume(p.vol, -1),
						unify )


