/***************************************************
	mined keyboard mapping table
	* generated with mkkbmap
	  from lib/kbmaps/cxterm/ks/HANJA.tit
	* with additional punctuation mappings
*/
struct keymap keymap_HANJA [] = {
	{"!", "！"},
	{"#", "〃 々 〆 〇 〜 ￦"},
	{"$", "￦"},
	{"&", "―"},
	{"(", "（"},
	{")", "）"},
	{",", "，"},
	{".", "。"},
	{":", "："},
	{";", "；"},
	{"<", "〈"},
	{"<<", "《"},
	{">", "〉"},
	{">>", "》"},
	{"?", "？"},
	{"@", "・"},
	{"[", "【 〖 〔 「 『"},
	{"\\", "、"},
	{"]", "】 〗 〕 」 』"},
	{"^", "……"},
	{"_", "――"},
	{"«", "《"},
	{"»", "》"},
	{"€", "€ ＄ ￥ ￦ ￡ ￠ ￢ ￣"},

	{"rk", "가 伽 佳 假 價 加 可 呵 哥 嘉 嫁 家 暇 架 枷 柯 歌 珂 痂 稼 苛 茄 街 袈 訶 賈 跏 軻 迦 駕"},
	{"ro", "개 介 价 個 凱 塏 愷 愾 慨 改 槪 漑 疥 皆 盖 箇 芥 蓋 豈 鎧 開"},
	{"ri", "갸"},
	{"rO", "걔"},
	{"rj", "거 倨 去 居 巨 拒 据 據 擧 渠 炬 祛 距 踞 車 遽 鉅 鋸"},
	{"rp", "게 偈 憩 揭"},
	{"ru", "겨"},
	{"rP", "계 係 啓 堺 契 季 屆 悸 戒 桂 械 棨 溪 界 癸 磎 稽 系 繫 繼 計 誡 谿 階 鷄"},
	{"rh", "고 古 叩 告 呱 固 姑 孤 尻 庫 拷 攷 故 敲 暠 枯 槁 沽 痼 皐 睾 稿 羔 考 股 膏 苦 苽 菰 藁 蠱 袴 誥 賈 辜 錮 雇 顧 高 鼓"},
	{"rK", "과 寡 戈 果 瓜 科 菓 誇 課 跨 過 鍋 顆"},
	{"rH", "괘 卦 掛 罫"},
	{"rL", "괴 乖 傀 塊 壞 怪 愧 拐 槐 魁"},
	{"ry", "교 交 僑 咬 喬 嬌 嶠 巧 攪 敎 校 橋 狡 皎 矯 絞 翹 膠 蕎 蛟 較 轎 郊 餃 驕 鮫"},
	{"rn", "구 丘 久 九 仇 俱 具 勾 區 口 句 咎 嘔 坵 垢 寇 嶇 廐 懼 拘 救 枸 柩 構 歐 毆 毬 求 溝 灸 狗 玖 球 瞿 矩 究 絿 耉 臼 舅 舊 苟 衢 謳 購 軀 逑 邱 鉤 銶 駒 驅 鳩 鷗 龜"},
	{"rJ", "궈"},
	{"rN", "궤 机 櫃 潰 詭 軌 饋 句"},
	{"rB", "귀 晷 歸 貴 鬼 龜"},
	{"rb", "규 叫 圭 奎 揆 槻 珪 硅 窺 竅 糾 葵 規 赳 逵 閨"},
	{"rm", "그"},
	{"rM", "긔"},
	{"rl", "기 企 伎 其 冀 嗜 器 圻 基 埼 夔 奇 妓 寄 岐 崎 己 幾 忌 技 旗 旣 朞 期 杞 棋 棄 機 欺 氣 汽 沂 淇 玘 琦 琪 璂 璣 畸 畿 碁 磯 祁 祇 祈 祺 箕 紀 綺 羈 耆 耭 肌 記 譏 豈 起 錡 錤 飢 饑 騎 騏 驥 麒"},
	{"Rk", "까"},
	{"Ro", "깨"},
	{"Ri", "꺄"},
	{"Rj", "꺼"},
	{"Rp", "께"},
	{"Ru", "껴"},
	{"RP", "꼐"},
	{"Rh", "꼬"},
	{"RK", "꽈"},
	{"RH", "꽤"},
	{"RL", "꾀"},
	{"Ry", "꾜"},
	{"Rn", "꾸"},
	{"RJ", "꿔"},
	{"RN", "꿰"},
	{"RB", "뀌"},
	{"Rb", "뀨"},
	{"Rm", "끄"},
	{"Rl", "끼"},
	{"sk", "나 儺 喇 奈 娜 懦 懶 拏 拿 癩 羅 蘿 螺 裸 邏 那"},
	{"so", "내 乃 來 內 奈 柰 耐"},
	{"si", "냐"},
	{"sj", "너"},
	{"sp", "네"},
	{"su", "녀 女"},
	{"sP", "녜"},
	{"sh", "노 努 勞 奴 弩 怒 擄 櫓 爐 瑙 盧 老 蘆 虜 路 露 駑 魯 鷺"},
	{"sK", "놔"},
	{"sL", "뇌 惱 牢 磊 腦 賂 雷"},
	{"sy", "뇨 尿"},
	{"sn", "누 壘 屢 樓 淚 漏 累 縷 陋"},
	{"sJ", "눠"},
	{"sN", "눼"},
	{"sB", "뉘"},
	{"sb", "뉴 杻 紐"},
	{"sm", "느"},
	{"sM", "늬"},
	{"sl", "니 尼 泥"},
	{"ek", "다 多 茶"},
	{"eo", "대 代 垈 坮 大 對 岱 帶 待 戴 擡 玳 臺 袋 貸 隊 黛"},
	{"ei", "댜"},
	{"ej", "더"},
	{"ep", "데"},
	{"eu", "뎌"},
	{"eP", "뎨"},
	{"eh", "도 倒 刀 到 圖 堵 塗 導 屠 島 嶋 度 徒 悼 挑 掉 搗 桃 棹 櫂 淘 渡 滔 濤 燾 盜 睹 禱 稻 萄 覩 賭 跳 蹈 逃 途 道 都 鍍 陶 韜"},
	{"eK", "돠"},
	{"eH", "돼"},
	{"eL", "되"},
	{"ey", "됴"},
	{"en", "두 兜 斗 杜 枓 痘 竇 荳 讀 豆 逗 頭"},
	{"eJ", "둬"},
	{"eN", "뒈"},
	{"eB", "뒤"},
	{"eb", "듀"},
	{"em", "드"},
	{"eM", "듸"},
	{"el", "디"},
	{"Ek", "따"},
	{"Eo", "때"},
	{"Ej", "떠"},
	{"Ep", "떼"},
	{"Eu", "뗘"},
	{"Eh", "또"},
	{"EK", "똬"},
	{"EH", "뙈"},
	{"EL", "뙤"},
	{"En", "뚜"},
	{"EN", "뛔"},
	{"EB", "뛰"},
	{"Em", "뜨"},
	{"EM", "띄"},
	{"El", "띠"},
	{"fk", "라 喇 懶 拏 癩 羅 蘿 螺 裸 邏"},
	{"fo", "래 來 崍 徠 萊"},
	{"fi", "랴"},
	{"fj", "러"},
	{"fp", "레"},
	{"fu", "려 侶 儷 勵 呂 廬 慮 戾 旅 櫚 濾 礪 藜 蠣 閭 驢 驪 麗 黎"},
	{"fP", "례 例 澧 禮 醴 隷"},
	{"fh", "로 勞 怒 撈 擄 櫓 潞 瀘 爐 盧 老 蘆 虜 路 輅 露 魯 鷺 鹵"},
	{"fK", "롸"},
	{"fL", "뢰 儡 瀨 牢 磊 賂 賚 賴 雷"},
	{"fy", "료 了 僚 寮 廖 料 燎 療 瞭 聊 蓼 遼 鬧"},
	{"fn", "루 壘 婁 屢 樓 淚 漏 瘻 累 縷 蔞 褸 鏤 陋"},
	{"fJ", "뤄"},
	{"fN", "뤠"},
	{"fB", "뤼"},
	{"fb", "류 劉 旒 柳 榴 流 溜 瀏 琉 瑠 留 瘤 硫 謬 類"},
	{"fm", "르"},
	{"fl", "리 俚 利 厘 吏 唎 履 悧 李 梨 浬 犁 狸 理 璃 異 痢 籬 罹 羸 莉 裏 裡 里 釐 離 鯉"},
	{"ak", "마 摩 瑪 痲 碼 磨 馬 魔 麻"},
	{"ao", "매 埋 妹 媒 寐 昧 枚 梅 每 煤 罵 買 賣 邁 魅"},
	{"ai", "먀"},
	{"aj", "머"},
	{"ap", "메"},
	{"au", "며"},
	{"aP", "몌 袂"},
	{"ah", "모 侮 冒 募 姆 帽 慕 摸 摹 暮 某 模 母 毛 牟 牡 瑁 眸 矛 耗 芼 茅 謀 謨 貌"},
	{"aK", "뫄"},
	{"aL", "뫼"},
	{"ay", "묘 卯 墓 妙 廟 描 昴 杳 渺 猫 竗 苗 錨"},
	{"an", "무 務 巫 憮 懋 戊 拇 撫 无 楙 武 毋 無 珷 畝 繆 舞 茂 蕪 誣 貿 霧 鵡"},
	{"aJ", "뭐"},
	{"aN", "뭬"},
	{"aB", "뮈"},
	{"ab", "뮤"},
	{"am", "므"},
	{"al", "미 味 媚 尾 嵋 彌 微 未 梶 楣 渼 湄 眉 米 美 薇 謎 迷 靡 黴"},
	{"qk", "바"},
	{"qo", "배 倍 俳 北 培 徘 拜 排 杯 湃 焙 盃 背 胚 裴 裵 褙 賠 輩 配 陪"},
	{"qi", "뱌"},
	{"qj", "버"},
	{"qp", "베"},
	{"qu", "벼"},
	{"qP", "볘"},
	{"qh", "보 保 堡 報 寶 普 步 洑 湺 潽 珤 甫 菩 補 褓 譜 輔"},
	{"qK", "봐"},
	{"qH", "봬"},
	{"qL", "뵈"},
	{"qy", "뵤"},
	{"qn", "부 不 付 俯 傅 剖 副 否 咐 埠 夫 婦 孚 孵 富 府 復 扶 敷 斧 浮 溥 父 符 簿 缶 腐 腑 膚 艀 芙 莩 訃 負 賦 賻 赴 趺 部 釜 阜 附 駙 鳧"},
	{"qJ", "붜"},
	{"qN", "붸"},
	{"qB", "뷔"},
	{"qb", "뷰"},
	{"qm", "브"},
	{"ql", "비 丕 備 匕 匪 卑 妃 婢 庇 悲 憊 扉 批 斐 枇 榧 比 毖 毗 毘 沸 泌 琵 痺 砒 碑 秕 秘 粃 緋 翡 肥 脾 臂 菲 蜚 裨 誹 譬 費 鄙 非 飛 鼻"},
	{"Qk", "빠"},
	{"Qo", "빼"},
	{"Qi", "뺘"},
	{"Qj", "뻐"},
	{"Qp", "뻬"},
	{"Qu", "뼈"},
	{"Qh", "뽀"},
	{"QL", "뾔"},
	{"Qy", "뾰"},
	{"Qn", "뿌"},
	{"Qb", "쀼"},
	{"Qm", "쁘"},
	{"Ql", "삐"},
	{"tk", "사 乍 事 些 仕 伺 似 使 俟 僿 史 司 唆 嗣 四 士 奢 娑 寫 寺 射 巳 師 徙 思 捨 斜 斯 柶 査 梭 死 沙 泗 渣 瀉 獅 砂 社 祀 祠 私 篩 紗 絲 肆 舍 莎 蓑 蛇 裟 詐 詞 謝 賜 赦 辭 邪 飼 駟 麝"},
	{"to", "새 塞 璽 賽"},
	{"ti", "샤"},
	{"tO", "섀"},
	{"tj", "서 墅 壻 嶼 序 庶 徐 恕 抒 捿 敍 暑 曙 書 栖 棲 犀 瑞 筮 絮 緖 署 胥 舒 薯 西 誓 逝 鋤 黍 鼠"},
	{"tp", "세 世 勢 歲 洗 稅 笹 細 說 貰"},
	{"tu", "셔"},
	{"tP", "셰"},
	{"th", "소 召 嘯 塑 宵 小 少 巢 所 掃 搔 昭 梳 沼 消 溯 瀟 炤 燒 甦 疏 疎 瘙 笑 篠 簫 素 紹 蔬 蕭 蘇 訴 逍 遡 邵 銷 韶 騷"},
	{"tK", "솨"},
	{"tH", "쇄 刷 殺 灑 碎 鎖"},
	{"tL", "쇠 衰 釗"},
	{"ty", "쇼"},
	{"tn", "수 修 受 嗽 囚 垂 壽 嫂 守 岫 峀 帥 愁 戍 手 授 搜 收 數 樹 殊 水 洙 漱 燧 狩 獸 琇 璲 瘦 睡 秀 穗 竪 粹 綏 綬 繡 羞 脩 茱 蒐 蓚 藪 袖 誰 讐 輸 遂 邃 酬 銖 銹 隋 隧 隨 雖 需 須 首 髓 鬚"},
	{"tJ", "숴"},
	{"tN", "쉐"},
	{"tB", "쉬"},
	{"tb", "슈"},
	{"tm", "스"},
	{"tl", "시 侍 匙 嘶 始 媤 尸 屎 屍 市 弑 恃 施 是 時 枾 柴 猜 矢 示 翅 蒔 蓍 視 試 詩 諡 豕 豺"},
	{"Tk", "싸"},
	{"To", "쌔"},
	{"Tj", "써"},
	{"Tp", "쎄"},
	{"Th", "쏘"},
	{"TK", "쏴"},
	{"TH", "쐐"},
	{"TL", "쐬"},
	{"Ty", "쑈"},
	{"Tn", "쑤"},
	{"TJ", "쒀"},
	{"TN", "쒜"},
	{"TB", "쒸"},
	{"Tm", "쓰"},
	{"TM", "씌"},
	{"Tl", "씨 氏"},
	{"dk", "아 亞 俄 兒 啞 娥 峨 我 牙 芽 莪 蛾 衙 訝 阿 雅 餓 鴉 鵝"},
	{"do", "애 厓 哀 埃 崖 愛 曖 涯 碍 艾 隘 靄"},
	{"di", "야 也 倻 冶 夜 惹 揶 椰 爺 耶 若 野"},
	{"dO", "얘"},
	{"dj", "어 圄 御 於 漁 瘀 禦 語 馭 魚 齬"},
	{"dp", "에"},
	{"du", "여 予 余 勵 呂 女 如 廬 旅 歟 汝 濾 璵 礖 礪 與 艅 茹 輿 轝 閭 餘 驪 麗 黎"},
	{"dP", "예 乂 倪 例 刈 叡 曳 汭 濊 猊 睿 穢 芮 藝 蘂 禮 裔 詣 譽 豫 醴 銳 隸 霓 預"},
	{"dh", "오 五 伍 俉 傲 午 吾 吳 嗚 塢 墺 奧 娛 寤 悟 惡 懊 敖 旿 晤 梧 汚 澳 烏 熬 獒 筽 蜈 誤 鰲 鼇"},
	{"dK", "와 渦 瓦 窩 窪 臥 蛙 蝸 訛"},
	{"dH", "왜 倭 娃 歪 矮"},
	{"dL", "외 外 嵬 巍 猥 畏"},
	{"dy", "요 了 僚 僥 凹 堯 夭 妖 姚 寥 寮 尿 嶢 拗 搖 撓 擾 料 曜 樂 橈 燎 燿 瑤 療 窈 窯 繇 繞 耀 腰 蓼 蟯 要 謠 遙 遼 邀 饒"},
	{"dn", "우 于 佑 偶 優 又 友 右 宇 寓 尤 愚 憂 旴 牛 玗 瑀 盂 祐 禑 禹 紆 羽 芋 藕 虞 迂 遇 郵 釪 隅 雨 雩"},
	{"dJ", "워"},
	{"dN", "웨"},
	{"dB", "위 位 偉 僞 危 圍 委 威 尉 慰 暐 渭 爲 瑋 緯 胃 萎 葦 蔿 蝟 衛 褘 謂 違 韋 魏"},
	{"db", "유 乳 侑 儒 兪 劉 唯 喩 孺 宥 幼 幽 庾 悠 惟 愈 愉 揄 攸 有 杻 柔 柚 柳 楡 楢 油 洧 流 游 溜 濡 猶 猷 琉 瑜 由 留 癒 硫 紐 維 臾 萸 裕 誘 諛 諭 踰 蹂 遊 逾 遺 酉 釉 鍮 類"},
	{"dm", "으"},
	{"dM", "의 依 倚 儀 宜 意 懿 擬 椅 毅 疑 矣 義 艤 薏 蟻 衣 誼 議 醫"},
	{"dl", "이 二 以 伊 利 吏 夷 姨 履 已 弛 彛 怡 易 李 梨 泥 爾 珥 理 異 痍 痢 移 罹 而 耳 肄 苡 荑 裏 裡 貽 貳 邇 里 離 飴 餌"},
	{"wk", "자 仔 刺 咨 姉 姿 子 字 孜 恣 慈 滋 炙 煮 玆 瓷 疵 磁 紫 者 自 茨 蔗 藉 諮 資 雌"},
	{"wo", "재 再 哉 在 宰 才 材 栽 梓 渽 滓 災 縡 裁 財 載 齋 齎"},
	{"wi", "쟈"},
	{"wO", "쟤"},
	{"wj", "저 佇 低 儲 咀 姐 底 抵 杵 楮 樗 沮 渚 狙 猪 疽 箸 紵 苧 菹 著 藷 詛 貯 躇 這 邸 雎 齟"},
	{"wp", "제 制 劑 啼 堤 帝 弟 悌 提 梯 濟 祭 第 臍 薺 製 諸 蹄 醍 除 際 霽 題 齊"},
	{"wu", "져"},
	{"wP", "졔"},
	{"wh", "조 俎 兆 凋 助 嘲 弔 彫 措 操 早 晁 曺 曹 朝 條 棗 槽 漕 潮 照 燥 爪 璪 眺 祖 祚 租 稠 窕 粗 糟 組 繰 肇 藻 蚤 詔 調 趙 躁 造 遭 釣 阻 雕 鳥"},
	{"wK", "좌 佐 坐 左 座 挫"},
	{"wH", "좨"},
	{"wL", "죄 罪"},
	{"wy", "죠"},
	{"wn", "주 主 住 侏 做 姝 胄 呪 周 嗾 奏 宙 州 廚 晝 朱 柱 株 注 洲 湊 澍 炷 珠 疇 籌 紂 紬 綢 舟 蛛 註 誅 走 躊 輳 週 酎 酒 鑄 駐"},
	{"wJ", "줘"},
	{"wN", "줴"},
	{"wB", "쥐"},
	{"wb", "쥬"},
	{"wm", "즈"},
	{"wl", "지 之 只 咫 地 址 志 持 指 摯 支 旨 智 枝 枳 止 池 沚 漬 知 砥 祉 祗 紙 肢 脂 至 芝 芷 蜘 誌 識 贄 趾 遲"},
	{"Wk", "짜"},
	{"Wo", "째"},
	{"Wi", "쨔"},
	{"Wj", "쩌"},
	{"Wp", "쩨"},
	{"Wu", "쪄"},
	{"Wh", "쪼"},
	{"WK", "쫘"},
	{"WH", "쫴"},
	{"WL", "쬐"},
	{"Wn", "쭈"},
	{"WJ", "쭤"},
	{"WB", "쮜"},
	{"Wb", "쮸"},
	{"Wm", "쯔"},
	{"Wl", "찌"},
	{"ck", "차 且 侘 借 叉 嗟 嵯 差 次 此 磋 箚 茶 蹉 車 遮"},
	{"co", "채 債 埰 寀 寨 彩 採 砦 綵 菜 蔡 采 釵"},
	{"ci", "챠"},
	{"cj", "처 凄 妻 悽 處"},
	{"cp", "체 切 剃 替 涕 滯 締 諦 逮 遞 體"},
	{"cu", "쳐"},
	{"cP", "쳬"},
	{"ch", "초 初 剿 哨 憔 抄 招 梢 椒 楚 樵 炒 焦 硝 礁 礎 秒 稍 肖 艸 苕 草 蕉 貂 超 酢 醋 醮"},
	{"cK", "촤"},
	{"cL", "최 催 崔 最"},
	{"cy", "쵸"},
	{"cn", "추 墜 抽 推 椎 楸 樞 湫 皺 秋 芻 萩 諏 趨 追 鄒 酋 醜 錐 錘 鎚 雛 騶 鰍"},
	{"cJ", "춰"},
	{"cN", "췌 悴 膵 萃"},
	{"cB", "취 贅 取 吹 嘴 娶 就 炊 翠 聚 脆 臭 趣 醉 驟 鷲"},
	{"cb", "츄"},
	{"cm", "츠"},
	{"cl", "치 侈 値 嗤 峙 幟 恥 梔 治 淄 熾 痔 痴 癡 稚 穉 緇 緻 置 致 蚩 輜 雉 馳 齒"},
	{"zk", "카"},
	{"zo", "캐"},
	{"zi", "캬"},
	{"zj", "커"},
	{"zp", "케"},
	{"zu", "켜"},
	{"zP", "켸"},
	{"zh", "코"},
	{"zK", "콰"},
	{"zH", "쾌 快"},
	{"zL", "쾨"},
	{"zy", "쿄"},
	{"zn", "쿠"},
	{"zJ", "쿼"},
	{"zN", "퀘"},
	{"zB", "퀴"},
	{"zb", "큐"},
	{"zm", "크"},
	{"zl", "키"},
	{"xk", "타 他 咤 唾 墮 妥 惰 打 拖 朶 楕 舵 陀 馱 駝"},
	{"xo", "태 兌 台 太 怠 態 殆 汰 泰 笞 胎 苔 跆 邰 颱"},
	{"xi", "탸"},
	{"xj", "터 攄"},
	{"xp", "테"},
	{"xu", "텨"},
	{"xP", "톄"},
	{"xh", "토 兎 吐 土 討"},
	{"xK", "톼"},
	{"xH", "퇘"},
	{"xL", "퇴 堆 槌 腿 褪 退 頹"},
	{"xy", "툐"},
	{"xn", "투 偸 套 妬 投 透 鬪"},
	{"xJ", "퉈"},
	{"xN", "퉤"},
	{"xB", "튀"},
	{"xb", "튜"},
	{"xm", "트"},
	{"xM", "틔"},
	{"xl", "티"},
	{"vk", "파 闖 坡 婆 巴 把 播 擺 杷 波 派 爬 琶 破 罷 芭 跛 頗"},
	{"vo", "패 佩 唄 悖 敗 沛 浿 牌 狽 稗 覇 貝"},
	{"vi", "퍄"},
	{"vj", "퍼"},
	{"vp", "페"},
	{"vu", "펴"},
	{"vP", "폐 吠 嬖 幣 廢 弊 斃 肺 蔽 閉 陛"},
	{"vh", "포 佈 包 匍 匏 咆 哺 圃 布 怖 抛 抱 捕 暴 泡 浦 疱 砲 胞 脯 苞 葡 蒲 袍 褒 逋 鋪 飽 鮑"},
	{"vK", "퐈"},
	{"vL", "푀"},
	{"vy", "표 俵 剽 彪 慓 杓 標 漂 瓢 票 表 豹 飇 飄 驃"},
	{"vn", "푸"},
	{"vJ", "풔"},
	{"vB", "퓌"},
	{"vb", "퓨"},
	{"vm", "프"},
	{"vl", "피 彼 披 疲 皮 被 避 陂"},
	{"gk", "하 下 何 厦 夏 廈 昰 河 瑕 荷 蝦 賀 遐 霞 鰕"},
	{"go", "해 亥 偕 咳 垓 奚 孩 害 懈 楷 海 瀣 蟹 解 該 諧 邂 駭 骸"},
	{"gi", "햐"},
	{"gj", "허 噓 墟 虛 許"},
	{"gp", "헤"},
	{"gu", "혀"},
	{"gP", "혜 兮 彗 惠 慧 暳 蕙 蹊 醯 鞋"},
	{"gh", "호 乎 互 呼 壕 壺 好 岵 弧 戶 扈 昊 晧 毫 浩 淏 湖 滸 澔 濠 濩 灝 狐 琥 瑚 瓠 皓 祜 糊 縞 胡 芦 葫 蒿 虎 號 蝴 護 豪 鎬 頀 顥"},
	{"gK", "화 化 和 嬅 樺 火 畵 禍 禾 花 華 話 譁 貨 靴"},
	{"gH", "홰"},
	{"gL", "회 匯 回 廻 徊 恢 悔 懷 晦 會 檜 淮 澮 灰 獪 繪 膾 茴 蛔 誨 賄"},
	{"gy", "효 哮 嚆 孝 效 斅 曉 梟 涍 淆 爻 肴 酵 驍"},
	{"gn", "후 侯 候 厚 后 吼 喉 嗅 帿 後 朽 煦 珝 逅"},
	{"gJ", "훠"},
	{"gN", "훼 卉 喙 毁"},
	{"gB", "휘 彙 徽 揮 暉 煇 諱 輝 麾"},
	{"gb", "휴 休 携 烋 畦 虧"},
	{"gm", "흐"},
	{"gM", "희 僖 凞 喜 噫 囍 姬 嬉 希 憙 憘 戱 晞 曦 熙 熹 熺 犧 禧 稀 羲"},
	{"gl", "히"},
	{"rkr", "각 刻 却 各 恪 慤 殼 珏 脚 覺 角 閣"},
	{"rks", "간 侃 刊 墾 奸 姦 干 幹 懇 揀 杆 柬 桿 澗 癎 看 磵 稈 竿 簡 肝 艮 艱 諫 間"},
	{"rke", "갇"},
	{"rkf", "갈 乫 喝 曷 渴 碣 竭 葛 褐 蝎 鞨"},
	{"rkG", "갉"},
	{"rkM", "갊"},
	{"rka", "감 勘 坎 堪 嵌 感 憾 戡 敢 柑 橄 減 甘 疳 監 瞰 紺 邯 鑑 鑒 龕"},
	{"rkq", "갑 匣 岬 甲 胛 鉀 閘"},
	{"rkC", "값"},
	{"rkt", "갓"},
	{"rkT", "갔"},
	{"rkd", "강 剛 堈 姜 岡 崗 康 强 彊 慷 江 畺 疆 糠 絳 綱 羌 腔 舡 薑 襁 講 鋼 降 鱇"},
	{"rkw", "갖"},
	{"rkc", "갗"},
	{"rkx", "같"},
	{"rkv", "갚"},
	{"rkg", "갛"},
	{"ror", "객 喀 客"},
	{"ros", "갠"},
	{"rof", "갤"},
	{"roa", "갬"},
	{"roq", "갭"},
	{"rot", "갯"},
	{"roT", "갰"},
	{"rod", "갱 坑 更 粳 羹"},
	{"rir", "갹 醵"},
	{"ris", "갼"},
	{"rif", "걀"},
	{"rit", "걋"},
	{"rid", "걍"},
	{"rOs", "걘"},
	{"rOf", "걜"},
	{"rjr", "걱"},
	{"rjs", "건 乾 件 健 巾 建 愆 楗 腱 虔 蹇 鍵 騫"},
	{"rje", "걷"},
	{"rjf", "걸 乞 傑 杰 桀"},
	{"rjM", "걺"},
	{"rja", "검 儉 劍 劒 檢 瞼 鈐 黔"},
	{"rjq", "겁 劫 怯 迲"},
	{"rjt", "것"},
	{"rjT", "겄"},
	{"rjd", "겅"},
	{"rjw", "겆"},
	{"rjx", "겉"},
	{"rjv", "겊"},
	{"rjg", "겋"},
	{"rps", "겐"},
	{"rpf", "겔"},
	{"rpa", "겜"},
	{"rpq", "겝"},
	{"rpt", "겟"},
	{"rpT", "겠"},
	{"rpd", "겡"},
	{"rur", "격 擊 格 檄 激 膈 覡 隔"},
	{"ruR", "겪"},
	{"rus", "견 堅 牽 犬 甄 絹 繭 肩 見 譴 遣 鵑"},
	{"rue", "겯"},
	{"ruf", "결 抉 決 潔 結 缺 訣"},
	{"rua", "겸 兼 慊 箝 謙 鉗 鎌"},
	{"ruq", "겹"},
	{"rut", "겻"},
	{"ruT", "겼"},
	{"rud", "경 京 俓 倞 傾 儆 勁 勍 卿 坰 境 庚 徑 慶 憬 擎 敬 景 暻 更 梗 涇 炅 烱 璟 璥 瓊 痙 硬 磬 竟 競 絅 經 耕 耿 脛 莖 警 輕 逕 鏡 頃 頸 驚 鯨"},
	{"rux", "곁"},
	{"rPs", "곈"},
	{"rPf", "곌"},
	{"rPq", "곕"},
	{"rPt", "곗"},
	{"rhr", "곡 哭 斛 曲 梏 穀 谷 鵠"},
	{"rhs", "곤 困 坤 崑 昆 梱 棍 滾 琨 袞 鯤"},
	{"rhe", "골 汨 滑 骨"},
	{"rhf", "골"},
	{"rhM", "곪"},
	{"rhN", "곬"},
	{"rhF", "곯"},
	{"rha", "곰"},
	{"rhq", "곱"},
	{"rht", "곳"},
	{"rhd", "공 供 公 共 功 孔 工 恐 恭 拱 控 攻 珙 空 蚣 貢 鞏"},
	{"rhw", "곶 串"},
	{"rKr", "곽 廓 槨 藿 郭"},
	{"rKs", "관 串 冠 官 寬 慣 棺 款 灌 琯 瓘 管 罐 菅 觀 貫 關 館"},
	{"rKf", "괄 刮 恝 括 适"},
	{"rKM", "괆"},
	{"rKa", "괌"},
	{"rKq", "괍"},
	{"rKt", "괏"},
	{"rKd", "광 侊 光 匡 壙 廣 曠 洸 炚 狂 珖 筐 胱 鑛"},
	{"rHs", "괜"},
	{"rHf", "괠"},
	{"rHq", "괩"},
	{"rHT", "괬"},
	{"rHd", "괭"},
	{"rLr", "괵"},
	{"rLs", "괸"},
	{"rLf", "괼"},
	{"rLa", "굄"},
	{"rLq", "굅"},
	{"rLt", "굇"},
	{"rLd", "굉 宏 紘 肱 轟"},
	{"rys", "굔"},
	{"ryf", "굘"},
	{"ryq", "굡"},
	{"ryt", "굣"},
	{"rnr", "국 國 局 菊 鞠 鞫 麴"},
	{"rns", "군 君 窘 群 裙 軍 郡"},
	{"rne", "굳"},
	{"rnf", "굴 堀 屈 掘 窟"},
	{"rnG", "굵"},
	{"rnM", "굶"},
	{"rnF", "굻"},
	{"rna", "굼"},
	{"rnq", "굽"},
	{"rnt", "굿"},
	{"rnd", "궁 宮 弓 穹 窮 芎 躬"},
	{"rnw", "궂"},
	{"rJr", "궉"},
	{"rJs", "권 倦 券 勸 卷 圈 拳 捲 權 淃 眷"},
	{"rJf", "궐 厥 獗 蕨 蹶 闕"},
	{"rJT", "궜"},
	{"rJd", "궝"},
	{"rNt", "궷"},
	{"rBr", "귁"},
	{"rBs", "귄"},
	{"rBf", "귈"},
	{"rBa", "귐"},
	{"rBq", "귑"},
	{"rBt", "귓"},
	{"rbs", "균 勻 均 畇 筠 菌 鈞 龜"},
	{"rbf", "귤 橘"},
	{"rmr", "극 克 剋 劇 戟 棘 極 隙"},
	{"rms", "근 僅 劤 勤 懃 斤 根 槿 瑾 筋 芹 菫 覲 謹 近 饉"},
	{"rme", "귿"},
	{"rmf", "글 契"},
	{"rmG", "긁"},
	{"rma", "금 今 妗 擒 昑 檎 琴 禁 禽 芩 衾 衿 襟 金 錦"},
	{"rmq", "급 伋 及 急 扱 汲 級 給"},
	{"rmt", "긋"},
	{"rmd", "긍 亘 兢 矜 肯"},
	{"rlr", "긱"},
	{"rls", "긴 緊"},
	{"rle", "긷"},
	{"rlf", "길 佶 吉 拮 桔"},
	{"rlM", "긺"},
	{"rla", "김 金"},
	{"rlq", "깁"},
	{"rlt", "깃"},
	{"rld", "깅"},
	{"rlw", "깆"},
	{"rlv", "깊"},
	{"Rkr", "깍"},
	{"RkR", "깎"},
	{"Rks", "깐"},
	{"Rkf", "깔"},
	{"RkM", "깖"},
	{"Rka", "깜"},
	{"Rkq", "깝"},
	{"Rkt", "깟"},
	{"RkT", "깠"},
	{"Rkd", "깡"},
	{"Rkx", "깥"},
	{"Ror", "깩"},
	{"Ros", "깬"},
	{"Rof", "깰"},
	{"Roa", "깸"},
	{"Roq", "깹"},
	{"Rot", "깻"},
	{"RoT", "깼"},
	{"Rod", "깽"},
	{"Rir", "꺅"},
	{"Rif", "꺌"},
	{"Rjr", "꺽"},
	{"RjR", "꺾"},
	{"Rjs", "껀"},
	{"Rjf", "껄"},
	{"Rja", "껌"},
	{"Rjq", "껍"},
	{"Rjt", "껏"},
	{"RjT", "껐"},
	{"Rjd", "껑"},
	{"Rpr", "껙"},
	{"Rps", "껜"},
	{"Rpa", "껨"},
	{"Rpt", "껫"},
	{"Rpd", "껭"},
	{"Rus", "껸"},
	{"Ruf", "껼"},
	{"Rut", "꼇"},
	{"RuT", "꼈"},
	{"Rux", "꼍"},
	{"Rhr", "꼭"},
	{"Rhs", "꼰"},
	{"RhH", "꼲"},
	{"Rhf", "꼴"},
	{"Rha", "꼼"},
	{"Rhq", "꼽"},
	{"Rht", "꼿"},
	{"Rhd", "꽁"},
	{"Rhw", "꽂"},
	{"Rhc", "꽃"},
	{"RKr", "꽉"},
	{"RKf", "꽐"},
	{"RKT", "꽜"},
	{"RKd", "꽝"},
	{"RHr", "꽥"},
	{"RHd", "꽹"},
	{"RLs", "꾄"},
	{"RLf", "꾈"},
	{"RLa", "꾐"},
	{"RLq", "꾑"},
	{"RLd", "꾕"},
	{"Rnr", "꾹"},
	{"Rns", "꾼"},
	{"Rnf", "꿀"},
	{"RnF", "꿇"},
	{"Rna", "꿈"},
	{"Rnq", "꿉"},
	{"Rnt", "꿋"},
	{"Rnd", "꿍"},
	{"Rnw", "꿎"},
	{"RJf", "꿜"},
	{"RJT", "꿨"},
	{"RJd", "꿩"},
	{"RNr", "꿱"},
	{"RNs", "꿴"},
	{"RNf", "꿸"},
	{"RNa", "뀀"},
	{"RNq", "뀁"},
	{"RNT", "뀄"},
	{"RBs", "뀐"},
	{"RBf", "뀔"},
	{"RBa", "뀜"},
	{"RBq", "뀝"},
	{"Rmr", "끅"},
	{"Rms", "끈"},
	{"RmH", "끊"},
	{"Rmf", "끌"},
	{"RmM", "끎"},
	{"RmF", "끓"},
	{"Rma", "끔"},
	{"Rmq", "끕"},
	{"Rmt", "끗"},
	{"Rmd", "끙"},
	{"Rmx", "끝"},
	{"Rlr", "끽 喫"},
	{"Rls", "낀"},
	{"Rlf", "낄"},
	{"Rla", "낌"},
	{"Rlq", "낍"},
	{"Rlt", "낏"},
	{"Rld", "낑"},
	{"skr", "낙 樂 洛 烙 珞 落 諾 酪 駱"},
	{"skR", "낚"},
	{"sks", "난 亂 卵 暖 欄 煖 爛 蘭 難 鸞"},
	{"ske", "낟"},
	{"skf", "날 捏 捺"},
	{"skG", "낡"},
	{"skM", "낢"},
	{"ska", "남 南 嵐 枏 楠 湳 濫 男 藍 襤"},
	{"skq", "납 拉 納 臘 蠟 衲"},
	{"skt", "낫"},
	{"skT", "났"},
	{"skd", "낭 囊 娘 廊 朗 浪 狼 郎"},
	{"skw", "낮"},
	{"skc", "낯"},
	{"skx", "낱"},
	{"skg", "낳"},
	{"sor", "낵"},
	{"sos", "낸"},
	{"sof", "낼"},
	{"soa", "냄"},
	{"soq", "냅"},
	{"sot", "냇"},
	{"soT", "냈"},
	{"sod", "냉 冷"},
	{"sir", "냑"},
	{"sis", "냔"},
	{"sif", "냘"},
	{"sia", "냠"},
	{"sid", "냥"},
	{"sjr", "넉"},
	{"sjS", "넋"},
	{"sjs", "넌"},
	{"sjf", "널"},
	{"sjM", "넒"},
	{"sjA", "넓"},
	{"sja", "넘"},
	{"sjq", "넙"},
	{"sjt", "넛"},
	{"sjT", "넜"},
	{"sjd", "넝"},
	{"sjg", "넣"},
	{"spr", "넥"},
	{"sps", "넨"},
	{"spf", "넬"},
	{"spa", "넴"},
	{"spq", "넵"},
	{"spt", "넷"},
	{"spT", "넸"},
	{"spd", "넹"},
	{"sur", "녁"},
	{"sus", "년 年 撚 秊"},
	{"suf", "녈"},
	{"sua", "념 念 恬 拈 捻"},
	{"suq", "녑"},
	{"suT", "녔"},
	{"sud", "녕 寧 寗"},
	{"suz", "녘"},
	{"sPs", "녠"},
	{"shr", "녹 碌 祿 綠 菉 錄 鹿"},
	{"shs", "논 論"},
	{"shf", "놀"},
	{"shM", "놂"},
	{"sha", "놈"},
	{"shq", "놉"},
	{"sht", "놋"},
	{"shd", "농 壟 弄 濃 籠 聾 膿 農"},
	{"shv", "높"},
	{"shg", "놓"},
	{"sKs", "놘"},
	{"sKf", "놜"},
	{"sKT", "놨"},
	{"sLs", "뇐"},
	{"sLf", "뇔"},
	{"sLa", "뇜"},
	{"sLq", "뇝"},
	{"sLt", "뇟"},
	{"syr", "뇩"},
	{"sys", "뇬"},
	{"syf", "뇰"},
	{"syq", "뇹"},
	{"syt", "뇻"},
	{"syd", "뇽"},
	{"snr", "눅"},
	{"sns", "눈 嫩"},
	{"sne", "눋"},
	{"snf", "눌 訥"},
	{"sna", "눔"},
	{"snq", "눕"},
	{"snt", "눗"},
	{"snd", "눙"},
	{"sJT", "눴"},
	{"sBs", "뉜"},
	{"sBf", "뉠"},
	{"sBa", "뉨"},
	{"sBq", "뉩"},
	{"sbr", "뉵"},
	{"sbf", "뉼"},
	{"sba", "늄"},
	{"sbq", "늅"},
	{"sbd", "늉"},
	{"smr", "늑 勒 肋"},
	{"sms", "는"},
	{"smf", "늘"},
	{"smG", "늙"},
	{"smM", "늚"},
	{"sma", "늠 凜"},
	{"smq", "늡"},
	{"smt", "늣"},
	{"smd", "능 凌 稜 綾 能 菱 陵"},
	{"smw", "늦"},
	{"smv", "늪"},
	{"sMs", "늰"},
	{"sMf", "늴"},
	{"slr", "닉 匿 溺"},
	{"sls", "닌"},
	{"slf", "닐"},
	{"slM", "닒"},
	{"sla", "님"},
	{"slq", "닙"},
	{"slt", "닛"},
	{"sld", "닝"},
	{"slv", "닢"},
	{"ekr", "닥"},
	{"ekR", "닦"},
	{"eks", "단 丹 亶 但 單 團 壇 彖 斷 旦 檀 段 湍 短 端 簞 緞 蛋 袒 鄲 鍛"},
	{"eke", "닫"},
	{"ekf", "달 撻 澾 獺 疸 達"},
	{"ekG", "닭"},
	{"ekM", "닮"},
	{"ekA", "닯"},
	{"ekF", "닳"},
	{"eka", "담 啖 坍 憺 擔 曇 淡 湛 潭 澹 痰 聃 膽 蕁 覃 談 譚 錟"},
	{"ekq", "답 沓 畓 答 踏 遝"},
	{"ekt", "닷"},
	{"ekT", "닸"},
	{"ekd", "당 唐 堂 塘 幢 戇 撞 棠 當 糖 螳 黨"},
	{"ekw", "닺"},
	{"ekc", "닻"},
	{"ekg", "닿"},
	{"eor", "댁 宅 德 悳"},
	{"eos", "댄"},
	{"eof", "댈"},
	{"eoa", "댐"},
	{"eoq", "댑"},
	{"eot", "댓"},
	{"eoT", "댔"},
	{"eod", "댕"},
	{"ejr", "덕"},
	{"ejR", "덖"},
	{"ejs", "던"},
	{"eje", "덛"},
	{"ejf", "덜"},
	{"ejM", "덞"},
	{"ejA", "덟"},
	{"eja", "덤"},
	{"ejq", "덥"},
	{"ejt", "덧"},
	{"ejd", "덩"},
	{"ejc", "덫"},
	{"ejv", "덮"},
	{"epr", "덱"},
	{"eps", "덴"},
	{"epf", "델"},
	{"epa", "뎀"},
	{"epq", "뎁"},
	{"ept", "뎃"},
	{"epT", "뎄"},
	{"epd", "뎅"},
	{"eus", "뎐"},
	{"euf", "뎔"},
	{"euT", "뎠"},
	{"eud", "뎡"},
	{"ePs", "뎬"},
	{"ehr", "독 毒 瀆 牘 犢 獨 督 禿 篤 纛 讀"},
	{"ehs", "돈 墩 惇 敦 旽 暾 沌 焞 燉 豚 頓"},
	{"ehe", "돋"},
	{"ehf", "돌 乭 突"},
	{"ehM", "돎"},
	{"ehN", "돐"},
	{"eha", "돔"},
	{"ehq", "돕"},
	{"eht", "돗"},
	{"ehd", "동 仝 冬 凍 動 同 憧 東 桐 棟 洞 潼 疼 瞳 童 胴 董 銅"},
	{"ehc", "돛"},
	{"ehx", "돝"},
	{"eKs", "돤"},
	{"eKf", "돨"},
	{"eHT", "됐"},
	{"eLs", "된"},
	{"eLf", "될"},
	{"eLa", "됨"},
	{"eLq", "됩"},
	{"eLt", "됫"},
	{"enr", "둑"},
	{"ens", "둔 屯 臀 芚 遁 遯 鈍"},
	{"enf", "둘"},
	{"ena", "둠"},
	{"enq", "둡"},
	{"ent", "둣"},
	{"end", "둥"},
	{"eJT", "뒀"},
	{"eNd", "뒝"},
	{"eBs", "뒨"},
	{"eBf", "뒬"},
	{"eBq", "뒵"},
	{"eBt", "뒷"},
	{"eBd", "뒹"},
	{"ebs", "듄"},
	{"ebf", "듈"},
	{"eba", "듐"},
	{"ebd", "듕"},
	{"emr", "득 得"},
	{"ems", "든"},
	{"eme", "듣"},
	{"emf", "들"},
	{"emM", "듦"},
	{"ema", "듬"},
	{"emq", "듭"},
	{"emt", "듯"},
	{"emd", "등 嶝 橙 燈 登 等 藤 謄 鄧 騰"},
	{"elr", "딕"},
	{"els", "딘"},
	{"ele", "딛"},
	{"elf", "딜"},
	{"ela", "딤"},
	{"elq", "딥"},
	{"elt", "딧"},
	{"elT", "딨"},
	{"eld", "딩"},
	{"elw", "딪"},
	{"Ekr", "딱"},
	{"Eks", "딴"},
	{"Ekf", "딸"},
	{"Eka", "땀"},
	{"Ekq", "땁"},
	{"Ekt", "땃"},
	{"EkT", "땄"},
	{"Ekd", "땅"},
	{"Ekg", "땋"},
	{"Eor", "땍"},
	{"Eos", "땐"},
	{"Eof", "땔"},
	{"Eoa", "땜"},
	{"Eoq", "땝"},
	{"Eot", "땟"},
	{"EoT", "땠"},
	{"Eod", "땡"},
	{"Ejr", "떡"},
	{"Ejs", "떤"},
	{"Ejf", "떨"},
	{"EjM", "떪"},
	{"EjA", "떫"},
	{"Eja", "떰"},
	{"Ejq", "떱"},
	{"Ejt", "떳"},
	{"EjT", "떴"},
	{"Ejd", "떵"},
	{"Ejg", "떻"},
	{"Epr", "떽"},
	{"Eps", "뗀"},
	{"Epf", "뗄"},
	{"Epa", "뗌"},
	{"Epq", "뗍"},
	{"Ept", "뗏"},
	{"EpT", "뗐"},
	{"Epd", "뗑"},
	{"EuT", "뗬"},
	{"Ehr", "똑"},
	{"Ehs", "똔"},
	{"Ehf", "똘"},
	{"Ehd", "똥"},
	{"EKf", "똴"},
	{"ELs", "뙨"},
	{"Enr", "뚝"},
	{"Ens", "뚠"},
	{"Enf", "뚤"},
	{"EnF", "뚫"},
	{"Ena", "뚬"},
	{"End", "뚱"},
	{"EBs", "뛴"},
	{"EBf", "뛸"},
	{"EBa", "뜀"},
	{"EBq", "뜁"},
	{"EBd", "뜅"},
	{"Emr", "뜩"},
	{"Ems", "뜬"},
	{"Eme", "뜯"},
	{"Emf", "뜰"},
	{"Ema", "뜸"},
	{"Emq", "뜹"},
	{"Emt", "뜻"},
	{"EMs", "띈"},
	{"EMf", "띌"},
	{"EMa", "띔"},
	{"EMq", "띕"},
	{"Els", "띤"},
	{"Elf", "띨"},
	{"Ela", "띰"},
	{"Elq", "띱"},
	{"Elt", "띳"},
	{"Eld", "띵"},
	{"fkr", "락 樂 洛 烙 珞 絡 落 諾 酪 駱"},
	{"fks", "란 丹 亂 卵 欄 欒 瀾 爛 蘭 鸞"},
	{"fkf", "랄 剌 辣"},
	{"fka", "람 嵐 擥 攬 欖 濫 籃 纜 藍 襤 覽"},
	{"fkq", "랍 拉 臘 蠟"},
	{"fkt", "랏"},
	{"fkT", "랐"},
	{"fkd", "랑 廊 朗 浪 狼 琅 瑯 螂 郞"},
	{"fkw", "랒"},
	{"fkv", "랖"},
	{"fkg", "랗"},
	{"for", "랙"},
	{"fos", "랜"},
	{"fof", "랭 冷"},
	{"foa", "램"},
	{"foq", "랩"},
	{"fot", "랫"},
	{"foT", "랬"},
	{"fod", "랭"},
	{"fir", "략 掠 略"},
	{"fis", "랸"},
	{"fit", "럇"},
	{"fid", "량 亮 倆 兩 凉 梁 樑 粮 粱 糧 良 諒 輛 量"},
	{"fjr", "럭"},
	{"fjs", "런"},
	{"fjf", "럴"},
	{"fja", "럼"},
	{"fjq", "럽"},
	{"fjt", "럿"},
	{"fjT", "렀"},
	{"fjd", "렁"},
	{"fjg", "렇"},
	{"fpr", "렉"},
	{"fps", "렌"},
	{"fpf", "렬 列 劣 洌 烈 裂"},
	{"fpa", "렴 廉 斂 殮 濂 簾"},
	{"fpq", "렵 獵"},
	{"fpt", "렛"},
	{"fpd", "령 令 伶 囹 寧 岺 嶺 怜 玲 笭 羚 翎 聆 逞 鈴 零 靈 領 齡"},
	{"fur", "력 力 曆 歷 瀝 礫 轢 靂"},
	{"fus", "련 憐 戀 攣 漣 煉 璉 練 聯 蓮 輦 連 鍊"},
	{"fuf", "렬"},
	{"fua", "렴"},
	{"fuq", "렵"},
	{"fut", "렷"},
	{"fuT", "렸"},
	{"fud", "령"},
	{"fPs", "롄"},
	{"fPq", "롑"},
	{"fPt", "롓"},
	{"fhr", "록 碌 祿 綠 菉 錄 鹿 麓"},
	{"fhs", "론 論"},
	{"fhf", "롤"},
	{"fha", "롬"},
	{"fhq", "롭"},
	{"fht", "롯"},
	{"fhd", "롱 壟 弄 朧 瀧 瓏 籠 聾"},
	{"fKs", "롼"},
	{"fKd", "뢍"},
	{"fHT", "뢨"},
	{"fLs", "뢴"},
	{"fLf", "뢸"},
	{"fLa", "룀"},
	{"fLq", "룁"},
	{"fLt", "룃"},
	{"fLd", "룅"},
	{"fys", "룐"},
	{"fyf", "룔"},
	{"fyq", "룝"},
	{"fyt", "룟"},
	{"fyd", "룡 龍"},
	{"fnr", "룩"},
	{"fns", "룬"},
	{"fnf", "룰"},
	{"fna", "룸"},
	{"fnq", "룹"},
	{"fnt", "룻"},
	{"fnd", "룽"},
	{"fJT", "뤘"},
	{"fBr", "뤽"},
	{"fBs", "륀"},
	{"fBf", "륄"},
	{"fBa", "륌"},
	{"fBt", "륏"},
	{"fBd", "륑"},
	{"fbr", "륙 六 戮 陸"},
	{"fbs", "륜 侖 倫 崙 淪 綸 輪"},
	{"fbf", "률 律 慄 栗 率"},
	{"fba", "륨"},
	{"fbq", "륩"},
	{"fbt", "륫"},
	{"fbd", "륭 隆"},
	{"fmr", "륵 勒 肋"},
	{"fms", "른"},
	{"fmf", "를"},
	{"fma", "름 凜"},
	{"fmq", "릅"},
	{"fmt", "릇"},
	{"fmd", "릉 凌 楞 稜 綾 菱 陵"},
	{"fmw", "릊"},
	{"fmx", "릍"},
	{"fmv", "릎"},
	{"flr", "릭"},
	{"fls", "린 吝 潾 燐 璘 藺 躪 隣 鱗 麟"},
	{"flf", "릴"},
	{"fla", "림 林 淋 琳 臨 霖"},
	{"flq", "립 砬 立 笠 粒"},
	{"flt", "릿"},
	{"fld", "링"},
	{"akr", "막 寞 幕 漠 膜 莫 邈"},
	{"aks", "만 万 卍 娩 巒 彎 慢 挽 晩 曼 滿 漫 灣 瞞 萬 蔓 蠻 輓 饅 鰻 唜"},
	{"akH", "많"},
	{"ake", "맏"},
	{"akf", "말 抹 末 沫 茉 襪 靺"},
	{"akG", "맑"},
	{"akM", "맒"},
	{"aka", "맘"},
	{"akq", "맙"},
	{"akt", "맛"},
	{"akd", "망 亡 妄 忘 忙 望 網 罔 芒 茫 莽 輞 邙"},
	{"akw", "맞"},
	{"akx", "맡"},
	{"akg", "맣"},
	{"aor", "맥 脈 貊 陌 驀 麥"},
	{"aos", "맨"},
	{"aof", "맬"},
	{"aoa", "맴"},
	{"aoq", "맵"},
	{"aot", "맷"},
	{"aoT", "맸"},
	{"aod", "맹 孟 氓 猛 盲 盟 萌"},
	{"aow", "맺"},
	{"air", "먁"},
	{"aif", "먈"},
	{"aid", "먕"},
	{"ajr", "먹"},
	{"ajs", "먼"},
	{"ajf", "멀"},
	{"ajM", "멂"},
	{"aja", "멈"},
	{"ajq", "멉"},
	{"ajt", "멋"},
	{"ajd", "멍"},
	{"ajw", "멎"},
	{"ajg", "멓"},
	{"apr", "멕"},
	{"aps", "멘"},
	{"apf", "멜"},
	{"apa", "멤"},
	{"apq", "멥"},
	{"apt", "멧"},
	{"apT", "멨"},
	{"apd", "멩"},
	{"aur", "멱 冪 覓"},
	{"aus", "면 免 冕 勉 棉 沔 眄 眠 綿 緬 面 麵"},
	{"auf", "멸 滅 蔑"},
	{"aut", "몃"},
	{"auT", "몄"},
	{"aud", "명 冥 名 命 明 暝 椧 溟 皿 瞑 茗 蓂 螟 酩 銘 鳴"},
	{"auc", "몇"},
	{"ahr", "목 木 沐 牧 目 睦 穆 鶩"},
	{"ahS", "몫"},
	{"ahs", "몬"},
	{"ahf", "몰 歿 沒"},
	{"ahM", "몲"},
	{"aha", "몸"},
	{"ahq", "몹"},
	{"aht", "못"},
	{"ahd", "몽 夢 朦 蒙"},
	{"aKs", "뫈"},
	{"aKT", "뫘"},
	{"aKd", "뫙"},
	{"aLs", "묀"},
	{"aLf", "묄"},
	{"aLq", "묍"},
	{"aLt", "묏"},
	{"aLd", "묑"},
	{"ays", "묜"},
	{"ayf", "묠"},
	{"ayq", "묩"},
	{"ayt", "묫"},
	{"anr", "묵 墨 默"},
	{"anR", "묶"},
	{"ans", "문 們 刎 吻 問 文 汶 紊 紋 聞 蚊 門 雯"},
	{"ane", "묻"},
	{"anf", "물 勿 沕 物"},
	{"anG", "묽"},
	{"anM", "묾"},
	{"ana", "뭄"},
	{"anq", "뭅"},
	{"ant", "뭇"},
	{"and", "뭉"},
	{"anx", "뭍"},
	{"ang", "뭏"},
	{"aJs", "뭔"},
	{"aJf", "뭘"},
	{"aJq", "뭡"},
	{"aJt", "뭣"},
	{"aBs", "뮌"},
	{"aBf", "뮐"},
	{"abs", "뮨"},
	{"abf", "뮬"},
	{"aba", "뮴"},
	{"abt", "뮷"},
	{"ams", "믄"},
	{"amf", "믈"},
	{"ama", "믐"},
	{"amt", "믓"},
	{"alr", "믹"},
	{"als", "민 岷 悶 愍 憫 敏 旻 旼 民 泯 玟 珉 緡 閔"},
	{"ale", "믿"},
	{"alf", "밀 密 蜜 謐"},
	{"alM", "밂"},
	{"ala", "밈"},
	{"alq", "밉"},
	{"alt", "밋"},
	{"alT", "밌"},
	{"ald", "밍"},
	{"alc", "및"},
	{"alx", "밑"},
	{"qkr", "박 剝 博 拍 搏 撲 朴 樸 泊 珀 璞 箔 粕 縛 膊 舶 薄 迫 雹 駁"},
	{"qkR", "밖"},
	{"qkS", "밗"},
	{"qks", "반 伴 半 反 叛 拌 搬 攀 斑 槃 泮 潘 班 畔 瘢 盤 盼 磐 磻 礬 絆 般 蟠 返 頒 飯"},
	{"qke", "받"},
	{"qkf", "발 勃 拔 撥 渤 潑 發 跋 醱 鉢 髮 魃"},
	{"qkG", "밝"},
	{"qkM", "밞"},
	{"qkA", "밟"},
	{"qka", "밤"},
	{"qkq", "밥"},
	{"qkt", "밧"},
	{"qkd", "방 倣 傍 坊 妨 尨 幇 彷 房 放 方 旁 昉 枋 榜 滂 磅 紡 肪 膀 舫 芳 蒡 蚌 訪 謗 邦 防 龐"},
	{"qkx", "밭"},
	{"qor", "백 伯 佰 帛 柏 栢 白 百 魄"},
	{"qos", "밴"},
	{"qof", "밸"},
	{"qoa", "뱀"},
	{"qoq", "뱁"},
	{"qot", "뱃"},
	{"qoT", "뱄"},
	{"qod", "뱅"},
	{"qox", "뱉"},
	{"qir", "뱍"},
	{"qis", "뱐"},
	{"qiq", "뱝"},
	{"qjr", "벅"},
	{"qjs", "번 幡 樊 煩 燔 番 磻 繁 蕃 藩 飜"},
	{"qje", "벋"},
	{"qjf", "벌 伐 筏 罰 閥"},
	{"qjM", "벎"},
	{"qja", "범 凡 帆 梵 氾 汎 泛 犯 範 范"},
	{"qjq", "법 法 琺"},
	{"qjt", "벗"},
	{"qjd", "벙"},
	{"qjw", "벚"},
	{"qpr", "벡"},
	{"qps", "벤"},
	{"qpe", "벧"},
	{"qpf", "벨"},
	{"qpa", "벰"},
	{"qpq", "벱"},
	{"qpt", "벳"},
	{"qpT", "벴"},
	{"qpd", "벵"},
	{"qur", "벽 僻 劈 壁 擘 檗 璧 癖 碧 蘗 闢 霹"},
	{"qus", "변 便 卞 弁 變 辨 辯 邊"},
	{"quf", "별 別 瞥 鱉 鼈"},
	{"quq", "볍"},
	{"qut", "볏"},
	{"quT", "볐"},
	{"qud", "병 丙 倂 兵 屛 幷 昞 昺 柄 棅 炳 甁 病 秉 竝 輧 餠 騈"},
	{"qux", "볕"},
	{"qPs", "볜"},
	{"qhr", "복 伏 僕 匐 卜 宓 復 服 福 腹 茯 蔔 複 覆 輹 輻 馥 鰒"},
	{"qhR", "볶"},
	{"qhs", "본 本"},
	{"qhf", "볼"},
	{"qha", "봄"},
	{"qhq", "봅"},
	{"qht", "봇"},
	{"qhd", "봉 乶 俸 奉 封 峯 峰 捧 棒 烽 熢 琫 縫 蓬 蜂 逢 鋒 鳳"},
	{"qKs", "봔"},
	{"qKT", "봤"},
	{"qHT", "뵀"},
	{"qLr", "뵉"},
	{"qLs", "뵌"},
	{"qLf", "뵐"},
	{"qLa", "뵘"},
	{"qLq", "뵙"},
	{"qys", "뵨"},
	{"qnr", "북 北"},
	{"qns", "분 分 吩 噴 墳 奔 奮 忿 憤 扮 昐 汾 焚 盆 粉 糞 紛 芬 賁 雰"},
	{"qne", "붇"},
	{"qnf", "불 不 佛 弗 彿 拂"},
	{"qnG", "붉"},
	{"qnM", "붊"},
	{"qna", "붐"},
	{"qnq", "붑"},
	{"qnt", "붓"},
	{"qnd", "붕 崩 朋 棚 硼 繃 鵬"},
	{"qnx", "붙"},
	{"qnv", "붚"},
	{"qJf", "붤"},
	{"qJT", "붰"},
	{"qBr", "뷕"},
	{"qBs", "뷘"},
	{"qBf", "뷜"},
	{"qBd", "뷩"},
	{"qbs", "뷴"},
	{"qbf", "뷸"},
	{"qba", "븀"},
	{"qbt", "븃"},
	{"qbd", "븅"},
	{"qmr", "븍"},
	{"qms", "븐"},
	{"qmf", "블"},
	{"qma", "븜"},
	{"qmq", "븝"},
	{"qmt", "븟"},
	{"qlr", "빅"},
	{"qls", "빈 嚬 嬪 彬 斌 檳 殯 浜 濱 瀕 牝 玭 貧 賓 頻"},
	{"qlf", "빌"},
	{"qlM", "빎"},
	{"qla", "빔"},
	{"qlq", "빕"},
	{"qlt", "빗"},
	{"qld", "빙 憑 氷 聘 騁"},
	{"qlw", "빚"},
	{"qlc", "빛"},
	{"Qkr", "빡"},
	{"Qks", "빤"},
	{"Qkf", "빨"},
	{"QkM", "빪"},
	{"Qka", "빰"},
	{"Qkq", "빱"},
	{"Qkt", "빳"},
	{"QkT", "빴"},
	{"Qkd", "빵"},
	{"Qkg", "빻"},
	{"Qor", "빽"},
	{"Qos", "뺀"},
	{"Qof", "뺄"},
	{"Qoa", "뺌"},
	{"Qoq", "뺍"},
	{"Qot", "뺏"},
	{"QoT", "뺐"},
	{"Qod", "뺑"},
	{"Qir", "뺙"},
	{"Qia", "뺨"},
	{"Qjr", "뻑"},
	{"Qjs", "뻔"},
	{"Qje", "뻗"},
	{"Qjf", "뻘"},
	{"Qja", "뻠"},
	{"Qjt", "뻣"},
	{"QjT", "뻤"},
	{"Qjd", "뻥"},
	{"Qpd", "뼁"},
	{"Qur", "뼉"},
	{"Qua", "뼘"},
	{"Quq", "뼙"},
	{"Qut", "뼛"},
	{"QuT", "뼜"},
	{"Qud", "뼝"},
	{"Qhr", "뽁"},
	{"Qhs", "뽄"},
	{"Qhf", "뽈"},
	{"Qha", "뽐"},
	{"Qhq", "뽑"},
	{"Qhd", "뽕"},
	{"Qyd", "뿅"},
	{"Qnr", "뿍"},
	{"Qns", "뿐"},
	{"Qnf", "뿔"},
	{"Qna", "뿜"},
	{"Qnt", "뿟"},
	{"Qnd", "뿡"},
	{"Qbd", "쁑"},
	{"Qms", "쁜"},
	{"Qmf", "쁠"},
	{"Qma", "쁨"},
	{"Qmq", "쁩"},
	{"Qlr", "삑"},
	{"Qls", "삔"},
	{"Qlf", "삘"},
	{"Qla", "삠"},
	{"Qlq", "삡"},
	{"Qlt", "삣"},
	{"Qld", "삥"},
	{"tkr", "삭 削 數 朔 索"},
	{"tkS", "삯"},
	{"tks", "산 傘 刪 山 散 汕 珊 産 疝 算 蒜 酸 霰"},
	{"tke", "삳"},
	{"tkf", "살 乷 撒 殺 煞 薩"},
	{"tkG", "삵"},
	{"tkM", "삶"},
	{"tka", "삼 三 參 杉 森 渗 芟 蔘 衫"},
	{"tkq", "삽 揷 澁 鈒 颯"},
	{"tkt", "삿"},
	{"tkT", "샀"},
	{"tkd", "상 上 傷 像 償 商 喪 嘗 孀 尙 峠 常 床 庠 廂 想 桑 橡 湘 爽 牀 狀 相 祥 箱 翔 裳 觴 詳 象 賞 霜"},
	{"tkx", "샅"},
	{"tor", "색 嗇 塞 穡 索 色"},
	{"tos", "샌"},
	{"tof", "샐"},
	{"toa", "샘"},
	{"toq", "샙"},
	{"tot", "샛"},
	{"toT", "샜"},
	{"tod", "생 牲 生 甥 省 笙"},
	{"tir", "샥"},
	{"tis", "샨"},
	{"tif", "샬"},
	{"tia", "샴"},
	{"tiq", "샵"},
	{"tit", "샷"},
	{"tid", "샹"},
	{"tOs", "섄"},
	{"tOf", "섈"},
	{"tOa", "섐"},
	{"tOd", "섕"},
	{"tjr", "석 夕 奭 席 惜 昔 晳 析 汐 淅 潟 石 碩 蓆 釋 錫"},
	{"tjR", "섞"},
	{"tjS", "섟"},
	{"tjs", "선 仙 僊 先 善 嬋 宣 扇 敾 旋 渲 煽 琁 瑄 璇 璿 癬 禪 線 繕 羨 腺 膳 船 蘚 蟬 詵 跣 選 銑 鐥 饍 鮮"},
	{"tje", "섣"},
	{"tjf", "설 卨 屑 楔 泄 洩 渫 舌 薛 褻 設 說 雪 齧"},
	{"tjM", "섦"},
	{"tjA", "섧"},
	{"tja", "섬 剡 暹 殲 纖 蟾 贍 閃 陝"},
	{"tjq", "섭 攝 涉 燮 葉"},
	{"tjt", "섯"},
	{"tjT", "섰"},
	{"tjd", "성 城 姓 宬 性 惺 成 星 晟 猩 珹 盛 省 筬 聖 聲 腥 誠 醒"},
	{"tjv", "섶"},
	{"tpr", "섹"},
	{"tps", "센"},
	{"tpf", "셀"},
	{"tpa", "셈"},
	{"tpq", "셉"},
	{"tpt", "셋"},
	{"tpT", "셌"},
	{"tpd", "셍"},
	{"tur", "셕"},
	{"tus", "션"},
	{"tuf", "셜"},
	{"tua", "셤"},
	{"tuq", "셥"},
	{"tut", "셧"},
	{"tuT", "셨"},
	{"tud", "셩"},
	{"tPs", "셴"},
	{"tPf", "셸"},
	{"tPd", "솅"},
	{"thr", "속 俗 屬 束 涑 粟 續 謖 贖 速"},
	{"thR", "솎"},
	{"ths", "손"},
	{"thf", "솔 率"},
	{"thM", "솖"},
	{"tha", "솜"},
	{"thq", "솝"},
	{"tht", "솟"},
	{"thd", "송 宋 悚 松 淞 訟 誦 送 頌"},
	{"thx", "솥"},
	{"tKr", "솩"},
	{"tKs", "솬"},
	{"tKf", "솰"},
	{"tKd", "솽"},
	{"tHs", "쇈"},
	{"tHf", "쇌"},
	{"tHa", "쇔"},
	{"tHt", "쇗"},
	{"tHT", "쇘"},
	{"tLs", "쇤"},
	{"tLf", "쇨"},
	{"tLa", "쇰"},
	{"tLq", "쇱"},
	{"tLt", "쇳"},
	{"tyr", "쇽"},
	{"tys", "숀"},
	{"tyf", "숄"},
	{"tya", "숌"},
	{"tyq", "숍"},
	{"tyt", "숏"},
	{"tyd", "숑"},
	{"tnr", "숙 叔 塾 夙 孰 宿 淑 潚 熟 琡 璹 肅 菽"},
	{"tns", "순 巡 徇 循 恂 旬 栒 楯 橓 殉 洵 淳 珣 盾 瞬 筍 純 脣 舜 荀 蓴 蕣 詢 諄 醇 錞 順 馴"},
	{"tne", "숟"},
	{"tnf", "술 戌 術 述 鉥"},
	{"tna", "숨"},
	{"tnq", "숩"},
	{"tnt", "숫"},
	{"tnd", "숭 崇 崧 嵩"},
	{"tnc", "숯"},
	{"tnx", "숱"},
	{"tnv", "숲"},
	{"tJT", "쉈"},
	{"tNr", "쉑"},
	{"tNs", "쉔"},
	{"tNf", "쉘"},
	{"tNa", "쉠"},
	{"tNd", "쉥"},
	{"tBr", "쉭"},
	{"tBs", "쉰"},
	{"tBf", "쉴"},
	{"tBa", "쉼"},
	{"tBq", "쉽"},
	{"tBt", "쉿"},
	{"tBd", "슁"},
	{"tbr", "슉"},
	{"tbf", "슐"},
	{"tba", "슘"},
	{"tbt", "슛"},
	{"tbd", "슝"},
	{"tmr", "슥"},
	{"tms", "슨"},
	{"tmf", "슬 瑟 膝 蝨"},
	{"tmG", "슭"},
	{"tma", "슴"},
	{"tmq", "습 濕 拾 習 褶 襲"},
	{"tmt", "슷"},
	{"tmd", "승 丞 乘 僧 勝 升 承 昇 繩 蠅 陞"},
	{"tlr", "식 埴 寔 式 息 拭 植 殖 湜 熄 篒 蝕 識 軾 食 飾"},
	{"tls", "신 伸 侁 信 呻 娠 宸 愼 新 晨 燼 申 神 紳 腎 臣 莘 薪 藎 蜃 訊 身 辛 辰 迅"},
	{"tle", "싣"},
	{"tlf", "실 失 室 實 悉"},
	{"tlF", "싫"},
	{"tla", "심 審 尋 心 沁 沈 深 瀋 甚 芯 諶"},
	{"tlq", "십 什 十 拾"},
	{"tlt", "싯"},
	{"tld", "싱"},
	{"tlv", "싶"},
	{"Tkr", "싹"},
	{"TkS", "싻"},
	{"Tks", "싼"},
	{"Tkf", "쌀"},
	{"Tka", "쌈"},
	{"Tkq", "쌉"},
	{"TkT", "쌌"},
	{"Tkd", "쌍 雙"},
	{"Tkg", "쌓"},
	{"Tor", "쌕"},
	{"Tos", "쌘"},
	{"Tof", "쌜"},
	{"Toa", "쌤"},
	{"Toq", "쌥"},
	{"ToT", "쌨"},
	{"Tod", "쌩"},
	{"Tid", "썅"},
	{"Tjr", "썩"},
	{"Tjs", "썬"},
	{"Tjf", "썰"},
	{"TjM", "썲"},
	{"Tja", "썸"},
	{"Tjq", "썹"},
	{"TjT", "썼"},
	{"Tjd", "썽"},
	{"Tps", "쎈"},
	{"Tpf", "쎌"},
	{"TPs", "쏀"},
	{"Thr", "쏙"},
	{"Ths", "쏜"},
	{"The", "쏟"},
	{"Thf", "쏠"},
	{"ThM", "쏢"},
	{"Tha", "쏨"},
	{"Thq", "쏩"},
	{"Thd", "쏭"},
	{"TKr", "쏵"},
	{"TKs", "쏸"},
	{"TKT", "쐈"},
	{"THT", "쐤"},
	{"TLs", "쐰"},
	{"TLf", "쐴"},
	{"TLa", "쐼"},
	{"TLq", "쐽"},
	{"Tnr", "쑥"},
	{"Tns", "쑨"},
	{"Tnf", "쑬"},
	{"Tna", "쑴"},
	{"Tnq", "쑵"},
	{"Tnd", "쑹"},
	{"TJT", "쒔"},
	{"TBs", "쒼"},
	{"Tbd", "쓩"},
	{"Tmr", "쓱"},
	{"Tms", "쓴"},
	{"Tmf", "쓸"},
	{"TmM", "쓺"},
	{"TmF", "쓿"},
	{"Tma", "씀"},
	{"Tmq", "씁"},
	{"TMs", "씐"},
	{"TMf", "씔"},
	{"TMa", "씜"},
	{"Tlr", "씩"},
	{"Tls", "씬"},
	{"Tlf", "씰"},
	{"Tla", "씸"},
	{"Tlq", "씹"},
	{"Tlt", "씻"},
	{"Tld", "씽"},
	{"dkr", "악 堊 岳 嶽 幄 惡 愕 握 樂 渥 鄂 鍔 顎 鰐 齷"},
	{"dks", "안 安 岸 按 晏 案 眼 雁 鞍 顔 鮟"},
	{"dkJ", "앉"},
	{"dkH", "않"},
	{"dkf", "알 斡 謁 軋 閼"},
	{"dkG", "앍"},
	{"dkM", "앎"},
	{"dkF", "앓"},
	{"dka", "암 唵 岩 巖 庵 暗 癌 菴 闇"},
	{"dkq", "압 壓 押 狎 鴨"},
	{"dkt", "앗"},
	{"dkT", "았"},
	{"dkd", "앙 仰 央 怏 昻 殃 秧 鴦"},
	{"dkx", "앝"},
	{"dkv", "앞"},
	{"dor", "액 厄 扼 掖 液 縊 腋 額"},
	{"dos", "앤"},
	{"dof", "앨"},
	{"doa", "앰"},
	{"doq", "앱"},
	{"dot", "앳"},
	{"doT", "앴"},
	{"dod", "앵 櫻 罌 鶯 鸚"},
	{"dir", "약 弱 掠 略 約 若 葯 蒻 藥 躍"},
	{"dis", "얀"},
	{"dif", "얄"},
	{"diA", "얇"},
	{"dia", "얌"},
	{"diq", "얍"},
	{"dit", "얏"},
	{"did", "양 亮 佯 兩 凉 壤 孃 恙 揚 攘 敭 暘 梁 楊 樣 洋 瀁 煬 痒 瘍 禳 穰 糧 羊 良 襄 諒 讓 釀 陽 量 養"},
	{"dix", "얕"},
	{"dig", "얗"},
	{"dOs", "얜"},
	{"dOf", "얠"},
	{"dOq", "얩"},
	{"djr", "억 億 憶 抑 檍 臆"},
	{"djs", "언 偃 堰 彦 焉 言 諺"},
	{"djJ", "얹"},
	{"dje", "얻"},
	{"djf", "얼 孼 蘖"},
	{"djG", "얽"},
	{"djM", "얾"},
	{"dja", "엄 俺 儼 嚴 奄 掩 淹"},
	{"djq", "업 嶪 業"},
	{"djC", "없"},
	{"djt", "엇"},
	{"djT", "었"},
	{"djd", "엉"},
	{"djw", "엊"},
	{"djz", "엌"},
	{"djv", "엎"},
	{"dpr", "엑"},
	{"dps", "엔 円"},
	{"dpf", "엘"},
	{"dpa", "엠"},
	{"dpq", "엡"},
	{"dpt", "엣"},
	{"dpd", "엥"},
	{"dur", "역 亦 力 域 役 易 曆 歷 疫 繹 譯 轢 逆 驛"},
	{"duR", "엮"},
	{"dus", "연 嚥 堧 姸 娟 宴 年 延 憐 戀 捐 挻 撚 椽 沇 沿 涎 涓 淵 演 漣 烟 然 煙 煉 燃 燕 璉 硏 硯 秊 筵 緣 練 縯 聯 衍 軟 輦 蓮 連 鉛 鍊 鳶"},
	{"duf", "열 冽 列 劣 咽 悅 涅 烈 熱 裂 說 閱"},
	{"duM", "엶"},
	{"duA", "엷"},
	{"dua", "염 厭 廉 念 捻 染 殮 炎 焰 琰 艶 苒 簾 閻 髥 鹽"},
	{"duq", "엽 曄 獵 燁 葉"},
	{"duC", "엾"},
	{"dut", "엿"},
	{"duT", "였"},
	{"dud", "영 令 囹 塋 寧 嶺 嶸 影 怜 映 暎 楹 榮 永 泳 渶 潁 濚 瀛 瀯 煐 營 獰 玲 瑛 瑩 瓔 盈 穎 纓 羚 聆 英 詠 迎 鈴 鍈 零 霙 靈 領"},
	{"dux", "옅"},
	{"duv", "옆"},
	{"dug", "옇"},
	{"dPs", "옌"},
	{"dPf", "옐"},
	{"dPa", "옘"},
	{"dPq", "옙"},
	{"dPt", "옛"},
	{"dPT", "옜"},
	{"dhr", "옥 屋 沃 獄 玉 鈺"},
	{"dhs", "온 溫 瑥 瘟 穩 縕 蘊"},
	{"dhf", "올 兀"},
	{"dhG", "옭"},
	{"dhM", "옮"},
	{"dhN", "옰"},
	{"dhF", "옳"},
	{"dha", "옴"},
	{"dhq", "옵"},
	{"dht", "옷"},
	{"dhd", "옹 壅 擁 瓮 甕 癰 翁 邕 雍 饔"},
	{"dhc", "옻"},
	{"dKr", "왁"},
	{"dKs", "완 婉 完 宛 梡 椀 浣 玩 琓 琬 碗 緩 翫 脘 腕 莞 豌 阮 頑"},
	{"dKf", "왈 曰"},
	{"dKa", "왐"},
	{"dKq", "왑"},
	{"dKt", "왓"},
	{"dKT", "왔"},
	{"dKd", "왕 往 旺 枉 汪 王"},
	{"dHr", "왝"},
	{"dHs", "왠"},
	{"dHa", "왬"},
	{"dHt", "왯"},
	{"dHd", "왱"},
	{"dLr", "왹"},
	{"dLs", "왼"},
	{"dLf", "욀"},
	{"dLa", "욈"},
	{"dLq", "욉"},
	{"dLt", "욋"},
	{"dLd", "욍"},
	{"dyr", "욕 慾 欲 浴 縟 褥 辱"},
	{"dys", "욘"},
	{"dyf", "욜"},
	{"dya", "욤"},
	{"dyq", "욥"},
	{"dyt", "욧"},
	{"dyd", "용 俑 傭 冗 勇 埇 墉 容 庸 慂 榕 涌 湧 溶 熔 瑢 用 甬 聳 茸 蓉 踊 鎔 鏞 龍"},
	{"dnr", "욱 勖 彧 旭 昱 栯 煜 稶 郁 頊"},
	{"dns", "운 云 暈 橒 殞 澐 熉 耘 芸 蕓 運 隕 雲 韻"},
	{"dnf", "울 蔚 鬱 亐"},
	{"dnG", "욹"},
	{"dnM", "욺"},
	{"dna", "움"},
	{"dnq", "웁"},
	{"dnt", "웃"},
	{"dnd", "웅 熊 雄"},
	{"dJr", "웍"},
	{"dJs", "원 元 原 員 圓 園 垣 媛 嫄 寃 怨 愿 援 沅 洹 湲 源 爰 猿 瑗 苑 袁 轅 遠 阮 院 願 鴛"},
	{"dJf", "월 月 越 鉞"},
	{"dJa", "웜"},
	{"dJq", "웝"},
	{"dJT", "웠"},
	{"dJd", "웡"},
	{"dNr", "웩"},
	{"dNs", "웬"},
	{"dNf", "웰"},
	{"dNa", "웸"},
	{"dNq", "웹"},
	{"dNd", "웽"},
	{"dBr", "윅"},
	{"dBs", "윈"},
	{"dBf", "윌"},
	{"dBa", "윔"},
	{"dBq", "윕"},
	{"dBt", "윗"},
	{"dBd", "윙"},
	{"dbr", "육 六 堉 戮 毓 肉 育 陸"},
	{"dbs", "윤 倫 允 奫 尹 崙 淪 潤 玧 胤 贇 輪 鈗 閏"},
	{"dbf", "율 律 慄 栗 率 聿"},
	{"dba", "윰"},
	{"dbq", "윱"},
	{"dbt", "윳"},
	{"dbd", "융 戎 瀜 絨 融 隆"},
	{"dbc", "윷"},
	{"dmr", "윽"},
	{"dms", "은 垠 恩 慇 殷 誾 銀 隱"},
	{"dmf", "을 乙"},
	{"dmV", "읊"},
	{"dma", "음 吟 淫 蔭 陰 音 飮"},
	{"dmq", "읍 揖 泣 邑"},
	{"dmt", "읏"},
	{"dmd", "응 凝 應 膺 鷹"},
	{"dmw", "읒"},
	{"dmc", "읓"},
	{"dmz", "읔"},
	{"dmx", "읕"},
	{"dmv", "읖"},
	{"dmg", "읗"},
	{"dMs", "읜"},
	{"dMf", "읠"},
	{"dMa", "읨"},
	{"dMt", "읫"},
	{"dlr", "익 匿 溺 瀷 益 翊 翌 翼 謚"},
	{"dls", "인 人 仁 刃 印 吝 咽 因 姻 寅 引 忍 湮 燐 璘 絪 茵 藺 蚓 認 隣 靭 靷 鱗 麟"},
	{"dlf", "일 一 佚 佾 壹 日 溢 逸 鎰 馹"},
	{"dlG", "읽"},
	{"dlM", "읾"},
	{"dlF", "잃"},
	{"dla", "임 任 壬 妊 姙 恁 林 淋 稔 臨 荏 賃"},
	{"dlq", "입 入 卄 立 笠 粒"},
	{"dlt", "잇"},
	{"dlT", "있"},
	{"dld", "잉 仍 剩 孕 芿"},
	{"dlw", "잊"},
	{"dlv", "잎"},
	{"wkr", "작 作 勺 嚼 斫 昨 灼 炸 爵 綽 芍 酌 雀 鵲"},
	{"wks", "잔 孱 棧 殘 潺 盞"},
	{"wkH", "잖"},
	{"wke", "잗"},
	{"wkf", "잘"},
	{"wkM", "잚"},
	{"wka", "잠 岑 暫 潛 箴 簪 蠶"},
	{"wkq", "잡 雜"},
	{"wkt", "잣"},
	{"wkT", "잤"},
	{"wkd", "장 丈 仗 匠 場 墻 壯 奬 將 帳 庄 張 掌 暲 杖 樟 檣 欌 漿 牆 狀 獐 璋 章 粧 腸 臟 臧 莊 葬 蔣 薔 藏 裝 贓 醬 長 障"},
	{"wkw", "잦"},
	{"wor", "잭"},
	{"wos", "잰"},
	{"wof", "잴"},
	{"woa", "잼"},
	{"woq", "잽"},
	{"wot", "잿"},
	{"woT", "쟀"},
	{"wod", "쟁 爭 箏 諍 錚"},
	{"wir", "쟉"},
	{"wis", "쟌"},
	{"wiH", "쟎"},
	{"wif", "쟐"},
	{"wia", "쟘"},
	{"wid", "쟝"},
	{"wOs", "쟨"},
	{"wOf", "쟬"},
	{"wjr", "적 勣 吊 嫡 寂 摘 敵 滴 狄 炙 的 積 笛 籍 績 翟 荻 謫 賊 赤 跡 蹟 迪 迹 適 鏑"},
	{"wjs", "전 佃 佺 傳 全 典 前 剪 塡 塼 奠 專 展 廛 悛 戰 栓 殿 氈 澱 煎 琠 田 甸 畑 癲 筌 箋 箭 篆 纏 詮 輾 轉 鈿 銓 錢 鐫 電 顚 顫 餞"},
	{"wjf", "절 切 截 折 浙 癤 竊 節 絶"},
	{"wjM", "젊"},
	{"wja", "점 占 岾 店 漸 点 粘 霑 鮎 點"},
	{"wjq", "접 接 摺 蝶"},
	{"wjt", "젓"},
	{"wjd", "정 丁 井 亭 停 偵 呈 姃 定 幀 庭 廷 征 情 挺 政 整 旌 晶 晸 柾 楨 檉 正 汀 淀 淨 渟 湞 瀞 炡 玎 珽 町 睛 碇 禎 程 穽 精 綎 艇 訂 諪 貞 鄭 酊 釘 鉦 鋌 錠 霆 靖 靜 頂 鼎"},
	{"wjw", "젖"},
	{"wpr", "젝"},
	{"wps", "젠"},
	{"wpf", "젤"},
	{"wpa", "젬"},
	{"wpq", "젭"},
	{"wpt", "젯"},
	{"wpd", "젱"},
	{"wus", "젼"},
	{"wuf", "졀"},
	{"wua", "졈"},
	{"wuq", "졉"},
	{"wuT", "졌"},
	{"wud", "졍"},
	{"whr", "족 族 簇 足 鏃"},
	{"wjf", "절 切 截 折 浙 癤 竊 節 絶"},
	{"whs", "존 存 尊"},
	{"whf", "졸 卒 拙 猝"},
	{"whM", "졺"},
	{"wha", "좀"},
	{"whq", "좁"},
	{"wht", "좃"},
	{"whd", "종 倧 宗 從 悰 慫 棕 淙 琮 種 終 綜 縱 腫 踪 踵 鍾 鐘"},
	{"whw", "좆"},
	{"whc", "좇"},
	{"whg", "좋"},
	{"wKr", "좍"},
	{"wKf", "좔"},
	{"wKq", "좝"},
	{"wKt", "좟"},
	{"wKd", "좡"},
	{"wHT", "좼"},
	{"wHd", "좽"},
	{"wLs", "죈"},
	{"wLf", "죌"},
	{"wLa", "죔"},
	{"wLq", "죕"},
	{"wLt", "죗"},
	{"wLd", "죙"},
	{"wyr", "죡"},
	{"wys", "죤"},
	{"wyd", "죵"},
	{"wnr", "죽 竹 粥"},
	{"wns", "준 俊 儁 准 埈 寯 峻 晙 樽 浚 準 濬 焌 畯 竣 蠢 逡 遵 雋 駿"},
	{"wnf", "줄 茁"},
	{"wnG", "줅"},
	{"wnM", "줆"},
	{"wna", "줌"},
	{"wnq", "줍"},
	{"wnt", "줏"},
	{"wnd", "중 中 仲 衆 重"},
	{"wJT", "줬"},
	{"wBr", "쥑"},
	{"wBs", "쥔"},
	{"wBf", "쥘"},
	{"wBa", "쥠"},
	{"wBq", "쥡"},
	{"wBt", "쥣"},
	{"wbs", "쥰"},
	{"wbf", "쥴"},
	{"wba", "쥼"},
	{"wmr", "즉 卽"},
	{"wms", "즌"},
	{"wmf", "즐 櫛"},
	{"wma", "즘"},
	{"wmq", "즙 楫 汁 葺"},
	{"wmt", "즛"},
	{"wmd", "증 增 憎 曾 拯 烝 甑 症 繒 蒸 證 贈"},
	{"wlr", "직 直 稙 稷 織 職"},
	{"wls", "진 唇 嗔 塵 振 搢 晉 晋 桭 榛 殄 津 溱 珍 瑨 璡 畛 疹 盡 眞 瞋 秦 縉 縝 臻 蔯 袗 診 賑 軫 辰 進 鎭 陣 陳 震"},
	{"wle", "짇"},
	{"wlf", "질 侄 叱 姪 嫉 帙 桎 瓆 疾 秩 窒 膣 蛭 質 跌 迭"},
	{"wlM", "짊"},
	{"wla", "짐 斟 朕"},
	{"wlq", "집 什 執 潗 緝 輯 鏶 集"},
	{"wlt", "짓"},
	{"wld", "징 徵 懲 澄"},
	{"wlw", "짖"},
	{"wlx", "짙"},
	{"wlv", "짚"},
	{"Wkr", "짝"},
	{"Wks", "짠"},
	{"WkH", "짢"},
	{"Wkf", "짤"},
	{"WkA", "짧"},
	{"Wka", "짬"},
	{"Wkq", "짭"},
	{"Wkt", "짯"},
	{"WkT", "짰"},
	{"Wkd", "짱"},
	{"Wor", "짹"},
	{"Wos", "짼"},
	{"Wof", "쨀"},
	{"Woa", "쨈"},
	{"Woq", "쨉"},
	{"Wot", "쨋"},
	{"WoT", "쨌"},
	{"Wod", "쨍"},
	{"Wis", "쨘"},
	{"Wid", "쨩"},
	{"Wjr", "쩍"},
	{"Wjs", "쩐"},
	{"Wjf", "쩔"},
	{"Wja", "쩜"},
	{"Wjq", "쩝"},
	{"Wjt", "쩟"},
	{"WjT", "쩠"},
	{"Wjd", "쩡"},
	{"Wpd", "쩽"},
	{"WuT", "쪘"},
	{"Whr", "쪽"},
	{"Whs", "쫀"},
	{"Whf", "쫄"},
	{"Wha", "쫌"},
	{"Whq", "쫍"},
	{"Wht", "쫏"},
	{"Whd", "쫑"},
	{"Whc", "쫓"},
	{"WKr", "쫙"},
	{"WKf", "쫠"},
	{"WKT", "쫬"},
	{"WHT", "쬈"},
	{"WLs", "쬔"},
	{"WLf", "쬘"},
	{"WLa", "쬠"},
	{"WLq", "쬡"},
	{"Wyd", "쭁"},
	{"Wnr", "쭉"},
	{"Wns", "쭌"},
	{"Wnf", "쭐"},
	{"Wna", "쭘"},
	{"Wnq", "쭙"},
	{"Wnd", "쭝"},
	{"WJT", "쭸"},
	{"WJd", "쭹"},
	{"Wma", "쯤"},
	{"Wmt", "쯧"},
	{"Wmd", "쯩"},
	{"Wlr", "찍"},
	{"Wls", "찐"},
	{"Wlf", "찔"},
	{"Wla", "찜"},
	{"Wlq", "찝"},
	{"Wld", "찡"},
	{"Wlw", "찢"},
	{"Wlg", "찧"},
	{"ckr", "착 捉 搾 着 窄 錯 鑿 齪"},
	{"cks", "찬 撰 澯 燦 璨 瓚 竄 簒 纂 粲 纘 讚 贊 鑽 餐 饌"},
	{"ckH", "찮"},
	{"ckf", "찰 刹 察 擦 札 紮"},
	{"cka", "참 僭 參 塹 慘 慙 懺 斬 站 讒 讖"},
	{"ckq", "찹"},
	{"ckt", "찻"},
	{"ckT", "찼"},
	{"ckd", "창 倉 倡 創 唱 娼 廠 彰 愴 敞 昌 昶 暢 槍 滄 漲 猖 瘡 窓 脹 艙 菖 蒼"},
	{"ckw", "찾"},
	{"cor", "책 冊 柵 策 責"},
	{"cos", "챈"},
	{"cof", "챌"},
	{"coa", "챔"},
	{"coq", "챕"},
	{"cot", "챗"},
	{"coT", "챘"},
	{"cod", "챙"},
	{"cis", "챤"},
	{"ciH", "챦"},
	{"cif", "챨"},
	{"cia", "챰"},
	{"cid", "챵"},
	{"cjr", "척 倜 刺 剔 尺 慽 戚 拓 擲 斥 滌 瘠 脊 蹠 陟 隻"},
	{"cjs", "천 仟 千 喘 天 川 擅 泉 淺 玔 穿 舛 薦 賤 踐 遷 釧 闡 阡 韆"},
	{"cjf", "철 凸 哲 喆 徹 撤 澈 綴 輟 轍 鐵"},
	{"cja", "첨 僉 尖 沾 添 甛 瞻 簽 籤 詹 諂"},
	{"cjq", "첩 堞 妾 帖 捷 牒 疊 睫 諜 貼 輒"},
	{"cjt", "첫"},
	{"cjT", "첬"},
	{"cjd", "청 廳 晴 淸 聽 菁 請 靑 鯖"},
	{"cpr", "첵"},
	{"cps", "첸"},
	{"cpf", "첼"},
	{"cpa", "쳄"},
	{"cpq", "쳅"},
	{"cpt", "쳇"},
	{"cpd", "쳉"},
	{"cus", "쳔"},
	{"cuT", "쳤"},
	{"cPs", "쳰"},
	{"cPd", "촁"},
	{"chr", "촉 促 囑 燭 矗 蜀 觸"},
	{"chs", "촌 寸 忖 村 邨"},
	{"chf", "촐"},
	{"cha", "촘"},
	{"chq", "촙"},
	{"cht", "촛"},
	{"chd", "총 叢 塚 寵 悤 憁 摠 總 聰 蔥 銃"},
	{"cKs", "촨"},
	{"cKf", "촬 撮"},
	{"cKd", "촹"},
	{"cLs", "쵠"},
	{"cLf", "쵤"},
	{"cLa", "쵬"},
	{"cLq", "쵭"},
	{"cLt", "쵯"},
	{"cLd", "쵱"},
	{"cya", "춈"},
	{"cnr", "축 丑 畜 祝 竺 筑 築 縮 蓄 蹙 蹴 軸 逐"},
	{"cns", "춘 春 椿 瑃"},
	{"cnf", "출 出 朮 黜"},
	{"cna", "춤"},
	{"cnq", "춥"},
	{"cnt", "춧"},
	{"cnd", "충 充 忠 沖 蟲 衝 衷"},
	{"cJT", "췄"},
	{"cNs", "췐"},
	{"cBs", "췬"},
	{"cBf", "췰"},
	{"cBa", "췸"},
	{"cBq", "췹"},
	{"cBt", "췻"},
	{"cBd", "췽"},
	{"cbs", "츈"},
	{"cbf", "츌"},
	{"cba", "츔"},
	{"cbd", "츙"},
	{"cmr", "측 側 仄 厠 惻 測"},
	{"cms", "츤"},
	{"cmf", "츨"},
	{"cma", "츰"},
	{"cmq", "츱"},
	{"cmt", "츳"},
	{"cmd", "층 層"},
	{"clr", "칙 則 勅 飭"},
	{"cls", "친 親"},
	{"cle", "칟"},
	{"clf", "칠 七 柒 漆"},
	{"clG", "칡"},
	{"cla", "침 侵 寢 枕 沈 浸 琛 砧 針 鍼"},
	{"clq", "칩 蟄"},
	{"clt", "칫"},
	{"cld", "칭 秤 稱"},
	{"zkr", "칵"},
	{"zks", "칸"},
	{"zkf", "칼"},
	{"zka", "캄"},
	{"zkq", "캅"},
	{"zkt", "캇"},
	{"zkd", "캉"},
	{"zor", "캑"},
	{"zos", "캔"},
	{"zof", "캘"},
	{"zoa", "캠"},
	{"zoq", "캡"},
	{"zot", "캣"},
	{"zoT", "캤"},
	{"zod", "캥"},
	{"zir", "캭"},
	{"zid", "컁"},
	{"zjr", "컥"},
	{"zjs", "컨"},
	{"zje", "컫"},
	{"zjf", "컬"},
	{"zja", "컴"},
	{"zjq", "컵"},
	{"zjt", "컷"},
	{"zjT", "컸"},
	{"zjd", "컹"},
	{"zpr", "켁"},
	{"zps", "켄"},
	{"zpf", "켈"},
	{"zpa", "켐"},
	{"zpq", "켑"},
	{"zpt", "켓"},
	{"zpd", "켕"},
	{"zus", "켠"},
	{"zuf", "켤"},
	{"zua", "켬"},
	{"zuq", "켭"},
	{"zut", "켯"},
	{"zuT", "켰"},
	{"zud", "켱"},
	{"zhr", "콕"},
	{"zhs", "콘"},
	{"zhf", "콜"},
	{"zha", "콤"},
	{"zhq", "콥"},
	{"zht", "콧"},
	{"zhd", "콩"},
	{"zKr", "콱"},
	{"zKs", "콴"},
	{"zKf", "콸"},
	{"zKa", "쾀"},
	{"zKd", "쾅"},
	{"zHd", "쾡"},
	{"zLf", "쾰"},
	{"znr", "쿡"},
	{"zns", "쿤"},
	{"znf", "쿨"},
	{"zna", "쿰"},
	{"znq", "쿱"},
	{"znt", "쿳"},
	{"znd", "쿵"},
	{"zJs", "퀀"},
	{"zJf", "퀄"},
	{"zJd", "퀑"},
	{"zNd", "퀭"},
	{"zBr", "퀵"},
	{"zBs", "퀸"},
	{"zBf", "퀼"},
	{"zBa", "큄"},
	{"zBq", "큅"},
	{"zBt", "큇"},
	{"zBd", "큉"},
	{"zbs", "큔"},
	{"zbf", "큘"},
	{"zba", "큠"},
	{"zmr", "큭"},
	{"zms", "큰"},
	{"zmf", "클"},
	{"zma", "큼"},
	{"zmq", "큽"},
	{"zmd", "킁"},
	{"zlr", "킥"},
	{"zls", "킨"},
	{"zlf", "킬"},
	{"zla", "킴"},
	{"zlq", "킵"},
	{"zlt", "킷"},
	{"zld", "킹"},
	{"xkr", "탁 倬 卓 啄 坼 度 托 拓 擢 晫 柝 濁 濯 琢 琸 託 鐸"},
	{"xks", "탄 呑 嘆 坦 彈 憚 歎 灘 炭 綻 誕"},
	{"xkf", "탈 奪 脫"},
	{"xkG", "탉"},
	{"xka", "탐 探 眈 耽 貪"},
	{"xkq", "탑 塔 搭 榻"},
	{"xkt", "탓"},
	{"xkT", "탔"},
	{"xkd", "탕 宕 帑 湯 糖 蕩"},
	{"xor", "택 宅 擇 澤"},
	{"xos", "탠"},
	{"xof", "탤"},
	{"xoa", "탬"},
	{"xoq", "탭"},
	{"xot", "탯"},
	{"xoT", "탰"},
	{"xod", "탱 撑"},
	{"xid", "턍"},
	{"xjr", "턱"},
	{"xjs", "턴"},
	{"xjf", "털"},
	{"xjM", "턺"},
	{"xja", "텀"},
	{"xjq", "텁"},
	{"xjt", "텃"},
	{"xjT", "텄"},
	{"xjd", "텅"},
	{"xpr", "텍"},
	{"xps", "텐"},
	{"xpf", "텔"},
	{"xpa", "템"},
	{"xpq", "텝"},
	{"xpt", "텟"},
	{"xpd", "텡"},
	{"xus", "텬"},
	{"xuT", "텼"},
	{"xPs", "톈"},
	{"xhr", "톡"},
	{"xhs", "톤"},
	{"xhf", "톨"},
	{"xha", "톰"},
	{"xhq", "톱"},
	{"xht", "톳"},
	{"xhd", "통 慟 桶 洞 痛 筒 統 通"},
	{"xhv", "톺"},
	{"xKs", "퇀"},
	{"xLs", "퇸"},
	{"xLt", "툇"},
	{"xLd", "툉"},
	{"xnr", "툭"},
	{"xns", "툰"},
	{"xnf", "툴"},
	{"xna", "툼"},
	{"xnq", "툽"},
	{"xnt", "툿"},
	{"xnd", "퉁"},
	{"xJT", "퉜"},
	{"xBr", "튁"},
	{"xBs", "튄"},
	{"xBf", "튈"},
	{"xBa", "튐"},
	{"xBq", "튑"},
	{"xBd", "튕"},
	{"xbs", "튠"},
	{"xbf", "튤"},
	{"xba", "튬"},
	{"xbd", "튱"},
	{"xmr", "특 慝 特"},
	{"xms", "튼"},
	{"xme", "튿"},
	{"xmf", "틀"},
	{"xmM", "틂"},
	{"xma", "틈"},
	{"xmq", "틉"},
	{"xmt", "틋"},
	{"xMs", "틘"},
	{"xMf", "틜"},
	{"xMa", "틤"},
	{"xMq", "틥"},
	{"xlr", "틱"},
	{"xls", "틴"},
	{"xlf", "틸"},
	{"xla", "팀"},
	{"xlq", "팁"},
	{"xlt", "팃"},
	{"xld", "팅"},
	{"vkr", "팍"},
	{"vkR", "팎"},
	{"vks", "판 判 坂 板 版 瓣 販 辦 鈑 阪"},
	{"vkf", "팔 八 叭 捌"},
	{"vkM", "팖"},
	{"vka", "팜"},
	{"vkq", "팝"},
	{"vkt", "팟"},
	{"vkT", "팠"},
	{"vkd", "팡"},
	{"vkx", "팥"},
	{"vor", "팩"},
	{"vos", "팬"},
	{"vof", "팰"},
	{"voa", "팸"},
	{"voq", "팹"},
	{"vot", "팻"},
	{"voT", "팼"},
	{"vod", "팽 彭 澎 烹 膨"},
	{"vir", "퍅 愎"},
	{"vjr", "퍽"},
	{"vjs", "펀"},
	{"vjf", "펄"},
	{"vja", "펌"},
	{"vjq", "펍"},
	{"vjt", "펏"},
	{"vjT", "펐"},
	{"vjd", "펑"},
	{"vpr", "펙"},
	{"vps", "펜"},
	{"vpf", "펠"},
	{"vpa", "펨"},
	{"vpq", "펩"},
	{"vpt", "펫"},
	{"vpd", "펭"},
	{"vus", "편 便 偏 扁 片 篇 編 翩 遍 鞭 騙"},
	{"vuf", "펼"},
	{"vua", "폄 貶"},
	{"vuq", "폅"},
	{"vuT", "폈"},
	{"vud", "평 坪 平 枰 萍 評"},
	{"vPf", "폘"},
	{"vPq", "폡"},
	{"vPt", "폣"},
	{"vhr", "폭 幅 暴 曝 瀑 爆 輻"},
	{"vhs", "폰"},
	{"vhf", "폴"},
	{"vha", "폼"},
	{"vhq", "폽"},
	{"vht", "폿"},
	{"vhd", "퐁"},
	{"vKd", "퐝"},
	{"vLs", "푄"},
	{"vys", "푠"},
	{"vyf", "푤"},
	{"vyq", "푭"},
	{"vyt", "푯"},
	{"vnr", "푹"},
	{"vns", "푼"},
	{"vne", "푿"},
	{"vnf", "풀"},
	{"vnM", "풂"},
	{"vna", "품 品 稟"},
	{"vnq", "풉"},
	{"vnt", "풋"},
	{"vnd", "풍 楓 諷 豊 風 馮"},
	{"vJd", "풩"},
	{"vBs", "퓐"},
	{"vBf", "퓔"},
	{"vBa", "퓜"},
	{"vBt", "퓟"},
	{"vbs", "퓬"},
	{"vbf", "퓰"},
	{"vba", "퓸"},
	{"vbt", "퓻"},
	{"vbd", "퓽"},
	{"vms", "픈"},
	{"vmf", "플"},
	{"vma", "픔"},
	{"vmq", "픕"},
	{"vmt", "픗"},
	{"vlr", "픽"},
	{"vls", "핀"},
	{"vlf", "필 匹 弼 必 泌 珌 畢 疋 筆 苾 馝"},
	{"vla", "핍 乏 逼"},
	{"vlq", "핍"},
	{"vlt", "핏"},
	{"vld", "핑"},
	{"gkr", "학 壑 學 虐 謔 鶴"},
	{"gks", "한 寒 恨 悍 旱 汗 漢 澣 瀚 罕 翰 閑 閒 限 韓"},
	{"gkf", "할 割 轄"},
	{"gkB", "핥"},
	{"gka", "함 函 含 咸 啣 喊 檻 涵 緘 艦 銜 陷 鹹"},
	{"gkq", "합 合 哈 盒 蛤 閤 闔 陜"},
	{"gkt", "핫"},
	{"gkd", "항 亢 伉 姮 嫦 巷 恒 抗 杭 桁 沆 港 缸 肛 航 行 降 項"},
	{"gor", "핵 劾 核"},
	{"gos", "핸"},
	{"gof", "핼"},
	{"goa", "햄"},
	{"goq", "햅"},
	{"got", "햇"},
	{"goT", "했"},
	{"god", "행 倖 幸 杏 荇 行"},
	{"gid", "향 享 向 嚮 珦 鄕 響 餉 饗 香"},
	{"gjr", "헉"},
	{"gjs", "헌 憲 櫶 獻 軒"},
	{"gjf", "헐 歇"},
	{"gjM", "헒"},
	{"gja", "험 險 驗"},
	{"gjq", "헙"},
	{"gjt", "헛"},
	{"gjd", "헝"},
	{"gpr", "헥"},
	{"gps", "헨"},
	{"gpf", "헬"},
	{"gpa", "헴"},
	{"gpq", "헵"},
	{"gpt", "헷"},
	{"gpd", "헹"},
	{"gur", "혁 奕 爀 赫 革"},
	{"gus", "현 俔 峴 弦 懸 晛 泫 炫 玄 玹 現 眩 睍 絃 絢 縣 舷 衒 見 賢 鉉 顯"},
	{"guf", "혈 孑 穴 血 頁"},
	{"gua", "혐 嫌"},
	{"guq", "협 俠 協 夾 峽 挾 浹 狹 脅 脇 莢 鋏 頰"},
	{"gut", "혓"},
	{"guT", "혔"},
	{"gud", "형 亨 兄 刑 型 形 泂 滎 瀅 灐 炯 熒 珩 瑩 荊 螢 衡 逈 邢 鎣 馨"},
	{"gPs", "혠"},
	{"gPf", "혤"},
	{"gPq", "혭"},
	{"ghr", "혹 惑 或 酷"},
	{"ghs", "혼 婚 昏 混 渾 琿 魂"},
	{"ghf", "홀 忽 惚 笏"},
	{"ghB", "홅"},
	{"gha", "홈"},
	{"ghq", "홉"},
	{"ght", "홋"},
	{"ghd", "홍 哄 弘 汞 泓 洪 烘 紅 虹 訌 鴻"},
	{"ghx", "홑"},
	{"gKr", "확 廓 擴 攫 確 碻 穫"},
	{"gKs", "환 丸 喚 奐 宦 幻 患 換 歡 晥 桓 渙 煥 環 紈 還 驩 鰥"},
	{"gKf", "활 活 滑 猾 豁 闊"},
	{"gKt", "홧"},
	{"gKd", "황 凰 幌 徨 恍 惶 愰 慌 晃 晄 榥 況 湟 滉 潢 煌 璜 皇 篁 簧 荒 蝗 遑 隍 黃"},
	{"gHr", "홱"},
	{"gHs", "홴"},
	{"gHt", "횃"},
	{"gHd", "횅"},
	{"gLr", "획 劃 獲"},
	{"gLs", "횐"},
	{"gLf", "횔"},
	{"gLq", "횝"},
	{"gLt", "횟"},
	{"gLd", "횡 宖 橫 鐄"},
	{"gys", "횬"},
	{"gyf", "횰"},
	{"gyq", "횹"},
	{"gyt", "횻"},
	{"gnr", "훅"},
	{"gns", "훈 勛 勳 塤 壎 焄 熏 燻 薰 訓 暈"},
	{"gnf", "훌"},
	{"gnB", "훑"},
	{"gna", "훔"},
	{"gnt", "훗"},
	{"gnd", "훙 薨"},
	{"gJs", "훤 喧 暄 煊 萱"},
	{"gJf", "훨"},
	{"gJa", "훰"},
	{"gJd", "훵"},
	{"gNr", "훽"},
	{"gNs", "휀"},
	{"gNf", "휄"},
	{"gNd", "휑"},
	{"gBr", "휙"},
	{"gBs", "휜"},
	{"gBf", "휠"},
	{"gBa", "휨"},
	{"gBq", "휩"},
	{"gBt", "휫"},
	{"gBd", "휭"},
	{"gbr", "휵"},
	{"gbs", "휸"},
	{"gbf", "휼 恤 譎 鷸"},
	{"gba", "흄"},
	{"gbt", "흇"},
	{"gbd", "흉 兇 凶 匈 洶 胸"},
	{"gmr", "흑 黑"},
	{"gms", "흔 昕 欣 炘 痕"},
	{"gmH", "흖"},
	{"gme", "흗"},
	{"gmf", "흘 吃 屹 紇 訖"},
	{"gmG", "흙"},
	{"gma", "흠 欠 欽 歆"},
	{"gmq", "흡 吸 恰 洽 翕"},
	{"gmt", "흣"},
	{"gmd", "흥 興"},
	{"gmx", "흩"},
	{"gMs", "흰"},
	{"gMf", "흴"},
	{"gMa", "흼"},
	{"gMq", "흽"},
	{"gMd", "힁"},
	{"glr", "힉"},
	{"gls", "힌"},
	{"glf", "힐 詰"},
	{"gla", "힘"},
	{"glq", "힙"},
	{"glt", "힛"},
	{"gld", "힝"},
	{NIL_PTR}
};
