/***************************************************
	mined keyboard mapping table
	* generated with mkkbmap
	  from lib/kbmaps/cxterm/ks/HANGUL.tit
	* with additional punctuation mappings
*/
struct keymap keymap_HANGUL [] = {
	{"!", "！"},
	{"#", "〃 々 〆 〇 〜 ￦"},
	{"$", "￦"},
	{"&", "―"},
	{"(", "（"},
	{")", "）"},
	{",", "，"},
	{".", "。"},
	{":", "："},
	{";", "；"},
	{"<", "〈"},
	{"<<", "《"},
	{">", "〉"},
	{">>", "》"},
	{"?", "？"},
	{"@", "・"},
	{"[", "【 〖 〔 「 『"},
	{"\\", "、"},
	{"]", "】 〗 〕 」 』"},
	{"^", "……"},
	{"_", "――"},
	{"«", "《"},
	{"»", "》"},
	{"€", "€ ＄ ￥ ￦ ￡ ￠ ￢ ￣"},

	{"r", "ㄱ"},
	{"R", "ㄲ"},
	{"s", "ㄴ"},
	{"e", "ㄷ"},
	{"E", "ㄸ"},
	{"f", "ㄹ"},
	{"a", "ㅁ"},
	{"q", "ㅂ"},
	{"Q", "ㅃ"},
	{"t", "ㅅ"},
	{"T", "ㅆ"},
	{"d", "ㅇ"},
	{"w", "ㅈ"},
	{"W", "ㅉ"},
	{"c", "ㅊ"},
	{"z", "ㅋ"},
	{"x", "ㅌ"},
	{"v", "ㅍ"},
	{"g", "ㅎ"},
	{"k", "ㅏ"},
	{"o", "ㅐ"},
	{"i", "ㅑ"},
	{"O", "ㅒ"},
	{"j", "ㅓ"},
	{"p", "ㅔ"},
	{"u", "ㅕ"},
	{"P", "ㅖ"},
	{"h", "ㅗ"},
	{"K", "ㅘ"},
	{"H", "ㅙ"},
	{"L", "ㅚ"},
	{"y", "ㅛ"},
	{"n", "ㅜ"},
	{"J", "ㅝ"},
	{"N", "ㅞ"},
	{"B", "ㅟ"},
	{"b", "ㅠ"},
	{"m", "ㅡ"},
	{"M", "ㅢ"},
	{"l", "ㅣ"},
	{"rk", "가"},
	{"ro", "개"},
	{"ri", "갸"},
	{"rO", "걔"},
	{"rj", "거"},
	{"rp", "게"},
	{"ru", "겨"},
	{"rP", "계"},
	{"rh", "고"},
	{"rK", "과"},
	{"rH", "괘"},
	{"rL", "괴"},
	{"ry", "교"},
	{"rn", "구"},
	{"rJ", "궈"},
	{"rN", "궤"},
	{"rB", "귀"},
	{"rb", "규"},
	{"rm", "그"},
	{"rM", "긔"},
	{"rl", "기"},
	{"Rk", "까"},
	{"Ro", "깨"},
	{"Ri", "꺄"},
	{"Rj", "꺼"},
	{"Rp", "께"},
	{"Ru", "껴"},
	{"RP", "꼐"},
	{"Rh", "꼬"},
	{"RK", "꽈"},
	{"RH", "꽤"},
	{"RL", "꾀"},
	{"Ry", "꾜"},
	{"Rn", "꾸"},
	{"RJ", "꿔"},
	{"RN", "꿰"},
	{"RB", "뀌"},
	{"Rb", "뀨"},
	{"Rm", "끄"},
	{"Rl", "끼"},
	{"sk", "나"},
	{"so", "내"},
	{"si", "냐"},
	{"sj", "너"},
	{"sp", "네"},
	{"su", "녀"},
	{"sP", "녜"},
	{"sh", "노"},
	{"sK", "놔"},
	{"sL", "뇌"},
	{"sy", "뇨"},
	{"sn", "누"},
	{"sJ", "눠"},
	{"sN", "눼"},
	{"sB", "뉘"},
	{"sb", "뉴"},
	{"sm", "느"},
	{"sM", "늬"},
	{"sl", "니"},
	{"ek", "다"},
	{"eo", "대"},
	{"ei", "댜"},
	{"ej", "더"},
	{"ep", "데"},
	{"eu", "뎌"},
	{"eP", "뎨"},
	{"eh", "도"},
	{"eK", "돠"},
	{"eH", "돼"},
	{"eL", "되"},
	{"ey", "됴"},
	{"en", "두"},
	{"eJ", "둬"},
	{"eN", "뒈"},
	{"eB", "뒤"},
	{"eb", "듀"},
	{"em", "드"},
	{"eM", "듸"},
	{"el", "디"},
	{"Ek", "따"},
	{"Eo", "때"},
	{"Ej", "떠"},
	{"Ep", "떼"},
	{"Eu", "뗘"},
	{"Eh", "또"},
	{"EK", "똬"},
	{"EH", "뙈"},
	{"EL", "뙤"},
	{"En", "뚜"},
	{"EN", "뛔"},
	{"EB", "뛰"},
	{"Em", "뜨"},
	{"EM", "띄"},
	{"El", "띠"},
	{"fk", "라"},
	{"fo", "래"},
	{"fi", "랴"},
	{"fj", "러"},
	{"fp", "레"},
	{"fu", "려"},
	{"fP", "례"},
	{"fh", "로"},
	{"fK", "롸"},
	{"fL", "뢰"},
	{"fy", "료"},
	{"fn", "루"},
	{"fJ", "뤄"},
	{"fN", "뤠"},
	{"fB", "뤼"},
	{"fb", "류"},
	{"fm", "르"},
	{"fl", "리"},
	{"ak", "마"},
	{"ao", "매"},
	{"ai", "먀"},
	{"aj", "머"},
	{"ap", "메"},
	{"au", "며"},
	{"aP", "몌"},
	{"ah", "모"},
	{"aK", "뫄"},
	{"aL", "뫼"},
	{"ay", "묘"},
	{"an", "무"},
	{"aJ", "뭐"},
	{"aN", "뭬"},
	{"aB", "뮈"},
	{"ab", "뮤"},
	{"am", "므"},
	{"al", "미"},
	{"qk", "바"},
	{"qo", "배"},
	{"qi", "뱌"},
	{"qj", "버"},
	{"qp", "베"},
	{"qu", "벼"},
	{"qP", "볘"},
	{"qh", "보"},
	{"qK", "봐"},
	{"qH", "봬"},
	{"qL", "뵈"},
	{"qy", "뵤"},
	{"qn", "부"},
	{"qJ", "붜"},
	{"qN", "붸"},
	{"qB", "뷔"},
	{"qb", "뷰"},
	{"qm", "브"},
	{"ql", "비"},
	{"Qk", "빠"},
	{"Qo", "빼"},
	{"Qi", "뺘"},
	{"Qj", "뻐"},
	{"Qp", "뻬"},
	{"Qu", "뼈"},
	{"Qh", "뽀"},
	{"QL", "뾔"},
	{"Qy", "뾰"},
	{"Qn", "뿌"},
	{"Qb", "쀼"},
	{"Qm", "쁘"},
	{"Ql", "삐"},
	{"tk", "사"},
	{"to", "새"},
	{"ti", "샤"},
	{"tO", "섀"},
	{"tj", "서"},
	{"tp", "세"},
	{"tu", "셔"},
	{"tP", "셰"},
	{"th", "소"},
	{"tK", "솨"},
	{"tH", "쇄"},
	{"tL", "쇠"},
	{"ty", "쇼"},
	{"tn", "수"},
	{"tJ", "숴"},
	{"tN", "쉐"},
	{"tB", "쉬"},
	{"tb", "슈"},
	{"tm", "스"},
	{"tl", "시"},
	{"Tk", "싸"},
	{"To", "쌔"},
	{"Tj", "써"},
	{"Tp", "쎄"},
	{"Th", "쏘"},
	{"TK", "쏴"},
	{"TH", "쐐"},
	{"TL", "쐬"},
	{"Ty", "쑈"},
	{"Tn", "쑤"},
	{"TJ", "쒀"},
	{"TN", "쒜"},
	{"TB", "쒸"},
	{"Tm", "쓰"},
	{"TM", "씌"},
	{"Tl", "씨"},
	{"dk", "아"},
	{"do", "애"},
	{"di", "야"},
	{"dO", "얘"},
	{"dj", "어"},
	{"dp", "에"},
	{"du", "여"},
	{"dP", "예"},
	{"dh", "오"},
	{"dK", "와"},
	{"dH", "왜"},
	{"dL", "외"},
	{"dy", "요"},
	{"dn", "우"},
	{"dJ", "워"},
	{"dN", "웨"},
	{"dB", "위"},
	{"db", "유"},
	{"dm", "으"},
	{"dM", "의"},
	{"dl", "이"},
	{"wk", "자"},
	{"wo", "재"},
	{"wi", "쟈"},
	{"wO", "쟤"},
	{"wj", "저"},
	{"wp", "제"},
	{"wu", "져"},
	{"wP", "졔"},
	{"wh", "조"},
	{"wK", "좌"},
	{"wH", "좨"},
	{"wL", "죄"},
	{"wy", "죠"},
	{"wn", "주"},
	{"wJ", "줘"},
	{"wN", "줴"},
	{"wB", "쥐"},
	{"wb", "쥬"},
	{"wm", "즈"},
	{"wl", "지"},
	{"Wk", "짜"},
	{"Wo", "째"},
	{"Wi", "쨔"},
	{"Wj", "쩌"},
	{"Wp", "쩨"},
	{"Wu", "쪄"},
	{"Wh", "쪼"},
	{"WK", "쫘"},
	{"WH", "쫴"},
	{"WL", "쬐"},
	{"Wn", "쭈"},
	{"WJ", "쭤"},
	{"WB", "쮜"},
	{"Wb", "쮸"},
	{"Wm", "쯔"},
	{"Wl", "찌"},
	{"ck", "차"},
	{"co", "채"},
	{"ci", "챠"},
	{"cj", "처"},
	{"cp", "체"},
	{"cu", "쳐"},
	{"cP", "쳬"},
	{"ch", "초"},
	{"cK", "촤"},
	{"cL", "최"},
	{"cy", "쵸"},
	{"cn", "추"},
	{"cJ", "춰"},
	{"cN", "췌"},
	{"cB", "취"},
	{"cb", "츄"},
	{"cm", "츠"},
	{"cl", "치"},
	{"zk", "카"},
	{"zo", "캐"},
	{"zi", "캬"},
	{"zj", "커"},
	{"zp", "케"},
	{"zu", "켜"},
	{"zP", "켸"},
	{"zh", "코"},
	{"zK", "콰"},
	{"zH", "쾌"},
	{"zL", "쾨"},
	{"zy", "쿄"},
	{"zn", "쿠"},
	{"zJ", "쿼"},
	{"zN", "퀘"},
	{"zB", "퀴"},
	{"zb", "큐"},
	{"zm", "크"},
	{"zl", "키"},
	{"xk", "타"},
	{"xo", "태"},
	{"xi", "탸"},
	{"xj", "터"},
	{"xp", "테"},
	{"xu", "텨"},
	{"xP", "톄"},
	{"xh", "토"},
	{"xK", "톼"},
	{"xH", "퇘"},
	{"xL", "퇴"},
	{"xy", "툐"},
	{"xn", "투"},
	{"xJ", "퉈"},
	{"xN", "퉤"},
	{"xB", "튀"},
	{"xb", "튜"},
	{"xm", "트"},
	{"xM", "틔"},
	{"xl", "티"},
	{"vk", "파"},
	{"vo", "패"},
	{"vi", "퍄"},
	{"vj", "퍼"},
	{"vp", "페"},
	{"vu", "펴"},
	{"vP", "폐"},
	{"vh", "포"},
	{"vK", "퐈"},
	{"vL", "푀"},
	{"vy", "표"},
	{"vn", "푸"},
	{"vJ", "풔"},
	{"vB", "퓌"},
	{"vb", "퓨"},
	{"vm", "프"},
	{"vl", "피"},
	{"gk", "하"},
	{"go", "해"},
	{"gi", "햐"},
	{"gj", "허"},
	{"gp", "헤"},
	{"gu", "혀"},
	{"gP", "혜"},
	{"gh", "호"},
	{"gK", "화"},
	{"gH", "홰"},
	{"gL", "회"},
	{"gy", "효"},
	{"gn", "후"},
	{"gJ", "훠"},
	{"gN", "훼"},
	{"gB", "휘"},
	{"gb", "휴"},
	{"gm", "흐"},
	{"gM", "희"},
	{"gl", "히"},
	{"rkr", "각"},
	{"rks", "간"},
	{"rke", "갇"},
	{"rkf", "갈"},
	{"rkG", "갉"},
	{"rkM", "갊"},
	{"rka", "감"},
	{"rkq", "갑"},
	{"rkC", "값"},
	{"rkt", "갓"},
	{"rkT", "갔"},
	{"rkd", "강"},
	{"rkw", "갖"},
	{"rkc", "갗"},
	{"rkx", "같"},
	{"rkv", "갚"},
	{"rkg", "갛"},
	{"ror", "객"},
	{"ros", "갠"},
	{"rof", "갤"},
	{"roa", "갬"},
	{"roq", "갭"},
	{"rot", "갯"},
	{"roT", "갰"},
	{"rod", "갱"},
	{"rir", "갹"},
	{"ris", "갼"},
	{"rif", "걀"},
	{"rit", "걋"},
	{"rid", "걍"},
	{"rOs", "걘"},
	{"rOf", "걜"},
	{"rjr", "걱"},
	{"rjs", "건"},
	{"rje", "걷"},
	{"rjf", "걸"},
	{"rjM", "걺"},
	{"rja", "검"},
	{"rjq", "겁"},
	{"rjt", "것"},
	{"rjT", "겄"},
	{"rjd", "겅"},
	{"rjw", "겆"},
	{"rjx", "겉"},
	{"rjv", "겊"},
	{"rjg", "겋"},
	{"rps", "겐"},
	{"rpf", "겔"},
	{"rpa", "겜"},
	{"rpq", "겝"},
	{"rpt", "겟"},
	{"rpT", "겠"},
	{"rpd", "겡"},
	{"rur", "격"},
	{"ruR", "겪"},
	{"rus", "견"},
	{"rue", "겯"},
	{"ruf", "결"},
	{"rua", "겸"},
	{"ruq", "겹"},
	{"rut", "겻"},
	{"ruT", "겼"},
	{"rud", "경"},
	{"rux", "곁"},
	{"rPs", "곈"},
	{"rPf", "곌"},
	{"rPq", "곕"},
	{"rPt", "곗"},
	{"rhr", "곡"},
	{"rhs", "곤"},
	{"rhe", "곧"},
	{"rhf", "골"},
	{"rhM", "곪"},
	{"rhN", "곬"},
	{"rhF", "곯"},
	{"rha", "곰"},
	{"rhq", "곱"},
	{"rht", "곳"},
	{"rhd", "공"},
	{"rhw", "곶"},
	{"rKr", "곽"},
	{"rKs", "관"},
	{"rKf", "괄"},
	{"rKM", "괆"},
	{"rKa", "괌"},
	{"rKq", "괍"},
	{"rKt", "괏"},
	{"rKd", "광"},
	{"rHs", "괜"},
	{"rHf", "괠"},
	{"rHq", "괩"},
	{"rHT", "괬"},
	{"rHd", "괭"},
	{"rLr", "괵"},
	{"rLs", "괸"},
	{"rLf", "괼"},
	{"rLa", "굄"},
	{"rLq", "굅"},
	{"rLt", "굇"},
	{"rLd", "굉"},
	{"rys", "굔"},
	{"ryf", "굘"},
	{"ryq", "굡"},
	{"ryt", "굣"},
	{"rnr", "국"},
	{"rns", "군"},
	{"rne", "굳"},
	{"rnf", "굴"},
	{"rnG", "굵"},
	{"rnM", "굶"},
	{"rnF", "굻"},
	{"rna", "굼"},
	{"rnq", "굽"},
	{"rnt", "굿"},
	{"rnd", "궁"},
	{"rnw", "궂"},
	{"rJr", "궉"},
	{"rJs", "권"},
	{"rJf", "궐"},
	{"rJT", "궜"},
	{"rJd", "궝"},
	{"rNt", "궷"},
	{"rBr", "귁"},
	{"rBs", "귄"},
	{"rBf", "귈"},
	{"rBa", "귐"},
	{"rBq", "귑"},
	{"rBt", "귓"},
	{"rbs", "균"},
	{"rbf", "귤"},
	{"rmr", "극"},
	{"rms", "근"},
	{"rme", "귿"},
	{"rmf", "글"},
	{"rmG", "긁"},
	{"rma", "금"},
	{"rmq", "급"},
	{"rmt", "긋"},
	{"rmd", "긍"},
	{"rlr", "긱"},
	{"rls", "긴"},
	{"rle", "긷"},
	{"rlf", "길"},
	{"rlM", "긺"},
	{"rla", "김"},
	{"rlq", "깁"},
	{"rlt", "깃"},
	{"rld", "깅"},
	{"rlw", "깆"},
	{"rlv", "깊"},
	{"Rkr", "깍"},
	{"RkR", "깎"},
	{"Rks", "깐"},
	{"Rkf", "깔"},
	{"RkM", "깖"},
	{"Rka", "깜"},
	{"Rkq", "깝"},
	{"Rkt", "깟"},
	{"RkT", "깠"},
	{"Rkd", "깡"},
	{"Rkx", "깥"},
	{"Ror", "깩"},
	{"Ros", "깬"},
	{"Rof", "깰"},
	{"Roa", "깸"},
	{"Roq", "깹"},
	{"Rot", "깻"},
	{"RoT", "깼"},
	{"Rod", "깽"},
	{"Rir", "꺅"},
	{"Rif", "꺌"},
	{"Rjr", "꺽"},
	{"RjR", "꺾"},
	{"Rjs", "껀"},
	{"Rjf", "껄"},
	{"Rja", "껌"},
	{"Rjq", "껍"},
	{"Rjt", "껏"},
	{"RjT", "껐"},
	{"Rjd", "껑"},
	{"Rpr", "껙"},
	{"Rps", "껜"},
	{"Rpa", "껨"},
	{"Rpt", "껫"},
	{"Rpd", "껭"},
	{"Rus", "껸"},
	{"Ruf", "껼"},
	{"Rut", "꼇"},
	{"RuT", "꼈"},
	{"Rux", "꼍"},
	{"Rhr", "꼭"},
	{"Rhs", "꼰"},
	{"RhH", "꼲"},
	{"Rhf", "꼴"},
	{"Rha", "꼼"},
	{"Rhq", "꼽"},
	{"Rht", "꼿"},
	{"Rhd", "꽁"},
	{"Rhw", "꽂"},
	{"Rhc", "꽃"},
	{"RKr", "꽉"},
	{"RKf", "꽐"},
	{"RKT", "꽜"},
	{"RKd", "꽝"},
	{"RHr", "꽥"},
	{"RHd", "꽹"},
	{"RLs", "꾄"},
	{"RLf", "꾈"},
	{"RLa", "꾐"},
	{"RLq", "꾑"},
	{"RLd", "꾕"},
	{"Rnr", "꾹"},
	{"Rns", "꾼"},
	{"Rnf", "꿀"},
	{"RnF", "꿇"},
	{"Rna", "꿈"},
	{"Rnq", "꿉"},
	{"Rnt", "꿋"},
	{"Rnd", "꿍"},
	{"Rnw", "꿎"},
	{"RJf", "꿜"},
	{"RJT", "꿨"},
	{"RJd", "꿩"},
	{"RNr", "꿱"},
	{"RNs", "꿴"},
	{"RNf", "꿸"},
	{"RNa", "뀀"},
	{"RNq", "뀁"},
	{"RNT", "뀄"},
	{"RBs", "뀐"},
	{"RBf", "뀔"},
	{"RBa", "뀜"},
	{"RBq", "뀝"},
	{"Rmr", "끅"},
	{"Rms", "끈"},
	{"RmH", "끊"},
	{"Rmf", "끌"},
	{"RmM", "끎"},
	{"RmF", "끓"},
	{"Rma", "끔"},
	{"Rmq", "끕"},
	{"Rmt", "끗"},
	{"Rmd", "끙"},
	{"Rmx", "끝"},
	{"Rlr", "끽"},
	{"Rls", "낀"},
	{"Rlf", "낄"},
	{"Rla", "낌"},
	{"Rlq", "낍"},
	{"Rlt", "낏"},
	{"Rld", "낑"},
	{"skr", "낙"},
	{"skR", "낚"},
	{"sks", "난"},
	{"ske", "낟"},
	{"skf", "날"},
	{"skG", "낡"},
	{"skM", "낢"},
	{"ska", "남"},
	{"skq", "납"},
	{"skt", "낫"},
	{"skT", "났"},
	{"skd", "낭"},
	{"skw", "낮"},
	{"skc", "낯"},
	{"skx", "낱"},
	{"skg", "낳"},
	{"sor", "낵"},
	{"sos", "낸"},
	{"sof", "낼"},
	{"soa", "냄"},
	{"soq", "냅"},
	{"sot", "냇"},
	{"soT", "냈"},
	{"sod", "냉"},
	{"sir", "냑"},
	{"sis", "냔"},
	{"sif", "냘"},
	{"sia", "냠"},
	{"sid", "냥"},
	{"sjr", "넉"},
	{"sjS", "넋"},
	{"sjs", "넌"},
	{"sjf", "널"},
	{"sjM", "넒"},
	{"sjA", "넓"},
	{"sja", "넘"},
	{"sjq", "넙"},
	{"sjt", "넛"},
	{"sjT", "넜"},
	{"sjd", "넝"},
	{"sjg", "넣"},
	{"spr", "넥"},
	{"sps", "넨"},
	{"spf", "넬"},
	{"spa", "넴"},
	{"spq", "넵"},
	{"spt", "넷"},
	{"spT", "넸"},
	{"spd", "넹"},
	{"sur", "녁"},
	{"sus", "년"},
	{"suf", "녈"},
	{"sua", "념"},
	{"suq", "녑"},
	{"suT", "녔"},
	{"sud", "녕"},
	{"suz", "녘"},
	{"sPs", "녠"},
	{"shr", "녹"},
	{"shs", "논"},
	{"shf", "놀"},
	{"shM", "놂"},
	{"sha", "놈"},
	{"shq", "놉"},
	{"sht", "놋"},
	{"shd", "농"},
	{"shv", "높"},
	{"shg", "놓"},
	{"sKs", "놘"},
	{"sKf", "놜"},
	{"sKT", "놨"},
	{"sLs", "뇐"},
	{"sLf", "뇔"},
	{"sLa", "뇜"},
	{"sLq", "뇝"},
	{"sLt", "뇟"},
	{"syr", "뇩"},
	{"sys", "뇬"},
	{"syf", "뇰"},
	{"syq", "뇹"},
	{"syt", "뇻"},
	{"syd", "뇽"},
	{"snr", "눅"},
	{"sns", "눈"},
	{"sne", "눋"},
	{"snf", "눌"},
	{"sna", "눔"},
	{"snq", "눕"},
	{"snt", "눗"},
	{"snd", "눙"},
	{"sJT", "눴"},
	{"sBs", "뉜"},
	{"sBf", "뉠"},
	{"sBa", "뉨"},
	{"sBq", "뉩"},
	{"sbr", "뉵"},
	{"sbf", "뉼"},
	{"sba", "늄"},
	{"sbq", "늅"},
	{"sbd", "늉"},
	{"smr", "늑"},
	{"sms", "는"},
	{"smf", "늘"},
	{"smG", "늙"},
	{"smM", "늚"},
	{"sma", "늠"},
	{"smq", "늡"},
	{"smt", "늣"},
	{"smd", "능"},
	{"smw", "늦"},
	{"smv", "늪"},
	{"sMs", "늰"},
	{"sMf", "늴"},
	{"slr", "닉"},
	{"sls", "닌"},
	{"slf", "닐"},
	{"slM", "닒"},
	{"sla", "님"},
	{"slq", "닙"},
	{"slt", "닛"},
	{"sld", "닝"},
	{"slv", "닢"},
	{"ekr", "닥"},
	{"ekR", "닦"},
	{"eks", "단"},
	{"eke", "닫"},
	{"ekf", "달"},
	{"ekG", "닭"},
	{"ekM", "닮"},
	{"ekA", "닯"},
	{"ekF", "닳"},
	{"eka", "담"},
	{"ekq", "답"},
	{"ekt", "닷"},
	{"ekT", "닸"},
	{"ekd", "당"},
	{"ekw", "닺"},
	{"ekc", "닻"},
	{"ekg", "닿"},
	{"eor", "댁"},
	{"eos", "댄"},
	{"eof", "댈"},
	{"eoa", "댐"},
	{"eoq", "댑"},
	{"eot", "댓"},
	{"eoT", "댔"},
	{"eod", "댕"},
	{"ejr", "덕"},
	{"ejR", "덖"},
	{"ejs", "던"},
	{"eje", "덛"},
	{"ejf", "덜"},
	{"ejM", "덞"},
	{"ejA", "덟"},
	{"eja", "덤"},
	{"ejq", "덥"},
	{"ejt", "덧"},
	{"ejd", "덩"},
	{"ejc", "덫"},
	{"ejv", "덮"},
	{"epr", "덱"},
	{"eps", "덴"},
	{"epf", "델"},
	{"epa", "뎀"},
	{"epq", "뎁"},
	{"ept", "뎃"},
	{"epT", "뎄"},
	{"epd", "뎅"},
	{"eus", "뎐"},
	{"euf", "뎔"},
	{"euT", "뎠"},
	{"eud", "뎡"},
	{"ePs", "뎬"},
	{"ehr", "독"},
	{"ehs", "돈"},
	{"ehe", "돋"},
	{"ehf", "돌"},
	{"ehM", "돎"},
	{"ehN", "돐"},
	{"eha", "돔"},
	{"ehq", "돕"},
	{"eht", "돗"},
	{"ehd", "동"},
	{"ehc", "돛"},
	{"ehx", "돝"},
	{"eKs", "돤"},
	{"eKf", "돨"},
	{"eHT", "됐"},
	{"eLs", "된"},
	{"eLf", "될"},
	{"eLa", "됨"},
	{"eLq", "됩"},
	{"eLt", "됫"},
	{"enr", "둑"},
	{"ens", "둔"},
	{"enf", "둘"},
	{"ena", "둠"},
	{"enq", "둡"},
	{"ent", "둣"},
	{"end", "둥"},
	{"eJT", "뒀"},
	{"eNd", "뒝"},
	{"eBs", "뒨"},
	{"eBf", "뒬"},
	{"eBq", "뒵"},
	{"eBt", "뒷"},
	{"eBd", "뒹"},
	{"ebs", "듄"},
	{"ebf", "듈"},
	{"eba", "듐"},
	{"ebd", "듕"},
	{"emr", "득"},
	{"ems", "든"},
	{"eme", "듣"},
	{"emf", "들"},
	{"emM", "듦"},
	{"ema", "듬"},
	{"emq", "듭"},
	{"emt", "듯"},
	{"emd", "등"},
	{"elr", "딕"},
	{"els", "딘"},
	{"ele", "딛"},
	{"elf", "딜"},
	{"ela", "딤"},
	{"elq", "딥"},
	{"elt", "딧"},
	{"elT", "딨"},
	{"eld", "딩"},
	{"elw", "딪"},
	{"Ekr", "딱"},
	{"Eks", "딴"},
	{"Ekf", "딸"},
	{"Eka", "땀"},
	{"Ekq", "땁"},
	{"Ekt", "땃"},
	{"EkT", "땄"},
	{"Ekd", "땅"},
	{"Ekg", "땋"},
	{"Eor", "땍"},
	{"Eos", "땐"},
	{"Eof", "땔"},
	{"Eoa", "땜"},
	{"Eoq", "땝"},
	{"Eot", "땟"},
	{"EoT", "땠"},
	{"Eod", "땡"},
	{"Ejr", "떡"},
	{"Ejs", "떤"},
	{"Ejf", "떨"},
	{"EjM", "떪"},
	{"EjA", "떫"},
	{"Eja", "떰"},
	{"Ejq", "떱"},
	{"Ejt", "떳"},
	{"EjT", "떴"},
	{"Ejd", "떵"},
	{"Ejg", "떻"},
	{"Epr", "떽"},
	{"Eps", "뗀"},
	{"Epf", "뗄"},
	{"Epa", "뗌"},
	{"Epq", "뗍"},
	{"Ept", "뗏"},
	{"EpT", "뗐"},
	{"Epd", "뗑"},
	{"EuT", "뗬"},
	{"Ehr", "똑"},
	{"Ehs", "똔"},
	{"Ehf", "똘"},
	{"Ehd", "똥"},
	{"EKf", "똴"},
	{"ELs", "뙨"},
	{"Enr", "뚝"},
	{"Ens", "뚠"},
	{"Enf", "뚤"},
	{"EnF", "뚫"},
	{"Ena", "뚬"},
	{"End", "뚱"},
	{"EBs", "뛴"},
	{"EBf", "뛸"},
	{"EBa", "뜀"},
	{"EBq", "뜁"},
	{"EBd", "뜅"},
	{"Emr", "뜩"},
	{"Ems", "뜬"},
	{"Eme", "뜯"},
	{"Emf", "뜰"},
	{"Ema", "뜸"},
	{"Emq", "뜹"},
	{"Emt", "뜻"},
	{"EMs", "띈"},
	{"EMf", "띌"},
	{"EMa", "띔"},
	{"EMq", "띕"},
	{"Els", "띤"},
	{"Elf", "띨"},
	{"Ela", "띰"},
	{"Elq", "띱"},
	{"Elt", "띳"},
	{"Eld", "띵"},
	{"fkr", "락"},
	{"fks", "란"},
	{"fkf", "랄"},
	{"fka", "람"},
	{"fkq", "랍"},
	{"fkt", "랏"},
	{"fkT", "랐"},
	{"fkd", "랑"},
	{"fkw", "랒"},
	{"fkv", "랖"},
	{"fkg", "랗"},
	{"for", "랙"},
	{"fos", "랜"},
	{"fof", "랠"},
	{"foa", "램"},
	{"foq", "랩"},
	{"fot", "랫"},
	{"foT", "랬"},
	{"fod", "랭"},
	{"fir", "략"},
	{"fis", "랸"},
	{"fit", "럇"},
	{"fid", "량"},
	{"fjr", "럭"},
	{"fjs", "런"},
	{"fjf", "럴"},
	{"fja", "럼"},
	{"fjq", "럽"},
	{"fjt", "럿"},
	{"fjT", "렀"},
	{"fjd", "렁"},
	{"fjg", "렇"},
	{"fpr", "렉"},
	{"fps", "렌"},
	{"fpf", "렐"},
	{"fpa", "렘"},
	{"fpq", "렙"},
	{"fpt", "렛"},
	{"fpd", "렝"},
	{"fur", "력"},
	{"fus", "련"},
	{"fuf", "렬"},
	{"fua", "렴"},
	{"fuq", "렵"},
	{"fut", "렷"},
	{"fuT", "렸"},
	{"fud", "령"},
	{"fPs", "롄"},
	{"fPq", "롑"},
	{"fPt", "롓"},
	{"fhr", "록"},
	{"fhs", "론"},
	{"fhf", "롤"},
	{"fha", "롬"},
	{"fhq", "롭"},
	{"fht", "롯"},
	{"fhd", "롱"},
	{"fKs", "롼"},
	{"fKd", "뢍"},
	{"fHT", "뢨"},
	{"fLs", "뢴"},
	{"fLf", "뢸"},
	{"fLa", "룀"},
	{"fLq", "룁"},
	{"fLt", "룃"},
	{"fLd", "룅"},
	{"fys", "룐"},
	{"fyf", "룔"},
	{"fyq", "룝"},
	{"fyt", "룟"},
	{"fyd", "룡"},
	{"fnr", "룩"},
	{"fns", "룬"},
	{"fnf", "룰"},
	{"fna", "룸"},
	{"fnq", "룹"},
	{"fnt", "룻"},
	{"fnd", "룽"},
	{"fJT", "뤘"},
	{"fBr", "뤽"},
	{"fBs", "륀"},
	{"fBf", "륄"},
	{"fBa", "륌"},
	{"fBt", "륏"},
	{"fBd", "륑"},
	{"fbr", "륙"},
	{"fbs", "륜"},
	{"fbf", "률"},
	{"fba", "륨"},
	{"fbq", "륩"},
	{"fbt", "륫"},
	{"fbd", "륭"},
	{"fmr", "륵"},
	{"fms", "른"},
	{"fmf", "를"},
	{"fma", "름"},
	{"fmq", "릅"},
	{"fmt", "릇"},
	{"fmd", "릉"},
	{"fmw", "릊"},
	{"fmx", "릍"},
	{"fmv", "릎"},
	{"flr", "릭"},
	{"fls", "린"},
	{"flf", "릴"},
	{"fla", "림"},
	{"flq", "립"},
	{"flt", "릿"},
	{"fld", "링"},
	{"akr", "막"},
	{"aks", "만"},
	{"akH", "많"},
	{"ake", "맏"},
	{"akf", "말"},
	{"akG", "맑"},
	{"akM", "맒"},
	{"aka", "맘"},
	{"akq", "맙"},
	{"akt", "맛"},
	{"akd", "망"},
	{"akw", "맞"},
	{"akx", "맡"},
	{"akg", "맣"},
	{"aor", "맥"},
	{"aos", "맨"},
	{"aof", "맬"},
	{"aoa", "맴"},
	{"aoq", "맵"},
	{"aot", "맷"},
	{"aoT", "맸"},
	{"aod", "맹"},
	{"aow", "맺"},
	{"air", "먁"},
	{"aif", "먈"},
	{"aid", "먕"},
	{"ajr", "먹"},
	{"ajs", "먼"},
	{"ajf", "멀"},
	{"ajM", "멂"},
	{"aja", "멈"},
	{"ajq", "멉"},
	{"ajt", "멋"},
	{"ajd", "멍"},
	{"ajw", "멎"},
	{"ajg", "멓"},
	{"apr", "멕"},
	{"aps", "멘"},
	{"apf", "멜"},
	{"apa", "멤"},
	{"apq", "멥"},
	{"apt", "멧"},
	{"apT", "멨"},
	{"apd", "멩"},
	{"aur", "멱"},
	{"aus", "면"},
	{"auf", "멸"},
	{"aut", "몃"},
	{"auT", "몄"},
	{"aud", "명"},
	{"auc", "몇"},
	{"ahr", "목"},
	{"ahS", "몫"},
	{"ahs", "몬"},
	{"ahf", "몰"},
	{"ahM", "몲"},
	{"aha", "몸"},
	{"ahq", "몹"},
	{"aht", "못"},
	{"ahd", "몽"},
	{"aKs", "뫈"},
	{"aKT", "뫘"},
	{"aKd", "뫙"},
	{"aLs", "묀"},
	{"aLf", "묄"},
	{"aLq", "묍"},
	{"aLt", "묏"},
	{"aLd", "묑"},
	{"ays", "묜"},
	{"ayf", "묠"},
	{"ayq", "묩"},
	{"ayt", "묫"},
	{"anr", "묵"},
	{"anR", "묶"},
	{"ans", "문"},
	{"ane", "묻"},
	{"anf", "물"},
	{"anG", "묽"},
	{"anM", "묾"},
	{"ana", "뭄"},
	{"anq", "뭅"},
	{"ant", "뭇"},
	{"and", "뭉"},
	{"anx", "뭍"},
	{"ang", "뭏"},
	{"aJs", "뭔"},
	{"aJf", "뭘"},
	{"aJq", "뭡"},
	{"aJt", "뭣"},
	{"aBs", "뮌"},
	{"aBf", "뮐"},
	{"abs", "뮨"},
	{"abf", "뮬"},
	{"aba", "뮴"},
	{"abt", "뮷"},
	{"ams", "믄"},
	{"amf", "믈"},
	{"ama", "믐"},
	{"amt", "믓"},
	{"alr", "믹"},
	{"als", "민"},
	{"ale", "믿"},
	{"alf", "밀"},
	{"alM", "밂"},
	{"ala", "밈"},
	{"alq", "밉"},
	{"alt", "밋"},
	{"alT", "밌"},
	{"ald", "밍"},
	{"alc", "및"},
	{"alx", "밑"},
	{"qkr", "박"},
	{"qkR", "밖"},
	{"qkS", "밗"},
	{"qks", "반"},
	{"qke", "받"},
	{"qkf", "발"},
	{"qkG", "밝"},
	{"qkM", "밞"},
	{"qkA", "밟"},
	{"qka", "밤"},
	{"qkq", "밥"},
	{"qkt", "밧"},
	{"qkd", "방"},
	{"qkx", "밭"},
	{"qor", "백"},
	{"qos", "밴"},
	{"qof", "밸"},
	{"qoa", "뱀"},
	{"qoq", "뱁"},
	{"qot", "뱃"},
	{"qoT", "뱄"},
	{"qod", "뱅"},
	{"qox", "뱉"},
	{"qir", "뱍"},
	{"qis", "뱐"},
	{"qiq", "뱝"},
	{"qjr", "벅"},
	{"qjs", "번"},
	{"qje", "벋"},
	{"qjf", "벌"},
	{"qjM", "벎"},
	{"qja", "범"},
	{"qjq", "법"},
	{"qjt", "벗"},
	{"qjd", "벙"},
	{"qjw", "벚"},
	{"qpr", "벡"},
	{"qps", "벤"},
	{"qpe", "벧"},
	{"qpf", "벨"},
	{"qpa", "벰"},
	{"qpq", "벱"},
	{"qpt", "벳"},
	{"qpT", "벴"},
	{"qpd", "벵"},
	{"qur", "벽"},
	{"qus", "변"},
	{"quf", "별"},
	{"quq", "볍"},
	{"qut", "볏"},
	{"quT", "볐"},
	{"qud", "병"},
	{"qux", "볕"},
	{"qPs", "볜"},
	{"qhr", "복"},
	{"qhR", "볶"},
	{"qhs", "본"},
	{"qhf", "볼"},
	{"qha", "봄"},
	{"qhq", "봅"},
	{"qht", "봇"},
	{"qhd", "봉"},
	{"qKs", "봔"},
	{"qKT", "봤"},
	{"qHT", "뵀"},
	{"qLr", "뵉"},
	{"qLs", "뵌"},
	{"qLf", "뵐"},
	{"qLa", "뵘"},
	{"qLq", "뵙"},
	{"qys", "뵨"},
	{"qnr", "북"},
	{"qns", "분"},
	{"qne", "붇"},
	{"qnf", "불"},
	{"qnG", "붉"},
	{"qnM", "붊"},
	{"qna", "붐"},
	{"qnq", "붑"},
	{"qnt", "붓"},
	{"qnd", "붕"},
	{"qnx", "붙"},
	{"qnv", "붚"},
	{"qJf", "붤"},
	{"qJT", "붰"},
	{"qBr", "뷕"},
	{"qBs", "뷘"},
	{"qBf", "뷜"},
	{"qBd", "뷩"},
	{"qbs", "뷴"},
	{"qbf", "뷸"},
	{"qba", "븀"},
	{"qbt", "븃"},
	{"qbd", "븅"},
	{"qmr", "븍"},
	{"qms", "븐"},
	{"qmf", "블"},
	{"qma", "븜"},
	{"qmq", "븝"},
	{"qmt", "븟"},
	{"qlr", "빅"},
	{"qls", "빈"},
	{"qlf", "빌"},
	{"qlM", "빎"},
	{"qla", "빔"},
	{"qlq", "빕"},
	{"qlt", "빗"},
	{"qld", "빙"},
	{"qlw", "빚"},
	{"qlc", "빛"},
	{"Qkr", "빡"},
	{"Qks", "빤"},
	{"Qkf", "빨"},
	{"QkM", "빪"},
	{"Qka", "빰"},
	{"Qkq", "빱"},
	{"Qkt", "빳"},
	{"QkT", "빴"},
	{"Qkd", "빵"},
	{"Qkg", "빻"},
	{"Qor", "빽"},
	{"Qos", "뺀"},
	{"Qof", "뺄"},
	{"Qoa", "뺌"},
	{"Qoq", "뺍"},
	{"Qot", "뺏"},
	{"QoT", "뺐"},
	{"Qod", "뺑"},
	{"Qir", "뺙"},
	{"Qia", "뺨"},
	{"Qjr", "뻑"},
	{"Qjs", "뻔"},
	{"Qje", "뻗"},
	{"Qjf", "뻘"},
	{"Qja", "뻠"},
	{"Qjt", "뻣"},
	{"QjT", "뻤"},
	{"Qjd", "뻥"},
	{"Qpd", "뼁"},
	{"Qur", "뼉"},
	{"Qua", "뼘"},
	{"Quq", "뼙"},
	{"Qut", "뼛"},
	{"QuT", "뼜"},
	{"Qud", "뼝"},
	{"Qhr", "뽁"},
	{"Qhs", "뽄"},
	{"Qhf", "뽈"},
	{"Qha", "뽐"},
	{"Qhq", "뽑"},
	{"Qhd", "뽕"},
	{"Qyd", "뿅"},
	{"Qnr", "뿍"},
	{"Qns", "뿐"},
	{"Qnf", "뿔"},
	{"Qna", "뿜"},
	{"Qnt", "뿟"},
	{"Qnd", "뿡"},
	{"Qbd", "쁑"},
	{"Qms", "쁜"},
	{"Qmf", "쁠"},
	{"Qma", "쁨"},
	{"Qmq", "쁩"},
	{"Qlr", "삑"},
	{"Qls", "삔"},
	{"Qlf", "삘"},
	{"Qla", "삠"},
	{"Qlq", "삡"},
	{"Qlt", "삣"},
	{"Qld", "삥"},
	{"tkr", "삭"},
	{"tkS", "삯"},
	{"tks", "산"},
	{"tke", "삳"},
	{"tkf", "살"},
	{"tkG", "삵"},
	{"tkM", "삶"},
	{"tka", "삼"},
	{"tkq", "삽"},
	{"tkt", "삿"},
	{"tkT", "샀"},
	{"tkd", "상"},
	{"tkx", "샅"},
	{"tor", "색"},
	{"tos", "샌"},
	{"tof", "샐"},
	{"toa", "샘"},
	{"toq", "샙"},
	{"tot", "샛"},
	{"toT", "샜"},
	{"tod", "생"},
	{"tir", "샥"},
	{"tis", "샨"},
	{"tif", "샬"},
	{"tia", "샴"},
	{"tiq", "샵"},
	{"tit", "샷"},
	{"tid", "샹"},
	{"tOs", "섄"},
	{"tOf", "섈"},
	{"tOa", "섐"},
	{"tOd", "섕"},
	{"tjr", "석"},
	{"tjR", "섞"},
	{"tjS", "섟"},
	{"tjs", "선"},
	{"tje", "섣"},
	{"tjf", "설"},
	{"tjM", "섦"},
	{"tjA", "섧"},
	{"tja", "섬"},
	{"tjq", "섭"},
	{"tjt", "섯"},
	{"tjT", "섰"},
	{"tjd", "성"},
	{"tjv", "섶"},
	{"tpr", "섹"},
	{"tps", "센"},
	{"tpf", "셀"},
	{"tpa", "셈"},
	{"tpq", "셉"},
	{"tpt", "셋"},
	{"tpT", "셌"},
	{"tpd", "셍"},
	{"tur", "셕"},
	{"tus", "션"},
	{"tuf", "셜"},
	{"tua", "셤"},
	{"tuq", "셥"},
	{"tut", "셧"},
	{"tuT", "셨"},
	{"tud", "셩"},
	{"tPs", "셴"},
	{"tPf", "셸"},
	{"tPd", "솅"},
	{"thr", "속"},
	{"thR", "솎"},
	{"ths", "손"},
	{"thf", "솔"},
	{"thM", "솖"},
	{"tha", "솜"},
	{"thq", "솝"},
	{"tht", "솟"},
	{"thd", "송"},
	{"thx", "솥"},
	{"tKr", "솩"},
	{"tKs", "솬"},
	{"tKf", "솰"},
	{"tKd", "솽"},
	{"tHs", "쇈"},
	{"tHf", "쇌"},
	{"tHa", "쇔"},
	{"tHt", "쇗"},
	{"tHT", "쇘"},
	{"tLs", "쇤"},
	{"tLf", "쇨"},
	{"tLa", "쇰"},
	{"tLq", "쇱"},
	{"tLt", "쇳"},
	{"tyr", "쇽"},
	{"tys", "숀"},
	{"tyf", "숄"},
	{"tya", "숌"},
	{"tyq", "숍"},
	{"tyt", "숏"},
	{"tyd", "숑"},
	{"tnr", "숙"},
	{"tns", "순"},
	{"tne", "숟"},
	{"tnf", "술"},
	{"tna", "숨"},
	{"tnq", "숩"},
	{"tnt", "숫"},
	{"tnd", "숭"},
	{"tnc", "숯"},
	{"tnx", "숱"},
	{"tnv", "숲"},
	{"tJT", "쉈"},
	{"tNr", "쉑"},
	{"tNs", "쉔"},
	{"tNf", "쉘"},
	{"tNa", "쉠"},
	{"tNd", "쉥"},
	{"tBr", "쉭"},
	{"tBs", "쉰"},
	{"tBf", "쉴"},
	{"tBa", "쉼"},
	{"tBq", "쉽"},
	{"tBt", "쉿"},
	{"tBd", "슁"},
	{"tbr", "슉"},
	{"tbf", "슐"},
	{"tba", "슘"},
	{"tbt", "슛"},
	{"tbd", "슝"},
	{"tmr", "슥"},
	{"tms", "슨"},
	{"tmf", "슬"},
	{"tmG", "슭"},
	{"tma", "슴"},
	{"tmq", "습"},
	{"tmt", "슷"},
	{"tmd", "승"},
	{"tlr", "식"},
	{"tls", "신"},
	{"tle", "싣"},
	{"tlf", "실"},
	{"tlF", "싫"},
	{"tla", "심"},
	{"tlq", "십"},
	{"tlt", "싯"},
	{"tld", "싱"},
	{"tlv", "싶"},
	{"Tkr", "싹"},
	{"TkS", "싻"},
	{"Tks", "싼"},
	{"Tkf", "쌀"},
	{"Tka", "쌈"},
	{"Tkq", "쌉"},
	{"TkT", "쌌"},
	{"Tkd", "쌍"},
	{"Tkg", "쌓"},
	{"Tor", "쌕"},
	{"Tos", "쌘"},
	{"Tof", "쌜"},
	{"Toa", "쌤"},
	{"Toq", "쌥"},
	{"ToT", "쌨"},
	{"Tod", "쌩"},
	{"Tid", "썅"},
	{"Tjr", "썩"},
	{"Tjs", "썬"},
	{"Tjf", "썰"},
	{"TjM", "썲"},
	{"Tja", "썸"},
	{"Tjq", "썹"},
	{"TjT", "썼"},
	{"Tjd", "썽"},
	{"Tps", "쎈"},
	{"Tpf", "쎌"},
	{"TPs", "쏀"},
	{"Thr", "쏙"},
	{"Ths", "쏜"},
	{"The", "쏟"},
	{"Thf", "쏠"},
	{"ThM", "쏢"},
	{"Tha", "쏨"},
	{"Thq", "쏩"},
	{"Thd", "쏭"},
	{"TKr", "쏵"},
	{"TKs", "쏸"},
	{"TKT", "쐈"},
	{"THT", "쐤"},
	{"TLs", "쐰"},
	{"TLf", "쐴"},
	{"TLa", "쐼"},
	{"TLq", "쐽"},
	{"Tnr", "쑥"},
	{"Tns", "쑨"},
	{"Tnf", "쑬"},
	{"Tna", "쑴"},
	{"Tnq", "쑵"},
	{"Tnd", "쑹"},
	{"TJT", "쒔"},
	{"TBs", "쒼"},
	{"Tbd", "쓩"},
	{"Tmr", "쓱"},
	{"Tms", "쓴"},
	{"Tmf", "쓸"},
	{"TmM", "쓺"},
	{"TmF", "쓿"},
	{"Tma", "씀"},
	{"Tmq", "씁"},
	{"TMs", "씐"},
	{"TMf", "씔"},
	{"TMa", "씜"},
	{"Tlr", "씩"},
	{"Tls", "씬"},
	{"Tlf", "씰"},
	{"Tla", "씸"},
	{"Tlq", "씹"},
	{"Tlt", "씻"},
	{"Tld", "씽"},
	{"dkr", "악"},
	{"dks", "안"},
	{"dkJ", "앉"},
	{"dkH", "않"},
	{"dkf", "알"},
	{"dkG", "앍"},
	{"dkM", "앎"},
	{"dkF", "앓"},
	{"dka", "암"},
	{"dkq", "압"},
	{"dkt", "앗"},
	{"dkT", "았"},
	{"dkd", "앙"},
	{"dkx", "앝"},
	{"dkv", "앞"},
	{"dor", "액"},
	{"dos", "앤"},
	{"dof", "앨"},
	{"doa", "앰"},
	{"doq", "앱"},
	{"dot", "앳"},
	{"doT", "앴"},
	{"dod", "앵"},
	{"dir", "약"},
	{"dis", "얀"},
	{"dif", "얄"},
	{"diA", "얇"},
	{"dia", "얌"},
	{"diq", "얍"},
	{"dit", "얏"},
	{"did", "양"},
	{"dix", "얕"},
	{"dig", "얗"},
	{"dOs", "얜"},
	{"dOf", "얠"},
	{"dOq", "얩"},
	{"djr", "억"},
	{"djs", "언"},
	{"djJ", "얹"},
	{"dje", "얻"},
	{"djf", "얼"},
	{"djG", "얽"},
	{"djM", "얾"},
	{"dja", "엄"},
	{"djq", "업"},
	{"djC", "없"},
	{"djt", "엇"},
	{"djT", "었"},
	{"djd", "엉"},
	{"djw", "엊"},
	{"djz", "엌"},
	{"djv", "엎"},
	{"dpr", "엑"},
	{"dps", "엔"},
	{"dpf", "엘"},
	{"dpa", "엠"},
	{"dpq", "엡"},
	{"dpt", "엣"},
	{"dpd", "엥"},
	{"dur", "역"},
	{"duR", "엮"},
	{"dus", "연"},
	{"duf", "열"},
	{"duM", "엶"},
	{"duA", "엷"},
	{"dua", "염"},
	{"duq", "엽"},
	{"duC", "엾"},
	{"dut", "엿"},
	{"duT", "였"},
	{"dud", "영"},
	{"dux", "옅"},
	{"duv", "옆"},
	{"dug", "옇"},
	{"dPs", "옌"},
	{"dPf", "옐"},
	{"dPa", "옘"},
	{"dPq", "옙"},
	{"dPt", "옛"},
	{"dPT", "옜"},
	{"dhr", "옥"},
	{"dhs", "온"},
	{"dhf", "올"},
	{"dhG", "옭"},
	{"dhM", "옮"},
	{"dhN", "옰"},
	{"dhF", "옳"},
	{"dha", "옴"},
	{"dhq", "옵"},
	{"dht", "옷"},
	{"dhd", "옹"},
	{"dhc", "옻"},
	{"dKr", "왁"},
	{"dKs", "완"},
	{"dKf", "왈"},
	{"dKa", "왐"},
	{"dKq", "왑"},
	{"dKt", "왓"},
	{"dKT", "왔"},
	{"dKd", "왕"},
	{"dHr", "왝"},
	{"dHs", "왠"},
	{"dHa", "왬"},
	{"dHt", "왯"},
	{"dHd", "왱"},
	{"dLr", "왹"},
	{"dLs", "왼"},
	{"dLf", "욀"},
	{"dLa", "욈"},
	{"dLq", "욉"},
	{"dLt", "욋"},
	{"dLd", "욍"},
	{"dyr", "욕"},
	{"dys", "욘"},
	{"dyf", "욜"},
	{"dya", "욤"},
	{"dyq", "욥"},
	{"dyt", "욧"},
	{"dyd", "용"},
	{"dnr", "욱"},
	{"dns", "운"},
	{"dnf", "울"},
	{"dnG", "욹"},
	{"dnM", "욺"},
	{"dna", "움"},
	{"dnq", "웁"},
	{"dnt", "웃"},
	{"dnd", "웅"},
	{"dJr", "웍"},
	{"dJs", "원"},
	{"dJf", "월"},
	{"dJa", "웜"},
	{"dJq", "웝"},
	{"dJT", "웠"},
	{"dJd", "웡"},
	{"dNr", "웩"},
	{"dNs", "웬"},
	{"dNf", "웰"},
	{"dNa", "웸"},
	{"dNq", "웹"},
	{"dNd", "웽"},
	{"dBr", "윅"},
	{"dBs", "윈"},
	{"dBf", "윌"},
	{"dBa", "윔"},
	{"dBq", "윕"},
	{"dBt", "윗"},
	{"dBd", "윙"},
	{"dbr", "육"},
	{"dbs", "윤"},
	{"dbf", "율"},
	{"dba", "윰"},
	{"dbq", "윱"},
	{"dbt", "윳"},
	{"dbd", "융"},
	{"dbc", "윷"},
	{"dmr", "윽"},
	{"dms", "은"},
	{"dmf", "을"},
	{"dmV", "읊"},
	{"dma", "음"},
	{"dmq", "읍"},
	{"dmt", "읏"},
	{"dmd", "응"},
	{"dmw", "읒"},
	{"dmc", "읓"},
	{"dmz", "읔"},
	{"dmx", "읕"},
	{"dmv", "읖"},
	{"dmg", "읗"},
	{"dMs", "읜"},
	{"dMf", "읠"},
	{"dMa", "읨"},
	{"dMt", "읫"},
	{"dlr", "익"},
	{"dls", "인"},
	{"dlf", "일"},
	{"dlG", "읽"},
	{"dlM", "읾"},
	{"dlF", "잃"},
	{"dla", "임"},
	{"dlq", "입"},
	{"dlt", "잇"},
	{"dlT", "있"},
	{"dld", "잉"},
	{"dlw", "잊"},
	{"dlv", "잎"},
	{"wkr", "작"},
	{"wks", "잔"},
	{"wkH", "잖"},
	{"wke", "잗"},
	{"wkf", "잘"},
	{"wkM", "잚"},
	{"wka", "잠"},
	{"wkq", "잡"},
	{"wkt", "잣"},
	{"wkT", "잤"},
	{"wkd", "장"},
	{"wkw", "잦"},
	{"wor", "잭"},
	{"wos", "잰"},
	{"wof", "잴"},
	{"woa", "잼"},
	{"woq", "잽"},
	{"wot", "잿"},
	{"woT", "쟀"},
	{"wod", "쟁"},
	{"wir", "쟉"},
	{"wis", "쟌"},
	{"wiH", "쟎"},
	{"wif", "쟐"},
	{"wia", "쟘"},
	{"wid", "쟝"},
	{"wOs", "쟨"},
	{"wOf", "쟬"},
	{"wjr", "적"},
	{"wjs", "전"},
	{"wjf", "절"},
	{"wjM", "젊"},
	{"wja", "점"},
	{"wjq", "접"},
	{"wjt", "젓"},
	{"wjd", "정"},
	{"wjw", "젖"},
	{"wpr", "젝"},
	{"wps", "젠"},
	{"wpf", "젤"},
	{"wpa", "젬"},
	{"wpq", "젭"},
	{"wpt", "젯"},
	{"wpd", "젱"},
	{"wus", "젼"},
	{"wuf", "졀"},
	{"wua", "졈"},
	{"wuq", "졉"},
	{"wuT", "졌"},
	{"wud", "졍"},
	{"whr", "족"},
	{"whs", "존"},
	{"whf", "졸"},
	{"whM", "졺"},
	{"wha", "좀"},
	{"whq", "좁"},
	{"wht", "좃"},
	{"whd", "종"},
	{"whw", "좆"},
	{"whc", "좇"},
	{"whg", "좋"},
	{"wKr", "좍"},
	{"wKf", "좔"},
	{"wKq", "좝"},
	{"wKt", "좟"},
	{"wKd", "좡"},
	{"wHT", "좼"},
	{"wHd", "좽"},
	{"wLs", "죈"},
	{"wLf", "죌"},
	{"wLa", "죔"},
	{"wLq", "죕"},
	{"wLt", "죗"},
	{"wLd", "죙"},
	{"wyr", "죡"},
	{"wys", "죤"},
	{"wyd", "죵"},
	{"wnr", "죽"},
	{"wns", "준"},
	{"wnf", "줄"},
	{"wnG", "줅"},
	{"wnM", "줆"},
	{"wna", "줌"},
	{"wnq", "줍"},
	{"wnt", "줏"},
	{"wnd", "중"},
	{"wJT", "줬"},
	{"wBr", "쥑"},
	{"wBs", "쥔"},
	{"wBf", "쥘"},
	{"wBa", "쥠"},
	{"wBq", "쥡"},
	{"wBt", "쥣"},
	{"wbs", "쥰"},
	{"wbf", "쥴"},
	{"wba", "쥼"},
	{"wmr", "즉"},
	{"wms", "즌"},
	{"wmf", "즐"},
	{"wma", "즘"},
	{"wmq", "즙"},
	{"wmt", "즛"},
	{"wmd", "증"},
	{"wlr", "직"},
	{"wls", "진"},
	{"wle", "짇"},
	{"wlf", "질"},
	{"wlM", "짊"},
	{"wla", "짐"},
	{"wlq", "집"},
	{"wlt", "짓"},
	{"wld", "징"},
	{"wlw", "짖"},
	{"wlx", "짙"},
	{"wlv", "짚"},
	{"Wkr", "짝"},
	{"Wks", "짠"},
	{"WkH", "짢"},
	{"Wkf", "짤"},
	{"WkA", "짧"},
	{"Wka", "짬"},
	{"Wkq", "짭"},
	{"Wkt", "짯"},
	{"WkT", "짰"},
	{"Wkd", "짱"},
	{"Wor", "짹"},
	{"Wos", "짼"},
	{"Wof", "쨀"},
	{"Woa", "쨈"},
	{"Woq", "쨉"},
	{"Wot", "쨋"},
	{"WoT", "쨌"},
	{"Wod", "쨍"},
	{"Wis", "쨘"},
	{"Wid", "쨩"},
	{"Wjr", "쩍"},
	{"Wjs", "쩐"},
	{"Wjf", "쩔"},
	{"Wja", "쩜"},
	{"Wjq", "쩝"},
	{"Wjt", "쩟"},
	{"WjT", "쩠"},
	{"Wjd", "쩡"},
	{"Wpd", "쩽"},
	{"WuT", "쪘"},
	{"Whr", "쪽"},
	{"Whs", "쫀"},
	{"Whf", "쫄"},
	{"Wha", "쫌"},
	{"Whq", "쫍"},
	{"Wht", "쫏"},
	{"Whd", "쫑"},
	{"Whc", "쫓"},
	{"WKr", "쫙"},
	{"WKf", "쫠"},
	{"WKT", "쫬"},
	{"WHT", "쬈"},
	{"WLs", "쬔"},
	{"WLf", "쬘"},
	{"WLa", "쬠"},
	{"WLq", "쬡"},
	{"Wyd", "쭁"},
	{"Wnr", "쭉"},
	{"Wns", "쭌"},
	{"Wnf", "쭐"},
	{"Wna", "쭘"},
	{"Wnq", "쭙"},
	{"Wnd", "쭝"},
	{"WJT", "쭸"},
	{"WJd", "쭹"},
	{"Wma", "쯤"},
	{"Wmt", "쯧"},
	{"Wmd", "쯩"},
	{"Wlr", "찍"},
	{"Wls", "찐"},
	{"Wlf", "찔"},
	{"Wla", "찜"},
	{"Wlq", "찝"},
	{"Wld", "찡"},
	{"Wlw", "찢"},
	{"Wlg", "찧"},
	{"ckr", "착"},
	{"cks", "찬"},
	{"ckH", "찮"},
	{"ckf", "찰"},
	{"cka", "참"},
	{"ckq", "찹"},
	{"ckt", "찻"},
	{"ckT", "찼"},
	{"ckd", "창"},
	{"ckw", "찾"},
	{"cor", "책"},
	{"cos", "챈"},
	{"cof", "챌"},
	{"coa", "챔"},
	{"coq", "챕"},
	{"cot", "챗"},
	{"coT", "챘"},
	{"cod", "챙"},
	{"cis", "챤"},
	{"ciH", "챦"},
	{"cif", "챨"},
	{"cia", "챰"},
	{"cid", "챵"},
	{"cjr", "척"},
	{"cjs", "천"},
	{"cjf", "철"},
	{"cja", "첨"},
	{"cjq", "첩"},
	{"cjt", "첫"},
	{"cjT", "첬"},
	{"cjd", "청"},
	{"cpr", "첵"},
	{"cps", "첸"},
	{"cpf", "첼"},
	{"cpa", "쳄"},
	{"cpq", "쳅"},
	{"cpt", "쳇"},
	{"cpd", "쳉"},
	{"cus", "쳔"},
	{"cuT", "쳤"},
	{"cPs", "쳰"},
	{"cPd", "촁"},
	{"chr", "촉"},
	{"chs", "촌"},
	{"chf", "촐"},
	{"cha", "촘"},
	{"chq", "촙"},
	{"cht", "촛"},
	{"chd", "총"},
	{"cKs", "촨"},
	{"cKf", "촬"},
	{"cKd", "촹"},
	{"cLs", "쵠"},
	{"cLf", "쵤"},
	{"cLa", "쵬"},
	{"cLq", "쵭"},
	{"cLt", "쵯"},
	{"cLd", "쵱"},
	{"cya", "춈"},
	{"cnr", "축"},
	{"cns", "춘"},
	{"cnf", "출"},
	{"cna", "춤"},
	{"cnq", "춥"},
	{"cnt", "춧"},
	{"cnd", "충"},
	{"cJT", "췄"},
	{"cNs", "췐"},
	{"cBs", "췬"},
	{"cBf", "췰"},
	{"cBa", "췸"},
	{"cBq", "췹"},
	{"cBt", "췻"},
	{"cBd", "췽"},
	{"cbs", "츈"},
	{"cbf", "츌"},
	{"cba", "츔"},
	{"cbd", "츙"},
	{"cmr", "측"},
	{"cms", "츤"},
	{"cmf", "츨"},
	{"cma", "츰"},
	{"cmq", "츱"},
	{"cmt", "츳"},
	{"cmd", "층"},
	{"clr", "칙"},
	{"cls", "친"},
	{"cle", "칟"},
	{"clf", "칠"},
	{"clG", "칡"},
	{"cla", "침"},
	{"clq", "칩"},
	{"clt", "칫"},
	{"cld", "칭"},
	{"zkr", "칵"},
	{"zks", "칸"},
	{"zkf", "칼"},
	{"zka", "캄"},
	{"zkq", "캅"},
	{"zkt", "캇"},
	{"zkd", "캉"},
	{"zor", "캑"},
	{"zos", "캔"},
	{"zof", "캘"},
	{"zoa", "캠"},
	{"zoq", "캡"},
	{"zot", "캣"},
	{"zoT", "캤"},
	{"zod", "캥"},
	{"zir", "캭"},
	{"zid", "컁"},
	{"zjr", "컥"},
	{"zjs", "컨"},
	{"zje", "컫"},
	{"zjf", "컬"},
	{"zja", "컴"},
	{"zjq", "컵"},
	{"zjt", "컷"},
	{"zjT", "컸"},
	{"zjd", "컹"},
	{"zpr", "켁"},
	{"zps", "켄"},
	{"zpf", "켈"},
	{"zpa", "켐"},
	{"zpq", "켑"},
	{"zpt", "켓"},
	{"zpd", "켕"},
	{"zus", "켠"},
	{"zuf", "켤"},
	{"zua", "켬"},
	{"zuq", "켭"},
	{"zut", "켯"},
	{"zuT", "켰"},
	{"zud", "켱"},
	{"zhr", "콕"},
	{"zhs", "콘"},
	{"zhf", "콜"},
	{"zha", "콤"},
	{"zhq", "콥"},
	{"zht", "콧"},
	{"zhd", "콩"},
	{"zKr", "콱"},
	{"zKs", "콴"},
	{"zKf", "콸"},
	{"zKa", "쾀"},
	{"zKd", "쾅"},
	{"zHd", "쾡"},
	{"zLf", "쾰"},
	{"znr", "쿡"},
	{"zns", "쿤"},
	{"znf", "쿨"},
	{"zna", "쿰"},
	{"znq", "쿱"},
	{"znt", "쿳"},
	{"znd", "쿵"},
	{"zJs", "퀀"},
	{"zJf", "퀄"},
	{"zJd", "퀑"},
	{"zNd", "퀭"},
	{"zBr", "퀵"},
	{"zBs", "퀸"},
	{"zBf", "퀼"},
	{"zBa", "큄"},
	{"zBq", "큅"},
	{"zBt", "큇"},
	{"zBd", "큉"},
	{"zbs", "큔"},
	{"zbf", "큘"},
	{"zba", "큠"},
	{"zmr", "큭"},
	{"zms", "큰"},
	{"zmf", "클"},
	{"zma", "큼"},
	{"zmq", "큽"},
	{"zmd", "킁"},
	{"zlr", "킥"},
	{"zls", "킨"},
	{"zlf", "킬"},
	{"zla", "킴"},
	{"zlq", "킵"},
	{"zlt", "킷"},
	{"zld", "킹"},
	{"xkr", "탁"},
	{"xks", "탄"},
	{"xkf", "탈"},
	{"xkG", "탉"},
	{"xka", "탐"},
	{"xkq", "탑"},
	{"xkt", "탓"},
	{"xkT", "탔"},
	{"xkd", "탕"},
	{"xor", "택"},
	{"xos", "탠"},
	{"xof", "탤"},
	{"xoa", "탬"},
	{"xoq", "탭"},
	{"xot", "탯"},
	{"xoT", "탰"},
	{"xod", "탱"},
	{"xid", "턍"},
	{"xjr", "턱"},
	{"xjs", "턴"},
	{"xjf", "털"},
	{"xjM", "턺"},
	{"xja", "텀"},
	{"xjq", "텁"},
	{"xjt", "텃"},
	{"xjT", "텄"},
	{"xjd", "텅"},
	{"xpr", "텍"},
	{"xps", "텐"},
	{"xpf", "텔"},
	{"xpa", "템"},
	{"xpq", "텝"},
	{"xpt", "텟"},
	{"xpd", "텡"},
	{"xus", "텬"},
	{"xuT", "텼"},
	{"xPs", "톈"},
	{"xhr", "톡"},
	{"xhs", "톤"},
	{"xhf", "톨"},
	{"xha", "톰"},
	{"xhq", "톱"},
	{"xht", "톳"},
	{"xhd", "통"},
	{"xhv", "톺"},
	{"xKs", "퇀"},
	{"xLs", "퇸"},
	{"xLt", "툇"},
	{"xLd", "툉"},
	{"xnr", "툭"},
	{"xns", "툰"},
	{"xnf", "툴"},
	{"xna", "툼"},
	{"xnq", "툽"},
	{"xnt", "툿"},
	{"xnd", "퉁"},
	{"xJT", "퉜"},
	{"xBr", "튁"},
	{"xBs", "튄"},
	{"xBf", "튈"},
	{"xBa", "튐"},
	{"xBq", "튑"},
	{"xBd", "튕"},
	{"xbs", "튠"},
	{"xbf", "튤"},
	{"xba", "튬"},
	{"xbd", "튱"},
	{"xmr", "특"},
	{"xms", "튼"},
	{"xme", "튿"},
	{"xmf", "틀"},
	{"xmM", "틂"},
	{"xma", "틈"},
	{"xmq", "틉"},
	{"xmt", "틋"},
	{"xMs", "틘"},
	{"xMf", "틜"},
	{"xMa", "틤"},
	{"xMq", "틥"},
	{"xlr", "틱"},
	{"xls", "틴"},
	{"xlf", "틸"},
	{"xla", "팀"},
	{"xlq", "팁"},
	{"xlt", "팃"},
	{"xld", "팅"},
	{"vkr", "팍"},
	{"vkR", "팎"},
	{"vks", "판"},
	{"vkf", "팔"},
	{"vkM", "팖"},
	{"vka", "팜"},
	{"vkq", "팝"},
	{"vkt", "팟"},
	{"vkT", "팠"},
	{"vkd", "팡"},
	{"vkx", "팥"},
	{"vor", "팩"},
	{"vos", "팬"},
	{"vof", "팰"},
	{"voa", "팸"},
	{"voq", "팹"},
	{"vot", "팻"},
	{"voT", "팼"},
	{"vod", "팽"},
	{"vir", "퍅"},
	{"vjr", "퍽"},
	{"vjs", "펀"},
	{"vjf", "펄"},
	{"vja", "펌"},
	{"vjq", "펍"},
	{"vjt", "펏"},
	{"vjT", "펐"},
	{"vjd", "펑"},
	{"vpr", "펙"},
	{"vps", "펜"},
	{"vpf", "펠"},
	{"vpa", "펨"},
	{"vpq", "펩"},
	{"vpt", "펫"},
	{"vpd", "펭"},
	{"vus", "편"},
	{"vuf", "펼"},
	{"vua", "폄"},
	{"vuq", "폅"},
	{"vuT", "폈"},
	{"vud", "평"},
	{"vPf", "폘"},
	{"vPq", "폡"},
	{"vPt", "폣"},
	{"vhr", "폭"},
	{"vhs", "폰"},
	{"vhf", "폴"},
	{"vha", "폼"},
	{"vhq", "폽"},
	{"vht", "폿"},
	{"vhd", "퐁"},
	{"vKd", "퐝"},
	{"vLs", "푄"},
	{"vys", "푠"},
	{"vyf", "푤"},
	{"vyq", "푭"},
	{"vyt", "푯"},
	{"vnr", "푹"},
	{"vns", "푼"},
	{"vne", "푿"},
	{"vnf", "풀"},
	{"vnM", "풂"},
	{"vna", "품"},
	{"vnq", "풉"},
	{"vnt", "풋"},
	{"vnd", "풍"},
	{"vJd", "풩"},
	{"vBs", "퓐"},
	{"vBf", "퓔"},
	{"vBa", "퓜"},
	{"vBt", "퓟"},
	{"vbs", "퓬"},
	{"vbf", "퓰"},
	{"vba", "퓸"},
	{"vbt", "퓻"},
	{"vbd", "퓽"},
	{"vms", "픈"},
	{"vmf", "플"},
	{"vma", "픔"},
	{"vmq", "픕"},
	{"vmt", "픗"},
	{"vlr", "픽"},
	{"vls", "핀"},
	{"vlf", "필"},
	{"vla", "핌"},
	{"vlq", "핍"},
	{"vlt", "핏"},
	{"vld", "핑"},
	{"gkr", "학"},
	{"gks", "한"},
	{"gkf", "할"},
	{"gkB", "핥"},
	{"gka", "함"},
	{"gkq", "합"},
	{"gkt", "핫"},
	{"gkd", "항"},
	{"gor", "핵"},
	{"gos", "핸"},
	{"gof", "핼"},
	{"goa", "햄"},
	{"goq", "햅"},
	{"got", "햇"},
	{"goT", "했"},
	{"god", "행"},
	{"gid", "향"},
	{"gjr", "헉"},
	{"gjs", "헌"},
	{"gjf", "헐"},
	{"gjM", "헒"},
	{"gja", "험"},
	{"gjq", "헙"},
	{"gjt", "헛"},
	{"gjd", "헝"},
	{"gpr", "헥"},
	{"gps", "헨"},
	{"gpf", "헬"},
	{"gpa", "헴"},
	{"gpq", "헵"},
	{"gpt", "헷"},
	{"gpd", "헹"},
	{"gur", "혁"},
	{"gus", "현"},
	{"guf", "혈"},
	{"gua", "혐"},
	{"guq", "협"},
	{"gut", "혓"},
	{"guT", "혔"},
	{"gud", "형"},
	{"gPs", "혠"},
	{"gPf", "혤"},
	{"gPq", "혭"},
	{"ghr", "혹"},
	{"ghs", "혼"},
	{"ghf", "홀"},
	{"ghB", "홅"},
	{"gha", "홈"},
	{"ghq", "홉"},
	{"ght", "홋"},
	{"ghd", "홍"},
	{"ghx", "홑"},
	{"gKr", "확"},
	{"gKs", "환"},
	{"gKf", "활"},
	{"gKt", "홧"},
	{"gKd", "황"},
	{"gHr", "홱"},
	{"gHs", "홴"},
	{"gHt", "횃"},
	{"gHd", "횅"},
	{"gLr", "획"},
	{"gLs", "횐"},
	{"gLf", "횔"},
	{"gLq", "횝"},
	{"gLt", "횟"},
	{"gLd", "횡"},
	{"gys", "횬"},
	{"gyf", "횰"},
	{"gyq", "횹"},
	{"gyt", "횻"},
	{"gnr", "훅"},
	{"gns", "훈"},
	{"gnf", "훌"},
	{"gnB", "훑"},
	{"gna", "훔"},
	{"gnt", "훗"},
	{"gnd", "훙"},
	{"gJs", "훤"},
	{"gJf", "훨"},
	{"gJa", "훰"},
	{"gJd", "훵"},
	{"gNr", "훽"},
	{"gNs", "휀"},
	{"gNf", "휄"},
	{"gNd", "휑"},
	{"gBr", "휙"},
	{"gBs", "휜"},
	{"gBf", "휠"},
	{"gBa", "휨"},
	{"gBq", "휩"},
	{"gBt", "휫"},
	{"gBd", "휭"},
	{"gbr", "휵"},
	{"gbs", "휸"},
	{"gbf", "휼"},
	{"gba", "흄"},
	{"gbt", "흇"},
	{"gbd", "흉"},
	{"gmr", "흑"},
	{"gms", "흔"},
	{"gmH", "흖"},
	{"gme", "흗"},
	{"gmf", "흘"},
	{"gmG", "흙"},
	{"gma", "흠"},
	{"gmq", "흡"},
	{"gmt", "흣"},
	{"gmd", "흥"},
	{"gmx", "흩"},
	{"gMs", "흰"},
	{"gMf", "흴"},
	{"gMa", "흼"},
	{"gMq", "흽"},
	{"gMd", "힁"},
	{"glr", "힉"},
	{"gls", "힌"},
	{"glf", "힐"},
	{"gla", "힘"},
	{"glq", "힙"},
	{"glt", "힛"},
	{"gld", "힝"},
	{NIL_PTR}
};
