/*======================================================================*\
|*		Editor mined, definitions				*|
|*		CJK character set <-> Unicode mapping tables		*|
\*======================================================================*/

#define arrlen(arr)	(sizeof (arr) / sizeof (* arr))

#define jis2_0x309A	0x80 << 16
#define jis2_0x0300	0x81 << 16
#define jis2_0x0301	0x82 << 16
#define jis2_0x02E5	0x83 << 16
#define jis2_0x02E9	0x84 << 16


/*======================================================================*\
	conversion tables mapping various CJK encodings to Unicode
\*======================================================================*/

extern struct cjk_table_entry big5_table [];
extern unsigned int big5_table_len;
extern struct cjk_table_entry gb_table [];
extern unsigned int gb_table_len;
extern struct cjk_table_entry cns_table [];
extern unsigned int cns_table_len;
extern struct cjk_table_entry ejis_table [];
extern unsigned int ejis_table_len;
extern struct cjk_table_entry sjis_table [];
extern unsigned int sjis_table_len;
extern struct cjk_table_entry uhc_table [];
extern unsigned int uhc_table_len;
extern struct cjk_table_entry johb_table [];
extern unsigned int johb_table_len;
extern struct cjk_table_entry viscii_table [];
extern unsigned int viscii_table_len;


/*======================================================================*\
	types and table entry macros
\*======================================================================*/

#define split_map_entries

struct cjk_table_entry {
#ifdef split_map_entries
	unsigned char cjk_ext;
	unsigned char unicode_high;
	unsigned short cjk_base;
	unsigned short unicode_low;
#else
	unsigned int cjk;
	unsigned int unicode;
#endif
};

#ifdef split_map_entries
/**
   For compact representation of encoding mapping tables, the following 
   mappings are used:
	Unicode       table entry
	XXYYZZ        XX, YYZZ

	2 * Unicode   special table entry (for JIS)
	00YYZZ 00yyzz xx, YYZZ (xx >= 80, indicates 2nd char - one of 
				0x309A, 0x0300, 0x0301, 0x02E5, 0x02E9)

	CJK (GB18030) table entry
	    XXYY      FF, XXYY
	XX31YY32      12, YYXX

	CJK (other)   table entry
	    XXYY      00, XXYY
	  8FXXYY      8F, XXYY
	8EXXYYZZ      XX, YYZZ (XX >= 90)
 */
#define map(cjk, unicode)	{(cjk >> 16) & 0xFF, (unicode) >> 16, cjk & 0xFFFF, (unicode) & 0xFFFF},
#define mapgbshort(cjk, unicode)	{0xFF, (unicode) >> 16, cjk, (unicode) & 0xFFFF},
#define mapgblong(cjk, unicode)	{((cjk >> 12) & 0xF0) | (cjk & 0x0F), (unicode) >> 16, (cjk & 0xFF00) | (cjk >> 24), (unicode) & 0xFFFF},
#else
#define map(cjk, unicode)	{cjk, unicode},
#define mapgb(cjk, unicode)	{cjk, unicode},
#endif


/*======================================================================*\
|*		end							*|
\*======================================================================*/
