
#############################################################################
# mined environment variable settings
#    - descriptions and examples -

#	Recommended examples are activated for inclusion of this script file 
#	in your shell setup ("source .../minedenv.sh").
#	With csh/tcsh, variable setting syntax will have to be adapted.


#############################################################################
# this variable tells other applications to use mined as text editor
EDITOR=mined
 export EDITOR


#############################################################################
# screen display properties

#################################################################
# display of line markers
# -	The following variables tell mined which characters to use for 
#	display of TAB characters, line ends, and shifted lines.
#	For MINEDRET, MINEDTAB, MINEDSHIFT, the ISO Latin-1 character set 
#	is used even if mined is run in UTF-8 mode. Alternative UTF 
#	variables exist.
#	I highly recommend setting MINEDDIM (see below) together with 
#	these special character display settings to have them displayed 
#	in a moderate colour.

MINEDRET=123	# line end displays as 12223 
MINEDRET=	# line end displays as  
MINEDRET=	# line end displays as  
MINEDRET=	# line end displays as  
MINEDRET=	# line end displays as      
 export MINEDRET
#MINEDUTFRET=	# line end in UTF-8 mode, use UTF-8 characters here
		# (number of valid characters still taken from MINEDRET!)
# export MINEDUTFRET

MINEDTAB=213	# TAB displays as 12222223 
MINEDTAB=	# TAB displays as  
MINEDTAB=	# TAB displays as  
MINEDTAB=	# TAB displays as  
MINEDTAB=	# TAB displays as  
 export MINEDTAB
#MINEDUTFTAB=	# TAB display in UTF-8 mode, use UTF-8 characters here
		# (number of valid characters still taken from MINEDTAB!)
# export MINEDUTFTAB

#MINEDSHIFT=	# Character that marks lines that continue beyond the 
		# right screen border. Default is "". If a second 
		# character is included, it is used to mark lines that 
		# are shifted out beyond the left screen border (e. g. "").
# export MINEDSHIFT

#########################
# UTF-8 terminal preselection
#utf8_screen=	# select UTF-8 output only (obsolete)
# export utf8_screen
#utf8_input=	# select UTF-8 input only (obsolete)
# export utf8_input
#utf8_term=	# select UTF-8 terminal operation
		# the recommended way is to set this implicitly when 
		# a UTF-8 terminal session is started, see the "uterm" script
# export utf8_term

#########################
# special terminal option
#MINEDMARK=as
#	A termcap capability code (e.g. alternate character set) to be 
#	used as a screen attribute for the special markers above.
#	Example usage (with xterm) should be combined with:
#MINEDRET='y'	# or '`' or 'u' or 'j'
#MINEDTAB='f'	# or 'l' or 'z'
#MINEDSHIFT='z'

#################################################################
# display mode (character attribute, e.g. colour) of line markers
MINEDDIM=31	# TAB and line end special display uses ANSI mode 31 (red)
 export MINEDDIM

#########################
# display mode (character attribute, e.g. colour) of Unicode indications
# (non-Latin-1 characters in Latin-1 terminals)
#MINEDUNI=" 46"	# display Unicode characters as "" and display all 
			# UTF-8 specialities in ANSI mode 46 (cyan background)
# export MINEDUNI

#################################################################
# other display modes
#MINEDCTRL="33;44"	# control character display uses this ANSI mode
# export MINEDCTRL
MINEDMENU=	# menu line and menus use this ANSI mode
 export MINEDMENU
MINEDDIAG=	# dialog and status (bottom) line uses this ANSI mode
 export MINEDDIAG

#################################################################
# display for silly 7-bit terminals with character set switching
# Enable output translation of 8 bit characters to be displayed using an 
# alternate character set. The example setting works for the 
# Siemens 9780x terminal.
#MINEDOUT='                                   n   l p    o s   xrv             i`at _      bz    j f   k hQ!"#'\''$%)*01239 8;-BCDEGF HTUVWZK['
# export MINEDOUT

#################################################################
# display of text modification status
#MINEDMODF		# String that marks modified text in the file status. 
# export MINEDMODF	# Default is " (*)".

#################################################################
# MSDOS only display settings
#MINEDCOL=	# ANSI code to be used as an attribute for highlighted display.
#LINES=		# Line count of terminal to be assumed.
#COLUMNS=	# Column count of terminal to be assumed.
#NOCLEAREOL=	# debug: don't use clear to end of line function.
#NORSCROLL=	# debug: don't use reverse scroll function.


#############################################################################
# configuration of character encoding auto-detection
MINEDDETECT=BGCJSKHV	# allow auto-detection of 
# Big5 / GB / CNS / JIS (EUC-JP) / Shift-JIS / UHC / JOHAB / VISCII encodings
# Remove the initial letters of those encodings that you 
# don't want to be auto-detected, 
# for the better recognition of those encodings that you do use.


#############################################################################
# various system environment dependencies
MINEDHELPFILE=.../mined.hlp	# File name of online help archive.
 export MINEDHELPFILE
#MINEDPRINT		# Command to print a file, with "%s" to be replaced by 
# export MINEDPRINT	# the file name. Default is operating system dependent.

#################################################################
# silly terminal connection work-around
#NoControlSQ=	# Disables ^S and ^Q command functions for dumb terminal 
		# connections that use these characters for flow control 
		# but don't filter them out themselves.
# export NoControlSQ


#############################################################################
# keyboard mappings for international scripts
MINEDKEYMAP=-gr	# known mappings are ar (Arabic), gr/el (Greek),
		# he (Hebrew), cy/ru (Cyrillic);
		# with prefix "-" the mapping is set standby,
		# without prefix the mapping is preselected (active)
 export MINEDKEYMAP

#############################################################################
# enabling function keys of special terminals
# The TERM variable is used to set screen output control.
# Input control (esp. escape sequences for function keys) is often 
# badly configured in operating system environments; for this reason 
# mined always accepts a wide variety of typical control codes.
# However, to accomodate some ambiguous cases, the kind of terminal 
# being used can be set with the following variable.
MINEDTERM=xterm		# the default, also works for VT100 and many others
MINEDTERM=hp		# for HP terminal windows
MINEDTERM=siemens	# for Siemens terminals (9780x)
 export MINEDTERM


#############################################################################
# various options (behaviour and command line options)
#   useful options for the environment variable MINED:
#	v	Start in view only mode.
#	r	Read and convert DOS line ends.
#	R	Read and convert Mac line ends.
#	x	Make new files executable.
#   character set handling
#	U	Enable/disable UTF-8 Unicode terminal operation.
#	u	Edit text files in UTF-8 encoding interpretation.
#	uu	Like u, and also handle Unicode line/paragraph separators.
#	+u	Edit text files in Latin-1 encoding interpretation.
#	C	Enable Chinese / 16-bit character set (with cxterm).
#	D	Input translation for German umlaut characters from {|}[\]~.
#	DD	Automatically set input translation mode if file contains 
#		many umlaut characters.
#   mode selection
#	B	Backspace moves left, Delete deletes left.
#	M	Disable mouse control and menus.
#	W	WordStar mode (key layout), with many ^K, ^O, ^Q functions.
#	-	Restricted mode: disallow editing of other files.
#   editing behaviour
#	w	Recognise fewer places as word boundaries (skip/delete).
#	j	Enable automatic word wrap when typing near line ends.
#	jj	Enable automatic word wrap when typing anywhere.
#	a	Append to (instead of replace) text buffer or external file 
#		for copy/delete commands.
#	T	Change positioning behaviour for vertical movement into 
#		a TAB column range; default is to go on to the TAB (left), 
#		may be changed to go behind the TAB (right).
#   display behaviour
#	p	Enables different display of line ends and paragraph ends.
#	tX	(where X is replaced by the desired TAB display character) -
#		Selects the character X for TAB display; for more complex 
#		display options, the MINEDTAB variable must be used (s. above).
#	s	Move cursor to top/bottom instead of center after page down/up.
#	S	Use scrolling for page up/down.
#	d-	Do not apply screen output delay.
#	d0	Apply 0..9 milliseconds delay between display of two lines.
#	...	This provides a nice visible page change effect, leaving a 
#	d9	better impression of the new display and cursor position.
#	P	Enables provisions for proportional display fonts.

MINED=p
 export MINED

#MINEDCJKTERM	# Set -C: Selects the CJK character set option.
# export MINEDCJKTERM
#MINEDWS	# Set -W: Selects the WordStar keyboard layout option.
# export MINEDWS
#MINEDMAC	# Set -R: Take all ^M characters for line ends (read Mac files).
# export MINEDMAC
#MINEDPROP	# Set -p: Enables the proportional font support.
# export MINEDPROP

#MINEDTMP=$HOME/tmp	# configure your own network-spanning copy and paste
# export MINEDTMP


#############################################################################
