
/* signal handling */
extern void catch_signals _((void (* catchfunc) (void)));
extern void suspendmyself _((void));

/* tty handling */
extern void raw_mode _((FLAG state));
extern void get_term _((void));
extern void getwinsize _((void));

/* i/o handling */
extern void flush _((void));
extern int inputreadyafter _((int fid, int msec));

/* screen mode handling */
#ifdef msdos
extern void set_video_lines _((int r));
	/* 0/1/2: 200/350/400 lines */
extern void set_grafmode_height _((int r, int l));
	/* 0/1/2: font height 8/14/16 ; 1/2/3/n: 14/25/43/n lines */
extern void set_fontbank _((int f));
	/* 0..7 */
#endif
extern void set_textmode_height _((int r));
	/* 0/1/2: font height 8/14/16 */
extern void set_font_height _((int r));
	/* set font height in character pixels, <= 32 */
extern void set_screen_mode _((int mode));
extern void resize_the_screen _((FLAG sb, FLAG keep_columns));
extern void switch_textmode_height _((FLAG cycle));
	/* True: cycle through font heights 8/14/16 
	   False: switch between font heights 8/16 */

/* screen manipulation */
extern void clear_screen _((void));
extern void clear_eol _((void));
extern void scroll_forward _((void));
extern void scroll_reverse _((void));
extern void add_line _((int));
extern void delete_line _((int));
extern void move_cursor _((int, int));
extern int current_cursor_y;

/* screen output */
extern void putstring _((char *));
extern void __putchar _((character));
extern void ring_bell _((void));
extern void putblockchar _((character));

/* screen attributes handling */
extern void disp_normal _((void));
extern void disp_colour _((int));
extern void reverse_on _((void));
extern void reverse_off _((void));
extern void altcset_on _((void));
extern void altcset_off _((void));
extern void start_extracset _((void));
extern void end_extracset _((void));
extern void dim_on _((void));
extern void dim_off _((void));
extern void bold_on _((void));
extern void bold_off _((void));
extern void unidisp_on _((void));
extern void unidisp_off _((void));
extern void ctrldisp_on _((void));
extern void ctrldisp_off _((void));
extern void menudisp_on _((void));
extern void menudisp_off _((void));
extern void dispHTML_code _((void));
extern void dispHTML_jsp _((void));
extern void dispHTML_comment _((void));
extern void dispHTML_off _((void));
extern void unimarkdisp_on _((void));
extern void unimarkdisp_off _((void));
extern void combiningdisp_on _((void));
extern void combiningdisp_off _((void));
extern void diagdisp_on _((void));
extern void diagdisp_off _((void));
extern void disp_scrollbar_foreground _((void));
extern void disp_scrollbar_background _((void));
extern void disp_scrollbar_off _((void));
extern void menuheader_on _((void));
extern void menuheader_off _((void));
extern void menuborder_on _((void));
extern void menuborder_off _((void));
extern void menuitem_on _((void));
extern void menuitem_off _((void));

/* input functions */
extern int get_digits _((int *));
extern int __readchar _((void));
extern int _readchar _((void));

/* keyboard functions */
extern unsigned long readcharacter_allbuttons _((void));
extern unsigned long readcharacter _((void));
extern unsigned long readcharacter_mapped _((void));
extern int _readchar_nokeymap _((void));
extern int read1byte _((void));
extern int char_ready_within _((int));
extern void set_fkeymap _((char *));

/* mouse handling functions */
extern void DIRECTcrttool _((void));
extern void DIRECTxterm _((void));
extern void TRACKxterm _((void));
extern void TRACKxtermT _((void));
extern FLAG mouse_hilite_tracking;
#define button_event_tracking

/* auxiliary menu functions */
extern void menu_mouse_mode _((FLAG));
extern FLAG in_menu_mouse_mode;
extern FLAG in_menu_border;

/* terminal feature usage flags */
extern FLAG use_ascii_graphics;		/* use ASCII graphics for borders */
extern FLAG use_vga_block_graphics;	/* charset is VGA with block graphics */
extern FLAG use_pc_block_graphics;	/* alternate charset is VGA with block graphics */
extern FLAG use_vt100_block_graphics;
extern char menu_border_style;
extern FLAG use_stylish_menu_selection;
extern FLAG use_unicode_menubar _((void));
extern FLAG explicit_border_style;
extern FLAG use_mouse;
extern FLAG use_bold;
extern FLAG use_bgcolor;
extern FLAG colours_256;
extern FLAG colours_88;
extern FLAG ansi_esc;
extern FLAG standout_glitch;

/* keyboard mapping setup functions */
extern void toggleKEYMAP _((void));
extern void setupKEYMAP _((void));
extern void cycleKEYMAP _((void));
extern void setKEYMAP _((char *));
extern int get_string_nokeymap _((char *, char *, FLAG, char *));
extern char * keyboard_mapping;

