%define _prefix /usr/local
Summary:	A program that creates emergency boot disks/CDs using your kernel, tools and modules.
Name:		mindi
Version:        0.86
Release:	1
Copyright:	GPL
Group:		System/Kernel and hardware
Url:		http://www.microwerks.net/~hugo/mindi/index.html
Source:		%{name}-%{version}.tgz
BuildRoot:	/tmp/%{name}-%{version}
Requires:	bzip2 >= 0.9, mkisofs, ncurses, binutils, gawk
Prefix:		/usr/local
Autoreq:	0

%description
Mindi takes your kernel, modules, tools and libraries, and puts them on N
bootable disks (or 1 bootable CD image). You may then boot from the disks/CD
and do system maintenance - e.g. format partitions, backup/restore data,
verify packages, etc.

%prep
%setup 
%build

%install
%{__rm} -rf $RPM_BUILD_ROOT
MINDIDIR=$RPM_BUILD_ROOT%{_datadir}/mindi
%{__mkdir_p} $MINDIDIR $RPM_BUILD_ROOT%{_bindir} $RPM_BUILD_ROOT%{_sysconfdir}/mindi
%{__mv} deplist.txt $RPM_BUILD_ROOT%{_sysconfdir}/mindi/
%{__cp} -a * $MINDIDIR
#
# These are installed twice if not removed here
( cd $MINDIDIR
rm -f CHANGES INSTALL LICENSE README TODO
)
cd $RPM_BUILD_ROOT%{_bindir}
%{__ln_s} -f %{_datadir}/mindi/mindi .
%{__ln_s} -f %{_datadir}/mindi/analyze-my-lvm .

%clean
%{__rm} -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,-)
%config(noreplace) %{_sysconfdir}/mindi/deplist.txt
%doc CHANGES INSTALL LICENSE README TODO

%{_datadir}/mindi
%{_bindir}/analyze-my-lvm
%{_bindir}/mindi


%changelog
* Thu Aug 28 2003 Anonymous <root@vanillaice> 0.86
- allow absolute pathnames again in deplist
- disable multifunc cd thing
- better Gentoo support (Daniel F Dickinson, Bill)

* Thu Jul 24 2003 Hugo Rabson <hugorabson@msn.com> 0.86
- altered rootfs's /dev entry to stop cvs from becoming confused
- analyze-my-lvm path bug fixed (Peter Gibbs)
- re-mount root as rw just in case
- added symlinks.tgz

* Sun May 18 2003 Hugo Rabson <hugorabson@msn.com> 0.85
- added cciss.o to SCSI_MODS
- if format type is (e.g.) ext3,ext2 then use 1st entry
- re-enabled fsck*
- if cciss in use then enable it
- added /dev/ataraid/* to boot disk via ataraid.tgz (Luc S.)
- better ISO support
- allow for Debian & other Stiefkinder that use 'none', not 'swap'
  as the mountpoint of the swap partition
- removed afio dependency
- re-worked install.sh and tarball not to use tgz's
- disabled 3 lines in ListAllPartitions() - erroneous
- add #!/bin/sh to start of insert-all-my-modules
- fixed obscure bug in install-additional-tools
- added MDK9.1-specific modules to CDROM_MODS
- moved vmlinuz and lib.tar.bz2 to mindi-kernel rpm/tarball

* Wed Apr 09 2003 Hugo Rabson <hugorabson@msn.com> 0.84
- insmod ide-cd, cdrom, isofs, just in case
- tmpfs ramdisk at boot-time is now 40m (was 32m)
- iso mode now calls Interactive
- make SizeOfPartition() more Debian-friendly (Andree Leidenfrost)
- disabled code which would make Mindi call sfdisk instead of fdisk
  if it looked as if Debian's fdisk would misbehave

* Sun Mar 23 2003 Hugo Rabson <hugorabson@msn.com> 0.83
- if bad lilo, give more verbose error before quitting

* Mon Feb 17 2003 Hugo Rabson <hugorabson@msn.com> 0.82
- better at finding isolinux.bin
- better at analyzing dependencies when running on broken distributions
- try harder to boot from CD, even if tape fails
- added ADDITIONAL_BOOT_PARAMS to be sent to kernel
- removed /lib/libuuid.* from rootfs.tgz
- fixed vi
- mindi now uses gawk --traditional (making gawk behave in a functionally
  identical way to awk) - PASS; great, so now Debian needs to fix its awk :)
- removed / from list of dirs accessed when trying to resolve deplist entry
- spinner bugfix; handle odd LABELs properly (Tom Mortell)
- added -e (don't eject) compatibility
- LVM-on-RAID patch (Brian Borgeson)

* Mon Dec 16 2002 Hugo Rabson <hugo@firstlinux.net> 0.81
- EXTRA_SPACE=16384
- updated ResolveSoftlinks() to work better with b0rkn Gentoo devfs /dev
- patched analyze-my-lvm (Benjamin Mampaey)
- detect built-in boot.b files in lilo
- cleaned up spec file a bit, more use of macros (Jesse Keating)
- return w/err, don't abort, if Matt Nelson's RH8 system is farked

* Mon Dec 02 2002 Hugo Rabson <hugo@firstlinux.net> 0.80
- new stable branch
- misc code clean-up
- save boot device's boot sector
- detect and beware Compaq diagnostic partitions
- better handling of devfs V non-devfs kernels and boot devs
- trimmed busybox 0.60.3 binary on boot disk
- mindi now resides in /usr/local/bin
- removed lilo from dependencies
- more Gentoo-friendly

* Sun Nov 18 2002 Hugo Rabson <hugo@firstlinux.net> 0.71
- if your kernel's builddate doesn't match any of the kernels in 
  your /boot directory then fudge the issue & find the closest 
  match (*grumble* Debian)
- scan tape & CD at start, to force inclusion of modules on boot device
- double EXTRA_SPACE if >7 disks
- slimmer, more lithesome logfile
- now accepts --findkernel
- line 1982 - dd count=24000 should be count=$ramdisksize (Andras Korn)
- better handling of non-Linux partitions on DevFS-enabled kernels
- misc clean-ups
- fixed Debian/ramdisksize/bloat problem (Johannes Franken)
- fixed 2.4.20/fdisk eccentricity (Alistair Stevens)
- updated kernel to 2.4.18-mdk6
- generate mountlist in dev-abetical order ;)
- fixed minor bug in .spec file
- better at finding /boot/boot.b if your distro breaks the de facto standard
- fixed minor bug in MakeMountlist
- fixed install.sh
- cleaned up deplist.txt
- added rudimentary -v / --version flag
- line 1180 or so --- duplicate mindi.iso entries --- fixed
- added /bin/[ - a softlink to /bin/sh
- ListAllPartitions() - sanity fix (KP)
- fixed .spec bug
- better feedback
- added Markus's RAID patch
- ListAllPartitions() - include /mnt/win* (Hugo)

* Sun Sep 08 2002 Hugo Rabson <hugo@firstlinux.net> 0.70
- better logging by dependency-calculating code
- better handling of dependencies, specifically softlinks
- if called by mondo then use mondo's temp dir as our temp dir too
- changed gawk to $AWK in a few places, to allow for Debian
- added host* config files to deplist
- added tftp, ifconfig to busybox
- added RPC support to uClibc
- cleaned up creation of Mondo-Mindi configuration file
- fixed bug in TryToFindKernelPath which stopped it from handling
  multiple, same-version kernels gracefully
- cleaned up deplist.txt
- receive 'DIFFERENTIAL' variable from Mondo
- better Debian compatibility, esp. w/detection of ver# (Hector Alvarez)
- better devfs support; call fgrep in places instead of grep (Andrew Korn)
- fixed analyze-my-lvm (Ralph Gruwe)
- moved 50K of stuff from rootfs.tgz to aux-tools.tgz
- added x11-tools.tgz option
- updated /dev/console and /dev/tty0 (Paul Stevens)
- cleaned up /mnt/groovy-stuff V /tmp/tmpfs code
- catch sigint, sighup, etc.
- fixed LILO-related message.txt mistake
- .spec file clean-up; automation; config file (Carl Wilhem Soderstrom)
- better devfs support (Andrew Korn)

* Sun Jul 14 2002 Hugo Rabson <hugo@firstlinux.net> 0.64-1
- fixed RH7.3 readonly bug
- improved nfs config file creation
- search more locations for isolinux.bin
- added isonuke option
- faster data disk creation
- better DevFS support (Hector Alvarez, DuckX)
- nfs-related fix (Hans Lie)
- abort if vfat filesystem present but mkfs.vfat missing
- removed softlink to pico
- allow Mondo to say no compression will be used
- added [ to ramdisk
- tar data disks with -b [block size] of 32k
- don't autoboot to 'RESTORE' screen - it's scary!
- let user choose lilo or syslinux as boot loader
- added syslinux support
- cleaned up message screens

































