/***********************************************************************
*
* embperl.c
*
* Routines for manipulating embedded Perl interpreter
*
* Copyright (C) 2003 by Roaring Penguin Software Inc.
*
***********************************************************************/

static char const RCSID[] =
"$Id: embperl.c,v 1.9 2004/01/29 15:47:43 dfs Exp $";

#ifdef EMBED_PERL
#include <EXTERN.h>
#include <perl.h>
#include <errno.h>
#include <syslog.h>

static PerlInterpreter *my_perl = NULL;
extern void xs_init ();

int
make_embedded_interpreter(char const *progPath, char const *subFilter)
{
    char *argv[6];
    int argc;

    if (my_perl != NULL) {
#ifdef SAFE_EMBED_PERL
	perl_destruct(my_perl);
	perl_free(my_perl);
	my_perl = NULL;
#else
	syslog(LOG_WARNING, "Cannot destroy and recreate a Perl interpreter safely on this platform.  Filter rules will NOT be reread.");
	return 0;
#endif

    }

    my_perl = perl_alloc();
    if (!my_perl) {
	errno = ENOMEM;
	return -1;
    }
#ifdef PERL_SET_CONTEXT
    PERL_SET_CONTEXT(my_perl);
#endif
    PL_perl_destruct_level = 1;
    perl_construct(my_perl);
    if (subFilter) {
	argv[0] = "";
	argv[1] = (char *) progPath;
	argv[2] = "-f";
	argv[3] = (char *) subFilter;
	argv[4] = "-embserver";
	argv[5] = NULL;
	argc = 5;
    } else {
	argv[0] = "";
	argv[1] = (char *) progPath;
	argv[2] = "-embserver";
	argv[3] = NULL;
	argc = 3;
    }
    perl_parse(my_perl, xs_init, argc, argv, NULL);
    perl_run(my_perl);
    return 0;
}

void
run_embedded_filter(void)
{
    char *args[] = { NULL };

    perl_call_argv("do_main_loop", G_DISCARD | G_NOARGS, args);
}
#endif

