/* 
 * Copyright (C) 2009 Piotr Pokora <piotrek.pokora@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef _MIDGARD_VIEW_H
#define _MIDGARD_VIEW_H

#include <glib-object.h>
#include "midgard_dbobject.h"

#define MIDGARD_TYPE_VIEW            (midgard_view_get_type())
#define MIDGARD_VIEW(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), MIDGARD_TYPE_VIEW, MidgardView))
#define MIDGARD_VIEW_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), MIDGARD_TYPE_VIEW, MidgardViewClass))
#define MIDGARD_IS_VIEW(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), MIDGARD_TYPE_VIEW))
#define MIDGARD_IS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), MIDGARD_TYPE_VIEW))
#define MIDGARD_VIEW_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), MIDGARD_TYPE_VIEW, MidgardViewClass))

typedef struct _MidgardView MidgardView;
typedef struct _MidgardViewClass MidgardViewClass;

struct _MidgardView {
	GObject parent;
	MidgardDBObjectPrivate *dbpriv;
};

struct _MidgardViewClass {
	GObjectClass parent;
	MidgardDBObjectPrivate *dbpriv;

	const MidgardConnection *(*get_connection) (MidgardDBObject *object);
};

GType midgard_view_get_type(void);

#endif /* MIDGARD_VIEW_H */
