/*
    MiddleMan filtering proxy server
    Copyright (C) 2002-2004  Jason McLaughlin
    Copyright (C) 2003  Riadh Elloumi

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "flags.h"
#include "proto.h"
#include "macros.h"

/*
 * Select a section from the document
 */
TiXmlNode* section_select(TiXmlDocument *doc, const char* name)
{
	TiXmlNode* node = 0;

	ASSERT(doc)

	node = doc->FirstChild("mman");
	ASSERT(node);

	node = node->FirstChild(name);
	ASSERT(node);

	return node;
}

/*
 * Some fuctions that eases properties reading
 */

XmlElement::XmlElement(TiXmlDocument* doc, const string& sn, const string& en)
{
	section_name = sn;
	element_name = en;
	tixml_element = section_select(doc, sn.c_str())->FirstChildElement(en.c_str());
}

XmlElement::XmlElement(TiXmlDocument* doc, const string& sn)
{
	section_name = sn;
	element_name = "";
	tixml_element = section_select(doc, sn.c_str())->ToElement();
}

int XmlElement::next()
{
	tixml_element = tixml_element->NextSiblingElement(element_name.c_str());
	
	return (tixml_element) ? TRUE : FALSE;
}

int XmlElement::full() const
{
	return (tixml_element) ? TRUE : FALSE;
}

string XmlElement::string_read(const string& name) const
{
	TiXmlElement* child = tixml_element->FirstChildElement(name.c_str());

	if (child) {
		TiXmlNode* text = child->FirstChild();		
		return (text) ? (char*)text->Value() : "";
	}
	
	throw ConfigError();
}

bool XmlElement::check_active(const string& name) const
{
	TiXmlElement* child = tixml_element->FirstChildElement(name.c_str());

	if (child) {
		const char* res = child->Attribute("active");
		if (res == NULL || !strcasecmp(res, "true"))
			return true;
		else if (!strcasecmp(res, "false"))
			return false;
		else
			throw ConfigError();
	}

	throw ConfigError();
}

string XmlElement::section_get() const
{
	return section_name;
}

string XmlElement::element_get() const
{
	return element_name;
}
