/*
    MiddleMan filtering proxy server
    Copyright (C) 2002-2004  Jason McLaughlin

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "proto.h"

#ifdef HAVE_SSL

pthread_mutex_t *lock_cs;
long *lock_count;

void SSL_thread_setup()
{
	int lockcount, x;

	/* libssl has shared global data structures, we need to provide it with a means to lock them against
	   concurrent access. */
	lockcount = CRYPTO_num_locks();
	lock_cs = (pthread_mutex_t *)malloc(lockcount * sizeof(pthread_mutex_t));
	lock_count = (long *)xmalloc(lockcount * sizeof(long));

	for (x = 0; x < lockcount; x++) {
		pthread_mutex_init(&lock_cs[x], NULL);
		lock_count[x] = 0;
	}

	CRYPTO_set_id_callback((unsigned long (*)()) SSL_pthreads_thread_id);
	CRYPTO_set_locking_callback((void (*)(int, int, const char *, int)) SSL_pthreads_locking_callback);
}

void SSL_thread_cleanup(void)
{
	int x;

	CRYPTO_set_locking_callback(NULL);
	for (x = 0; x < CRYPTO_num_locks(); x++)
		pthread_mutex_destroy(&(lock_cs[x]));

	xfree(lock_cs);
	xfree(lock_count);
}

void SSL_pthreads_locking_callback(int mode, int type, const char *file, int line)
{
	if (mode & CRYPTO_LOCK) {
		pthread_mutex_lock(&(lock_cs[type]));
		lock_count[type]++;
	} else
		pthread_mutex_unlock(&(lock_cs[type]));
}

unsigned long SSL_pthreads_thread_id(void)
{
	unsigned long ret;
	ret = (unsigned long) pthread_self();

	return (ret);
}
#endif
