#ifndef SECTION_H
#define SECTION_H

typedef struct CONNECTION_T CONNECTION;
class Filebuf;

class StringList: public list<string> {
 public:
	StringList();
	StringList(const string&, const char = ',');
	void parse(const string&, const char = ',');
	int has(const string) const;
};

class Couple: public StringList {
 public:
	Couple(const string&);
	string first() const;
	string second() const;
};

typedef list<int> IntList;

class StringSelect {
 public:
	string name;
	string comment;
	string desc;
	bool selected;

 	StringSelect();
	StringSelect(string, string, string, bool);
};

class StringSelectVector: public vector<StringSelect> {
 public:
	StringSelectVector() {}
	StringSelectVector(int i): vector<StringSelect>(i) {}
	int case_indexof(const string&) const;
	void reset();
};

typedef map <string, StringSelectVector> SSVMap;

class XmlElement {
	TiXmlElement* tixml_element;
	string section_name;
	string element_name;

 public:
	XmlElement(TiXmlDocument*, const string&);
	XmlElement(TiXmlDocument*, const string&, const string&);
	int next();
	int full() const;
	string string_read(const string&) const;
	bool check_active(const string&) const;
	string section_get() const;
	string element_get() const;
};

class IpRange {	 
	string ip_start;	 
	unsigned int ip_start_int;
	string ip_end;
	unsigned int ip_end_int;

 public:
	IpRange(const string&);
	int has(char*) const;	
};

class IpRangeList: public list<IpRange> {
 public:
	IpRangeList();
	IpRangeList(const string&);
	void parse(const string&);
	int has(char*) const;
};

class PortRange {	 
public:
	int start;
	int end;

	PortRange(const string&);
};

class PortRangeList: public list<PortRange> {
 public:
	PortRangeList();
	PortRangeList(const string&);
	void parse(const string&);
	int has(int port) const;
};

class CGIMap: public map <string, string> {
 public:
	CGIMap() {}
	CGIMap(char *);
	void parse(char*);
};

class Item;
class ItemList;

class Field {
 public:
	static const int INT = 0;
	static const int UINT = 1;
	static const int BOOL = 2;
	static const int STRING = 3;	
	static const int STRING_SELECT_ONE = 4;
	static const int STRING_SELECT_MANY = 5;
	static const int STRING_LIST = 6;
	static const int IP_RANGE_LIST = 7;
	static const int PORT_RANGE_LIST = 8;
	static const int UNIQUE_ID = 9;
	static const int STRING_RANGE = 10;
	static const int INT_RANGE = 11;
	static const int FILE_SIZE = 12;
	static const int MULTILINE_STRING = 13;

	string name;
	int type;
	string comment;
	string desc;
	int space;
	int min;
	int max;
	bool optional;

	bool active;
	int int_value;
	int int_value2;
	unsigned int uint_value;
	string string_value;
	StringList string_list_value;
	IpRangeList ip_range_list_value;
	PortRangeList port_range_list_value;
	StringSelectVector string_select_value;
	StringSelectVector string_select_value2;

	Field(string, string, string, string, int, bool);
	Field(string, string, string, StringSelectVector&, int, bool);

	static int type_get(const string&);
	string possible_values() const;
	string nature() const;
	void error_log(const XmlElement&) const;
	void load(const XmlElement&);
	void save(TiXmlElement*) const;
	void zero();
	void read(CGIMap&, int);
	void display(Filebuf *) const;
	void dialog_display(Filebuf *, CGIMap&, int) const;
};

class FieldVector: public vector<Field> {
 public:	
	FieldVector(): vector<Field> () {}  
        FieldVector(const TiXmlElement&, SSVMap &);	   
	void parse(const TiXmlElement&, SSVMap &);
	StringList read(CGIMap&);
	void save(TiXmlElement*) const;
	void display(Filebuf *) const;
	void dialog_display(Filebuf *, CGIMap &) const;
};

class Subsection;

class Item {
 private:
	static int count;
	int id;
	string section;
	string subsection;

 public:
	FieldVector field_vec;

	Item(const Subsection&, const XmlElement* = 0);
	StringList read(CGIMap&);
	int id_get() const;
	int is(int) const;
	void display(Filebuf*, int) const;
};

class ItemList: public list<Item> {
 public:
	const Item* find(const string&);
};

class Section;

class Subsection {
 public:
	string section, name, comment;
	ItemList item_list;
	FieldVector templ;

	Subsection() {};
	Subsection(const string, const string, const string, const FieldVector&);
};

typedef vector<Subsection> SubsectionVector;

typedef map <string, Section*> SectionMap;

class Section {
	friend class Subsection;

 private:
	mutable pthread_rwlock_t rwlock;
	mutable pthread_mutex_t mutex;
	const int lock_type;

 protected:
	string name;
	string comment;
	bool restart;
	FieldVector field_vec;
 	virtual void update() = 0;
	SubsectionVector sub_vec;

 public:
	static SectionMap map;

	Section(string, int, bool = false);
	virtual ~Section();
	void load(TiXmlDocument*, int);
	void save(TiXmlDocument*);
	void read_lock() const;
	void write_lock() const;
	void mutex_lock() const;
	void unlock() const;
	int cond_wait(pthread_cond_t*);
	int atomic_read(int *) const;
	int atomic_read(unsigned int *) const;
	int atomic_read(long *) const;
	int atomic_read(unsigned long *) const;
	void interface(Filebuf*, CGIMap &, CONNECTION*, const StringList&);
	void interface_dialog(Filebuf*, CGIMap &, CONNECTION*, const StringList&);
	StringList interface_action(Filebuf*, CGIMap &, CONNECTION*);
	Item* item_get(int);
	ItemList::iterator item_iterator_get(int);
	Subsection* subsection_get(const string&);
	void display_enabled(Filebuf*);
	string name_get() const;
};

class Encapsulator {
 public:
	const Item* item;
	Encapsulator(): item(NULL) {}
	Encapsulator(const Item& i): item(&i) {}
	Encapsulator(const Item* i): item(i) {}
};

class ConfigError {

};
	
class InterfaceError {
 public:
	string msg;
	InterfaceError(const char *, ...);
};
	

#endif  /* SECTION_H */
