
#ifdef USE_IMLIB

#include "image.h"

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/extensions/shape.h>
#include <Imlib.h>

#define IMFILENUM 500
static char imfile[IMFILENUM][1024];
static ImlibImage *imdata[IMFILENUM];
static int imnum;
static ImlibData *id;

int imIdent(char *fullname, char *name)
{
	return 1;
}

Image *imLoad(char *fullname, char *name, unsigned int verbose)
{
	static Display *disp = NULL;
	Image *image;
	ImlibImage *im;
	ImlibColor shape;
	unsigned int w,h, size;
	ImlibImage *search_imdata();
	void regist_imdata();

	if (disp == NULL) {
		disp=XOpenDisplay(NULL);
	}
	if (id == NULL) id=Imlib_init(disp);
	if ((im = search_imdata(fullname)) == NULL) {
		im = Imlib_load_image(id, fullname);
	}
	if (im == NULL) {
		return NULL;
	}
	w = im->rgb_width;
	h = im->rgb_height;
	size = w * h * 3;

	image = newTrueImage(w, h);
	memcpy(image->data, im->rgb_data, size);
	
	Imlib_get_image_shape(id, im, &shape);

	/*
	 * bug fix for transparent gif handling
	 * suggested by Jose Geraldo Alves Brito Neto <jgabrito@iq.usp.br>
	 */
	if ((shape.r >=0) && (shape.g >= 0) && (shape.b >= 0))
	  image->trans = \
	    ((shape.r & 0xff) << 16) |
	    ((shape.g & 0xff) <<  8) |
	    ((shape.b & 0xff) <<  0);

	image->title = dupString(name);
#if 0
	Imlib_kill_image(id, im);
#else
	regist_imdata(name, im);
#endif
	
	return image;
}

ImlibImage *search_imdata(char *fullname)
{
	int i;
	for (i = 0; i < imnum; i ++){
		if (!strcmp(imfile[i], fullname)) {
			return imdata[i];
		}
	}
	return NULL;
}

void regist_imdata(fullname, im)
	char *fullname; 
	ImlibImage *im;
{
	strcpy(imfile[imnum], fullname);	
	imdata[imnum] = im;
	imnum ++;
}

Pixmap pixmap_fromimimage(imimage, width, height)
	ImlibImage *imimage;
	int width, height;
{
	static Pixmap pixmap;
	Imlib_render(id, imimage, width, height);
	pixmap = Imlib_move_image(id, imimage);

	return pixmap;
}

#define MAXPMAP 100
void
manage_pixmap(pixmap, add, page)
	Pixmap pixmap;
	int add;
	int page;
{
	static Pixmap pmap[MAXPMAP];
	static int ppage[MAXPMAP];
	int i;

	if (add) {
		for (i = 0; i < MAXPMAP; i ++) {
			if (pmap[i] == pixmap) return;
		}
		for (i = 0; i < MAXPMAP; i ++) {
			if (!pmap[i]) break;
		}
		if (i == MAXPMAP) {
			fprintf(stderr, "warning: too many images in manage_pixmap\n");
			return;
		}
		pmap[i] = pixmap;
		ppage[i] = page;
	} else {
		for (i = 0; i < MAXPMAP; i ++) {
			if (ppage[i] == page){
				Imlib_free_pixmap(id, pmap[i]);
				pmap[i] = 0;
			}
		}
	}
}

#endif
