/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef LogHandler_H
#define LogHandler_H

#include <iostream>
#include <sstream>
#include <vector>


using namespace std;

class LogItem
{
public:
	LogItem() : errorStatus_(false) {};
	LogItem(string& desc) : description_(desc), errorStatus_(false) {};

	void description(string s) {description_=s;}
	void command(string s) {command_=s;}
	void method(string s) {method_=s;}
	void request(string s) {request_=s;}
	void status(string s) {status_=s;}
	//void log(string s) {log_=s;}
	void log(string s) {log_.append(s);}
	void error(string s) {if(s.size() > 0) {log(s); errorStatus_=true;};}
	void errorStatus(bool b) {errorStatus_=b;}

	const string& description() const {return description_;}
	const string& command() const {return command_;}
	const string& method() const {return method_;}
	const string& request() {return request_;}
	const string& status() {return status_;}
	const string& log() {return log_;}
	bool  errorStatus() {return errorStatus_;}

	void  clear() {description_.clear(); command_.clear(); method_.clear(); log_.clear(); 
		      request_.clear(); status_.clear(); errorStatus_=false;}

private:
	string   	description_;
	string   	command_;
	string 		method_;
	string		log_;
	string          request_;
	string 		status_;
	bool     	errorStatus_;
};


class LogHandler
{
public:
	~LogHandler() {instanceFlag_ = false; clear();}
	static LogHandler* instance();
	void add(LogItem*);
	void clear();
	const vector<LogItem*>& item() {return item_;} 
	LogItem* lastItem() {return (item_.size() > 0)?item_[item_.size()-1]:0;} 	

protected:
	LogHandler() {};

private:
	static bool instanceFlag_;
	static LogHandler* instance_;

	vector<LogItem*>  item_;	
};
	
#endif
