/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <stdio.h>
#include <errno.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <Xm/Xm.h>
#include <Xm/Text.h>
#include <Xm/CutPaste.h>
#include "xec.h"


/* convert to lower case */

/* Removed by Iain Russell, 2008-12-22
   because not needed by any code which is used in Metview
static lowcase(char *p)
{
	while(*p)
	{
		if(*p>='A' && *p<='Z') *p += 32;
		p++;
	}
}


int  regexp_find(char *word,char *buffer,Boolean nocase,int *from,int *to)
{
	extern char *xec_loc1,*xec_loc2;

	if(nocase) {
		lowcase(word);
		lowcase(buffer);
	};
	xec_compile(word);
	if(xec_step(buffer))
	{
		*from = xec_loc1-buffer;
		*to   = xec_loc2-buffer;
		return TRUE;
	}
	return FALSE;
}
*/

/*--------------------------------------------------
---------------------------------------------------*/


/*--------------------------------------------------

	Search the regexp 'word' in the text 'w'.
	Return TRUE in the text was found.
	if 'nocase' is TRUE the search is not case sensitive.
	if 'fromstart' is TRUE the search start from the
	fisrt char, else from the current position.
	if 'wrap' is TRUE the search is done all the text.

---------------------------------------------------*/
/* Removed by Iain Russell, 2008-12-22
   because not needed by any code which is used in Metview

Boolean xec_TextSearch(Widget w,char *word,Boolean nocase,Boolean fromstart,Boolean wrap)
{
	char 			*p=XmTextGetString(w);
	Boolean			success,more;
	XmTextPosition 	from,to,offset,dummy;


	if(fromstart)
	{
		offset=0;
		wrap = FALSE;
	}
	else
	{
		XmTextGetSelectionPosition(w,&dummy,&offset);
		if(dummy == offset) offset = XmTextGetInsertionPosition(w);

	}

	do
	{

		if(success =  regexp_find(word,p+offset,nocase,&from,&to))
		{
			XmTextShowPosition(w,to+offset);
			XmTextSetSelection(w,from+offset,to+offset,CurrentTime);
		}

		more = wrap && !success;

		if(wrap)
		{
			wrap = FALSE;
			offset = 0;
		}

	}while(more);

	XtFree((XtPointer)p);

	return success;

}
*/


/*-------------------------------------------------

	Copy the content of a Text in a buffer.

--------------------------------------------------*/

char *xec_GetText(Widget w,char *buf)
{
	char *q = (char*)XmTextGetString(w);

	strcpy(buf,q);
	XtFree((XtPointer)q);

	return buf;
}


/*-------------------------------------------------

	Load a file into a text widget.
	if include is TRUE the text if included.

--------------------------------------------------*/

int xec_LoadText(Widget Text,const char *fname,Boolean include)
{
	FILE    *fp = NULL;
	char    *p;
	long    length;
	int 	ret = 0;

	errno = 0;

	if (!fname) return -1;

	if (fp = fopen(fname,"r"))
	{
		fseek(fp,0L,2);
		if (errno)
		{
			ret = errno;
			fclose(fp);
			return errno = ret;
		}

		length=ftell(fp);
		if (errno)
		{
			ret = errno;
			fclose(fp);
			return errno = ret;
		}

		fseek(fp,0L,0);
		if (errno)
		{
			ret = errno;
			fclose(fp);
			return errno = ret;
		}

		p = (char*)XtMalloc(length+1);
		p[length] = 0;

		fread(p,length,1,fp);
		if (errno)
		{
			ret = errno;
			fclose(fp);
			return errno = ret;
		}

		_XmTextDisableRedisplay(Text,TRUE);
		if (include)
			xec_ReplaceTextSelection(Text,p,FALSE);
		else
		{
			XmTextSetInsertionPosition(Text,0);
			XmTextSetSelection(Text,0,0,CurrentTime);
			XmTextSetString(Text,p);
		}
		_XmTextEnableRedisplay(Text);

		free(p);
		fclose(fp);
	} 
	else 
	{
		ret = errno;
		if (!include) XmTextSetString(Text,"");
	}
	return errno = ret;

}

/*-------------------------------------------------

	Save a text into a file

--------------------------------------------------*/

/* Open file, save text and close file */

int xec_SaveText(Widget w,const char *fname)
{
	FILE    *fp = NULL;
	char    *p = XmTextGetString(w);
	long    length = strlen(p);
	int 	ret;

	errno = 0;

	if (!fname) return -1;

	if (fp = fopen(fname,"w"))
		if (fwrite(p,strlen(p),1,fp)) fclose(fp);

	ret = errno;
	free(p);
	return errno = ret;
}


/* File is already opened: just save text */

int xec_DumpText(FILE *fp,Widget w)
{
	char    *p = XmTextGetString(w);
	long    length = strlen(p);

	errno = 0;
	fwrite(p,strlen(p),1,fp);
	XtFree((XtPointer)p);
	return errno;
}


/*-------------------------------------------------

	Print a text

--------------------------------------------------*/

void xec_PrintText(Widget w,const char *cmd)
{
	char    *tmp = tmpnam(NULL);
	char	buf[1024];

	xec_SaveText(w,tmp);
	if(cmd)
		sprintf(buf,"%s %s",cmd,tmp);
	else
		sprintf(buf,"lpr %s",tmp);

	system(buf);
	unlink(tmp);


}

/*-------------------------------------------------

	Replace the selection by a char*
	If sel the inserted text is selected

--------------------------------------------------*/

void xec_ReplaceTextSelection(Widget w,const char *p,Boolean sel)
{
	XmTextPosition	from,to;

	XmTextGetSelectionPosition(w,&from,&to);
	if(from == to) from = to = XmTextGetInsertionPosition(w);
	XmTextReplace(w,from,to,p);
	if(sel)
		XmTextSetSelection(w,from,from+strlen(p),CurrentTime);
	else
		XmTextSetSelection(w,from+strlen(p),from+strlen(p),CurrentTime);
	XmTextSetInsertionPosition(w,from+strlen(p));
}

