/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "UserMessage.h"
#include "Request.h"


#ifndef Log_H
#include "Log.h"
#endif

#ifndef Protocol_H
#include "Protocol.h"
#endif

UserMessage::UserMessage(): 
	Message("USER_MESSAGE") 
{ 
}

UserMessage::~UserMessage()
{ 
}


void UserMessage::callback(MvRequest& r)
{
  const char* info = r("INFO");

  const char* c = getSource();          //-- prevent string(0) constructor
  string s = c ? string(c) : string("?");

  Log::info(s) << info << endl;
}

static ProtocolFactory<UserMessage> usrMsg;

