/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef Rainbow_H
#include "Rainbow.h"
#endif

#ifndef XPalette_H
#include "XPalette.h"
#endif


Rainbow::Rainbow(Widget w):
	widget_(w),
	gc_(XtGetGC(w,0,0))
{
	XtVaGetValues(widget_,
		XmNwidth, &width_,
		XmNheight,&height_,
		0);

	Display* dpy = XtDisplay(widget_);
	int     screen = DefaultScreen(dpy);
	Window  root   = RootWindow(dpy,screen);

	image_ =  XGetImage(dpy,root, 0, 0, 
				width_, height_, 
				AllPlanes, ZPixmap);
}

Rainbow::~Rainbow()
{
	XtReleaseGC(widget_,gc_);
	XDestroyImage(image_);
}

void Rainbow::redraw()
{
	if(XtIsRealized(widget_))
		XPutImage(
			XtDisplay(widget_),
			XtWindow(widget_),
			gc_,
			image_,
			0,0,0,0,width_,height_);
}

void Rainbow::fill(const RainbowMaker& maker)
{
	int w = width_-1;
	int h = height_-1;

	for(int i = 0; i < width_ ; i++)
		for(int j = h; j >= 0; j--)
		{
			double x = double(i)/double(w);
			double y = double(h-j)/double(h);
			XPutPixel(image_,i,j, maker.pixel(x,y));
		}

	redraw();
}
