/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File ODBEditor.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef ODBEditor_H
#define ODBEditor_H

#ifndef InternalEditor_H
#include "InternalEditor.h"
#endif

#include "UIODBEditor.h"


class ODBEditor : public XEditor<UIODBEditor_c> {
public:

// -- Exceptions
	// None

// -- Contructors

	ODBEditor(const IconClass&,const string&);

// -- Destructor

	virtual ~ODBEditor(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods

	void sql(Widget);
	void constants(Widget);
	void insert(const string&);

	map<string,string>& params();

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members
	// None

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	ODBEditor(const ODBEditor&);
	ODBEditor& operator=(const ODBEditor&);

// -- Members

	map<string,string> params_;
	map<string,map<string,vector<string> > > tables_;

	Widget sql_;
	Widget constants_;

// -- Methods

	void parseDDfile();

	string selectedVariable();
	void adjustButtons();

// -- Overridden methods

	// From InternalEditor 

	virtual void apply();
	virtual void reset();
	virtual void close();
	virtual void merge(IconObject*);
	virtual void replace(IconObject*);
	virtual string alternateEditor();

	// From XD

	virtual void browseTablesCB(Widget,XtPointer);
	virtual void browseColumnsCB(Widget,XtPointer);
	virtual void browseFieldsCB(Widget,XtPointer);
	virtual void browseSelectCB(Widget,XtPointer);
	virtual void doubleClickCB(Widget,XtPointer);

	virtual void addCB(Widget,XtPointer);
	virtual void removeCB(Widget,XtPointer);
	virtual void upCB(Widget,XtPointer);
	virtual void downCB(Widget,XtPointer);
	virtual void insertCB(Widget,XtPointer);

	virtual void changedCB(Widget,XtPointer);

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const ODBEditor& p)
	//	{ p.print(s); return s; }

};

inline void destroy(ODBEditor**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(ODBEditor);
//#endif

#endif
