/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File Drawer.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef Drawer_H
#define Drawer_H

#include <string>
using std::string;

#include <Xm/Xm.h>

class Drawer {
public:

// -- Exceptions
	// None

// -- Contructors

	Drawer();

// -- Destructor

	virtual ~Drawer(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods

	virtual Widget widget() = 0;


	void open();
	void close();
	virtual string name();

	virtual void opened();
	virtual void closed();

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members
	// None

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	Drawer(const Drawer&);
	Drawer& operator=(const Drawer&);

// -- Members

	Widget widget_;

// -- Methods
	// None

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const Drawer& p)
	//	{ p.print(s); return s; }

};

inline void destroy(Drawer**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(Drawer);
//#endif

#endif
