/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef RootFolder_H
#define RootFolder_H

#include "SystemFolder.h"

class RootFolder : public SystemFolder
{
public:
	RootFolder();
	virtual ~RootFolder(); 

private:
	// No copy allowed
	RootFolder(const RootFolder&);
	RootFolder& operator=(const RootFolder&);

	virtual Path path() const;
	virtual Path dotPath() const;
	virtual string fullName() const;
	virtual Folder* parent() const;
	virtual Path logPath();
	bool isEmbedded() {return false;}

};

inline void destroy(RootFolder**) {}

#endif
