/***************************** LICENSE START ***********************************

 Copyright 2014 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef Command_H
#define Command_H

#include <string>

using namespace std;

class IconObject;

class Command {
public:
	Command(const string& name);
	virtual ~Command();

	virtual void execute(IconObject*) = 0;
	static void execute(const string&,IconObject*);
	static bool isValid(const string&);

protected:
	string name_;

private:
	// No copy allowed
	Command(const Command&);
	Command& operator=(const Command&);
};

#endif
