/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQRequestPanelLine_H
#define MvQRequestPanelLine_H

#include "RequestPanelItem.h"

#include <QObject>
#include <QString>

class QLabel;
class QToolButton;

class  MvQRequestPanelHelp;

class  Parameter;
class  RequestPanel;

class MvQRequestPanelLine : public QObject, public RequestPanelItem
{
Q_OBJECT  
  
public:
	MvQRequestPanelLine(RequestPanel&,const Parameter&,bool buildLine=true);
	virtual ~MvQRequestPanelLine(); 
	
	static MvQRequestPanelLine* build(RequestPanel&,const Parameter&);
	
	void gray(bool);
	void mark(bool);
	bool hasDefaultTb();
	
public slots:
  	void slotChangeToDefault(bool);
	virtual void slotHelperEdited(const vector<string>&) {};
	virtual void slotHelperEdited(const vector<string>&,const vector<string>&) {};
	void slotStarHelpDialog(bool);
	
protected:
	void buildHelp();
	void setEnabled(bool);
	
	enum ColumnPos {DefaultColumn=0,NameColumn=1,ExpandColumn=2,WidgetColumn=3};
	
	QToolButton* defaultTb_;
	QLabel* nameLabel_;
	QToolButton* helpTb_;
	QString name_;
	QString source_;	
	int row_;
	
	bool gray_;
	bool mark_;
	
	MvQRequestPanelHelp* helper_;
	QWidget *parentWidget_;
};


#endif
