/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <messaging/qt/variant.h>

#include <gtest/gtest.h>

TEST(QtVariant, construction_from_qvariant_yields_correct_type)
{
    EXPECT_EQ(messaging::Variant::Type::integer, messaging::qt::Variant{QVariant(uint(42))}.type());
    EXPECT_EQ(messaging::Variant::Type::integer, messaging::qt::Variant{QVariant(int(42))}.type());
    EXPECT_EQ(messaging::Variant::Type::integer, messaging::qt::Variant{QVariant(qulonglong(42))}.type());
    EXPECT_EQ(messaging::Variant::Type::integer, messaging::qt::Variant{QVariant(qlonglong(42))}.type());

    EXPECT_EQ(messaging::Variant::Type::boolean, messaging::qt::Variant{QVariant(bool(true))}.type());
    EXPECT_EQ(messaging::Variant::Type::floating_point, messaging::qt::Variant{QVariant(double(42.))}.type());
    EXPECT_EQ(messaging::Variant::Type::string, messaging::qt::Variant{QVariant(QString("42"))}.type());
    EXPECT_EQ(messaging::Variant::Type::recursive,
              messaging::qt::Variant{QVariant(QVariantMap({{"42", uint(42)}}))}.type());
    EXPECT_EQ(messaging::Variant::Type::recursive,
              messaging::qt::Variant{QVariant(QVariantList({QVariant{uint(42)}}))}.type());
}

TEST(QtVariant, construction_from_qvariant_yields_correct_value)
{
    EXPECT_EQ(42, messaging::qt::Variant{QVariant(uint(42))}.as_int());
    EXPECT_EQ(42, messaging::qt::Variant{QVariant(int(42))}.as_int());
    EXPECT_EQ(42, messaging::qt::Variant{QVariant(qulonglong(42))}.as_int());
    EXPECT_EQ(42, messaging::qt::Variant{QVariant(qlonglong(42))}.as_int());

    EXPECT_EQ(true, messaging::qt::Variant{QVariant(bool(true))}.as_bool());
    EXPECT_EQ(42, messaging::qt::Variant{QVariant(double(42.))}.as_double());
    EXPECT_EQ("42", messaging::qt::Variant{QVariant(QString("42"))}.as_string());
    EXPECT_EQ(42, messaging::qt::Variant{QVariant(QVariantMap({{"42", uint(42)}}))}.at(0)->at(1)->as_int());
    EXPECT_EQ(42, messaging::qt::Variant{QVariant(QVariantList({QVariant{uint(42)}}))}.at(0)->as_int());
}

TEST(QtVariant, qvariant_map)
{
    QVariantMap map{{"one", uint{1}}, {"two", "dos"}};
    messaging::qt::Variant qt_variant_map{QVariant(map)};

    std::shared_ptr<messaging::Variant> value1 = qt_variant_map.at("one");
    std::shared_ptr<messaging::Variant> value2 = qt_variant_map.at("two");
    EXPECT_EQ(value1->as_int(), 1);
    EXPECT_EQ(value2->as_string(), std::string{"dos"});
}
