/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef TESTING_QT_TP_CLIENT_H_
#define TESTING_QT_TP_CLIENT_H_

#include <TelepathyQt/AbstractClientApprover>
#include <TelepathyQt/AbstractClientHandler>
#include <TelepathyQt/ChannelDispatchOperation>
#include <TelepathyQt/ClientRegistrar>
#include <TelepathyQt/MethodInvocationContext>

#include <messaging/qt/tp/initializer.h>

#include <set>
#include <vector>

namespace testing
{
namespace qt
{
namespace tp
{
class Client
{
public:
    static constexpr const char* name{"testing.qt.tp.Client"};

    class Approver : public Tp::AbstractClientApprover
    {
    public:
        Approver(const Tp::AbstractClientHandlerPtr handler, const Tp::ChannelClassSpecList& filter);

        void addDispatchOperation(const Tp::MethodInvocationContextPtr<>& context,
                                  const Tp::ChannelDispatchOperationPtr& dispatchOperation) override;

    private:
        Tp::AbstractClientHandlerPtr handler;
    };

    class Handler : public Tp::AbstractClientHandler
    {
    public:
        Handler(const Tp::ChannelClassSpecList& filter);

        bool bypassApproval() const override;

        void handleChannels(const Tp::MethodInvocationContextPtr<>& context,
                            const Tp::AccountPtr& account,
                            const Tp::ConnectionPtr& connection,
                            const QList<Tp::ChannelPtr>& channels,
                            const QList<Tp::ChannelRequestPtr>& requestsSatisfied,
                            const QDateTime& userActionTime,
                            const HandlerInfo& handlerInfo);

    private:
        std::vector<Tp::ChannelPtr> channels_in_flight;  ///< Keep the new channel objects alive.
    };

    Client(const QDBusConnection& connection, const Tp::ChannelClassSpecList& filter);

    messaging::qt::tp::Initializer ti;
    Tp::AbstractClientHandlerPtr handler;
    Tp::AbstractClientApproverPtr approver;
    Tp::ClientRegistrarPtr client_registrar;
};
}
}
}

#endif  // TESTING_QT_TP_CLIENT_H_
