/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <messaging/parameter.h>

#include <messaging/associative_dictionary.h>
#include <messaging/variant.h>

#include <messaging/boost/variant.h>

#include <gtest/gtest.h>

TEST(Parameter, can_extract_from_dictionary_for_existing_value)
{
    messaging::AssociativeDictionary<std::string, messaging::BoostVariant, messaging::Variant> ad;
    ad.set_value_for_key("42", messaging::BoostVariant{std::int64_t{42}});

    messaging::Parameter param{"42", "u", messaging::Parameter::Flags::required};

    EXPECT_TRUE(param.can_extract_from(ad));
    EXPECT_EQ(42, param.extract_from(ad).as_int());
}

TEST(Parameter, returns_false_and_throws_if_dictionary_does_not_contain_parameter)
{
    messaging::AssociativeDictionary<std::string, messaging::BoostVariant, messaging::Variant> ad;

    messaging::Parameter param{"42", "u", messaging::Parameter::Flags::required};

    EXPECT_FALSE(param.can_extract_from(ad));
    EXPECT_ANY_THROW(param.extract_from(ad));
}
