#include <gtest/gtest.h>
#include <gmock/gmock.h>

#include <messaging/group_manager.h>

#include <tests/mock_group_manager.h>

#include <memory>

namespace testing
{

TEST(GroupManagerTest, test_set_group_permissions_by_method)
{
    auto group_manager = std::make_shared<NiceMock<MockGroupManager>>();
    messaging::Flags<messaging::GroupPermissions> permissions = messaging::GroupPermissions::CanChangeTitle |
                messaging::GroupPermissions::CanSetAdmin;
    group_manager->set_permissions(permissions);

    EXPECT_TRUE(group_manager->permissions().is_set(messaging::GroupPermissions::CanChangeTitle));
    EXPECT_FALSE(group_manager->permissions().is_set(messaging::GroupPermissions::CanDissolve));
    EXPECT_FALSE(group_manager->permissions().is_set(messaging::GroupPermissions::CanKick));
    EXPECT_TRUE(group_manager->permissions().is_set(messaging::GroupPermissions::CanSetAdmin));
}

TEST(GroupManagerTest, test_set_group_permissions_by_read_reference)
{
    //another way of setting the permissions
    auto group_manager = std::make_shared<NiceMock<MockGroupManager>>();
    group_manager->permissions() = messaging::GroupPermissions::CanDissolve |
            messaging::GroupPermissions::CanSetAdmin | messaging::GroupPermissions::CanKick;

    EXPECT_FALSE(group_manager->permissions().is_set(messaging::GroupPermissions::CanChangeTitle));
    EXPECT_TRUE(group_manager->permissions().is_set(messaging::GroupPermissions::CanDissolve));
    EXPECT_TRUE(group_manager->permissions().is_set(messaging::GroupPermissions::CanKick));
    EXPECT_TRUE(group_manager->permissions().is_set(messaging::GroupPermissions::CanSetAdmin));
}

TEST(GroupManagerTest, test_set_group_permissions_by_or_operator)
{
    //and another
    auto group_manager = std::make_shared<NiceMock<MockGroupManager>>();
    group_manager->permissions() |= messaging::GroupPermissions::CanDissolve;
    group_manager->permissions() |= messaging::GroupPermissions::CanKick;

    EXPECT_FALSE(group_manager->permissions().is_set(messaging::GroupPermissions::CanChangeTitle));
    EXPECT_TRUE(group_manager->permissions().is_set(messaging::GroupPermissions::CanDissolve));
    EXPECT_TRUE(group_manager->permissions().is_set(messaging::GroupPermissions::CanKick));
    EXPECT_FALSE(group_manager->permissions().is_set(messaging::GroupPermissions::CanSetAdmin));
}
}
