/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef FORK_AND_WAIT_H_
#define FORK_AND_WAIT_H_

#include <core/posix/fork.h>

namespace testing
{
/// @brief fork_and_wait executes the given functor f in a new process and waits for it to complete.
/// @return the wait result.
core::posix::wait::Result fork_and_wait(std::function<core::posix::exit::Status()> f);
}

#endif  // FORK_AND_WAIT_H_
