/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <messaging/connection.h>
#include <messaging/messenger.h>

#include "mock_connection.h"

#include <gtest/gtest.h>

namespace
{
struct TestingConnection : public messaging::Connection
{
    TestingConnection(const std::shared_ptr<messaging::Connection::Observer>& observer)
        : messaging::Connection{observer}
    {
    }

    std::string self_identifier() override
    {
        throw std::logic_error{"Not implemented"};
    }

    std::shared_ptr<messaging::PresenceManager> presence_manager() override
    {
        throw std::logic_error{"Not implemented"};
    }

    std::shared_ptr<messaging::Messenger> messenger() override
    {
        throw std::logic_error{"Not implemented"};
    }

    std::shared_ptr<messaging::GroupStarter> group_starter() override
    {
        throw std::logic_error{"Not implemented"};
    }

    void connect() {}
    void disconnect(StatusChangedReason) {}
    std::string normalize_identifier(const std::string& id) { return id; }
    bool is_valid_identifier(const std::string &id) { return !id.empty(); }

    using messaging::Connection::announce_status_changed;
};
}

TEST(Connection, correctly_propagates_status_changes)
{
    const auto the_new_status = messaging::Connection::Status::disconnected;
    const auto the_reason = messaging::Connection::StatusChangedReason::not_specified;

    auto observer = std::make_shared<testing::MockConnection::MockObserver>();
    EXPECT_CALL(*observer, on_status_changed(the_new_status, the_reason)).Times(1);

    TestingConnection connection(observer);
    connection.announce_status_changed(the_new_status, the_reason);
}
