/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "blocking_connector.h"

#include <stdexcept>

const messaging::Enumerator<messaging::Parameter>& testing::BlockingConnector::parameters() const
{
    return params;
}

std::shared_ptr<messaging::Connection> testing::BlockingConnector::request_connection(
    const std::shared_ptr<messaging::Connection::Observer>&,
    const std::shared_ptr<messaging::Messenger::Observer>&,
    const std::shared_ptr<messaging::PresenceManager::Observer>&,
    const messaging::Dictionary<std::string, messaging::Variant>&)
{
    throw std::logic_error{"Not implemented"};
}

void testing::BlockingConnector::run()
{
    std::unique_lock<std::mutex> ul(m);
    // We need to check on the flag to prevent from spurious wakeups.
    cv.wait(ul,
            [this]()
            {
        return stop_requested;
    });
}

void testing::BlockingConnector::stop()
{
    stop_requested = true;
    cv.notify_all();
}
