/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <messaging/associative_dictionary.h>
#include <messaging/boost/variant.h>

#include <gtest/gtest.h>

namespace
{
void test_that_this_compiles_fine(
    const messaging::Dictionary<std::string, messaging::Variant>& dict =
        messaging::AssociativeDictionary<std::string, messaging::BoostVariant, messaging::Variant>())
{
    (void)dict;
}
}

TEST(AssociativeDictionary, can_distinguish_between_interface_and_impl_for_value)
{
    test_that_this_compiles_fine();
}

TEST(AssociativeDictionary, can_retrieve_added_values)
{
    messaging::AssociativeDictionary<std::string, int> ad;

    EXPECT_FALSE(ad.has_value_for_key("42"));

    ad.set_value_for_key("42", 42);

    EXPECT_TRUE(ad.has_value_for_key("42"));
    EXPECT_EQ(42, ad.value_for_key("42"));
}
