/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef TESTING_MOCK_PRESENCEMANAGER_H_
#define TESTING_MOCK_PRESENCEMANAGER_H_

#include <messaging/presence_manager.h>
#include <messaging/recipient.h>

#include <gmock/gmock.h>

namespace testing
{
class MockPresenceManager : public messaging::PresenceManager
{
public:

    struct MockObserver : public messaging::PresenceManager::Observer
    {
        MOCK_METHOD2(on_presence_changed, void(const std::shared_ptr<messaging::Recipient>&, const messaging::Presence&));
    };

    MockPresenceManager(const std::shared_ptr<messaging::PresenceManager::Observer>& observer);

    MOCK_METHOD0(get_valid_statuses, messaging::PresenceManager::StatusMap());
    MOCK_METHOD2(set_self_presence, void(const std::string&, const std::string&));
    MOCK_METHOD1(request_presence, void(const std::shared_ptr<messaging::Recipient>&));

    void announce_presence_changed(const std::shared_ptr<messaging::Recipient>& recipient, const messaging::Presence& presence);

private:

    messaging::PresenceManager::StatusMap fake_get_valid_statuses();
};
}

#endif  // TESTING_MOCK_MESSENGER_H_
