/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef TESTING_MOCK_MESSENGER_H_
#define TESTING_MOCK_MESSENGER_H_

#include <messaging/messenger.h>

#include <gmock/gmock.h>

namespace testing
{
class MockMessenger : public messaging::Messenger
{
public:
    struct MockObserver : public messaging::Messenger::Observer
    {
        MOCK_METHOD2(on_message_without_chat_received, void(const messaging::Recipient::shared_ptr&, const messaging::Message&));
        MOCK_METHOD1(on_new_group_invitation_received, void(const std::shared_ptr<messaging::Group>&));
    };

    MockMessenger(const std::shared_ptr<messaging::Messenger::Observer>& observer);

    void announce_message_without_chat_received(const messaging::Recipient::shared_ptr& recipient, const messaging::Message& message);
    void announce_new_group_invitation_received(const std::shared_ptr<messaging::Group>&);

    MOCK_METHOD2(create_chat_with, std::shared_ptr<messaging::Chat>(const messaging::Recipient::shared_ptr&, const std::shared_ptr<messaging::Chat::Observer>&));

private:

    std::shared_ptr<messaging::Chat> fake_create_chat_with(const messaging::Recipient::shared_ptr&,
                                                             const std::shared_ptr<messaging::Chat::Observer>& chat_observer);
};

}

#endif  // TESTING_MOCK_MESSENGER_H_
