/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef TESTING_MOCK_GROUP_MANAGER_H_
#define TESTING_MOCK_GROUP_MANAGER_H_

#include <messaging/group_manager.h>
#include <messaging/flags.h>
#include <messaging/member.h>
#include <messaging/members.h>

#include <gmock/gmock.h>

namespace testing
{
class MockGroupManager : public messaging::GroupManager
{
public:
    struct MockObserver : public messaging::GroupManager::Observer
    {
        MOCK_METHOD1(on_group_created, void(const std::string& id));
        MOCK_METHOD0(on_group_cancelled, void());
        MOCK_METHOD1(on_group_title_changed, void(const std::string&));
        MOCK_METHOD3(on_group_subject_changed, void(const std::string&, const std::shared_ptr<messaging::Member>&, const std::chrono::system_clock::time_point&));
    };

    MOCK_METHOD0(leave_group, void());
    MOCK_METHOD0(dissolve_group, void());
    MOCK_METHOD0(join_group, void());
    MOCK_METHOD1(change_group_title, void(const std::string&));
    MOCK_METHOD1(change_group_subject, void(const std::string&));
    MOCK_METHOD1(add_members, void(const messaging::Members&));
    MOCK_METHOD1(remove_members, void(const messaging::Members&));
    MOCK_METHOD0(group_id, std::string());
    MOCK_METHOD0(group_title, std::string());
    MOCK_METHOD0(group_subject, std::string());
    MOCK_METHOD0(group_creator, std::shared_ptr<messaging::Member>());
    MOCK_METHOD0(group_admins, std::set<std::string>());
    MOCK_METHOD0(members, messaging::Members());
    MOCK_METHOD1(set_observer, void(const std::shared_ptr<Observer>&));
    MOCK_METHOD1(on_plugged, void(const std::weak_ptr<messaging::HasInterfaces>&));
};

}

#endif  // TESTING_MOCK_GROUP_MANAGER_H_
