/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <messaging/associative_connector_factory.h>

messaging::ConnectorFactory::Generator messaging::AssociativeConnectorFactory::create_instance_for_name(
    const std::string& name) const
{
    auto it = generators.find(name);

    if (it == generators.end())
    {
        throw std::out_of_range("Could not find a messaging::Connector generator for name " + name);
    }

    return it->second;
}

bool messaging::AssociativeConnectorFactory::has_generator_for_name(const std::string& name) const noexcept(true)
{
    return generators.count(name) > 0;
}

void messaging::AssociativeConnectorFactory::add_generator_for_name(const std::string& name,
                                                                    const Generator& generator) noexcept(true)
{
    generators[name] = generator;
}

void messaging::AssociativeConnectorFactory::remove_generator_for_name(const std::string& name) noexcept(true)
{
    generators.erase(name);
}
