/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MESSAGING_QT_TP_INTERFACES_BASE_CHANNEL_SUBJECT_INTERNAL_H_
#define MESSAGING_QT_TP_INTERFACES_BASE_CHANNEL_SUBJECT_INTERNAL_H_

#include <TelepathyQt/_gen/svc-channel.h>
#include <messaging/qt/tp/interfaces/base_channel_subject.h>
#include <messaging/visibility.h>

namespace messaging
{
namespace qt
{
namespace tp
{
namespace interfaces
{

class MESSAGING_FW_LOCAL BaseChannelSubjectInterface::Adaptee : public QObject
{
    Q_OBJECT
public:
    Adaptee(BaseChannelSubjectInterface *interface);
    ~Adaptee();

    QString subject() const;
    QString actor() const;
    uint actorHandle() const;
    qlonglong timestamp() const;
    bool canSet() const;

public Q_SLOTS:
    void setSubject(const QString &subject, const Tp::Service::ChannelInterfaceSubjectAdaptor::SetSubjectContextPtr &context);

public:
    BaseChannelSubjectInterface *mInterface;
};

}
}
}
}

#endif // MESSAGING_QT_TP_INTERFACES_BASE_CHANNEL_SUBJECT_INTERNAL_H_

