/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MESSAGING_NON_COPYABLE_H_
#define MESSAGING_NON_COPYABLE_H_

#include <messaging/visibility.h>

namespace messaging
{
/// @cond
class MESSAGING_FW_PUBLIC NonCopyable
{
  public:
    virtual ~NonCopyable() = default;
    NonCopyable(const NonCopyable& rhs) = delete;
    NonCopyable& operator=(const NonCopyable& rhs) = delete;

  protected:
    NonCopyable() = default;
};
/// @endcond
}

#endif // MESSAGING_NON_COPYABLE_H_
