#ifndef MESSAGING_MEMBER
#define MESSAGING_MEMBER

#include <messaging/user.h>
#include <messaging/flags.h>

namespace messaging
{

enum class PendingStatus
{
    None,
    Remote,
    Local
};

enum class Role : uint
{
    Member  = 1 << 0,   //1
    Admin   = 1 << 1    //2
};

class MESSAGING_FW_PUBLIC Member : public User
{
public:
    Member(std::string id,
                PendingStatus pending_status = PendingStatus::None,
                Flags<Role> roles = Flags<Role>(Role::Member),
                std::string display_name = std::string{},
                VariantMap properties = VariantMap{});

    PendingStatus pending_status() const;
    Flags<Role> roles() const;

private:
    /// @cond
    struct Private;
    std::shared_ptr<Private> impl;
    /// @endcond
};

}
#endif // MESSAGING_MEMBER

