/*
 * Copyright 2016 Canonical Ltd.
 *
 * This file is part of messaging-app.
 *
 * messaging-app is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * messaging-app is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 2.0
import Ubuntu.Components 1.3
import Ubuntu.Components.Popups 1.3

Dialog {
    id: mmsDialog

    signal accepted(var message)

    property var message: null

    title: i18n.tr("Multiple MMS Messages")
    text: i18n.tr("The content you are sending requires one MMS message per recipient, so you might get charged for multiple messages.\n\Do you want to continue?")

    Button {
        id: noButton
        text: i18n.tr("No")
        onClicked: PopupUtils.close(mmsDialog)
    }

    Button {
        id: yesButton
        text: i18n.tr("Yes")
        color: UbuntuColors.orange
        onClicked: {
            mmsDialog.accepted(message)
            PopupUtils.close(mmsDialog)
        }
    }

}
