/*
rfc822.h - MessageWall RFC822 parsing declarations
Copyright (C) 2002 Ian Gulliver

This program is free software; you can redistribute it and/or modify
it under the terms of version 2 of the GNU General Public License as
published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef _RFC822_H
#define _RFC822_H

#include <firestring.h>

#define RFC822_WHITESPACE " \t"
#define RFC822_VALUE_MAXLEN 256

struct rfc822_message_t {
	struct firestring_estr_t header;
	struct firestring_estr_t body;
};

int rfc822_split_message(struct firestring_estr_t *data, struct rfc822_message_t *message);

struct firestring_estr_t *rfc822_header_value(struct rfc822_message_t *message, char *header);
struct firestring_estr_t *rfc822_eheader_value(struct rfc822_message_t *message, struct firestring_estr_t *header);
struct firestring_estr_t *rfc822_parameter_value(struct firestring_estr_t *headervalue, char *parameter);

int rfc822_header_check(struct rfc822_message_t *message, struct firestring_estr_t *header, struct firestring_estr_t *content);
int rfc822_header_checki(struct rfc822_message_t *message, struct firestring_estr_t *header, struct firestring_estr_t *content);

int rfc822_to_cc_check(struct rfc822_message_t *message, struct firestring_estr_t *address);
int rfc822_from_check(struct rfc822_message_t *message, struct firestring_estr_t *address);
int rfc822_realname_check(struct rfc822_message_t *message);

int rfc822_header_reject_check(int client);
int rfc822_header_rejecti_check(int client);

int rfc822_body_reject_check(int client, struct firestring_estr_t *part);
int rfc822_body_rejecti_check(int client, struct firestring_estr_t *part);

#endif
