String.prototype.trim = function(){ return this.replace(/^\s+|\s+$/g,'') }
String.prototype.escRegExp = function(){ return this.replace(/[\\$*+?()=!|,{}\[\]\.^]/g,'\\$&') }
String.prototype.unescHtml = function(){ var i,t=this; for(i in e) t=t.replace(new RegExp(i,'g'),e[i]); return t }
function Suggestions() { this.length=0; this.picked=0 }
var suggestions = new Suggestions();
var tagSearch='', lastEdit='';
var h={}, sections=[{},{},{},{},{},{}], selected={}, currentTag={},
e={'&lt;':'<','&gt;':'>','&amp;':'&','&quot;':'"'};

function init () {
    document.onkeydown = document.onkeypress = document.onkeyup = handler
    h.suggest = document.getElementById("suggestionlist");
    h.tags = document.getElementById("tags");
}

function handler(event) { var e=(event||window.event) //w3||ie
    if (e.type == 'keyup') {
        switch(e.keyCode) {
            //case 8:  //backspace
            //case 46: //delete
            case 35: //end
            case 36: //home
            case 39: // right
            case 37: // left
            case 32: // space
                hideSuggestions(); break
            case 38: case 40: break;
            case 9: break;
            case 13: break;
            default: 
            updateSuggestions()
}}
    else if (e.type == "keypress") { lastEdit = h.tags.value }
}

function makeTag(parent, tag, js) {
    parent.appendChild(document.createTextNode(" "+ tag))
}

function updateSuggestions() {
    while (h.suggest.hasChildNodes()) h.suggest.removeChild(h.suggest.firstChild)
    if(!getCurrentTag() || !currentTag.text) { 
        hideSuggestions(); return false 
    }
    var tagArray = h.tags.value.toLowerCase().split(' '),
    txt=currentTag.text.trim().escRegExp(), tagHash={}, t
    for(t in tagArray) tagHash[tagArray[t]] = true;

    var search = tagList.match(new RegExp(("(?:^| )("+txt+"[^ ]+)"), "gi"))
    if(search){
        var i;
        for (i=0; i<search.length; i++) {
            var tl = search[i].trim()
            if(tagHash[tl])  continue // do not suggest already typed tag
            suggestions[suggestions.length] = makeTag(h.suggest, tl, 'complete')
            suggestions.length++
    }} 
    if (suggestions.length > 0) { showSuggestions() } 
    else { hideSuggestions(); }
}

function getCurrentTag() {
    if(h.tags.value == lastEdit) return true // no edit
    if(h.tags == '') return false
    currentTag = {}
    var tagArray=h.tags.value.toLowerCase().split(' '), oldArray=lastEdit.toLowerCase().split(' '), currentTags = [], matched=false, t,o
    for (t in tagArray) {
        for (o in oldArray) {
            if(typeof oldArray[o] == 'undefined') { oldArray.splice(o,1); break }
            if(tagArray[t] == oldArray[o]) { matched = true; oldArray.splice(o,1); break; }
        }
        if(!matched) currentTags[currentTags.length] = t
        matched=false
    }
    // more than one word changed... abort
    currentTag = { text:tagArray[currentTags[0]], index:currentTags[0] }
    return true
}


function hideSuggestions() { h.suggest.style.visibility='hidden' }
function showSuggestions() { h.suggest.style.visibility='visible' }
