<?php
/**
 * Rebuild interwiki table using the file on meta and the language list
 * Wikimedia specific!
 *
 * @todo document
 * @addtogroup Maintenance
 */

/** */

/**
 * @todo document
 * @addtogroup Maintenance
 */
class Site {
	var $suffix, $lateral, $url;

	function Site( $s, $l, $u ) {
		$this->suffix = $s;
		$this->lateral = $l;
		$this->url = $u;
	}

	function getURL( $lang ) {
		$xlang = str_replace( '_', '-', $lang );
		return "http://$xlang.{$this->url}/wiki/\$1";
	}
}

function getRebuildInterwikiSQL() {
	global $langlist, $languageAliases, $prefixRewrites;

	# Multi-language sites
	# db suffix => db suffix, iw prefix, hostname
	$sites = array(
		'wiki' => new Site( 'wiki', 'w', 'wikipedia.org' ),
		'wiktionary' => new Site( 'wiktionary', 'wikt', 'wiktionary.org' ),
		'wikiquote' => new Site( 'wikiquote', 'q', 'wikiquote.org' ),
		'wikibooks' => new Site( 'wikibooks', 'b', 'wikibooks.org' ),
		'wikinews' => new Site( 'wikinews', 'n', 'wikinews.org' ),
		'wikisource' => new Site( 'wikisource', 's', 'wikisource.org' ),
		'wikimedia' => new Site( 'wikimedia', 'chapter', 'wikimedia.org' ),
	);

	# List of language prefixes likely to be found in multi-language sites
	$langlist = array_map( "trim", file( "/home/wikipedia/common/langlist" ) );

	# List of all database names
	$dblist = array_map( "trim", file( "/home/wikipedia/common/all.dblist" ) );

	# Special-case hostnames
	$specials = array(
		'sourceswiki' => 'sources.wikipedia.org',
		'quotewiki' => 'wikiquote.org',
		'textbookwiki' => 'wikibooks.org',
		'sep11wiki' => 'sep11.wikipedia.org',
		'metawiki' => 'meta.wikimedia.org',
		'commonswiki' => 'commons.wikimedia.org',
		'specieswiki' => 'species.wikimedia.org',
	);

	# Extra interwiki links that can't be in the intermap for some reason
	$extraLinks = array(
		array( 'm', 'http://meta.wikimedia.org/wiki/$1', 1 ),
		array( 'meta', 'http://meta.wikimedia.org/wiki/$1', 1 ),
		array( 'sep11', 'http://sep11.wikipedia.org/wiki/$1', 1 ),
	);

	# Language aliases, usually configured as redirects to the real wiki in apache
	# Interlanguage links are made directly to the real wiki
	# Something horrible happens if you forget to list an alias here, I can't
	#   remember what
	$languageAliases = array(
		'zh-cn' => 'zh',
		'zh-tw' => 'zh',
		'dk' => 'da',
		'nb' => 'no',
	);

	# Special case prefix rewrites, for the benefit of Swedish which uses s:t
	# as an abbreviation for saint
	$prefixRewrites = array(
		'svwiki' => array( 's' => 'src' ),
	);

	# Construct a list of reserved prefixes
	$reserved = array();
	foreach ( $langlist as $lang ) {
		$reserved[$lang] = 1;
	}
	foreach ( $languageAliases as $alias => $lang ) {
		$reserved[$alias] = 1;
	}
	foreach( $sites as $site ) {
		$reserved[$site->lateral] = 1;
	}

	# Extract the intermap from meta
	$intermap = wfGetHTTP( 'http://meta.wikimedia.org/w/index.php?title=Interwiki_map&action=raw', 30 );
	$lines = array_map( 'trim', explode( "\n", trim( $intermap ) ) );

	if ( !$lines || count( $lines ) < 2 ) {
		wfDie( "m:Interwiki_map not found" );
	}

	$iwArray = array();

	foreach ( $lines as $line ) {
		$matches = array();
		if ( preg_match( '/^\|\s*(.*?)\s*\|\|\s*(https?:\/\/.*?)\s*$/', $line, $matches ) ) {
			$prefix = strtolower( $matches[1] );
			$url = $matches[2];
			if ( preg_match( '/(wikipedia|wiktionary|wikisource|wikiquote|wikibooks|wikimedia)\.org/', $url ) ) {
				$local = 1;
			} else {
				$local = 0;
			}

			if ( empty( $reserved[$prefix] ) ) {
				$iwArray[$prefix] = array( "iw_prefix" => $prefix, "iw_url" => $url, "iw_local" => $local );
			}
		}
	}

	$sql = "-- Generated by rebuildInterwiki.php";


	foreach ( $dblist as $db ) {
		if ( isset( $specials[$db] ) ) {
			# Special wiki
			# Has interwiki links and interlanguage links to wikipedia

			$host = $specials[$db];
			$sql .= "\n--$host\n\n";
			$sql .= "USE $db;\n" .
					"TRUNCATE TABLE interwiki;\n" .
					"INSERT INTO interwiki (iw_prefix, iw_url, iw_local) VALUES \n";
			$first = true;

			# Intermap links
			foreach ( $iwArray as $iwEntry ) {
				$sql .= makeLink( $iwEntry, $first, $db );
			}

			# Links to multilanguage sites
			foreach ( $sites as $targetSite ) {
				$sql .= makeLink( array( $targetSite->lateral, $targetSite->getURL( 'en' ), 1 ), $first, $db );
			}

			# Interlanguage links to wikipedia
			$sql .= makeLanguageLinks( $sites['wiki'], $first, $db );

			# Extra links
			foreach ( $extraLinks as $link ) {
				$sql .= makeLink( $link, $first, $db );
			}

			$sql .= ";\n";
		} else {
			# Find out which site this DB belongs to
			$site = false;
			foreach( $sites as $candidateSite ) {
				$suffix = $candidateSite->suffix;
				if ( preg_match( "/(.*)$suffix$/", $db, $matches ) ) {
					$site = $candidateSite;
					break;
				}
			}
			if ( !$site ) {
				print "Invalid database $db\n";
				continue;
			}
			$lang = $matches[1];
			$host = "$lang." . $site->url;
			$sql .= "\n--$host\n\n";

			$sql .= "USE $db;\n" .
					"TRUNCATE TABLE interwiki;\n" .
					"INSERT INTO interwiki (iw_prefix,iw_url,iw_local) VALUES\n";
			$first = true;

			# Intermap links
			foreach ( $iwArray as $iwEntry ) {
				# Suppress links with the same name as the site
				if ( ( $suffix == 'wiki' && $iwEntry['iw_prefix'] != 'wikipedia' ) ||
				  ( $suffix != 'wiki' && $suffix != $iwEntry['iw_prefix'] ) )
				{
					$sql .= makeLink( $iwEntry, $first, $db );
				}
			}

			# Lateral links
			foreach ( $sites as $targetSite ) {
				# Suppress link to self
				if ( $targetSite->suffix != $site->suffix ) {
					$sql .= makeLink( array( $targetSite->lateral, $targetSite->getURL( $lang ), 1 ), $first, $db );
				}
			}

			# Interlanguage links
			$sql .= makeLanguageLinks( $site, $first, $db );

			# w link within wikipedias
			# Other sites already have it as a lateral link
			if ( $site->suffix == "wiki" ) {
				$sql .= makeLink( array("w", "http://en.wikipedia.org/wiki/$1", 1), $first, $db );
			}

			# Extra links
			foreach ( $extraLinks as $link ){
					$sql .= makeLink( $link, $first, $db );
			}
			$sql .= ";\n\n";
		}
	}
	return $sql;
}

# ------------------------------------------------------------------------------------------

# Returns part of an INSERT statement, corresponding to all interlanguage links to a particular site
function makeLanguageLinks( &$site, &$first, $source ) {
	global $langlist, $languageAliases;

	$sql = "";

	# Actual languages with their own databases
	foreach ( $langlist as $targetLang ) {
		$sql .= makeLink( array( $targetLang, $site->getURL( $targetLang ), 1 ), $first, $source );
	}

	# Language aliases
	foreach ( $languageAliases as $alias => $lang ) {
		$sql .= makeLink( array( $alias, $site->getURL( $lang ), 1 ), $first, $source );
	}
	return $sql;
}

# Make SQL for a single link from an array
function makeLink( $entry, &$first, $source ) {
	global $prefixRewrites;

	if ( isset( $prefixRewrites[$source] ) && isset( $prefixRewrites[$source][$entry[0]] ) ) {
		$entry[0] = $prefixRewrites[$source][$entry[0]];
	}

	$sql = "";
	# Add comma
	if ( $first ) {
		$first = false;
	} else {
		$sql .= ",\n";
	}
	$dbr = wfGetDB( DB_SLAVE );
	$sql .= "(" . $dbr->makeList( $entry ) . ")";
	return $sql;
}

?>
