<?php
/*
 * MV_Messages.php Created on Jan 8, 2008
 *
 * Internationalization file for MetavidWiki extension
 */

$messages = array();

/** English
 * @author Michael Dale
 */
$messages['en'] = array(
	'metavid'           => 'Metavid Page',
	'mv_missing_stream' => 'Missing Stream: $1',

	#stream/files key descriptions:
	'mv_ogg_low_quality'      => 'Web streamable - Ogg Theora 300kbs',
	'mv_ogg_high_quality'     => 'High quality - Ogg Theora 900kbs',
	'mv_archive_org_link'     => 'Links into Archive.org mpeg2 originals',
	'ao_file_64Kb_MPEG4'      => 'Archive.org - mpeg4 64kbs',
	'ao_file_256Kb_MPEG4'     => 'Archive.org - mpeg4 256kbs',
	'ao_file_MPEG1'           => 'Archive.org - mpeg1',
	'ao_file_MPEG2'           => 'Archive.org - mpeg2 original',
	'ao_file_flash_flv'       => 'Archive.org - flash video',

	'mv_error_stream_missing' => '<span class="error">Error: There is no video file associated with this stream.</span><br />Please report this to the site administrator.',

	#add/edit stream text:
	'mv_stream_meta'                => 'Stream page',
	'mv_add_stream'                 => 'Metavid Add Stream',
	'mv_edit_stream'                => 'Metavid Edit Stream',
	'mvexportsearch'                => 'Metavid Export',
	'mvexportsequence'              => 'Metavid Export Sequence',
	'mvexportstream'                => 'Metavid Export Stream',
	
	'mv_add_stream_page'            => 'Mv Add Stream',
	'mv_edit_strea_docu'            => '<p>Edit stream <b>admin</b><br />for normal user view/edit see $1 page',
	'mv_add_stream_docu'            => '<p>Add a new Stream with the field below.</p>
<p>More information is given on the <a href="$1">help page for add stream</a>.</p>',
	'mv_add_stream_submit'          => 'Add stream',
	'mv_no_stream_files'            => 'No Existing Stream files',
	'mv_edit_stream_files'          => 'Edit stream files',
	'mv_path_type_url_anx'          => 'full media url',
	'mv_path_type_wiki_title'       => 'wiki media title',
	'mv_path_type_label'            => 'path type',
	'mv_base_offset_label'          => 'base offset',
	'mv_duration_label'             => 'duration',
	'mv_file_desc_label'            => 'stream desc msg',
	'mv_delete_stream_file'         => 'delete stream file reference',
	'mv_save_changes'               => 'Save changes',
	'mv_file_with_same_desc'        => 'Error: stream file with same description key <i>$1</i> already present',
	'mv_updated_stream_files'       => 'Updated Stream Files Record',
	'mv_removed_file_stream'        => 'Removed Stream file: $1',
	'mv_missing_stream_text'        => 'The stream you requested <b>$1</b> is not available.<br />
You may want to check the <a href="$2">Stream list</a><br />
Or you many want to <a href="$3">Add the stream</a>.',
	'mv_user_cant_edit'             => 'You may have to $1 to edit, $2', //$1 is login link and $2 is cancel link

	'mv_add_stream_file'            => 'Add stream file',
	'mv_media_path'                 => 'media path',
	'mv_file_list'                  => 'Stream files',
	'mv_label_stream_name'          => 'Stream name',
	'mv_label_stream_desc'          => 'Stream description',
	'add_stream_permission'         => 'You lack permission to add a new stream',
	'edit_stream_missing'           => 'Missing stream name',	
	'mv_missing_req_time'           => 'Missing request time', 
	'mv_missing_cat'                => 'Missing category name',
	'mv_stream_already_exists'      => 'The stream <a href="$2">$1</a> already exists',
	'mv_summary_add_stream'         => 'stream added by form',
	'mv_error_stream_insert'        => 'failed to insert stream',
	'mv_redirect_and_delete_reason' => 'removed redirect page',
	'mv_remove_reason'              => 'Reason for deletion:',
	'mv_stream_delete_warrning'     => '<b>Removing this Stream will also remove $1 pieces of assocative metadata</b><br />',

	#stream type
	'mv_label_stream_type'     => 'Stream type',
	'mv_metavid_file'          => 'Existing file on server',
	'mv_metavid_live'          => 'Set up live stream',
	'mv_upload_file'           => 'Upload file',
	'mv_external_file'         => 'External file',
	'mv_stream_delete_warning' => 'Deleting this stream will additionally remove $1 pages of metadata',

	#tools
	'mv_tool_search'            => 'Search',
	'mv_tool_search_title'      => 'Search within this Stream',
	'mv_search_transcripts_for' => 'Search transcripts for',
	'mv_tool_navigate'          => 'Navigate',
	'mv_tool_navigate_title'    => 'Navigate the full stream',
	'mv_tool_export'            => 'Export',
	'mv_tool_export_title'      => 'Export stream metadata',
	'mv_tool_embed'             => 'Embed',
	'mv_tool_embed_title'       => 'Embed options for the current requested segment',
	'mv_tool_overlay'           => 'Template overlays',
	'mv_tool_overlay_title'     => 'Template based metadata Overlays',
	'mv_results_found_for'      => 'Search results <b>$1</b> to <b>$2</b> of <b>$3</b> for:',
	'mv_tool_mang_layers'       => 'Manage layers',
	'mv_update_layers'          => 'Update layers',
	'mv_watch_clip'				=> 'Watch Clip',
	'mv_close_clip'				=> 'Close Clip',
	'mv_improve_transcript'		=> 'Improve Transcript',

	#mvd types:
	'ht_en'          => 'Transcript',
	'ht_en_desc'     => 'English transcripts. This overlay type is for spoken text',
	'anno_en'        => 'Annotations and Categories',
	'anno_en_desc'   => 'English categorizations and annotations.
This overlay can be used to categorize sections of video or to add annotative information that is not spoken text',
	'thomas_en'      => 'Official transcript',
	'thomas_en_desc' => 'Official Thomas Transcript from the governments THOMAS record service.
Source time synced by C-SPAN\'s c-spanarchives.org',

	#mvd errors:
	'mvd_default_mismatch'      => 'Error in settings file',
	'mvd_default_mismatch_text' => 'There is an error in your setting file.
$mvMVDTypeDefaultDisp should be a subset of $mvMVDTypeAllAvailable',

	'mv_data_page_title' => '$1 for $2 from $3',
	'mv_time_separator'  => '$1 to $2',

	# Messages for  Special List stream
	'mv_list_streams'      => 'Metavid list streams',
	'mv_list_streams_page' => 'Mv list streams',
	'mv_list_streams_docu' => 'The following streams exist:',
	'mv_list_streams_none' => 'No streams exist',

	#messages for metavid export feed:
	'mvvideofeed'        => 'Metavid video feed export',	
	'mvexportask'		 => 'Semantic Video Feed Export',
	'video_feed_cat'     => 'Video feed for category:',
	'mv_cat_search_note' => 'Note: Categories only lists top level categories.
For all metadata in category ranges search for $1',

	# Messages for MV_DataPage
	'mv_mvd_linkback' => 'Part of stream $1 <br />
Jump to stream view: $2',

	#messages for MVD pages
	'mvBadMVDtitle' => 'missing type, stream missing, or not valid time format',
	'mvMVDFormat'   => 'MVD title should be of format: mvd:type:stream_name/start_time/end_time',

	#messeges for interface mvd pages:
	'mv_play'                     => 'Play',
	'mv_edit'                     => 'Edit',
	'mv_history'                  => 'History',
	'mv_history_title'            => 'Edit and video alignment history',
	'mv_edit_title'               => 'Edit text',
	'mv_edit_adjust_title'        => 'Edit text and video alignment',
	'mv_remove'                   => 'remove',
	'mv_remove_title'             => 'remove this meta data segment',
	'mv_adjust'                   => 'adjust',
	'mv_adjust_submit'            => 'Save adjustment',
	'mv_adjust_title'             => 'Adjust start and end time',
	'mv_adjust_preview'           => 'Preview adjustment',
	'mv_adjust_preview_stop'      => 'Stop preview',
	'mv_adjust_default_reason'    => 'metavid interface adjust',
	'mv_adjust_old_title_missing' => 'The page you are trying to move from ($1) does not exist',
	'mv_adjust_ok_move'           => 'Success, adjusting...',

	'mv_start_desc'               => 'Start time',
	'mv_end_desc'                 => 'End time',
	'mv_of'                       => '&#32;of&#32;',

	#search
	'mediasearch'                    => 'Media search',
	'mv_search_sel_t'                => 'Select search type',
	'mv_run_search'                  => 'Run search',
	'mv_add_filter'                  => 'Add filter',
	'mv_search_match'                => 'Search text',
	'mv_search_spoken_by'            => 'Spoken by',
	'mv_search_category'             => 'Category',
	'mv_search_smw_property'         => 'Semantic properties',
	'mv_search_smw_property_numeric' => 'Numeric semantic value',
	'mv_search_and'                  => 'and',
	'mv_search_or'                   => 'or',
	'mv_search_not'                  => 'not',
	'mv_search_stream_name'          => 'Stream name',
	'mv_search_date_range'           => 'Date range',
	'mv_stream_name'                 => 'stream name',
	'mv_date_range'                  => 'date range',

	'mv_match'     => 'match',
	'mv_spoken_by' => 'spoken by',
	'mv_category'  => 'category',

	'mv_search_no_results'        => 'No media matches',
	'mv_media_matches'            => 'Media matches',
	'mv_remove_filter'            => 'remove filter',
	'mv_advaced_search'           => 'Advanced media search',
	'mv_expand_play'              => 'Expand and play in-line',
	'mv_view_in_stream_interface' => 'View in stream interface',
	'mv_view_wiki_page'           => 'View wiki page',
	'mv_error_mvd_not_found'      => 'Error mvd not found',
	'mv_match_text'               => '~  $1 matches',
	'mv_match_text_one'           => '~ 1 match',

	#sequence text:
	'mv_edit_sequence'            => 'Editing sequence:$1',
	'mv_sequence_player_title'    => 'sequence player',

	'mv_save_sequence'            => 'Save Sequence',
	'mv_sequence_page_desc'       => 'Save the current sequence',
	'mv_sequence_add'             => 'Add clips',
	'mv_sequence_add_manual'      => 'Add by Name',
	'mv_sequence_add_manual_desc' => 'Add clips by stream name',
	'mv_sequence_add_search'      => 'Add by Search',
	'mv_sequence_add_search_desc' => 'Add clips by media search',
	'mv_seq_add_end'              => 'Add to end of sequence',

	'mv_sequence_timeline'        => 'Sequence timeline:',
	'mv_edit_sequence_desc_help'  => 'Sequence description',
	'mv_edithelpsequence'         => 'Help:Sequence_Editing',
	'mv_seq_summary'              => 'Sequence edit summary',
	'mv_add_clip_by_name'         => 'Add clip by name',

	#mv tools
	'mv_export_cmml'         => 'export cmml',
	'mv_search_stream'       => 'Search stream',
	'mv_navigate_stream'     => 'Navigate full stream',
	'mv_embed_options'       => 'Embed options',
	'mv_overlay'             => 'Overlay controls',
	'mv_stream_tool_heading' => 'Stream tools',
	'mv_tool_missing'        => 'tool request ($1) does not exist',
	'mv_bad_tool_request'    => 'bad tool line should be form: tool_name|tool_display_name',
	'mv_update_layers'       => 'update layers view',

	#msg for overlay interface:
	'mv_search_stream'       => 'Search stream',
	'mv_search_stream_title' => 'Search the current stream',
	'mv_new_ht_en'           => 'New transcript',
	'mv_new_anno_en'         => 'New tag or annotation',
	'mv_mang_layers'         => 'Manage layers',
	'mv_mang_layers_title'   => 'Manage the layer display set for the current stream',

	#msg for bots and maintance
	'mv_protect_source_material'=> 'Original source material protected from edits'
);

/** Karelian (Karjala)
 * @author Flrn
 */
$messages['krl'] = array(
	'mv_tool_search' => 'Ečindy',
	'mv_edit'        => 'Muokkaus',
);

/** Afrikaans (Afrikaans)
 * @author Arnobarnard
 */
$messages['af'] = array(
	'mv_tool_search' => 'Soek',
	'mv_remove'      => 'skrap',
	'mv_search_and'  => 'en',
);

/** Arabic (العربية)
 * @author Meno25
 * @author Siebrand
 * @author Alnokta
 */
$messages['ar'] = array(
	'metavid'                        => 'صفحة ميتافيد',
	'mv_missing_stream'              => 'ستريم مفقود: $1',
	'mv_ogg_low_quality'             => 'ثيورا أو جي جي، مستضاف على ميتافيد',
	'mv_ogg_high_quality'            => 'ثيورا أو جي جي ذو جودة عالية، مستضاف على ميتافيد',
	'mv_archive_org_link'            => 'يصل إلى Archive.org mpeg2 الأصلي',
	'ao_file_64Kb_MPEG4'             => 'Archive.org - mpeg4 64 كيلوبايت',
	'ao_file_256Kb_MPEG4'            => 'Archive.org - mpeg4 25كيلوبايت',
	'ao_file_MPEG1'                  => 'Archive.org - إم بي إي جي1',
	'ao_file_MPEG2'                  => 'Archive.org - إم بي إي جي2 أصلي',
	'ao_file_flash_flv'              => 'Archive.org - فيديو فلاش',
	'mv_error_stream_missing'        => '<span class="error">خطأ: لا يوجد ملف فيديو مصاحب لبيانات الميتا هذه.</span><br /> من فضلك أبلغ هذا إلى إداري الموقع.',
	'mv_stream_meta'                 => 'صفحة ستريم',
	'mv_add_stream'                  => 'أضف ستريم ميتافيد',
	'mv_edit_stream'                 => 'عدل ستريم ميتافيد',
	'mvexportsearch'                 => 'تصدير ميتافيد',
	'mvexportsequence'               => 'تتابع تصدير ميتافيد',
	'mvexportstream'                 => 'ستريم تصدير ميتافيد',
	'mv_add_stream_page'             => 'أضف ستريم إم في',
	'mv_edit_strea_docu'             => '<p>عدل الستريم <b>إداري</b> <br /> للمستخدم العادي عرض/تعديل انظر صفحة $1',
	'mv_add_stream_docu'             => '<p>إضافة ستريم جديد بالحقل بالأسفل.</p><p> المزيد من المعلومات معطاة في <a href="$1">صفحة المساعدة لإضافة الستريم</a>.</p>',
	'mv_add_stream_submit'           => 'أضف ستريم',
	'mv_no_stream_files'             => 'لا ملفات ستريم موجودة',
	'mv_edit_stream_files'           => 'عدل ملفات الستريم',
	'mv_path_type_url_anx'           => 'مسار الميديا الكامل',
	'mv_path_type_wiki_title'        => 'عنوان الميديا على الويكي',
	'mv_path_type_label'             => 'نوع المسار',
	'mv_base_offset_label'           => 'أوف سيت الأساس',
	'mv_duration_label'              => 'المدة',
	'mv_file_desc_label'             => 'رسالة وصف الستريم',
	'mv_delete_stream_file'          => 'احذف مرجع ملف الستريم',
	'mv_save_changes'                => 'حفظ التغييرات',
	'mv_file_with_same_desc'         => 'خطأ: ملف ستريم بنفس مفتاح الوصف <i>$1</i> موجود بالفعل',
	'mv_updated_stream_files'        => 'سجل ملفات الستريم المحدث',
	'mv_removed_file_stream'         => 'أزال ملف الستريم: $1',
	'mv_missing_stream_text'         => 'الستريم الذي طلبته <b>$1</b> غير متوفر.<br />ربما تريد فحص <a href="$2">قائمة الستريم</a><br />أو ربما ترغب في <a href="$3">إضافة الستريم</a>.',
	'mv_user_cant_edit'              => 'ربما ينبغي عليك $1 للتعديل، $2',
	'mv_add_stream_file'             => 'أضف ملف ستريم',
	'mv_media_path'                  => 'مسار الميديا',
	'mv_file_list'                   => 'ملفات الستريم',
	'mv_label_stream_name'           => 'اسم الستريم',
	'mv_label_stream_desc'           => 'وصف الستريم',
	'add_stream_permission'          => 'أنت لا تمتلك الصلاحية لإضافة ستريم جديد',
	'edit_stream_missing'            => 'اسم ستريم مفقود',
	'mv_missing_req_time'            => 'وقت طلب مفقود',
	'mv_missing_cat'                 => 'اسم تصنيف مفقود',
	'mv_stream_already_exists'       => 'الستريم <a href="$2">$1</a> موجود بالفعل',
	'mv_summary_add_stream'          => 'الستريم تمت إضافته بواسطة الاستمارة',
	'mv_error_stream_insert'         => 'فشل في إدراج الستريم',
	'mv_redirect_and_delete_reason'  => 'أزال صفحة التحويل',
	'mv_remove_reason'               => 'السبب للحذف:',
	'mv_stream_delete_warrning'      => '<b>إزالة هذا الستريم ستزيل أيضا $1 قطعة من بيانات الميتا المصاحبة</b><br />',
	'mv_label_stream_type'           => 'نوع الستريم',
	'mv_metavid_file'                => 'الملف الموجود على الخادم',
	'mv_metavid_live'                => 'ضبط ستريم حي',
	'mv_upload_file'                 => 'رفع ملف',
	'mv_external_file'               => 'ملف خارجي',
	'mv_stream_delete_warning'       => 'حذف هذا الستريم سيزيل أيضا $1 صفحة من بيانات الميتا',
	'mv_tool_search'                 => 'بحث',
	'mv_tool_search_title'           => 'ابحث في هذا الستريم',
	'mv_tool_navigate'               => 'إبحار',
	'mv_tool_navigate_title'         => 'تصفح الستريم الكامل',
	'mv_tool_export'                 => 'تصدير',
	'mv_tool_export_title'           => 'صدر بيانات ميتا الستريم',
	'mv_tool_embed'                  => 'إدراج',
	'mv_tool_embed_title'            => 'خيارات الإدراج للعامود المطلوب حاليا',
	'mv_tool_overlay'                => 'القالب يغطي',
	'mv_tool_overlay_title'          => 'تغطية بيانات ميتا بواسطة قوالب',
	'mv_results_found_for'           => 'نتائج البحث <b>$1</b> إلى <b>$2</b> ل <b>$3</b> ل:',
	'mv_tool_mang_layers'            => 'التحكم بالطبقات',
	'mv_update_layers'               => 'تحديث عرض الطبقات',
	'ht_en'                          => 'ترانسكريبت',
	'ht_en_desc'                     => 'ترانسكريبتات إنجليزية. نوع التغطية هذا للنص المنطوق في ستريم الفيديو. الوصلات يمكن إضافتها، لكن كل النص ينبغي أن يكون ما هو منطوق في ستريم الفيديو.',
	'anno_en'                        => 'الأنوتاشنات والتصنيفات',
	'anno_en_desc'                   => 'التصنيفات والأنوتاشنتات الإنجليزية. هذه التغطية يمكن استخدامها لتصنيف أقسام من الفيديو أو لإضافة معلومات أنوتاشن ليست نصا منطوقا',
	'thomas_en'                      => 'ترانس سكريبت رسمي',
	'thomas_en_desc'                 => "ترانس سكريبت توماس الرسمي من خدمة تسجيل THOMAS الرسمية. وقت المصدر معدل بواسطة C-SPAN's c-spanarchives.org",
	'mvd_default_mismatch'           => 'خطأ في ملف الإعدادات',
	'mvd_default_mismatch_text'      => 'هناك خطأ في ملف إعداداتك، $mvMVDTypeDefaultDisp يجب أن تكون جزء من $mvMVDTypeAllAvailable',
	'mv_data_page_title'             => '$1 ل$2 من $3',
	'mv_time_separator'              => '$1 إلى $2',
	'mv_list_streams'                => 'عرض ستريمات ميتافيد',
	'mv_list_streams_page'           => 'عرض ستريمات إم في',
	'mv_list_streams_docu'           => 'الستريمات التالية موجودة:',
	'mv_list_streams_none'           => 'لا ستريمات موجودة',
	'mvvideofeed'                    => 'تصدير تلقيم فيديو ميتافيد',
	'video_feed_cat'                 => 'تلقيم فيديو للتصنيف:',
	'mv_cat_search_note'             => 'ملاحظة: التصنيفات تعرض فقط التصنيفات العليا، لكل بيانات الميتا في بحث نطاقات التصنيف عن $1',
	'mv_mvd_linkback'                => 'جزء من الستريم $1 <br />القفز إلى عرض الستريم: $2<br />',
	'mvBadMVDtitle'                  => 'نوع مفقود، ستريم مفقود، أو صيغة وقت غير صحيحة',
	'mvMVDFormat'                    => 'عنوان إم في دي ينبغي أن يكون بالصيغة: mvd:نوع:اسم_الستريم/وقت_البداية/وقت_النهاية',
	'mv_play'                        => 'عرض',
	'mv_edit'                        => 'عدل',
	'mv_history'                     => 'تاريخ',
	'mv_history_title'               => 'تاريخ التعديل وترتيب الفيديو',
	'mv_edit_title'                  => 'عدل النص',
	'mv_edit_adjust_title'           => 'عدل ترتيب النص والفيديو',
	'mv_remove'                      => 'إزالة',
	'mv_remove_title'                => 'أزل عامود بيانات الميتا هذا',
	'mv_adjust'                      => 'ضبط',
	'mv_adjust_submit'               => 'حفظ الضبط',
	'mv_adjust_title'                => 'ضبط وقت البداية والنهاية',
	'mv_adjust_preview'              => 'عرض الضبط',
	'mv_adjust_preview_stop'         => 'إيقاف العرض المسبق',
	'mv_adjust_default_reason'       => 'ضبط واجهة ميتافيد',
	'mv_adjust_old_title_missing'    => 'الصفحة التي تحاول النقل منها ($1) غير موجودة',
	'mv_adjust_ok_move'              => 'نجاح، يتم الضبط...',
	'mv_start_desc'                  => 'وقت البداية',
	'mv_end_desc'                    => 'وقت النهاية',
	'mv_of'                          => 'ل',
	'mediasearch'                    => 'بحث الميديا',
	'mv_search_sel_t'                => 'اختر نوع البحث',
	'mv_run_search'                  => 'تنفيذ البحث',
	'mv_add_filter'                  => 'إضافة فلتر',
	'mv_search_match'                => 'بحث النص',
	'mv_search_spoken_by'            => 'قيل بواسطة',
	'mv_search_category'             => 'تصنيف',
	'mv_search_smw_property'         => 'خصائص سيمناتيك',
	'mv_search_smw_property_numeric' => 'قيمة سيمناتيك رقمية',
	'mv_search_and'                  => 'و',
	'mv_search_or'                   => 'أو',
	'mv_search_not'                  => 'ليس',
	'mv_search_stream_name'          => 'اسم الستريم',
	'mv_search_date_range'           => 'نطاق التاريخ',
	'mv_stream_name'                 => 'اسم الستريم',
	'mv_date_range'                  => 'نطاق التاريخ',
	'mv_match'                       => 'مطابقة',
	'mv_spoken_by'                   => 'قيل بواسطة',
	'mv_category'                    => 'تصنيف',
	'mv_search_no_results'           => 'لا ميديا تطابق',
	'mv_media_matches'               => 'الميديا تطابق',
	'mv_remove_filter'               => 'إزالة الفلتر',
	'mv_advaced_search'              => 'بحث ميديا متقدم',
	'mv_expand_play'                 => 'تمديد وعرض',
	'mv_view_in_stream_interface'    => 'عرض في واجهة الستريم',
	'mv_view_wiki_page'              => 'عرض صفحة الويكي',
	'mv_error_mvd_not_found'         => 'خطأ إم في دي غير موجود',
	'mv_match_text'                  => '~  $1 مطابقة',
	'mv_match_text_one'              => '~ 1 تطابق',
	'mv_edit_sequence'               => 'تعديل التتابع:$1',
	'mv_sequence_player_title'       => 'عرض التتابع',
	'mv_save_sequence'               => 'حفظ التتابع',
	'mv_sequence_page_desc'          => 'حفظ التتابع الحالي',
	'mv_sequence_add'                => 'إضافة كليبات',
	'mv_sequence_add_manual'         => 'إضافة بالاسم',
	'mv_sequence_add_manual_desc'    => 'إضافة الكليبات باسم الستريم',
	'mv_sequence_add_search'         => 'إضافة بالبحث',
	'mv_sequence_add_search_desc'    => 'إضافة الكليبات ببحث الميديا',
	'mv_seq_add_end'                 => 'إضافة إلى آخر التتابع',
	'mv_sequence_timeline'           => 'الخط الزمني للتتابع:',
	'mv_edit_sequence_desc_help'     => 'وصف التتابع',
	'mv_edithelpsequence'            => 'Help:تعديل_التتابع',
	'mv_seq_summary'                 => 'ملخص تعديل التتابع',
	'mv_add_clip_by_name'            => 'إضافة الكليبات بالاسم',
	'mv_export_cmml'                 => 'صدر cmml',
	'mv_search_stream'               => 'بحث الستريم',
	'mv_navigate_stream'             => 'إبحار الستريم الكامل',
	'mv_embed_options'               => 'خيارات الإدراج',
	'mv_overlay'                     => 'التحكم بالتغطية',
	'mv_stream_tool_heading'         => 'أدوات الستريم',
	'mv_tool_missing'                => 'طلب الأداة ($1) غير موجود',
	'mv_bad_tool_request'            => 'سطر أداة سيء ينبغي أن يكون بالصيغة: اسم_الأداة|اسم_العرض_للأداة',
	'mv_search_stream_title'         => 'ابحث في الستريم الحالي',
	'mv_new_ht_en'                   => 'ترانسكريبت جديد',
	'mv_new_anno_en'                 => 'وسم أو أنوتاشن جديد',
	'mv_mang_layers'                 => 'التحكم بالطبقات',
	'mv_mang_layers_title'           => 'التحكم بمجموعة عرض الطبقة للستريم الحالي',
	'mv_protect_source_material'     => 'المادة المصدر الأصلية محمية من التعديلات',
);

/** Bulgarian (Български)
 * @author DCLXVI
 */
$messages['bg'] = array(
	'mv_duration_label'      => 'продължителност',
	'mv_save_changes'        => 'Съхранение на промените',
	'mv_remove_reason'       => 'Причина за изтриването:',
	'mv_upload_file'         => 'Качване на файл',
	'mv_external_file'       => 'Външен файл',
	'mv_tool_search'         => 'Търсене',
	'mv_tool_export'         => 'Изнасяне',
	'mv_results_found_for'   => 'Резултати от търсенето от <b>$1</b> до <b>$2</b> от общо <b>$3</b> за:',
	'anno_en'                => 'Анотации и категории',
	'mvd_default_mismatch'   => 'Грешка във файла с настройките',
	'mv_data_page_title'     => '$1 за $2 от $3',
	'mv_edit'                => 'Редактиране',
	'mv_history'             => 'История',
	'mv_remove'              => 'премахване',
	'mv_remove_title'        => 'премахване на този сегмент от метаданни',
	'mv_adjust_preview_stop' => 'Спиране на прегледа',
	'mv_start_desc'          => 'Начало',
	'mv_end_desc'            => 'Край',
	'mv_add_filter'          => 'Добавяне на филтър',
	'mv_search_category'     => 'Категория',
	'mv_search_and'          => 'и',
	'mv_search_or'           => 'или',
	'mv_category'            => 'категория',
	'mv_remove_filter'       => 'премахване на филтър',
	'mv_match_text'          => '~  $1 съвпадения',
	'mv_match_text_one'      => '~ 1 съвпадение',
	'mv_mang_layers'         => 'Управление на слоевете',
);

/** Bengali (বাংলা)
 * @author Zaheen
 */
$messages['bn'] = array(
	'mv_tool_search' => 'অনুসন্ধান',
);

/** Catalan (Català)
 * @author SMP
 */
$messages['ca'] = array(
	'mv_edit'            => 'Edita',
	'mv_search_category' => 'Categoria',
	'mv_category'        => 'categoria',
);

/** Chamorro (Chamoru)
 * @author Jatrobat
 */
$messages['ch'] = array(
	'mv_upload_file' => "Na'kåtga hulu' i atkibu",
	'mv_tool_search' => 'Aligao',
	'mv_edit'        => 'Tulaika',
);

/** Welsh (Cymraeg)
 * @author Lloffiwr
 */
$messages['cy'] = array(
	'mv_edit' => 'Golygu',
);

/** Danish (Dansk)
 * @author Jon Harald Søby
 */
$messages['da'] = array(
	'mv_upload_file'     => 'Læg en fil op',
	'mv_tool_search'     => 'Søg',
	'mv_edit'            => 'Redigér',
	'mv_history'         => 'Historik',
	'mv_search_category' => 'Kategori',
	'mv_category'        => 'kategori',
);

/** Greek (Ελληνικά)
 * @author Consta
 */
$messages['el'] = array(
	'mv_search_category' => 'Κατηγορία',
	'mv_search_and'      => 'και',
	'mv_search_or'       => 'ή',
	'mv_category'        => 'Κατηγορία',
);

/** Esperanto (Esperanto)
 * @author Yekrats
 * @author ArnoLagrange
 */
$messages['eo'] = array(
	'mv_duration_label'    => 'daŭro',
	'mv_save_changes'      => 'Konservu Ŝanĝojn',
	'mv_missing_cat'       => 'Kategoria nomo mankas',
	'mv_remove_reason'     => 'Kialo por forigo:',
	'mv_upload_file'       => 'Alŝutu dosieron',
	'mv_external_file'     => 'Ekstera Dosieron',
	'mv_tool_search'       => 'Serĉu',
	'mv_tool_navigate'     => 'Navigado',
	'mv_tool_export'       => 'Eksportu',
	'mv_tool_embed'        => 'Enigu',
	'mv_results_found_for' => 'Serĉrezultoj <b>$1</b> al <b>$2</b> de <b>$3</b> por:',
	'mv_data_page_title'   => '$1 por $2 de $3',
	'mv_time_separator'    => '$1 al $2',
	'mv_play'              => 'Legu',
	'mv_edit'              => 'Redaktu',
	'mv_history'           => 'Historio',
	'mv_remove'            => 'forigu',
	'mv_of'                => '&#32;de&#32;',
	'mv_add_filter'        => 'Aldonu Filtrilon',
	'mv_search_spoken_by'  => 'Parolata de',
	'mv_search_category'   => 'Kategorio',
	'mv_search_and'        => 'kaj',
	'mv_search_or'         => 'aŭ',
	'mv_search_not'        => 'ne',
	'mv_spoken_by'         => 'parolata de',
	'mv_category'          => 'kategorio',
	'mv_remove_filter'     => 'forigu filtrilon',
	'mv_view_wiki_page'    => 'Rigardu vikian paĝon',
	'mv_match_text'        => '~ $1 pafoj',
);

/** Spanish (Español)
 * @author Jatrobat
 */
$messages['es'] = array(
	'mv_tool_search' => 'Buscar',
);

/** French (Français)
 * @author Grondin
 * @author Urhixidur
 * @author Siebrand
 */
$messages['fr'] = array(
	'metavid'                        => 'Page metavid',
	'mv_missing_stream'              => 'Flux manquant : $1',
	'mv_ogg_low_quality'             => 'Flux ogg utilisable en ligne, hébergé sur metavid',
	'mv_ogg_high_quality'            => 'Flux ogg de haute qualité, hébergé sur metavid.',
	'mv_archive_org_link'            => 'Liens vers les originaux mpeg2 dans Archive.org',
	'ao_file_64Kb_MPEG4'             => 'Archive.org - mpeg4 64 kb/s',
	'ao_file_256Kb_MPEG4'            => 'Archive.org - mpeg4 256 kb/s',
	'ao_file_flash_flv'              => 'Archive.org - flash vidéo',
	'mv_error_stream_missing'        => '<span class="error">Erreur : il n\'existe aucun fichier vidéo associé avec ce flux.</span><br /> Vous êtes prié de reporter ceci sur le site d\'administration.',
	'mv_stream_meta'                 => 'Page de flux',
	'mv_add_stream'                  => "Ajout d'un flux metavid",
	'mv_edit_stream'                 => 'Modifier un flux metavid',
	'mvexportsearch'                 => 'Exporter Metavid',
	'mvexportsequence'               => 'Séquence d’exportation de Metavid',
	'mvexportstream'                 => 'Flux d’exportation de Metavid',
	'mv_add_stream_page'             => "Ajout d'un flux metavid",
	'mv_edit_strea_docu'             => "<b>Éditer l'administration des flux</b> <br /> pour qu'un utilisateur puisse voir ou éditer la page $1 de visualisation.",
	'mv_add_stream_docu'             => "<p>Ajouter un nouveau flux avec le champ ci-dessous.</p><p>Plus d'informations sont données sur <a href=\"\$1\">la page d'aide concernant l'ajout d'un flux.",
	'mv_add_stream_submit'           => 'Ajouter un flux',
	'mv_no_stream_files'             => 'Fichiers de flux inexistants.',
	'mv_edit_stream_files'           => 'Modifier les fichiers de flux',
	'mv_path_type_url_anx'           => 'Adresse Internet complète du média',
	'mv_path_type_wiki_title'        => 'Titre wiki du media',
	'mv_path_type_label'             => 'type de chemin',
	'mv_base_offset_label'           => 'décalage de base',
	'mv_duration_label'              => 'durée',
	'mv_file_desc_label'             => 'message de description du flux',
	'mv_delete_stream_file'          => 'supprimer la référence du fichier de flux',
	'mv_save_changes'                => 'Sauvegarder les modifications',
	'mv_file_with_same_desc'         => 'Erreur : fichier de flux avec la même clef de description  <i>$1</i> déjà présent',
	'mv_updated_stream_files'        => 'Mise à jour des enregistrements des fichiers de flux',
	'mv_removed_file_stream'         => 'Fichier de flux retiré : $1',
	'mv_missing_stream_text'         => 'Le flux <b>$1</b> que vous avez demandé n\'est pas disponible.<br />Il vous est permis de consulter la <a href="$2">Liste des flux</a><br />Ou bien être autorisé à <a href="$3">Ajouter le flux</a>',
	'mv_user_cant_edit'              => 'Vous pouvez avoir $1 pour modifier, $2',
	'mv_add_stream_file'             => 'Ajouter un fichier de flux',
	'mv_media_path'                  => 'chemin du média',
	'mv_file_list'                   => 'Fichiers de flux',
	'mv_label_stream_name'           => 'Nom du flux',
	'mv_label_stream_desc'           => 'Description du flux',
	'add_stream_permission'          => "Il ne vous est pas permis d'ajouter un nouveau flux",
	'edit_stream_missing'            => 'Nom du flux manquant',
	'mv_missing_req_time'            => 'Omission du temps de requête',
	'mv_missing_cat'                 => 'Omission du nom de la catégorie',
	'mv_stream_already_exists'       => 'Le flux <a href="$2">$1</a> existe déjà',
	'mv_summary_add_stream'          => 'flux ajouté par un formulaire',
	'mv_error_stream_insert'         => 'échec de l’insertion du flux',
	'mv_redirect_and_delete_reason'  => 'page de redirection enlevée',
	'mv_remove_reason'               => 'Motif de la suppression :',
	'mv_stream_delete_warrning'      => '<b>La suppression de ce flux enlèvera également $1 parties des métadonnées associées</b><br />',
	'mv_label_stream_type'           => 'Type de flux',
	'mv_metavid_file'                => 'Fichier existant sur le serveur',
	'mv_metavid_live'                => 'Installer le flux en direct',
	'mv_upload_file'                 => 'Télécharger le fichier',
	'mv_external_file'               => 'Fichier externe',
	'mv_stream_delete_warning'       => 'Supprimer ce flux enlèvera en plus $1 pages de métadonnées',
	'mv_tool_search'                 => 'Rechercher',
	'mv_tool_search_title'           => 'Rechercher dans ce flux',
	'mv_search_transcripts_for'      => 'Rechercher des transcriptions pour',
	'mv_tool_navigate'               => 'Naviguer',
	'mv_tool_navigate_title'         => 'Naviguer dans le flux entier',
	'mv_tool_export'                 => 'Exporter',
	'mv_tool_export_title'           => 'Exporter les métadonnées du flux',
	'mv_tool_embed'                  => 'Inclure',
	'mv_tool_embed_title'            => 'Options d’incrustation du segment demandé',
	'mv_tool_overlay'                => 'Présentations du modèle',
	'mv_tool_overlay_title'          => 'Présentations du modèle sur la base des métadonnées',
	'mv_results_found_for'           => 'Résultats de la recherche <b>$1</b> vers <b>$2</b> de <b>$3</b> pour :',
	'mv_tool_mang_layers'            => 'Gère les couches',
	'mv_update_layers'               => 'met à jour le visionnement des couches',
	'mv_watch_clip'                  => 'Visionner le clip',
	'mv_close_clip'                  => 'Fermer le clip',
	'mv_improve_transcript'          => 'Améliorer la transcription',
	'ht_en'                          => 'Transcrire',
	'ht_en_desc'                     => 'Transcriptions anglaises. Ce type de présentation est pour le texte qui est parlé avec le flux vidéo. Des liens peuvent êtres ajoutés, mais tout texte devrait être en corrélation avec ce qui est dit dans le flux vidéo.',
	'anno_en'                        => 'Annotations et catégories',
	'anno_en_desc'                   => 'Annotations et catégorisation anglaises. Cette présentation peut être utilisée pour catégoriser les sections de vidéo ou pour ajouter des informations sous forme d’annotations qui ne sont pas du texte parlé.',
	'thomas_en'                      => 'Transcription officielle',
	'thomas_en_desc'                 => "Transcription officielle de Thomas du service THOMAS d'enregistrement des gouvernements. Date de la source synchronisée par c-spanarchives.org de C-SPAN.",
	'mvd_default_mismatch'           => 'Erreur dans la configuration du fichier',
	'mvd_default_mismatch_text'      => 'Une erreur s\'est glissée dans votre fichier de configuration : $mvMVDTypeDefaultDisp aurait dû être un sous-paramètre de $mvMVDTypeAllAvailable.',
	'mv_data_page_title'             => '$1 pour $2 à partir de $3',
	'mv_time_separator'              => '$1 vers $2',
	'mv_list_streams'                => 'Liste des flux de metavid',
	'mv_list_streams_page'           => 'Liste des flux de metavid',
	'mv_list_streams_docu'           => 'Le flux suivant existe :',
	'mv_list_streams_none'           => "Aucun flux n'existe",
	'mvvideofeed'                    => "Alimentation de l'export de la vidéo metavid",
	'mvexportask'                    => 'Exportation d’un fil vidéo sémantique',
	'video_feed_cat'                 => 'Alimentation de la vidéo pour la catégorie :',
	'mv_cat_search_note'             => 'Note : « Catégories » ne liste que les catégories de premier niveau. Pour toutes les métadonnées dans les groupes de catégories, recherchez $1',
	'mv_mvd_linkback'                => 'Partie du flux $1 <br />Saut vers le visionnement du flux : $2<br />',
	'mvBadMVDtitle'                  => 'type manquant, flux manquant, ou format de durée non conforme.',
	'mvMVDFormat'                    => 'Le titre de metavid devrait être au format : mvd:type:nom_du_flux/durée_commencement/durée_fin',
	'mv_play'                        => 'Jouer',
	'mv_edit'                        => 'Modifier',
	'mv_history'                     => 'Historique',
	'mv_history_title'               => "Édition et historique de l'alignement vidéo",
	'mv_edit_title'                  => 'Modifier le texte',
	'mv_edit_adjust_title'           => "Modifier le texte et l'alignement vidéo",
	'mv_remove'                      => 'enlever',
	'mv_remove_title'                => 'enlever ce segment de métadonnées',
	'mv_adjust'                      => 'ajuster',
	'mv_adjust_submit'               => "Sauvegarder l'ajustement",
	'mv_adjust_title'                => 'Ajuster le début et la fin de la durée',
	'mv_adjust_preview'              => "Prévisualiser l'ajustement",
	'mv_adjust_preview_stop'         => 'Arrêter la prévisualisation',
	'mv_adjust_default_reason'       => "Ajustement de l'interface metavid",
	'mv_adjust_old_title_missing'    => 'La page que vous êtes en train d’essayer de quitter ($1) n’existe pas.',
	'mv_adjust_ok_move'              => 'Succès, ajustement...',
	'mv_start_desc'                  => 'Durée au départ',
	'mv_end_desc'                    => 'Durée à la fin',
	'mv_of'                          => ' de',
	'mediasearch'                    => 'Recherche du média',
	'mv_search_sel_t'                => 'Choisir le mode de recherche',
	'mv_run_search'                  => 'Lancer la recherche',
	'mv_add_filter'                  => 'Ajouter un filtre',
	'mv_search_match'                => 'Rechercher le texte',
	'mv_search_spoken_by'            => 'Parlé par',
	'mv_search_category'             => 'Catégorie',
	'mv_search_smw_property'         => 'Propriétés sémantiques',
	'mv_search_smw_property_numeric' => 'Valeur sémantique numérique',
	'mv_search_and'                  => 'et',
	'mv_search_or'                   => 'ou',
	'mv_search_not'                  => 'non',
	'mv_search_stream_name'          => 'Nom du flux',
	'mv_search_date_range'           => 'Fourchette de date',
	'mv_stream_name'                 => 'nom du flux',
	'mv_date_range'                  => 'fourchette de date',
	'mv_match'                       => 'assortir',
	'mv_spoken_by'                   => 'parlé par',
	'mv_category'                    => 'catégorie',
	'mv_search_no_results'           => 'Aucun média assorti',
	'mv_media_matches'               => 'Médias assortis',
	'mv_remove_filter'               => 'enlever le filtre',
	'mv_advaced_search'              => 'Recherche avancée de médias',
	'mv_expand_play'                 => 'Développer et jouer en ligne',
	'mv_view_in_stream_interface'    => "Voir dans l'interface du flux",
	'mv_view_wiki_page'              => 'Voir la page wiki',
	'mv_error_mvd_not_found'         => 'Erreur, aucune metavid de trouvée',
	'mv_match_text'                  => '~ $1 similitudes',
	'mv_match_text_one'              => '~ 1 occurence',
	'mv_edit_sequence'               => 'Édition de la séquence : $1',
	'mv_sequence_player_title'       => 'lecteur de séquence',
	'mv_save_sequence'               => 'Sauvegarder la séquence',
	'mv_sequence_page_desc'          => 'Sauvegarder la séquence actuelle',
	'mv_sequence_add'                => 'Ajouter des clips',
	'mv_sequence_add_manual'         => 'Ajouter par nom',
	'mv_sequence_add_manual_desc'    => 'Ajouter des clips par nom de flux',
	'mv_sequence_add_search'         => 'Ajouter par recherche',
	'mv_sequence_add_search_desc'    => 'Ajouter des clips par recherche de médias',
	'mv_seq_add_end'                 => 'Ajouter à la fin de la séquence',
	'mv_sequence_timeline'           => 'Séquence chronologique :',
	'mv_edit_sequence_desc_help'     => 'Description de la séquence',
	'mv_edithelpsequence'            => 'Aide:Édition_de_séquence',
	'mv_seq_summary'                 => 'Édition du sommaire de la séquence',
	'mv_add_clip_by_name'            => 'Ajouter un clip par nom',
	'mv_export_cmml'                 => 'exporter cmml',
	'mv_search_stream'               => 'Rechercher le flux',
	'mv_navigate_stream'             => 'Naviguer dans le flux entier',
	'mv_embed_options'               => 'Options d’incrustation',
	'mv_overlay'                     => 'Contrôles de superposition',
	'mv_stream_tool_heading'         => 'Outils pour les flux',
	'mv_tool_missing'                => "la requête de l'outil ($1) n'existe pas",
	'mv_bad_tool_request'            => 'une mauvaise ligne de commande pourrait être formulée : nom_outil|affichage_nom_outil',
	'mv_search_stream_title'         => 'Rechercher le flux actuel',
	'mv_new_ht_en'                   => 'Nouvelle transcription',
	'mv_new_anno_en'                 => 'Nouvelle balise ou annotation',
	'mv_mang_layers'                 => 'Gère les couches',
	'mv_mang_layers_title'           => "Gère les paramètres d'affichage de la couche pour le flux courant",
	'mv_protect_source_material'     => 'Original protégé en écriture',
);

/** Irish (Gaeilge)
 * @author Moilleadóir
 */
$messages['ga'] = array(
	'mv_search_category' => 'Catagóir',
	'mv_category'        => 'catagóir',
);

/** Galician (Galego)
 * @author Alma
 * @author Toliño
 */
$messages['gl'] = array(
	'mv_duration_label'             => 'duración',
	'mv_save_changes'               => 'Gardar Cambios',
	'mv_user_cant_edit'             => 'Precisará $1 para editar, $2',
	'mv_missing_cat'                => 'Falta o nome da categoría',
	'mv_redirect_and_delete_reason' => 'eliminar páxina de redirección',
	'mv_remove_reason'              => 'Razón Para a eliminación:',
	'mv_metavid_file'               => 'Arquivo Existente no Servidor',
	'mv_upload_file'                => 'Cargar ficheiro',
	'mv_external_file'              => 'Arquivo Externo',
	'mv_tool_search'                => 'Procurar',
	'mv_tool_navigate'              => 'Navegar',
	'mv_tool_export'                => 'Exportar',
	'mv_results_found_for'          => 'Procurar resultados <b>$1</b> a <b>$2</b> de <b>$3</b> para:',
	'anno_en'                       => 'Anotacións e Categorías',
	'mv_data_page_title'            => '$1 para $2 de $3',
	'mv_time_separator'             => '$1 a $2',
	'mv_play'                       => 'Reproducir',
	'mv_edit'                       => 'Editar',
	'mv_history'                    => 'Historial',
	'mv_edit_title'                 => 'Editar Texto',
	'mv_remove'                     => 'eliminar',
	'mv_adjust'                     => 'axustar',
	'mv_adjust_submit'              => 'Gardar Axuste',
	'mv_adjust_title'               => 'Axustar Comezo e Fin do tempo',
	'mv_adjust_preview'             => 'Axuste da vista previa',
	'mv_adjust_preview_stop'        => 'Parar Vista previa',
	'mv_adjust_old_title_missing'   => 'A páxina que está tentando mover desde ($1) non existe',
	'mv_start_desc'                 => 'Comezar Tempo',
	'mv_end_desc'                   => 'Finalizar Tempo',
	'mv_of'                         => '&#32;de&#32;',
	'mediasearch'                   => 'Busca multimedia',
	'mv_search_sel_t'               => 'Seleccionar o tipo de busca',
	'mv_run_search'                 => 'Busca rápida',
	'mv_add_filter'                 => 'Engadir Filtro',
	'mv_search_match'               => 'Procurar Texto',
	'mv_search_category'            => 'Categoría',
	'mv_search_smw_property'        => 'Propiedades Semánticas',
	'mv_search_and'                 => 'e',
	'mv_search_or'                  => 'ou',
	'mv_category'                   => 'categoría',
	'mv_search_no_results'          => 'Ningunha coincidencia multimedia',
	'mv_media_matches'              => 'Coincidencias multimedia',
	'mv_remove_filter'              => 'eliminar filtro',
	'mv_advaced_search'             => 'Busca multimedia avanzada',
	'mv_view_wiki_page'             => 'Ver páxina wiki',
	'mv_match_text'                 => '~  $1 coincidencias',
	'mv_match_text_one'             => '~ 1 coincidencia',
	'mv_sequence_add'               => 'Engadir clips',
	'mv_sequence_add_manual'        => 'Engadir polo Nome',
	'mv_edit_sequence_desc_help'    => 'Descrición da secuencia',
	'mv_add_clip_by_name'           => 'Engadir Clip polo Nome',
	'mv_new_anno_en'                => 'Nova Etiqueta ou Anotación',
);

/** Manx (Gaelg)
 * @author MacTire02
 */
$messages['gv'] = array(
	'mv_tool_search'     => 'Ronsaghey',
	'mv_tool_navigate'   => 'Stiurey',
	'mv_history'         => 'Shennaghys',
	'mv_search_category' => 'Ronney',
	'mv_search_and'      => 'as',
	'mv_search_or'       => 'ny',
	'mv_category'        => 'ronney',
);

/** Hindi (हिन्दी)
 * @author Kaustubh
 */
$messages['hi'] = array(
	'metavid'                        => 'मेटाविड पन्ना',
	'mv_missing_stream'              => 'स्ट्रीम नहीं मिल रहीं: $1',
	'mv_ogg_low_quality'             => 'वेब स्ट्रीमेबल - ऑग थिओरा ३०० केबीपीएस',
	'mv_ogg_high_quality'            => 'उच्च दर्जा - ऑग थिओरा ९०० केबीपीएस',
	'mv_archive_org_link'            => 'Archive.org में एमपीईजी२ मूल की कड़ी देता हैं',
	'mv_stream_meta'                 => 'स्ट्रीम पन्ना',
	'mv_add_stream'                  => 'मेटाविड स्ट्रीम बढायें',
	'mv_edit_stream'                 => 'मेटाविड संपादन स्ट्रीम',
	'mvexportsearch'                 => 'मेटाविड निर्यात',
	'mvexportsequence'               => 'मेटाविड निर्यात क्रम',
	'mvexportstream'                 => 'मेटाविड निर्यात स्ट्रीम',
	'mv_add_stream_page'             => 'मेवि स्ट्रीम बढायें',
	'mv_edit_strea_docu'             => '<p><b>प्रबंधक</b> स्ट्रीम संपादित करें<br />साधारण सदस्य देखें/संपादित करें $1 पृष्ठ पर जायें',
	'mv_add_stream_submit'           => 'स्ट्रीम बढायें',
	'mv_no_stream_files'             => 'कोईभी स्ट्रीम फ़ाईल अस्तित्वमें नहीं हैं',
	'mv_edit_stream_files'           => 'स्ट्रीम फ़ाईल संपादित करें',
	'mv_path_type_url_anx'           => 'पूर्ण मीडिया url',
	'mv_path_type_wiki_title'        => 'विकि मीडिया शीर्षक',
	'mv_path_type_label'             => 'मार्ग प्रकार',
	'mv_base_offset_label'           => 'बेससे फर्क (offset)',
	'mv_duration_label'              => 'कालावधि',
	'mv_file_desc_label'             => 'स्ट्रीम ज़ानकारी संदेश',
	'mv_delete_stream_file'          => 'स्ट्रीम फ़ाईल का संदर्भ हटायें',
	'mv_save_changes'                => 'बदलाव संजोयें',
	'mv_updated_stream_files'        => 'स्ट्रीम फ़ाईलोंकी सूची अपडेट की',
	'mv_removed_file_stream'         => 'स्ट्रीम फ़ाईल हटाईं: $1',
	'mv_user_cant_edit'              => 'आपको संपादन करने के लिये $1 करना आवश्यक हैं, $2',
	'mv_add_stream_file'             => 'स्ट्रीम फ़ाईल बढायें',
	'mv_media_path'                  => 'मीडिया मार्ग',
	'mv_file_list'                   => 'स्ट्रीम फ़ाईलें',
	'mv_label_stream_name'           => 'स्ट्रीम नाम',
	'mv_label_stream_desc'           => 'स्ट्रीम ज़ानकारी',
	'add_stream_permission'          => 'नई स्ट्रीम बनाने की आपको अनुमति नहीं हैं',
	'edit_stream_missing'            => 'स्ट्रीम नाम नहीं दिया हैं',
	'mv_missing_req_time'            => 'माँग का समय नहीं दिया हैं',
	'mv_missing_cat'                 => 'श्रेणी का नाम नहीं दिया हैं',
	'mv_stream_already_exists'       => '<a href="$2">$1</a> यह स्ट्रीम पहलेसे अस्तित्वमें हैं',
	'mv_summary_add_stream'          => 'फ़ार्म का इस्तेमाल करके स्ट्रीम बढाई',
	'mv_error_stream_insert'         => 'स्ट्रीम डाल नहीं पायें',
	'mv_redirect_and_delete_reason'  => 'अनुप्रेषित पन्ना हटाया',
	'mv_remove_reason'               => 'हटाने का कारण:',
	'mv_label_stream_type'           => 'स्ट्रीम प्रकार',
	'mv_metavid_file'                => 'सर्वर पर उपलब्ध संचिका',
	'mv_metavid_live'                => 'लाइव स्ट्रीम बनायें',
	'mv_upload_file'                 => 'फ़ाइल अपलोड करें',
	'mv_external_file'               => 'बाहरी फ़ाईल',
	'mv_tool_search'                 => 'खोजें',
	'mv_tool_search_title'           => 'इस स्ट्रीम में खोजें',
	'mv_search_transcripts_for'      => 'की ट्रान्स्क्रीप्टस खोजें',
	'mv_tool_navigate'               => 'नैविगेट',
	'mv_tool_navigate_title'         => 'पूरी स्ट्रीम नैविगेट करें',
	'mv_tool_export'                 => 'निर्यात',
	'mv_tool_export_title'           => 'स्ट्रीम मेटाडाटा निर्यात',
	'mv_tool_embed'                  => 'एम्बेड',
	'mv_tool_embed_title'            => 'अभी पूछे हुए सेगमेंटके एम्बेड विकल्प',
	'mv_tool_overlay'                => 'टेम्प्लेट एकत्रिकरण',
	'mv_tool_overlay_title'          => 'टेम्प्लेट पर आधारित मेटाडाटाका एकत्रिकरण',
	'mv_results_found_for'           => 'नीचे दिये खोज रिज़ल्ट <b>$3</b> में से <b>$1</b> से <b>$2</b>:',
	'mv_tool_mang_layers'            => 'स्तर व्यवस्थापन',
	'mv_update_layers'               => 'स्तर दर्शाना अपडेट करें',
	'mv_watch_clip'                  => 'क्लिप देखें',
	'mv_close_clip'                  => 'क्लिप बंद करें',
	'mv_improve_transcript'          => 'ट्रान्स्क्रीप्ट ठीक करें',
	'ht_en'                          => 'ट्रानस्क्रीप्ट',
	'ht_en_desc'                     => 'अंग्रेजी ट्रानस्क्रीप्ट्स। यह ओव्हरले प्रकार बोले हुए पाठ के लिये हैं',
	'anno_en'                        => 'ऍनोटेशन्स और श्रेणीयाँ',
	'thomas_en'                      => 'अधिकृत ट्रानस्कीप्ट',
	'mvd_default_mismatch'           => 'सेटींग फ़ाईलमें गलती',
	'mv_data_page_title'             => '$3 से $2 के लिये $1',
	'mv_time_separator'              => '$1 से $2',
	'mv_list_streams'                => 'मेटाविड स्ट्रीम सूची',
	'mv_list_streams_page'           => 'मेवि स्ट्रीम सूची',
	'mv_list_streams_docu'           => 'निम्नलिखित स्ट्रीम अस्तित्वमें हैं:',
	'mv_list_streams_none'           => 'एकभी स्ट्रीम अस्तित्वमें नहीं',
	'mvvideofeed'                    => 'मेटाविड व्हिडियो फीड निर्यात',
	'video_feed_cat'                 => 'श्रेणीयों के लिये व्हिडियो फीड:',
	'mvBadMVDtitle'                  => 'प्रकार दिया नहीं, स्ट्रीम दी नहीं, या गलत समय रूपरेषा',
	'mvMVDFormat'                    => 'MVD शीर्षक ऐसा होना चाहिये: mvd:type:stream_name/start_time/end_time',
	'mv_play'                        => 'शुरू करें',
	'mv_edit'                        => 'संपादन',
	'mv_history'                     => 'इतिहास',
	'mv_history_title'               => 'व्हिडियो अलाईनमेंट और संपादन इतिहास',
	'mv_edit_title'                  => 'पाठ संपादित करें',
	'mv_edit_adjust_title'           => 'पाठ संपादन और व्हिडियो अलाइनमेंट',
	'mv_remove'                      => 'हटायें',
	'mv_remove_title'                => 'यह मेटा डाटा सेगमेंट हटायें',
	'mv_adjust'                      => 'ऐडजस्ट',
	'mv_adjust_submit'               => 'एडजस्टमेंट संजोयें',
	'mv_adjust_title'                => 'शुरू और समाप्ति समय एडजस्ट करें',
	'mv_adjust_preview'              => 'एडजस्टमेंट की झलक देखें',
	'mv_adjust_preview_stop'         => 'झलक रोकें',
	'mv_adjust_default_reason'       => 'मेटाविड इंटरफेसका व्यवस्थापन',
	'mv_adjust_old_title_missing'    => 'आप ($1) से जिसे स्थानांतरीत कर रहें हैं वह पन्ना अस्तित्व में नहीं हैं',
	'mv_adjust_ok_move'              => 'सफल, एडजस्टींग...',
	'mv_start_desc'                  => 'शुरू समय',
	'mv_end_desc'                    => 'समाप्ति समय',
	'mv_of'                          => '&#32;में से&#32;',
	'mediasearch'                    => 'मीडिया खोज',
	'mv_search_sel_t'                => 'खोज प्रकार चुनें',
	'mv_run_search'                  => 'खोज शुरू करें',
	'mv_add_filter'                  => 'फ़िल्टर बढायें',
	'mv_search_match'                => 'पाठ खोजें',
	'mv_search_spoken_by'            => 'निवेदक',
	'mv_search_category'             => 'श्रेणी',
	'mv_search_smw_property'         => 'सिमांटिक गुणधर्म',
	'mv_search_smw_property_numeric' => 'सांख्यिक सिमॅंटिक वैल्यू',
	'mv_search_and'                  => 'और',
	'mv_search_or'                   => 'या',
	'mv_search_not'                  => 'नहीं',
	'mv_search_stream_name'          => 'स्ट्रीम नाम',
	'mv_search_date_range'           => 'तिथी सीमा',
	'mv_stream_name'                 => 'स्ट्रीम नाम',
	'mv_date_range'                  => 'तिथी सीमा',
	'mv_match'                       => 'मिलायें',
	'mv_spoken_by'                   => 'निवेदक',
	'mv_category'                    => 'श्रेणी',
	'mv_search_no_results'           => 'मीडिया मिली नहीं',
	'mv_media_matches'               => 'मिली हुई मीडिया',
	'mv_remove_filter'               => 'फ़िल्टर निकालें',
	'mv_advaced_search'              => 'एडवान्स्ड मीडिया खोज',
	'mv_expand_play'                 => 'बढायें और इन-लाइन शुरू करें',
	'mv_view_in_stream_interface'    => 'स्ट्रीम इंटरफेस में देखें',
	'mv_view_wiki_page'              => 'विकि पृष्ठ देखें',
	'mv_error_mvd_not_found'         => 'गलत एमव्हीडी मिली नहीं',
	'mv_match_text'                  => '~  $1 मिलें',
	'mv_match_text_one'              => '~ १ मिला',
	'mv_edit_sequence'               => 'संपादन सिक्वेन्स:$1',
	'mv_sequence_player_title'       => 'सिक्वेन्स प्लेयर',
	'mv_save_sequence'               => 'सिक्वेन्स संजोयें',
	'mv_sequence_page_desc'          => 'अभी का सिक्वेन्स संजोयें',
	'mv_sequence_add'                => 'क्लिप बढायें',
	'mv_sequence_add_manual'         => 'नामसे बढायें',
	'mv_sequence_add_manual_desc'    => 'स्ट्रीम नामसे क्लिप बढायें',
	'mv_sequence_add_search'         => 'खोजकर बढायें',
	'mv_sequence_add_search_desc'    => 'मीडिया खोजकर क्लिप बढायें',
	'mv_seq_add_end'                 => 'सिक्वेन्सके आखिरमें बढायें',
	'mv_sequence_timeline'           => 'सिक्वेन्स समयरेखा:',
	'mv_edit_sequence_desc_help'     => 'सिक्वेन्स ज़ानकारी',
	'mv_edithelpsequence'            => 'Help:सिक्वेन्स_संपादन',
	'mv_seq_summary'                 => 'सिक्वेन्स संपादन संक्षिप्त ज़ानकारी',
	'mv_add_clip_by_name'            => 'नाम देकर क्लिप बढायें',
	'mv_export_cmml'                 => 'cmml निर्यात करें',
	'mv_search_stream'               => 'स्ट्रीम खोजें',
	'mv_navigate_stream'             => 'पूरी स्ट्रीम नैविगेट करें',
	'mv_embed_options'               => 'एम्बेड विकल्प',
	'mv_overlay'                     => 'ओवरले नियंत्रक',
	'mv_stream_tool_heading'         => 'स्ट्रीम औज़ार',
	'mv_tool_missing'                => '($1) औज़ार माँग नहीं हैं',
	'mv_search_stream_title'         => 'सद्य स्ट्रीम खोजें',
	'mv_new_ht_en'                   => 'नई ट्रान्स्क्रीप्ट',
	'mv_new_anno_en'                 => 'नया टैग या एनोटेशन',
	'mv_mang_layers'                 => 'स्तर व्यवस्थापन',
	'mv_mang_layers_title'           => 'सद्य स्ट्रीम के स्तर-प्रदर्शन प्रणालीका व्यवस्थापन करें',
	'mv_protect_source_material'     => 'मूल स्रोत साहित्य बदलावोंसे सुरक्षित किया',
);

/** Hiligaynon (Ilonggo)
 * @author Jose77
 */
$messages['hil'] = array(
	'mv_upload_file' => 'Karga file',
	'mv_tool_search' => 'Pangita-a',
	'mv_edit'        => 'Ilisan',
	'mv_history'     => 'Saysay',
);

/** Upper Sorbian (Hornjoserbsce)
 * @author Michawiki
 * @author Siebrand
 * @author Yekrats
 */
$messages['hsb'] = array(
	'metavid'                        => 'Strona Metavid',
	'mv_missing_stream'              => 'Falowacy stream: $1',
	'mv_ogg_low_quality'             => 'Streamujomne ogg theora, na metavidźe hostowane',
	'mv_ogg_high_quality'            => 'Ogg theora wysokeje kwality, na metavidźe hostowane',
	'mv_archive_org_link'            => 'Wotkazy k originalam mpeg2 na Archive.org',
	'mv_error_stream_missing'        => '<span class="error">Zmylk: Njeje wideodataja zwjazana z tutym streamom.</span><br />Prošu zdźěl to sydłowemu administratorej.',
	'mv_stream_meta'                 => 'Strona streama',
	'mv_add_stream'                  => 'Metavid stream přidać',
	'mv_edit_stream'                 => 'Metavid stream wobdźěłać',
	'mvexportsearch'                 => 'Metavid eksportować',
	'mvexportsequence'               => 'Metvid sekwencu eksportować',
	'mvexportstream'                 => 'Metavid stream eksportować',
	'mv_add_stream_page'             => 'Mv stream přidać',
	'mv_edit_strea_docu'             => '<p>Stream wobdźěłać <b>administrator</b><br />napohlad/wobdźělanje za normalneho wužiwarja hlej strona $1',
	'mv_add_stream_docu'             => '<p>Přidaj nowy stream pola slědowaceho pola.</p><p>Dalše informacije su na <a href="$1">pomocnej stronje za přidaće streama</a>.</p>',
	'mv_add_stream_submit'           => 'Stream přidać',
	'mv_no_stream_files'             => 'Njejsu streamowe dataje',
	'mv_edit_stream_files'           => 'Streamowe dataje wobdźěłać',
	'mv_path_type_url_anx'           => 'połny multimedijowy url',
	'mv_path_type_wiki_title'        => 'titul wiki medija',
	'mv_path_type_label'             => 'Pućowy typ',
	'mv_base_offset_label'           => 'Zakładne přesadźenje',
	'mv_duration_label'              => 'traće',
	'mv_file_desc_label'             => 'Wopisanje streama',
	'mv_delete_stream_file'          => 'Referenca na streamowu dataju wušmórnyć',
	'mv_save_changes'                => 'Změny składować',
	'mv_file_with_same_desc'         => 'Zmylk: streamowa dataja ze samsnym wopisanskim klučom <i>$1</i> hižo eksistuje',
	'mv_updated_stream_files'        => 'Lisćina streamowych datajow zaktualizowana',
	'mv_removed_file_stream'         => 'Streamowu dataju wotstronjena: $1',
	'mv_missing_stream_text'         => 'Stream, kotryž sy požadał <b>$1</b> k dispoziciji njesteji.<br />Ty móhł <a href="$2">lisćinu streamow</a> přepytać<br />abo <a href="$3">Stream přidać</a>.',
	'mv_user_cant_edit'              => 'Móhło być, zo dyrbiš $1, zo by wobdźěłał, $2',
	'mv_add_stream_file'             => 'Streamowu dataju přidać',
	'mv_media_path'                  => 'medijowy puć',
	'mv_file_list'                   => 'Streamowe dataje',
	'mv_label_stream_name'           => 'Mjeno streama',
	'mv_label_stream_desc'           => 'Streamowe wopisanje',
	'add_stream_permission'          => 'Nimaš dowolnosć nowy stream přidać',
	'edit_stream_missing'            => 'Mjeno streama faluje',
	'mv_missing_req_time'            => 'Falowacy čas naprašowanja',
	'mv_missing_cat'                 => 'Kategorijowe mjeno faluje',
	'mv_stream_already_exists'       => 'Stream <a href="$2">$1</a> hižo eksistuje',
	'mv_summary_add_stream'          => 'stream přez fromular přidaty',
	'mv_error_stream_insert'         => 'Zasunjenje streama njeporadźiło',
	'mv_redirect_and_delete_reason'  => 'Daleposrědkowanska strona wotstronjena',
	'mv_remove_reason'               => 'Přičina za wušmórnjenje:',
	'mv_stream_delete_warrning'      => '<b>Z wotstronjenjom tutoho streama so tež $1 asociěrowanych metadatow wotstroni<b><br />',
	'mv_label_stream_type'           => 'Streamowy typ',
	'mv_metavid_file'                => 'Eksistowaca dataja na serwerje',
	'mv_metavid_live'                => 'Live stream nastajić',
	'mv_upload_file'                 => 'Dataju nahrać',
	'mv_external_file'               => 'Eksterna dataja',
	'mv_stream_delete_warning'       => 'Wušmórnjenje tutoho streama tež $1 {{PLURAL:$1|strona|stronow|strony|stronow}} metadatow wotstroni.',
	'mv_tool_search'                 => 'Pytać',
	'mv_tool_search_title'           => 'Znutřka tutoho streama pytać',
	'mv_search_transcripts_for'      => 'Přepisanja pytać za',
	'mv_tool_navigate'               => 'Nawigěrować',
	'mv_tool_navigate_title'         => 'W cyłym streamje nawigěrować',
	'mv_tool_export'                 => 'Eksportować',
	'mv_tool_export_title'           => 'Streamowe metadaty eksportować',
	'mv_tool_embed'                  => 'Zasadźić',
	'mv_tool_embed_title'            => 'Opcije za aktualne požadnany wotrězk zasadźić',
	'mv_tool_overlay'                => 'Přikrywy předłohow',
	'mv_tool_overlay_title'          => 'Přikrywy metadatow na zakładźe předłohow',
	'mv_results_found_for'           => 'Pytanske wuslědki <b>$1</b> hač <b>$2</b> z <b>$3</b> za:',
	'mv_tool_mang_layers'            => 'Woršty zrjadować',
	'mv_update_layers'               => 'Napohlad wořstow aktualizować',
	'ht_en'                          => 'Přepis',
	'ht_en_desc'                     => 'Jendźelske přepisy. Tutón typ naworštowanja je za tekst, kotryž so we wideostreamje rěči. Wotkazy móža so přidać, ale tekst měł jenož tón być, kotryž so we wideostreamje rěči.',
	'anno_en'                        => 'Přispomnjenki a kategorije',
	'anno_en_desc'                   => 'Jendźelske kategorizacije a anotacije. Tute naworštowanje hodźi so wužiwać, zo bychu wotrězki wideja kategorizowali abo komentarowe informacije přidali, kotrež rěčany tekst njejsu.',
	'thomas_en'                      => 'Oficielna transkripcija',
	'thomas_en_desc'                 => 'Oficielna transkripcija Thomas z wopismoweje słužby THOMAS knježerstwa. Žórłowy čas přez C-SPAN spanarchives.org synchronizowany.',
	'mvd_default_mismatch'           => 'Zmylk w dataji nastajenjow',
	'mvd_default_mismatch_text'      => 'Je zmylk w twojej dataji nastajenjow, $mvMVDTypeDefaultDisp měł podmnóstwo  $mvMVDTypeAllAvailable być',
	'mv_data_page_title'             => '$1 za $2 z $3',
	'mv_time_separator'              => '$1 hač $2',
	'mv_list_streams'                => 'Lisćina streamow Metavid',
	'mv_list_streams_page'           => 'Lisćina streamow Mv',
	'mv_list_streams_docu'           => 'Slědowace streamy eksistuja:',
	'mv_list_streams_none'           => 'Njeeksistuja žane streamy',
	'mvvideofeed'                    => 'Metavid Eksport widejokanala',
	'video_feed_cat'                 => 'Wideokanal za kategoriju:',
	'mv_cat_search_note'             => 'Kedźbu: Mjez kategorijemi su jenož kategorije najwyšeje runiny, za wšě metadaty w kategorijach pytaj za $1',
	'mv_mvd_linkback'                => 'Dźěl streama $1 <br />Do streamoweho napohlada skočić: $2<br />',
	'mvBadMVDtitle'                  => 'Typ faluje, stream faluje abo njepłaćiwy časowy format',
	'mvMVDFormat'                    => 'Titul MVD měł slědowacy format měć: mvd:typ:mjeno_streama/spočatny_čas/kónčny_čas',
	'mv_play'                        => 'Wothrać',
	'mv_edit'                        => 'Wobdźěłać',
	'mv_history'                     => 'Stawizny',
	'mv_history_title'               => 'Stawizny wobdźěłanja a wusměrjenja wideja',
	'mv_edit_title'                  => 'Tekst wobdźěłać',
	'mv_edit_adjust_title'           => 'Tekst a wideowusměrjenja wobdźěłać',
	'mv_remove'                      => 'wotstronić',
	'mv_remove_title'                => 'tutón wotrězk metadatow wotstronić',
	'mv_adjust'                      => 'přiměrić',
	'mv_adjust_submit'               => 'Přiměrjenje składować',
	'mv_adjust_title'                => 'Startowy a kónčny čas nastajić',
	'mv_adjust_preview'              => 'Přehlad přiměrjenja',
	'mv_adjust_preview_stop'         => 'Přehlad zastajić',
	'mv_adjust_default_reason'       => 'powjerch metavida přiměrić',
	'mv_adjust_old_title_missing'    => 'Strona, kotruž pospytuješ z ($1) přesunyć, njeeksistuje',
	'mv_adjust_ok_move'              => 'Wuspěch, přiměrja so...',
	'mv_start_desc'                  => 'Startowy čas',
	'mv_end_desc'                    => 'Kónčny čas',
	'mv_of'                          => '&#32;z&#32;',
	'mediasearch'                    => 'Medije pytać',
	'mv_search_sel_t'                => 'Pytanski typ wubrać',
	'mv_run_search'                  => 'Pytanje startować',
	'mv_add_filter'                  => 'Filter přidać',
	'mv_search_match'                => 'Tekst pytać',
	'mv_search_spoken_by'            => 'Rěčany wot',
	'mv_search_category'             => 'Kategorija',
	'mv_search_smw_property'         => 'Semantiske kajkosće',
	'mv_search_smw_property_numeric' => 'Numeriska semantiska hódnota',
	'mv_search_and'                  => 'a',
	'mv_search_or'                   => 'abo',
	'mv_search_not'                  => 'nic',
	'mv_search_stream_name'          => 'Mjeno streama',
	'mv_search_date_range'           => 'Rozsah datumow',
	'mv_stream_name'                 => 'mjeno streama',
	'mv_date_range'                  => 'rozsah datumow',
	'mv_match'                       => 'wotpowědnik',
	'mv_spoken_by'                   => 'rěčany wot',
	'mv_category'                    => 'kategorija',
	'mv_search_no_results'           => 'Žane medijowe wotpowědniki',
	'mv_media_matches'               => 'Medijowe wotpowědniki',
	'mv_remove_filter'               => 'Filter wotstronić',
	'mv_advaced_search'              => 'Rozšěrjene medijowe pytanje',
	'mv_expand_play'                 => 'W rjedźe rozfałdować a wothrać',
	'mv_view_in_stream_interface'    => 'W streamowym powjerchu wobhladać',
	'mv_view_wiki_page'              => 'Wikijowu stronu wobhladać',
	'mv_error_mvd_not_found'         => 'Zmylk mvd njenamakany',
	'mv_match_text'                  => '~ $1 {{PLURAL:$1|wotpowědnik|wotpowědnikaj|wotpowědniki|wotpowědnikow}}',
	'mv_match_text_one'              => '~ 1 wotpowědnik',
	'mv_edit_sequence'               => 'Wobdźěłanje sekwency:$1',
	'mv_sequence_player_title'       => 'Wothrawak sekwencow',
	'mv_save_sequence'               => 'Sekwencu składować',
	'mv_sequence_page_desc'          => 'Aktualnu sekwencu składować',
	'mv_sequence_add'                => 'Klipy přidać',
	'mv_sequence_add_manual'         => 'Po mjenje přidać',
	'mv_sequence_add_manual_desc'    => 'Klipy po streamowym mjenje přidać',
	'mv_sequence_add_search'         => 'Po pytanju přidać',
	'mv_sequence_add_search_desc'    => 'Klipy z medijowym pytanjom přidać',
	'mv_seq_add_end'                 => 'Kóncej sekwency přidać',
	'mv_sequence_timeline'           => 'Časowa lajsta sekwency:',
	'mv_edit_sequence_desc_help'     => 'Wopisanje sekwency',
	'mv_edithelpsequence'            => 'Pomoc:Wobdźěłanje_sekwency',
	'mv_seq_summary'                 => 'Zjeće wobdźěłanja sekwency',
	'mv_add_clip_by_name'            => 'Klip po mjenje přidać',
	'mv_export_cmml'                 => 'cmml eksportować',
	'mv_search_stream'               => 'Stream pytać',
	'mv_navigate_stream'             => 'W cyłym streamje nawigěrować',
	'mv_embed_options'               => 'Opcije zasadźić',
	'mv_overlay'                     => 'Rjadowaki naworštowanja',
	'mv_stream_tool_heading'         => 'Streamowe nastroje',
	'mv_tool_missing'                => 'požadanje wo nastroj ($1) njeeksistuje',
	'mv_bad_tool_request'            => 'Špatna rjadka nastroja měła tule formu měć: mjeno_nastroja|zwobraznjene_mjeno_nastroja',
	'mv_search_stream_title'         => 'Aktualny stream přepytać',
	'mv_new_ht_en'                   => 'Nowy přepis',
	'mv_new_anno_en'                 => 'Nowa taflička abo přispomnjenka',
	'mv_mang_layers'                 => 'Woršty zrjadować',
	'mv_mang_layers_title'           => 'Sadźbu worštow za aktualny prud zrjadować',
	'mv_protect_source_material'     => 'Originalny žórłowy material přećiwo změnam škitany.',
);

/** Hungarian (Magyar)
 * @author Dani
 * @author Dorgan
 * @author Tgr
 */
$messages['hu'] = array(
	'mv_missing_stream'       => 'Hiányzó adatfolyam: $1',
	'mv_add_stream'           => 'Metavid adatfolyam hozzáadása',
	'mv_edit_stream'          => 'Metavid adatfolyam szerkesztése',
	'mv_add_stream_page'      => 'Mv adatfolyam hozzáadása',
	'mv_add_stream_submit'    => 'Adatfolyam hozzáadása',
	'mv_no_stream_files'      => 'Nincsenek adatfolyam-fájlok',
	'mv_edit_stream_files'    => 'Adatfolyam-fájlok szerkesztése',
	'mv_path_type_wiki_title' => 'wiki média cím',
	'mv_duration_label'       => 'hossz',
	'mv_save_changes'         => 'Változtatások mentése',
	'mv_add_stream_file'      => 'Adatfolyam fájl hozzáadása',
	'mv_file_list'            => 'Adatfolyam fájlok',
	'mv_label_stream_name'    => 'Adatfolyam neve',
	'mv_label_stream_desc'    => 'Adatfolyam leírása',
	'edit_stream_missing'     => 'Hiányzó adatfolyam-név',
	'mv_remove_reason'        => 'Törlés oka',
	'mv_label_stream_type'    => 'Adatfolyam típusa',
	'mv_metavid_file'         => 'Létező fájl a szerveren',
	'mv_upload_file'          => 'Fájl feltöltése',
	'mv_external_file'        => 'Külső fájl',
	'mv_tool_search'          => 'Keresés',
	'mv_play'                 => 'Lejátszás',
	'mv_edit'                 => 'Szerkesztés',
	'mv_edit_title'           => 'Szöveg szerkesztése',
	'mv_remove'               => 'eltávolítás',
	'mv_search_and'           => 'és',
	'mv_search_or'            => 'vagy',
	'mv_search_not'           => 'nem',
);

/** Lojban (Lojban)
 * @author Malafaya
 */
$messages['jbo'] = array(
	'mv_category' => 'klesi',
);

/** Javanese (Basa Jawa)
 * @author Meursault2004
 */
$messages['jv'] = array(
	'metavid'                => 'Kaca Metavid',
	'mv_ogg_high_quality'    => 'Kwalitas dhuwur - Ogg Theora 900kbs',
	'mvexportsearch'         => 'Èkspor Metavid',
	'mv_duration_label'      => 'durasi',
	'mv_save_changes'        => 'Simpen owah-owahan',
	'mv_remove_reason'       => 'Alesan mbusak:',
	'mv_upload_file'         => 'Unggahna berkas',
	'mv_external_file'       => 'Berkas jaba',
	'mv_tool_search'         => 'Golèk',
	'mv_tool_navigate'       => 'Navigasi',
	'mv_tool_export'         => 'Èkspor',
	'ht_en'                  => 'Transkripsi',
	'anno_en'                => 'Anotasi lan Kategori',
	'thomas_en'              => 'Transkripsi resmi',
	'mv_play'                => 'Main',
	'mv_edit'                => 'Sunting',
	'mv_history'             => 'Sajarah',
	'mv_edit_title'          => 'Sunting tèks',
	'mv_remove'              => 'busak',
	'mv_adjust'              => 'setèl',
	'mv_start_desc'          => 'Wektu wiwitan',
	'mv_end_desc'            => 'Wektu akir',
	'mv_add_filter'          => 'Tambahna filter',
	'mv_search_match'        => 'Golèk tèks',
	'mv_search_spoken_by'    => 'Diwicarakaké déning',
	'mv_search_category'     => 'Kategori',
	'mv_search_smw_property' => 'Sifat-sifat sémantik',
	'mv_search_and'          => 'lan',
	'mv_search_or'           => 'utawa',
	'mv_search_not'          => 'ora',
	'mv_match'               => 'cocog',
	'mv_spoken_by'           => 'diwicarakaké déning',
	'mv_category'            => 'kategori',
	'mv_remove_filter'       => 'ilangana filter',
);

/** Khmer (ភាសាខ្មែរ)
 * @author Chhorran
 * @author Lovekhmer
 */
$messages['km'] = array(
	'mv_path_type_url_anx'   => 'url មេឌាពេញលេញ',
	'mv_duration_label'      => 'រយះពេល',
	'mv_save_changes'        => 'រក្សាបំលាស់ប្តូរទុក',
	'mv_remove_reason'       => 'មូលហេតុនៃការលុប៖',
	'mv_upload_file'         => 'ផ្ទុកឡើងឯកសារ',
	'mv_external_file'       => 'ឯកសារផ្នែកខាងក្រៅ',
	'mv_tool_search'         => 'ស្វែងរក',
	'mv_tool_navigate'       => 'ទិសដៅ',
	'mv_tool_export'         => 'នាំចេញ',
	'mv_tool_mang_layers'    => 'គ្រប់គ្រង ស្រទាប់',
	'mv_update_layers'       => 'បន្ទាប់សម័យ ការមើលស្រទាប់',
	'mv_edit'                => 'កែប្រែ',
	'mv_history'             => 'ប្រវត្តិ',
	'mv_edit_title'          => 'កែប្រែអត្ថបទ',
	'mv_remove'              => 'ដកចេញ',
	'mv_adjust_preview_stop' => 'បញ្ឈប់ ការមើលមុន',
	'mv_start_desc'          => 'ពេលចាប់ផ្តើម',
	'mv_end_desc'            => 'ពេលបញ្ចប់',
	'mediasearch'            => 'ការស្វែងរកមេឌា',
	'mv_add_filter'          => 'បន្ថែមតំរង',
	'mv_search_match'        => 'ស្វែងរកអត្ថបទ',
	'mv_search_category'     => 'ចំណាត់ថ្នាក់ក្រុម',
	'mv_search_and'          => 'និង',
	'mv_search_or'           => 'ឬ',
	'mv_search_not'          => 'អត់',
	'mv_search_date_range'   => 'ដែនកំណត់ នៃ ថ្ងៃ ខែ ឆ្នាំ',
	'mv_category'            => 'ចំណាត់ក្រុម',
	'mv_remove_filter'       => 'ដកចេញ តំរង',
	'mv_view_wiki_page'      => 'មើលទំព័រវិគី',
	'mv_mang_layers'         => 'គ្រប់គ្រង ស្រទាប់',
);

/** Korean (한국어)
 * @author ToePeu
 */
$messages['ko'] = array(
	'mv_tool_search' => '찾기',
);

/** Kinaray-a (Kinaray-a)
 * @author Jose77
 */
$messages['krj'] = array(
	'mv_tool_search'     => 'Sagap',
	'mv_edit'            => 'Iislan',
	'mv_history'         => 'Kasaysayan',
	'mv_search_category' => 'Kategorya',
	'mv_category'        => 'kategorya',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Robby
 */
$messages['lb'] = array(
	'metavid'             => 'Metavid-Säit',
	'mv_save_changes'     => 'Ännerunge späicheren',
	'mv_missing_cat'      => 'Den Numm vun der Kategorie feelt',
	'mv_remove_reason'    => 'Grond vum Läschen:',
	'mv_upload_file'      => 'Fichier eroplueden',
	'mv_tool_search'      => 'Sichen',
	'mv_tool_export'      => 'Exportéieren',
	'mv_time_separator'   => '$1 op $2',
	'mv_edit'             => 'Änneren',
	'mv_edit_title'       => 'Text änneren',
	'mv_start_desc'       => 'Ufankszäit',
	'mv_search_spoken_by' => 'Geschwat vum',
	'mv_search_category'  => 'Kategorie',
	'mv_search_and'       => 'an',
	'mv_search_or'        => 'oder',
	'mv_search_not'       => 'net',
	'mv_spoken_by'        => 'Geschwat vum',
	'mv_category'         => 'Kategorie',
	'mv_view_wiki_page'   => 'Wiki-Säit gesinn',
);

/** Malayalam (മലയാളം)
 * @author Shijualex
 */
$messages['ml'] = array(
	'mv_upload_file'     => 'പ്രമാണം അപ്‌ലോഡ് ചെയ്യുക',
	'mv_tool_search'     => 'തിരയുക',
	'mv_edit'            => 'തിരുത്തുക',
	'mv_history'         => 'നാള്‍വഴി',
	'mv_remove'          => 'നീക്കം ചെയ്യുക',
	'mv_search_category' => 'വിഭാഗം',
	'mv_category'        => 'വിഭാഗം',
);

/** Marathi (मराठी)
 * @author Kaustubh
 * @author Siebrand
 * @author Mahitgar
 */
$messages['mr'] = array(
	'metavid'                        => 'मेटाविड पान',
	'mv_missing_stream'              => 'स्ट्रीम सापडली नाही: $1',
	'mv_ogg_low_quality'             => 'वेब स्ट्रीमेबल - ऑग थिओरा ३०० केबीपीएस',
	'mv_ogg_high_quality'            => 'उच्च दर्जा - ऑग थिओरा ९०० केबीपीएस',
	'mv_archive_org_link'            => 'Archive.org मध्ये एमपीईजी२ मूळ चा दुवा देते',
	'ao_file_64Kb_MPEG4'             => 'आर्चिव्ह.ऑर्ग - mpeg4 64kbs',
	'ao_file_256Kb_MPEG4'            => 'आर्चिव्ह.ऑर्ग - mpeg4 256kbs',
	'ao_file_MPEG1'                  => 'आर्चिव्ह.ऑर्ग - mpeg1',
	'ao_file_MPEG2'                  => 'आर्चिव्ह.ऑर्ग - mpeg2 मूळ',
	'ao_file_flash_flv'              => 'आर्चिव्ह.ऑर्ग - फ्लश व्हिडियो',
	'mv_error_stream_missing'        => '<span class="error">त्रुटी: या स्ट्रीमशी संबंधित व्हीडियो संचिका अस्तित्वात नाही.</span><br />कृपया प्रबंधकांना याची माहिती द्या.',
	'mv_stream_meta'                 => 'स्ट्रीम पान',
	'mv_add_stream'                  => 'मेटाविड स्ट्रीम वाढवा',
	'mv_edit_stream'                 => 'मेटाविड स्ट्रीम संपादा',
	'mvexportsearch'                 => 'मेटाविड निर्यात',
	'mvexportsequence'               => 'मेटाविड निर्यात क्रम',
	'mvexportstream'                 => 'मेटाविड निर्यात स्ट्रीम',
	'mv_add_stream_page'             => 'मेवि स्ट्रीम वाढवा',
	'mv_edit_strea_docu'             => '<p><b>प्रबंधकांकरीता</b> स्ट्रीम संपादा<br />साधारण सदस्यांकरीता पहा/संपादा $1 पान पहा',
	'mv_add_stream_docu'             => '<p>खालील रकाना वापरून एक स्ट्रीम वाढवा.</p>
<p>अधिक माहिती <a href="$1">स्ट्रीम वाढवण्याबद्दल साहाय्य</a> या पानावर दिलेली आहे.</p>',
	'mv_add_stream_submit'           => 'स्ट्रीम वाढवा',
	'mv_no_stream_files'             => 'अगोदरच अस्तित्वात असणार्‍या स्ट्रीम संचिका नाहीत',
	'mv_edit_stream_files'           => 'स्ट्रीम संचिका संपादा',
	'mv_path_type_url_anx'           => 'पूर्ण मिडिया url',
	'mv_path_type_wiki_title'        => 'विकि मीडिया शीर्षक',
	'mv_path_type_label'             => 'मार्ग प्रकार',
	'mv_base_offset_label'           => 'बेसपासूनचा फरक (offset)',
	'mv_duration_label'              => 'कालावधी',
	'mv_file_desc_label'             => 'स्ट्रीम माहिती संदेश',
	'mv_delete_stream_file'          => 'स्ट्रीम संचिकेचा संदर्भ वगळा',
	'mv_save_changes'                => 'बदल जतन करा',
	'mv_file_with_same_desc'         => 'त्रुटी: <i>$1</i> या माहितीचावीची स्ट्रीम संचिका अगोदरच अस्तित्वात आहे',
	'mv_updated_stream_files'        => 'स्ट्रीम संचिकांची यादी नवीन केली',
	'mv_removed_file_stream'         => 'स्ट्रीम संचिका वगळली: $1',
	'mv_missing_stream_text'         => 'तुम्ही मागितलेली <b>$1</b> स्ट्रीम उपलब्ध नाही.<br />
तुम्ही <a href="$2">स्ट्रीम यादी</a> तपासू शकता<br />
किंवा ही <a href="$3">स्ट्रीम वाढवा</a>.',
	'mv_user_cant_edit'              => 'तुम्हाला संपादन करण्यासाठी $1 करणे आवश्यक आहे, $2',
	'mv_add_stream_file'             => 'स्ट्रीम संचिका वाढवा',
	'mv_media_path'                  => 'मीडिया मार्ग',
	'mv_file_list'                   => 'स्ट्रीम संचिका',
	'mv_label_stream_name'           => 'स्ट्रीम नाव',
	'mv_label_stream_desc'           => 'स्ट्रीम माहिती',
	'add_stream_permission'          => 'तुम्हाला नवीन स्ट्रीम वाढविण्याची परवानगी नाही',
	'edit_stream_missing'            => 'स्ट्रीम नाव दिलेले नाही',
	'mv_missing_req_time'            => 'मागणी वेळ दिलेली नाही',
	'mv_missing_cat'                 => 'वर्ग नाव दिलेले नाही',
	'mv_stream_already_exists'       => '<a href="$2">$1</a> ही स्ट्रीम अगोदरच अस्तित्वात आहे',
	'mv_summary_add_stream'          => 'अर्ज वापरून स्ट्रीम वाढविलेली आहे',
	'mv_error_stream_insert'         => 'स्ट्रीम घालणे जमले नाही',
	'mv_redirect_and_delete_reason'  => 'पुनर्निर्देशनाचे पान वगळले',
	'mv_remove_reason'               => 'वगळण्यासाठीचे कारण:',
	'mv_stream_delete_warrning'      => '<b>ही स्ट्रीम वगळल्यास संलग्न $1 मेटाडाटाचे तुकडे सुद्धा वगळले जातील</b><br />',
	'mv_label_stream_type'           => 'स्ट्रीम प्रकार',
	'mv_metavid_file'                => 'सर्व्हर वरील अस्तित्वात असणारी संचिका',
	'mv_metavid_live'                => 'जिवंत स्ट्रीम तयार करा',
	'mv_upload_file'                 => 'संचिका चढवा',
	'mv_external_file'               => 'बाह्य संचिका',
	'mv_stream_delete_warning'       => 'ही स्ट्रीम वगळल्यास संलग्न मेटाडाटाची $1 पाने सुद्धा वगळली जातील',
	'mv_tool_search'                 => 'शोधा',
	'mv_tool_search_title'           => 'या स्ट्रीम मध्ये शोधा',
	'mv_search_transcripts_for'      => 'च्या साठीच्या ट्रान्स्क्रीप्टस शोधा',
	'mv_tool_navigate'               => 'नॅव्हिगेट',
	'mv_tool_navigate_title'         => 'पूर्ण स्ट्रीम नॅव्हिगेट करा',
	'mv_tool_export'                 => 'निर्यात',
	'mv_tool_export_title'           => 'स्ट्रीम मेटाडाटा निर्यात',
	'mv_tool_embed'                  => 'एम्बेड',
	'mv_tool_embed_title'            => 'सध्या मागितलेल्या सेगमेंटचे एम्बेड विकल्प',
	'mv_tool_overlay'                => 'साचा एकत्रीकरण',
	'mv_tool_overlay_title'          => 'साच्यावर आधारित मेटाडाटाचे एकत्रीकरण',
	'mv_results_found_for'           => 'खालीलचे शोध निकाल <b>$3</b> पैकी <b>$1</b> ते <b>$2</b>:',
	'mv_tool_mang_layers'            => 'स्तर व्यवस्थापन',
	'mv_update_layers'               => 'स्तर दर्शवा',
	'mv_watch_clip'                  => 'क्लिप पहा',
	'mv_close_clip'                  => 'क्लिप बंद करा',
	'mv_improve_transcript'          => 'ट्रान्स्क्रीप्ट इम्प्रूव्ह करा',
	'ht_en'                          => 'ट्रानस्क्रीप्ट',
	'ht_en_desc'                     => 'इंग्रजी ट्रानस्क्रीप्ट्स. हा ओव्हरले प्रकार बोललेल्या मजकूरासाठी आहे',
	'anno_en'                        => 'ऍनोटेशन्स व वर्ग',
	'anno_en_desc'                   => 'इंग्रजी वर्गीकरण व शेरे.
हा ओव्हरले व्हिडियोचे वर्गीकरण करणे व न बोललेल्या मजकूराबद्दल शेरे देण्यासाठी वापरता येईल',
	'thomas_en'                      => 'अधिकृत ट्रानस्कीप्ट',
	'thomas_en_desc'                 => 'सरकारच्या थॉमस रेकॉर्ड सेवेवरील अधिकृत थॉमस ट्रान्स्क्रीप्ट्स.
स्रोत वेळ C-SPAN च्या c-spanarchives.org ने दिली.',
	'mvd_default_mismatch'           => 'सेटींग संचिकेमध्ये त्रुटी',
	'mvd_default_mismatch_text'      => 'तुमच्या सेटिंग संचिकेमध्ये त्रुटी आहे.
$mvMVDTypeDefaultDisp हा $mvMVDTypeAllAvailable चा सबसेट असायला हवा',
	'mv_data_page_title'             => '$3 कडून $2 साठी $1',
	'mv_time_separator'              => '$1 ते $2',
	'mv_list_streams'                => 'मेटाविड स्ट्रीम यादी',
	'mv_list_streams_page'           => 'मेवि स्ट्रीम यादी',
	'mv_list_streams_docu'           => 'खालील स्ट्रीम्स अस्तित्वात आहे:',
	'mv_list_streams_none'           => 'एकही स्ट्रीम अस्तित्वात नाही',
	'mvvideofeed'                    => 'मेटाविड व्हिडियो फीड निर्यात',
	'mvexportask'                    => 'सिमँटिक व्हिडियो फिड निर्यात',
	'video_feed_cat'                 => 'वर्गा साठी व्हिडियो फीड:',
	'mv_cat_search_note'             => 'सूचना: वर्ग फक्त वरच्या स्तरावरील वर्ग दर्शवितो.
वर्ग सीमांमध्ये संपूर्ण मेटाडाटा शोधण्यासाठी $1 चा शोध घ्या',
	'mv_mvd_linkback'                => '$1 स्ट्रीम चा भाग<br />
स्ट्रीम दृश्याकडे जा: $2',
	'mvBadMVDtitle'                  => 'प्रकार दिलेला नाही, स्ट्रीम दिलेली नाही, किंवा चुकीची वेळ रुपरेषा',
	'mvMVDFormat'                    => 'MVD शीर्षक पुढीलप्रमाणे असायला हवे: mvd:type:stream_name/start_time/end_time',
	'mv_play'                        => 'चालू करा',
	'mv_edit'                        => 'संपादन',
	'mv_history'                     => 'इतिहास',
	'mv_history_title'               => 'व्हिडियो अलाईनमेंट व संपादन इतिहास',
	'mv_edit_title'                  => 'मजकूर संपादा',
	'mv_edit_adjust_title'           => 'मजकूर संपादन व व्हिडियो अलाइनमेंट',
	'mv_remove'                      => 'वगळा',
	'mv_remove_title'                => 'ही मेटा डाटा सेगमेंट वगळा',
	'mv_adjust'                      => 'ठीकठाक करा',
	'mv_adjust_submit'               => 'ठाकठीक जतन करा',
	'mv_adjust_title'                => 'सुरु व समाप्त वेळ ठाकठीक करा',
	'mv_adjust_preview'              => 'ठाकठीकीची झलक पहा',
	'mv_adjust_preview_stop'         => 'झलक थांबवा',
	'mv_adjust_default_reason'       => 'मेटाविड इंटरफेसचे व्यवस्थापन',
	'mv_adjust_old_title_missing'    => 'तुम्ही ($1) पासून स्थानांतरीत करीत असलेले पान अस्तित्वात नाही',
	'mv_adjust_ok_move'              => 'सफल, ठाकठीक करीत आहे...',
	'mv_start_desc'                  => 'सुरू वेळ',
	'mv_end_desc'                    => 'समाप्ती वेळ',
	'mv_of'                          => '&#32;पैकी&#32;',
	'mediasearch'                    => 'मीडिया शोध',
	'mv_search_sel_t'                => 'शोध प्रकार निवडा',
	'mv_run_search'                  => 'शोध राबवा',
	'mv_add_filter'                  => 'फिल्टर वाढवा',
	'mv_search_match'                => 'मजकूर शोधा',
	'mv_search_spoken_by'            => 'वाचक (निवेदक)',
	'mv_search_category'             => 'वर्ग',
	'mv_search_smw_property'         => 'सिमांटिक गुणधर्म',
	'mv_search_smw_property_numeric' => 'सांख्यिक सिमॅंटिक किंमत',
	'mv_search_and'                  => 'आणि',
	'mv_search_or'                   => 'किंवा',
	'mv_search_not'                  => 'नाही',
	'mv_search_stream_name'          => 'स्ट्रीम नाव',
	'mv_search_date_range'           => 'तारीख सीमा',
	'mv_stream_name'                 => 'स्ट्रीम नाव',
	'mv_date_range'                  => 'तारीख सीमा',
	'mv_match'                       => 'जुळवा',
	'mv_spoken_by'                   => 'निवेदक',
	'mv_category'                    => 'वर्ग',
	'mv_search_no_results'           => 'मिडिया जुळल्या नाहीत',
	'mv_media_matches'               => 'जुळलेल्या मिडिया',
	'mv_remove_filter'               => 'फिल्टर हटवा',
	'mv_advaced_search'              => 'वाढीव मिडिया शोध',
	'mv_expand_play'                 => 'वाढवा व इन-लाइन चालू करा',
	'mv_view_in_stream_interface'    => 'स्ट्रीम इंटरफेस मध्ये पहा',
	'mv_view_wiki_page'              => 'विकि पान पहा',
	'mv_error_mvd_not_found'         => 'त्रुटी एमव्हीडी सापडली नाही',
	'mv_match_text'                  => '~  $1 जुळण्या',
	'mv_match_text_one'              => '~ १ जुळणी',
	'mv_edit_sequence'               => 'सिक्वेन्स संपादित आहे:$1',
	'mv_sequence_player_title'       => 'सिक्वेन्स प्लेयर',
	'mv_save_sequence'               => 'सिक्वेन्स जतन करा',
	'mv_sequence_page_desc'          => 'सध्याच्या सिक्वेन्स जतन करा',
	'mv_sequence_add'                => 'क्लीप वाढवा',
	'mv_sequence_add_manual'         => 'नावाने वाढवा',
	'mv_sequence_add_manual_desc'    => 'स्ट्रीम नावाने क्लीप वाढवा',
	'mv_sequence_add_search'         => 'शोधानुसार वाढवा',
	'mv_sequence_add_search_desc'    => 'मिडिया शोधानुसार क्लीप वाढवा',
	'mv_seq_add_end'                 => 'सिक्वेन्सच्या शेवटी वाढवा',
	'mv_sequence_timeline'           => 'सिक्वेन्स वेळरेषा (timeline):',
	'mv_edit_sequence_desc_help'     => 'सिक्वेन्स माहिती',
	'mv_edithelpsequence'            => 'साहाय्य:सिक्वेन्स_संपादन',
	'mv_seq_summary'                 => 'सिक्वेन्स संपादन संक्षिप्त माहिती',
	'mv_add_clip_by_name'            => 'नावानुसार क्लीप वाढवा',
	'mv_export_cmml'                 => 'cmml निर्यात करा',
	'mv_search_stream'               => 'स्ट्रीम शोधा',
	'mv_navigate_stream'             => 'पूर्ण स्ट्रीम नॅव्हिगेट करा',
	'mv_embed_options'               => 'एम्बेड विकल्प',
	'mv_overlay'                     => 'ओव्हरले नियंत्रण विकल्प',
	'mv_stream_tool_heading'         => 'स्ट्रीम उपकरणे',
	'mv_tool_missing'                => '($1) उपकरण मागणी अस्तित्वात नाही',
	'mv_bad_tool_request'            => 'चुकीच्या उपकरणाची ओळ रुपरेषा: tool_name|tool_display_name',
	'mv_search_stream_title'         => 'सद्य स्ट्रीमचा शोध घ्या',
	'mv_new_ht_en'                   => 'नवीन ट्रान्स्क्रीप्ट',
	'mv_new_anno_en'                 => 'नवीन टॅग किंवा खूण',
	'mv_mang_layers'                 => 'स्तर व्यवस्थापन',
	'mv_mang_layers_title'           => 'सद्य स्ट्रीम साठीच्या स्तर-प्रदर्शन प्रणालीचे व्यवस्थापन करा',
	'mv_protect_source_material'     => 'मूळ स्रोत साहित्य संपादनांपासून सुरक्षित केले',
);

/** Dutch (Nederlands)
 * @author Siebrand
 * @author SPQRobin
 */
$messages['nl'] = array(
	'metavid'                        => 'Metavid-pagina',
	'mv_missing_stream'              => 'Stream niet aanwezig: $1',
	'mv_ogg_low_quality'             => 'Via het web te streamen ogg theora, gehost op metavid',
	'mv_ogg_high_quality'            => 'Hoge kwaliteit ogg theora, gehost op metavid',
	'mv_archive_org_link'            => 'Links naar de originele mpeg2 op Archive.org',
	'mv_error_stream_missing'        => '<span class="error">Fout: Er is geen videobestand gekoppeld aan deze stream.</span><br />Rapporteer dit alstublieft aan de sitebeheerder.',
	'mv_stream_meta'                 => 'Streampagina',
	'mv_add_stream'                  => 'Metavid stream toevoegen',
	'mv_edit_stream'                 => 'Metavid-stream bewerken',
	'mvexportsearch'                 => 'Metavid exporteren',
	'mvexportsequence'               => 'Metavid onderdeel exporteren',
	'mvexportstream'                 => 'Metavid stream exporteren',
	'mv_add_stream_page'             => 'Metavid-stream toevoegen',
	'mv_edit_strea_docu'             => '<p>Stream bewerken <b>beheerder</b><br />voor bekijken/bewerken als normale gebruikers, zie pagina $1',
	'mv_add_stream_docu'             => '<p>Voeg met het onderstaande veld een nieuwe stream toe.</p><p>Meer information staat op de <a href="$1">helppagina voor het toevoegen van een stream</a>.</p>',
	'mv_add_stream_submit'           => 'Stream toevoegen',
	'mv_no_stream_files'             => 'Er zijn geen streambestanden',
	'mv_edit_stream_files'           => 'Streambestanden bewerken',
	'mv_path_type_url_anx'           => 'volledige media-url',
	'mv_path_type_wiki_title'        => 'wiki medianaam',
	'mv_path_type_label'             => 'padtype',
	'mv_base_offset_label'           => 'basisverschuiving',
	'mv_duration_label'              => 'duur',
	'mv_file_desc_label'             => 'stream desc msg',
	'mv_delete_stream_file'          => 'streambestandsreferentie verwijderen',
	'mv_save_changes'                => 'Wijzigingen opslaan',
	'mv_file_with_same_desc'         => 'Fout: er bestaat al een streambestand met dezelfde sleutel ($1)',
	'mv_updated_stream_files'        => 'Streambestanden bijgewerkt',
	'mv_removed_file_stream'         => 'Streambestand $1 is verwijderd',
	'mv_missing_stream_text'         => 'De stream die u hebt opgevraagd (<b>$1</b>) is niet beschikbaar.<br />U kunt de <a href="$2">streamlijst</a> bekijken of u kunt <a href="$3">de stream toevoegen</a>.',
	'mv_user_cant_edit'              => 'Wellicht moet u zich $1 om te bewerken ($2)',
	'mv_add_stream_file'             => 'Streambestand toevoegen',
	'mv_media_path'                  => 'medialocatie',
	'mv_file_list'                   => 'Streambestanden',
	'mv_label_stream_name'           => 'Streamnaam',
	'mv_label_stream_desc'           => 'Streambeschrijving',
	'add_stream_permission'          => 'U hebt geen rechten om een nieuwe stream toe te voegen',
	'edit_stream_missing'            => 'De streamnaam mist',
	'mv_missing_req_time'            => 'Tijd van verzoek is niet opgegeven',
	'mv_missing_cat'                 => 'Categorienaam is niet opgegeven',
	'mv_stream_already_exists'       => 'De stream <a href="$2">$1</a> bestaat al',
	'mv_summary_add_stream'          => 'stream toegevoegd via formulier',
	'mv_error_stream_insert'         => 'de stream kon niet ingevoegd worden',
	'mv_redirect_and_delete_reason'  => 'de doorverwijspagina is verwijderd',
	'mv_remove_reason'               => 'Reden voor verwijdering:',
	'mv_stream_delete_warrning'      => '<b>Met het verwijderen van deze stream, worden ook $1 gerelateerde metadata-onderdelen verwijderd</b><br />',
	'mv_label_stream_type'           => 'Streamtype',
	'mv_metavid_file'                => 'Bestand bestaat op server',
	'mv_metavid_live'                => 'Livestream opzetten',
	'mv_upload_file'                 => 'Bestand uploaden',
	'mv_external_file'               => 'Extern bestand',
	'mv_stream_delete_warning'       => "Met deze stream worden ook $1 pagina's metadata verwijderd",
	'mv_tool_search'                 => 'Zoeken',
	'mv_tool_search_title'           => 'Binnen deze stream zoeken',
	'mv_search_transcripts_for'      => 'Transscripts zoeken voor',
	'mv_tool_navigate'               => 'Navigatie',
	'mv_tool_navigate_title'         => 'Volledige stream navigeren',
	'mv_tool_export'                 => 'Exporteren',
	'mv_tool_export_title'           => 'Streammetadata exporteren',
	'mv_tool_embed'                  => 'Inbedden',
	'mv_tool_embed_title'            => 'Inbedinstellingen voor het huidige segment',
	'mv_tool_overlay'                => 'Sjabloonoverlays',
	'mv_tool_overlay_title'          => 'Sjabloongebaseerde overlay voor metadata',
	'mv_results_found_for'           => 'Zoekresultaten <b>$1</b> tot <b>$2</b> van <b>$3</b> voor:',
	'mv_tool_mang_layers'            => 'Lagen beheren',
	'mv_update_layers'               => 'Lagenoverzicht bijwerken',
	'mv_watch_clip'                  => 'Clip bekijken',
	'mv_close_clip'                  => 'Clip sluiten',
	'mv_improve_transcript'          => 'Transscript verbeteren',
	'ht_en'                          => 'Transcriptie',
	'ht_en_desc'                     => 'Engelstalige transcripties. Dit type overlay is voor gesproken tekst in een videostream.
U kunt links toevoegen, maar alle tekst moet gesproken worden in de videostream.',
	'anno_en'                        => 'Annotaties en categorieën',
	'anno_en_desc'                   => "Engelstalige categorisatie en annotatie. Deze overlay is te gebruiken voor het Categoriseren van delen van video's of om annotaties voor niet-gesproken tekst toe te voegen",
	'thomas_en'                      => 'Officiële transcriptie',
	'thomas_en_desc'                 => 'Officiële transcriptie',
	'mvd_default_mismatch'           => 'Fout in het instellingenbestand',
	'mvd_default_mismatch_text'      => 'Er staat een fout in uw instellingenbestand. $mvMVDTypeDefaultDisp hoort een subset van $mvMVDTypeAllAvailable te zijn',
	'mv_data_page_title'             => '$1 voor $2 van $3',
	'mv_time_separator'              => '$1 tot $2',
	'mv_list_streams'                => 'Metavid streamlijst',
	'mv_list_streams_page'           => 'Metavid streamlijst',
	'mv_list_streams_docu'           => 'De volgende streams zijn beschikbaar:',
	'mv_list_streams_none'           => 'Er zijn geen streams',
	'mvvideofeed'                    => 'Metavid videofeed exporteren',
	'mvexportask'                    => 'Videofeed semantisch exporteren',
	'video_feed_cat'                 => 'Videofeed voor categorie:',
	'mv_cat_search_note'             => 'Let op: alleen ondercategorieën van het eerste niveau worden weergegeven.
Zoek naar $1 om alle metadata in een reeks categorieën te bekijken.',
	'mv_mvd_linkback'                => 'Onderdeel van stream $1<br />Stream bekijken: $2<br />',
	'mvBadMVDtitle'                  => 'type of stream niet aanwezig, of onjuiste tijdsnotatie',
	'mvMVDFormat'                    => 'De titel voor MVD hoort de volgende opmaak te hebben: mvd:type:streamnaam/begintijd/eindtijd',
	'mv_play'                        => 'Afspelen',
	'mv_edit'                        => 'Bewerken',
	'mv_history'                     => 'Geschiedenis',
	'mv_history_title'               => 'Geschiedenis bewerken en videosynchronisatie',
	'mv_edit_title'                  => 'Tekst bewerken',
	'mv_edit_adjust_title'           => 'Tekst en videosynchronisatie bewerken',
	'mv_remove'                      => 'verwijderen',
	'mv_remove_title'                => 'dit metadatasegment verwijderen',
	'mv_adjust'                      => 'aanpassen',
	'mv_adjust_submit'               => 'Aanpassing opslaan',
	'mv_adjust_title'                => 'Begin- en eindtijd aanpassen',
	'mv_adjust_preview'              => 'Aanpassing bekijken',
	'mv_adjust_preview_stop'         => 'Proefvertoning afbreken',
	'mv_adjust_default_reason'       => 'metavid-interface aanpassen',
	'mv_adjust_old_title_missing'    => 'De pagina die u probeert te hernoemen ($1) bestaat niet',
	'mv_adjust_ok_move'              => 'Geslaagd. Bezig met aanpassen...',
	'mv_start_desc'                  => 'Begintijd',
	'mv_end_desc'                    => 'Eindtijd',
	'mv_of'                          => '&#32;van&#32;',
	'mediasearch'                    => 'Media zoeken',
	'mv_search_sel_t'                => 'Selecteer zoektype',
	'mv_run_search'                  => 'Zoekopdracht uitvoeren',
	'mv_add_filter'                  => 'Filter toevoegen',
	'mv_search_match'                => 'Tekst zoeken',
	'mv_search_spoken_by'            => 'Gesproken door',
	'mv_search_category'             => 'Categorie',
	'mv_search_smw_property'         => 'Semantische eigenschappen',
	'mv_search_smw_property_numeric' => 'Numerieke semantische waarde',
	'mv_search_and'                  => 'en',
	'mv_search_or'                   => 'of',
	'mv_search_not'                  => 'niet',
	'mv_search_stream_name'          => 'Streamnaam',
	'mv_search_date_range'           => 'Periode',
	'mv_stream_name'                 => 'streamnaam',
	'mv_date_range'                  => 'periode',
	'mv_match'                       => 'resultaat',
	'mv_spoken_by'                   => 'gesproken door',
	'mv_category'                    => 'categorie',
	'mv_search_no_results'           => 'Geen media gevonden',
	'mv_media_matches'               => 'Gevonden media',
	'mv_remove_filter'               => 'filter verwijderen',
	'mv_advaced_search'              => 'Media zoeken (uitgebreid)',
	'mv_expand_play'                 => 'Uitvoeren en in de browser afspelen',
	'mv_view_in_stream_interface'    => 'In streaminterface bekijken',
	'mv_view_wiki_page'              => 'Wikipagina bekijken',
	'mv_error_mvd_not_found'         => 'Fout: mvd niet aangetroffen',
	'mv_match_text'                  => '~ $1 resultaten',
	'mv_match_text_one'              => '~ 1 resultaat',
	'mv_edit_sequence'               => 'Onderdeel in bewerking: $1',
	'mv_sequence_player_title'       => 'onderdelenspeler',
	'mv_save_sequence'               => 'Reeks opslaan',
	'mv_sequence_page_desc'          => 'Huidige reeks opslaan',
	'mv_sequence_add'                => 'Clips toevoegen',
	'mv_sequence_add_manual'         => 'Op naam toevoegen',
	'mv_sequence_add_manual_desc'    => 'Clips toevoegen op streamnaam',
	'mv_sequence_add_search'         => 'Via zoeken toevoegen',
	'mv_sequence_add_search_desc'    => 'Clips toevoegen via een mediazoekopdracht',
	'mv_seq_add_end'                 => 'Achter het onderdeel toevoegen',
	'mv_sequence_timeline'           => 'Tijdlijn onderdeel:',
	'mv_edit_sequence_desc_help'     => 'Beschrijving reeks',
	'mv_edithelpsequence'            => 'Help:Onderdelen bewerken',
	'mv_seq_summary'                 => 'Bewerkingssamenvatting reeks',
	'mv_add_clip_by_name'            => 'Clip toevoegen op naam',
	'mv_export_cmml'                 => 'cmml exporteren',
	'mv_search_stream'               => 'Stream zoeken',
	'mv_navigate_stream'             => 'Door volledige stream navigeren',
	'mv_embed_options'               => 'Embedinstellingen',
	'mv_overlay'                     => 'Overlay-instellingen',
	'mv_stream_tool_heading'         => 'Extra',
	'mv_tool_missing'                => 'Verzoek van hulpmiddel ($1) bestaat niet',
	'mv_bad_tool_request'            => 'Onjuiste invoer voor hulpmiddel. Deze hoort in de volgende vorm: hulpmiddelnaam|weer_te_geven_hulpmiddelnaam',
	'mv_search_stream_title'         => 'Zoeken in de huidige stream',
	'mv_new_ht_en'                   => 'Nieuwe transcriptie',
	'mv_new_anno_en'                 => 'Nieuwe tag of annotatie',
	'mv_mang_layers'                 => 'Lagen beheren',
	'mv_mang_layers_title'           => 'Laagweergave voor de huidige set beheren',
	'mv_protect_source_material'     => 'Origineel bronmateriaal dat niet bewerkt kan worden',
);

/** Norwegian Nynorsk (‪Norsk (nynorsk)‬)
 * @author Jon Harald Søby
 */
$messages['nn'] = array(
	'mv_remove_reason'   => 'Slettingsårsak:',
	'mv_upload_file'     => 'Last opp fil',
	'mv_tool_search'     => 'Søk',
	'mv_tool_export'     => 'Eksporter',
	'mv_edit'            => 'Endre',
	'mv_history'         => 'Historikk',
	'mv_remove'          => 'fjern',
	'mv_search_category' => 'Kategori',
	'mv_category'        => 'kategori',
);

/** Norwegian (bokmål)‬ (‪Norsk (bokmål)‬)
 * @author Jon Harald Søby
 * @author Siebrand
 */
$messages['no'] = array(
	'metavid'                        => 'Metavid-side',
	'mv_missing_stream'              => 'Mangler dataflyt: $1',
	'mv_ogg_low_quality'             => 'Direkteoverført over nettet – Ogg Theora 300kbs',
	'mv_ogg_high_quality'            => 'Høy kvalitet – Ogg Theora 900kbs',
	'mv_archive_org_link'            => 'Lenker til mpeg2-originaler hos Archive.org',
	'mv_error_stream_missing'        => '<span class="error">Feil: Det er ingen videofil assosiert med denne dataflyten.</span><br />Vennligst rapporter dette til sideoperatøren.',
	'mv_stream_meta'                 => 'Dataflytside',
	'mv_add_stream'                  => 'Metavid legg til dataflyt',
	'mv_edit_stream'                 => 'Metavid rediger dataflyt',
	'mvexportsearch'                 => 'Metavid eksporter',
	'mvexportsequence'               => 'Metavid eksporter sekvens',
	'mvexportstream'                 => 'Metavid eksporter dataflyt',
	'mv_add_stream_page'             => 'Mv legg til dataflyt',
	'mv_edit_strea_docu'             => '<p>Rediger datastrøm <b>admin</b><br />for vanlig brukervisning/-redigering, se siden $1',
	'mv_add_stream_docu'             => '<p>Legg til en ny dataflyt med feltet nedenfor.</p><p>Mer informasjon gis på <a href="$1">hjelpesiden for tillegging av dataflyt</a>.</p>',
	'mv_add_stream_submit'           => 'Legg til dataflyt',
	'mv_no_stream_files'             => 'Ingen eksisterende dataflytfiler',
	'mv_edit_stream_files'           => 'Rediger dataflytfiler',
	'mv_path_type_url_anx'           => 'full medie-URL',
	'mv_path_type_wiki_title'        => 'medietittel på wiki',
	'mv_path_type_label'             => 'stitype',
	'mv_base_offset_label'           => 'grunnforskyvning',
	'mv_duration_label'              => 'varighet',
	'mv_file_desc_label'             => 'beskrivelsesbeskjed for dataflyt',
	'mv_delete_stream_file'          => 'slett dataflytfilreferanse',
	'mv_save_changes'                => 'Lagre endringer',
	'mv_file_with_same_desc'         => 'Feil: dataflytfil med samme beskrivelsesnøkkel, <i>$1</i>, finnes allerede',
	'mv_updated_stream_files'        => 'Oppdatert dataflytfillogg',
	'mv_removed_file_stream'         => 'Fjernet dataflytfil: $1',
	'mv_missing_stream_text'         => 'Dataflytfilen du etterspurte, <b>$1</b>, er ikke tilgjengelig.<br />Du bør sjekke <a href="$2">dataflytlisten</a><br />Ellers kan du <a href="$3">legge til dataflyten</a>.',
	'mv_user_cant_edit'              => 'Du må kanskje $1 for å redigere, $2',
	'mv_add_stream_file'             => 'Legg til dataflytfil',
	'mv_media_path'                  => 'mediesti',
	'mv_file_list'                   => 'Dataflytfiler',
	'mv_label_stream_name'           => 'Dataflytnavn',
	'mv_label_stream_desc'           => 'Dataflytbeskrivelse',
	'add_stream_permission'          => 'Du har ikke tillatelse til å legge til en ny dataflyt',
	'edit_stream_missing'            => 'Mangler dataflytnavn',
	'mv_missing_req_time'            => 'Mangler tid for forespørsel',
	'mv_missing_cat'                 => 'Mangler kategorinavn',
	'mv_stream_already_exists'       => 'Dataflyten <a href="$2">$1</a> finnes allerede',
	'mv_summary_add_stream'          => 'dataflyt lagt til med skjema',
	'mv_error_stream_insert'         => 'innsetting av dataflyt mislyktes',
	'mv_redirect_and_delete_reason'  => 'fjernet omdirigeringsside',
	'mv_remove_reason'               => 'Slettingsårsak:',
	'mv_stream_delete_warrning'      => '<b>Fjerning av denne dataflyten vil også føre til fjerning av $1 deler av assosiert metadata</b><br />',
	'mv_label_stream_type'           => 'Dataflyttype',
	'mv_metavid_file'                => 'Eksisterende fil på tjener',
	'mv_metavid_live'                => 'Oppsett av direkteoverføring',
	'mv_upload_file'                 => 'Last opp fil',
	'mv_external_file'               => 'Ekstern fil',
	'mv_stream_delete_warning'       => 'Sletting av denne dataflyten vil også føre til fjerning av $1 sider med metadata',
	'mv_tool_search'                 => 'Søk',
	'mv_tool_search_title'           => 'Søk innen denne dataflyten',
	'mv_search_transcripts_for'      => 'Søk i transkripsjoner etter',
	'mv_tool_navigate'               => 'Naviger',
	'mv_tool_navigate_title'         => 'Naviger hele dataflyten',
	'mv_tool_export'                 => 'Eksporter',
	'mv_tool_export_title'           => 'Eksporter dataflytmetadata',
	'mv_tool_embed'                  => 'Inkluder',
	'mv_tool_embed_title'            => 'Inkluder valgmuligheter for det etterspurte segmentet',
	'mv_tool_overlay'                => 'Maloverlegg',
	'mv_tool_overlay_title'          => 'Mal basert på metadataoverlegg',
	'mv_results_found_for'           => 'Søkeresultat <b>$1</b> til <b>$2</b> av <b>$3</b> for:',
	'mv_tool_mang_layers'            => 'Behandle lag',
	'mv_update_layers'               => 'oppdater lagvisning',
	'mv_watch_clip'                  => 'Se klipp',
	'mv_close_clip'                  => 'Steng klipp',
	'mv_improve_transcript'          => 'Forbedre transkripsjon',
	'ht_en'                          => 'Transkripsjon',
	'ht_en_desc'                     => 'Engelske transkripsjoner. Denne overleggstypen er for opplest tekst',
	'anno_en'                        => 'Annoteringer og kategorier',
	'anno_en_desc'                   => 'Engelske kategoriseringer og merknader.
Denne overleggstypen kan brukes for å kategorisere seksjoner av videoer eller til å legge til merknader som ikke er opplest tekst',
	'thomas_en'                      => 'Offisiell transkripsjon',
	'thomas_en_desc'                 => 'Offisiell Thomas-transkripsjon fra regjeringens THOMAS-innspillingstjeneste. Kildetid synkronisert av C-SPANs c-spanarchives.org',
	'mvd_default_mismatch'           => 'Feil i innstillingsfil',
	'mvd_default_mismatch_text'      => 'Det er en feil i innstillingsfilen din, $mvMVDTypeDefaultDisp burde være et undersett av $mvMVDTypeAllAvailable',
	'mv_data_page_title'             => '$1 for $2 fra $3',
	'mv_time_separator'              => '$1 til $2',
	'mv_list_streams'                => 'Metavid list opp dataflyter',
	'mv_list_streams_page'           => 'Mv list opp dataflyter',
	'mv_list_streams_docu'           => 'Følgende dataflyter finnes:',
	'mv_list_streams_none'           => 'Ingen dataflyter finnes',
	'mvvideofeed'                    => 'Metavid eksportering av videokilde',
	'mvexportask'                    => 'Semantisk videokildeeksport',
	'video_feed_cat'                 => 'Videokilde for kategori:',
	'mv_cat_search_note'             => 'Merk: Kategoriene lister kun opp underkategorier i første nivå; for all metadata i et kategoriområde, søk etter $1',
	'mv_mvd_linkback'                => 'Del av dataflyten $1 <br />Hopp til dataflytvisning: $2<br />',
	'mvBadMVDtitle'                  => 'mangler type, mangler dataflyt eller ugyldig tidsformat',
	'mvMVDFormat'                    => 'MVD-tittel burde være på formatet: mvd:type:dataflytnavn/starttid/sluttid',
	'mv_play'                        => 'Spill',
	'mv_edit'                        => 'Rediger',
	'mv_history'                     => 'Historikk',
	'mv_history_title'               => 'Redigerings- og videojusteringshistorikk',
	'mv_edit_title'                  => 'Rediger tekst',
	'mv_edit_adjust_title'           => 'Rediger tekst og videojustering',
	'mv_remove'                      => 'fjern',
	'mv_remove_title'                => 'fjern dette metadatasegmentet',
	'mv_adjust'                      => 'still inn',
	'mv_adjust_submit'               => 'Lagre innstilling',
	'mv_adjust_title'                => 'Still inn start- og sluttid',
	'mv_adjust_preview'              => 'Forhåndsvis tilpassing',
	'mv_adjust_preview_stop'         => 'Stopp forhåndsvisning',
	'mv_adjust_default_reason'       => 'still inn metavid-grensesnitt',
	'mv_adjust_old_title_missing'    => 'Siden du prøver å flytte fra ($1) finnes ikke',
	'mv_adjust_ok_move'              => 'Suksess, stiller inn...',
	'mv_start_desc'                  => 'Starttid',
	'mv_end_desc'                    => 'Sluttid',
	'mv_of'                          => '&#32;av&#32;',
	'mediasearch'                    => 'Mediesøk',
	'mv_search_sel_t'                => 'Velg søkemåte',
	'mv_run_search'                  => 'Kjør søk',
	'mv_add_filter'                  => 'Legg til filter',
	'mv_search_match'                => 'Søketekst',
	'mv_search_spoken_by'            => 'Opplest av',
	'mv_search_category'             => 'Kategori',
	'mv_search_smw_property'         => 'Semantiske verdier',
	'mv_search_smw_property_numeric' => 'Numerisk semantisk verdi',
	'mv_search_and'                  => 'og',
	'mv_search_or'                   => 'eller',
	'mv_search_not'                  => 'ikke',
	'mv_search_stream_name'          => 'Dataflytnavn',
	'mv_search_date_range'           => 'Datoområde',
	'mv_stream_name'                 => 'dataflytnavn',
	'mv_date_range'                  => 'datoområde',
	'mv_match'                       => 'treff',
	'mv_spoken_by'                   => 'opplest av',
	'mv_category'                    => 'kategori',
	'mv_search_no_results'           => 'Ingen medietreff',
	'mv_media_matches'               => 'Medietreff',
	'mv_remove_filter'               => 'fjern filter',
	'mv_advaced_search'              => 'Avansert mediesøk',
	'mv_expand_play'                 => 'Utvid og spill integrert',
	'mv_view_in_stream_interface'    => 'Vis i datastrømgrensesnitt',
	'mv_view_wiki_page'              => 'Vis wikiside',
	'mv_error_mvd_not_found'         => 'Feil: mvd ikke funnet',
	'mv_match_text'                  => '~ $1 treff',
	'mv_match_text_one'              => '~ 1 treff',
	'mv_edit_sequence'               => 'Redigerer sekvens: $1',
	'mv_sequence_player_title'       => 'sekvensspiller',
	'mv_save_sequence'               => 'Lagre sekvens',
	'mv_sequence_page_desc'          => 'Lagre nåværende sekvens',
	'mv_sequence_add'                => 'Legg til klipp',
	'mv_sequence_add_manual'         => 'Legg til etter navn',
	'mv_sequence_add_manual_desc'    => 'Legg til klipp etter dataflytnavn',
	'mv_sequence_add_search'         => 'Legg til etter søk',
	'mv_sequence_add_search_desc'    => 'Legg til klipp etter mediesøk',
	'mv_seq_add_end'                 => 'Legg til sekvensslutt',
	'mv_sequence_timeline'           => 'Sekvenstidslinje',
	'mv_edit_sequence_desc_help'     => 'Sekvensbeskrivelse',
	'mv_edithelpsequence'            => 'Help:Sekvensredigering',
	'mv_seq_summary'                 => 'Sammendrag av sekvensredigering',
	'mv_add_clip_by_name'            => 'Legg til klipp etter navn',
	'mv_export_cmml'                 => 'eksporter cmml',
	'mv_search_stream'               => 'Søk dataflyt',
	'mv_navigate_stream'             => 'Naviger full dataflyt',
	'mv_embed_options'               => 'Inkluderingsvalg',
	'mv_overlay'                     => 'Overleggkontroll',
	'mv_stream_tool_heading'         => 'Dataflytverktøy',
	'mv_tool_missing'                => 'verktøyforespørsel ($1) finnes ikke',
	'mv_bad_tool_request'            => 'dårlig verktøylinje; burde være på formen: verktøynavn|visningsnavn',
	'mv_search_stream_title'         => 'Søk i den nåværende dataflyten',
	'mv_new_ht_en'                   => 'Ny transkripsjon',
	'mv_new_anno_en'                 => 'Ny tagg eller merknad',
	'mv_mang_layers'                 => 'Behandle lag',
	'mv_mang_layers_title'           => 'Behandle lagvisningssettet for den nåværende dataflyten',
	'mv_protect_source_material'     => 'Originalt kildemateriale beskyttet mot redigeringer',
);

/** Northern Sotho (Sesotho sa Leboa)
 * @author Mohau
 */
$messages['nso'] = array(
	'mv_search_and' => 'le',
	'mv_search_or'  => 'goba',
);

/** Occitan (Occitan)
 * @author Cedric31
 * @author Siebrand
 */
$messages['oc'] = array(
	'metavid'                        => 'Pagina metavid',
	'mv_missing_stream'              => 'Flus mancant : $1',
	'mv_ogg_low_quality'             => 'Flus ogg utilizable en linha, alberjat sus metavid',
	'mv_ogg_high_quality'            => 'Flus ogg de nauta qualitat, alberjat sus metavid.',
	'mv_archive_org_link'            => 'Ligams vèrs los originals mpeg2 dins Archive.org',
	'ao_file_64Kb_MPEG4'             => 'Archive.org - mpeg4 64 kb/s',
	'ao_file_256Kb_MPEG4'            => 'Archive.org - mpeg4 256 kb/s',
	'ao_file_flash_flv'              => 'Archive.org - flash vidèo',
	'mv_error_stream_missing'        => '<span class="error">Error : existís pas cap de flus vidèo associat amb aquesta metadonada.</span><br /> Reportatz aquò sul sit d\'aministracion.',
	'mv_stream_meta'                 => 'Pagina de flus',
	'mv_add_stream'                  => "Ajust d'un flus metavid",
	'mv_edit_stream'                 => 'Modificar un flus metavid',
	'mvexportsearch'                 => 'Exportar Metavid',
	'mvexportsequence'               => 'Sequéncia d’exportacion de Metavid',
	'mvexportstream'                 => 'Flus d’exportacion de Metavid',
	'mv_add_stream_page'             => "Ajust d'un flus metavid",
	'mv_edit_strea_docu'             => "<b>Editar l'administracion dels fluses</b> <br /> per qu'un utilizaire pòsca veire o editar la pagina $1 de visualizacion.",
	'mv_add_stream_docu'             => "<p>Apondre un flus novèl amb lo camp çaijós.</p><p>Mai d'entrenhas son balhadas sus <a href=\"\$1\">la pagina d'ajuda concernent l'ajuston d'un flus.",
	'mv_add_stream_submit'           => 'Apondre un flus',
	'mv_no_stream_files'             => 'Fichièrs de flus inexistents.',
	'mv_edit_stream_files'           => 'Modificar los fichièrs de flus',
	'mv_path_type_url_anx'           => 'Adreça internet complèta del mèdia',
	'mv_path_type_wiki_title'        => 'Títol wiki del mèdia',
	'mv_path_type_label'             => 'tipe de camin',
	'mv_base_offset_label'           => 'offset de basa',
	'mv_duration_label'              => 'durada',
	'mv_file_desc_label'             => 'msg de desc del flus',
	'mv_delete_stream_file'          => 'referéncia del fichièr de flus suprimit',
	'mv_save_changes'                => 'Salvagardar las modificacions',
	'mv_file_with_same_desc'         => 'Error : fichièr de flus amb la meteissa clau de descripcion  <i>$1</i> ja presenta',
	'mv_updated_stream_files'        => 'Mesa a jorn dels enregistraments dels fichièrs de flus',
	'mv_removed_file_stream'         => 'Fichièr de flus levat : $1',
	'mv_missing_stream_text'         => 'Lo flus <b>$1</b> qu\'avètz demandat es pas disponible.<br />Vos es permes de consultar la <a href="$2">Lista dels fluses</a><br />O alara vos cal èsser autorizat a <a href="$3">Apondre lo flus</a>',
	'mv_user_cant_edit'              => 'Podètz aver $1 per modificar, $2',
	'mv_add_stream_file'             => 'Apondre un fichièr de flus',
	'mv_media_path'                  => 'camin del mèdia',
	'mv_file_list'                   => 'Fichièrs de fluses',
	'mv_label_stream_name'           => 'Nom del flus',
	'mv_label_stream_desc'           => 'Descripcion del flus',
	'add_stream_permission'          => "Vos es pas permes d'ajustar un flus novèl",
	'edit_stream_missing'            => 'Nom del flus mancant',
	'mv_missing_req_time'            => 'Omission del temps de requèsta',
	'mv_missing_cat'                 => 'Omission del nom de la categoria',
	'mv_stream_already_exists'       => 'Lo flus <a href="$2">$1</a> existís ja',
	'mv_summary_add_stream'          => 'flus ajustat per un formulari',
	'mv_error_stream_insert'         => "fracàs per l'insercion del flus",
	'mv_redirect_and_delete_reason'  => 'pagina de redireccion levada',
	'mv_remove_reason'               => 'Motiu de la supression :',
	'mv_stream_delete_warrning'      => "<b>La supression d'aqueste flus levarà tanben $1 partidas de las metadonadas associadas</b><br />",
	'mv_label_stream_type'           => 'Tipe de flus',
	'mv_metavid_file'                => 'Fichièr existent sul serveire',
	'mv_metavid_live'                => 'Installar lo flus en dirècte',
	'mv_upload_file'                 => 'Telecargar lo fichièr',
	'mv_external_file'               => 'Fichièr extèrn',
	'mv_stream_delete_warning'       => 'Suprimir aqueste flus levarà en mai $1 paginas de metadonadas',
	'mv_tool_search'                 => 'Recercar',
	'mv_tool_search_title'           => 'Recercar dins aqueste flus',
	'mv_search_transcripts_for'      => 'Recercar de transcripcions per',
	'mv_tool_navigate'               => 'Navegar',
	'mv_tool_navigate_title'         => 'Navegar dins lo flus entièr',
	'mv_tool_export'                 => 'Exportar',
	'mv_tool_export_title'           => 'Exportar las metadonadas del flus',
	'mv_tool_embed'                  => 'Inclure',
	'mv_tool_embed_title'            => 'Inclure las opcions pel segment actual demandat',
	'mv_tool_overlay'                => 'Presentacions del modèl',
	'mv_tool_overlay_title'          => 'Presentacions del modèl sus la banca de las metadonadas',
	'mv_results_found_for'           => 'Resultats de la recèrca <b>$1</b> vèrs <b>$2</b> de <b>$3</b> per :',
	'mv_tool_mang_layers'            => 'Administra los jaces',
	'mv_update_layers'               => 'met a jorn lo visionament dels jaces',
	'mv_watch_clip'                  => 'Visionar lo clip',
	'mv_close_clip'                  => 'Tampar lo clip',
	'mv_improve_transcript'          => 'Melhorar la transcripcion',
	'ht_en'                          => 'Transcriure',
	'ht_en_desc'                     => "Transcripcions anglesas. Aqueste tipe de presentacion es pel tèxt qu'es parlat amb lo flus vidèo. De ligams pòdon èsser ajustats, mas tot tèxt deuriá èsser en correlacion amb çò qu'es dich dins lo flus vidèo.",
	'anno_en'                        => 'Anotacions e categorias',
	'anno_en_desc'                   => "Anotacions e categorizacion anglesas. Aquesta presentacion pòt èsser utilizada per balisar o categorizar de seccions de vidèo o per apondre d'anotacions que son pas de tèxt parlat.",
	'thomas_en'                      => 'Transcripcion oficiala',
	'thomas_en_desc'                 => "Transcripcion oficiala de Thomas del servici THOMAS d'enregistrament dels govèrnaments. Data de la font sincronizada per c-spanarchives.org de C-SPAN.",
	'mvd_default_mismatch'           => 'Error dins la configuracion del fichièr',
	'mvd_default_mismatch_text'      => 'Una error s\'es introdusida dins vòstre fichièr de configuracion : $mvMVDTypeDefaultDisp auriá degut èsser un sosparamètre de $mvMVDTypeAllAvailable.',
	'mv_data_page_title'             => '$1 per $2 a partir de $3',
	'mv_time_separator'              => '$1 vèrs $2',
	'mv_list_streams'                => 'Lista dels fluses de metavid',
	'mv_list_streams_page'           => 'Lista dels fluses de metavid',
	'mv_list_streams_docu'           => 'Lo flus seguent existís :',
	'mv_list_streams_none'           => 'Cap de flus existís pas :',
	'mvvideofeed'                    => "Alimentacion de l'expòrt de la vidèo metavid",
	'mvexportask'                    => 'Exportacion d’un fial vidèo semantic',
	'video_feed_cat'                 => 'Alimentacion de la vidèo per la categoria :',
	'mv_cat_search_note'             => 'Nòta : las categorias listan pas que las del nivèl mai naut, per tota recèrca de metadonadas dins los gropes de categorias per $1',
	'mv_mvd_linkback'                => 'Partida del flus $1 <br />Saut vèrs lo visionament del flus : $2<br />',
	'mvBadMVDtitle'                  => 'tipe mancant, flus mancant, o format de durada pas confòrme.',
	'mvMVDFormat'                    => 'Lo títol de metavid deuriá èsser al format : mvd:type:nom_del_flus/durada_començament/durada_fin',
	'mv_play'                        => 'Jogar',
	'mv_edit'                        => 'Modificar',
	'mv_history'                     => 'Istoric',
	'mv_history_title'               => "Edicion e istoric de l'alinhament vidèo",
	'mv_edit_title'                  => 'Modificar lo tèxt',
	'mv_edit_adjust_title'           => "Modificar lo tèxt e l'alinhament vidèo",
	'mv_remove'                      => 'levar',
	'mv_remove_title'                => 'levar aqueste segment de metadonadas',
	'mv_adjust'                      => 'apondre',
	'mv_adjust_submit'               => "Salvagardar l'ajustament",
	'mv_adjust_title'                => 'Apondre lo començament e la fin de la durada',
	'mv_adjust_preview'              => "Previsualizar l'ajustament",
	'mv_adjust_preview_stop'         => 'Arrestar la previsualizacion',
	'mv_adjust_default_reason'       => "Ajustament de l'interfàcia metavid",
	'mv_adjust_old_title_missing'    => 'La pagina que sètz a desplaçar dempuèi ($1) existís pas.',
	'mv_adjust_ok_move'              => 'Succès, ajustament...',
	'mv_start_desc'                  => 'Durada al començament',
	'mv_end_desc'                    => 'Durada a la fin',
	'mv_of'                          => '&#32;de&#32;',
	'mediasearch'                    => 'Recèrca del mèdia',
	'mv_search_sel_t'                => 'Causir lo mòde de recèrca',
	'mv_run_search'                  => 'Amodar la recèrca',
	'mv_add_filter'                  => 'Apondre un filtre',
	'mv_search_match'                => 'Recercar lo tèxt',
	'mv_search_spoken_by'            => 'Parlat per',
	'mv_search_category'             => 'Categoria',
	'mv_search_smw_property'         => 'Proprietat de Semantic',
	'mv_search_smw_property_numeric' => 'Valor numerica de Semantic',
	'mv_search_and'                  => 'e',
	'mv_search_or'                   => 'o',
	'mv_search_not'                  => 'non',
	'mv_search_stream_name'          => 'Nom del flus',
	'mv_search_date_range'           => 'Forqueta de data',
	'mv_stream_name'                 => 'nom del flus',
	'mv_date_range'                  => 'forqueta de data',
	'mv_match'                       => 'assortir',
	'mv_spoken_by'                   => 'parlat per',
	'mv_category'                    => 'categoria',
	'mv_search_no_results'           => 'Cap de mèdia pas assortit',
	'mv_media_matches'               => 'Mèdias assortits',
	'mv_remove_filter'               => 'levar lo filtre',
	'mv_advaced_search'              => 'Recèrca avançada de mèdias',
	'mv_expand_play'                 => 'Desvolopar e jogar en linha',
	'mv_view_in_stream_interface'    => "Veire dins l'interfàcia del flus",
	'mv_view_wiki_page'              => 'Veire la pagina wiki',
	'mv_error_mvd_not_found'         => 'Error, cap de metavid pas trobada',
	'mv_match_text'                  => '~ $1 similituds',
	'mv_match_text_one'              => '~ 1 ocuréncia',
	'mv_edit_sequence'               => 'Edicion de la sequéncia : $1',
	'mv_sequence_player_title'       => 'lector de sequéncia',
	'mv_save_sequence'               => 'Salvagardar la sequéncia',
	'mv_sequence_page_desc'          => 'Salvagardar la sequéncia actuala',
	'mv_sequence_add'                => 'Apondre de clips',
	'mv_sequence_add_manual'         => 'Apondre per nom',
	'mv_sequence_add_manual_desc'    => 'Apondre de clips per nom de flus',
	'mv_sequence_add_search'         => 'Apondre per recèrca',
	'mv_sequence_add_search_desc'    => 'Apondre de clips per recèrca de mèdias',
	'mv_seq_add_end'                 => 'Apondre a la fin de la sequéncia',
	'mv_sequence_timeline'           => 'Sequéncia cronologica :',
	'mv_edit_sequence_desc_help'     => 'Descripcion de la sequéncia',
	'mv_edithelpsequence'            => 'Ajuda:Edicion_de_sequéncia',
	'mv_seq_summary'                 => 'Edicion del somari de la sequéncia',
	'mv_add_clip_by_name'            => 'Apondre un clip per nom',
	'mv_export_cmml'                 => 'exportar cmml',
	'mv_search_stream'               => 'Recercar lo flus',
	'mv_navigate_stream'             => 'Navegar dins lo flus entièr',
	'mv_embed_options'               => "Opcion d'incrustacion",
	'mv_overlay'                     => 'Contraròtles de cobertura',
	'mv_stream_tool_heading'         => 'Espleches pels fluses',
	'mv_tool_missing'                => "la requèsta de l'esplech ($1) existís pas",
	'mv_bad_tool_request'            => 'una linha de comanda marrida poiriá èsser formulada : nom_esplech|afichatge_nom_esplech',
	'mv_search_stream_title'         => 'Recercar lo flus actual',
	'mv_new_ht_en'                   => 'Transcripcion novèla',
	'mv_new_anno_en'                 => 'Balisa o anotacion novèla',
	'mv_mang_layers'                 => 'Administra los jaces',
	'mv_mang_layers_title'           => "Gerís los paramètres d'afichatge de la jaça pel flus corrent",
	'mv_protect_source_material'     => 'Original protegit en escritura',
);

/** Ossetic (Иронау)
 * @author Amikeco
 */
$messages['os'] = array(
	'mv_upload_file'     => 'Ног файл сæвæр',
	'mv_search_category' => 'Категори',
	'mv_category'        => 'категори',
);

/** Polish (Polski)
 * @author McMonster
 * @author Sp5uhe
 */
$messages['pl'] = array(
	'mv_save_changes'      => 'Zapisz zmiany',
	'mv_label_stream_type' => 'Typ strumienia',
	'mv_remove'            => 'usuń',
);

/** Pashto (پښتو)
 * @author Ahmed-Najib-Biabani-Ibrahimkhel
 */
$messages['ps'] = array(
	'mv_save_changes'    => 'بدلونونه خوندي کول',
	'mv_upload_file'     => 'دوتنه پورته کول',
	'mv_external_file'   => 'باندنۍ دوتنه',
	'mv_tool_search'     => 'پلټل',
	'mv_play'            => 'غږول',
	'mv_history'         => 'پېښليک',
	'mv_remove'          => 'غورځول',
	'mv_start_desc'      => 'د پيل وخت',
	'mv_end_desc'        => 'د پای وخت',
	'mediasearch'        => 'د رسنيو لټون',
	'mv_search_category' => 'وېشنيزه',
	'mv_search_and'      => 'او',
	'mv_search_or'       => 'يا',
	'mv_category'        => 'وېشنيزه',
);

/** Portuguese (Português)
 * @author Malafaya
 * @author 555
 * @author Lijealso
 * @author Cedric31
 */
$messages['pt'] = array(
	'metavid'                        => 'Página Metavid',
	'mv_missing_stream'              => 'Stream não localizado: $1',
	'mv_ogg_low_quality'             => 'Ogg Theora para Stream Web, armazenado em metavid',
	'mv_ogg_high_quality'            => 'Ogg Theora de Alta Qualidade, armazenado em metavid',
	'mv_archive_org_link'            => 'Liga para os originais mpeg2 de Archive.org',
	'mv_error_stream_missing'        => '<span class="error">Erro: Não há um ficheiro de vídeo associado com este stream.</span><br />Por favor, reporte este facto ao administrador do sítio.',
	'mv_stream_meta'                 => 'Página de stream',
	'mv_add_stream'                  => 'Adicionar Stream Metavid',
	'mv_edit_stream'                 => 'Editar Stream Metavid',
	'mvexportsearch'                 => 'Exportar Metavid',
	'mvexportsequence'               => 'Exportar Sequência Metavid',
	'mvexportstream'                 => 'Exportar Stream Metavid',
	'mv_add_stream_page'             => 'Adicionar Stream Mv',
	'mv_edit_strea_docu'             => '<p>Editar <b>administração</b> de stream<br />para visualização/edição por utilizadores normais, veja a página $1',
	'mv_add_stream_docu'             => '<p>Adicionar uma nova stream com o campo abaixo.</p>
<p>Mais informação é dada na <a href="$1">página de ajuda de adição de streams</a>.</p>',
	'mv_add_stream_submit'           => 'Adicionar stream',
	'mv_no_stream_files'             => 'Ficheiros de Stream não existentes',
	'mv_edit_stream_files'           => 'Editar ficheiros de stream',
	'mv_path_type_url_anx'           => 'url da media completa',
	'mv_path_type_wiki_title'        => 'título wiki da media',
	'mv_path_type_label'             => 'tipo de caminho',
	'mv_base_offset_label'           => 'desvio da base',
	'mv_duration_label'              => 'duração',
	'mv_file_desc_label'             => 'msg de desc da stream',
	'mv_delete_stream_file'          => 'eliminar referência a ficheiro de stream',
	'mv_save_changes'                => 'Salvar alterações',
	'mv_file_with_same_desc'         => 'Erro: ficheiro de stream com mesma chave de descrição <i>$1</i> já presente',
	'mv_removed_file_stream'         => 'Foi removido o ficheiro de stream: $1',
	'mv_user_cant_edit'              => 'Poderá ter que $1 para editar, $2',
	'mv_add_stream_file'             => 'Adicionar ficheiro de stream',
	'mv_media_path'                  => 'caminho da media',
	'mv_file_list'                   => 'Ficheiros de stream',
	'mv_label_stream_name'           => 'Nome do stream',
	'mv_label_stream_desc'           => 'Descrição do stream',
	'add_stream_permission'          => 'Você não possui permissões para adicionar um novo stream',
	'edit_stream_missing'            => 'Falta nome de stream',
	'mv_missing_req_time'            => 'Tempo do pedido não especificado',
	'mv_missing_cat'                 => 'Nome de categoria não especificado',
	'mv_stream_already_exists'       => 'A stream <a href="$2">$1</a> já existe',
	'mv_summary_add_stream'          => 'stream adicionada através de formulário',
	'mv_error_stream_insert'         => 'falhou inserção de stream',
	'mv_redirect_and_delete_reason'  => 'página de redireccionamento removida',
	'mv_remove_reason'               => 'Motivo da eliminação:',
	'mv_label_stream_type'           => 'Tipo de stream',
	'mv_metavid_file'                => 'Ficheiro existente no servidor',
	'mv_upload_file'                 => 'Enviar ficheiro',
	'mv_external_file'               => 'Ficheiro externo',
	'mv_tool_search'                 => 'Pesquisa',
	'mv_tool_search_title'           => 'Procurar neste stream',
	'mv_tool_navigate'               => 'Navegação',
	'mv_tool_navigate_title'         => 'Navegar pelo stream completo',
	'mv_tool_export'                 => 'Exportar',
	'mv_tool_export_title'           => 'Exportar metadados do stream',
	'mv_results_found_for'           => 'Resultados de Busca <b>$1</b> a <b>$2</b> de <b>$3</b> para:',
	'mv_tool_mang_layers'            => 'Gerir camadas',
	'mv_update_layers'               => 'actualizar vista de camadas',
	'mv_watch_clip'                  => 'Ver Clip',
	'mv_close_clip'                  => 'Fechar Clip',
	'ht_en'                          => 'Transcrição',
	'ht_en_desc'                     => 'Transcrições inglesas. Este tipo de overlay é para texto falado.',
	'anno_en'                        => 'Anotações e Categorias',
	'thomas_en'                      => 'Transcrição oficial',
	'thomas_en_desc'                 => 'Transcrição Thomas oficial do serviço de registo THOMAS do governo.
Hora fonte sincronizada por c-spanarchives.org da C-SPAN',
	'mvd_default_mismatch'           => 'Erro no ficheiro de configuração',
	'mvd_default_mismatch_text'      => 'Há um erro no seu ficheiro de configuração.
$mvMVDTypeDefaultDisp deverá ser um subconjunto de $mvMVDTypeAllAvailable',
	'mv_data_page_title'             => '$1 para $2 de $3',
	'mv_time_separator'              => '$1 a $2',
	'mv_list_streams_page'           => 'Listar streams mv',
	'mv_list_streams_docu'           => 'Os seguintes streams se encontram disponíveis:',
	'mv_list_streams_none'           => 'Não há streams disponíveis',
	'video_feed_cat'                 => '"Feed" de vídeo para a Categoria:',
	'mv_cat_search_note'             => "Nota: 'Categorias' apenas lista categorias de nível de topo.
Para todos os metadados no intervalo de categorias, procure por $1",
	'mvMVDFormat'                    => 'O título MVD deverá estar no formato: mvd:type:nome_da_stream/tempo_início/tempo_fim',
	'mv_play'                        => 'Tocar',
	'mv_edit'                        => 'Editar',
	'mv_history'                     => 'Histórico',
	'mv_history_title'               => 'Histórico de Edição e Alinhamento de Vídeo',
	'mv_edit_title'                  => 'Editar texto',
	'mv_edit_adjust_title'           => 'Editar texto e alinhamento de vídeo',
	'mv_remove'                      => 'remover',
	'mv_adjust'                      => 'apondre',
	'mv_adjust_submit'               => 'Salvar ajuste',
	'mv_adjust_title'                => 'Ajustar tempo de início e fim',
	'mv_adjust_preview'              => 'Prever ajuste',
	'mv_adjust_preview_stop'         => 'Interromper a previsão',
	'mv_adjust_old_title_missing'    => 'A página a partir da qual está a tentar mover ($1) não existe',
	'mv_adjust_ok_move'              => 'Sucesso, ajustando...',
	'mv_start_desc'                  => 'Tempo de início',
	'mv_end_desc'                    => 'Tempo de término',
	'mv_of'                          => '&#32;de&#32;',
	'mediasearch'                    => 'Pesquisa de multimédia',
	'mv_search_sel_t'                => 'Seleccionar tipo de pesquisa',
	'mv_run_search'                  => 'Efectuar pesquisa',
	'mv_add_filter'                  => 'Adicionar filtro',
	'mv_search_match'                => 'Procurar Texto',
	'mv_search_spoken_by'            => 'Falado por',
	'mv_search_category'             => 'Categoria',
	'mv_search_smw_property'         => 'Propriedades semânticas',
	'mv_search_smw_property_numeric' => 'Valor semântico numérico',
	'mv_search_and'                  => 'e',
	'mv_search_or'                   => 'ou',
	'mv_search_not'                  => 'não',
	'mv_search_stream_name'          => 'Nome de Stream',
	'mv_search_date_range'           => 'Intervalo de datas',
	'mv_stream_name'                 => 'nome da "stream"',
	'mv_date_range'                  => 'intervalo de datas',
	'mv_category'                    => 'categoria',
	'mv_remove_filter'               => 'remover filtro',
	'mv_advaced_search'              => 'Pesquisa avançada de multimédia',
	'mv_view_in_stream_interface'    => 'Ver na interface de stream',
	'mv_view_wiki_page'              => 'Ver página wiki',
	'mv_match_text'                  => '~  $1 resultados',
	'mv_match_text_one'              => '~ 1 resultado',
	'mv_edit_sequence'               => 'Editando Sequência:$1',
	'mv_save_sequence'               => 'Salvar sequência',
	'mv_sequence_page_desc'          => 'Salva a sequência atual',
	'mv_sequence_add'                => 'Adicionar clipes',
	'mv_sequence_add_manual'         => 'Adicionar pelo nome',
	'mv_sequence_add_manual_desc'    => 'Adiciona clipes pelo nome do stream',
	'mv_sequence_add_search'         => 'Adicionar por pesquisa',
	'mv_sequence_add_search_desc'    => 'Adicionar clipes através de pesquisa por multimédias',
	'mv_seq_add_end'                 => 'Adicionar ao Fim da Sequência',
	'mv_sequence_timeline'           => 'Linha temporal da sequência:',
	'mv_edit_sequence_desc_help'     => 'Descrição da sequência',
	'mv_seq_summary'                 => 'Sumário de edição da sequência',
	'mv_add_clip_by_name'            => 'Adicionar clip por nome',
	'mv_navigate_stream'             => 'Navegar stream completa',
	'mv_stream_tool_heading'         => 'Ferramentas de Stream',
	'mv_tool_missing'                => 'pedido de ferramenta ($1) não existe',
	'mv_search_stream_title'         => 'Pesquisar Stream Actual',
	'mv_new_anno_en'                 => 'Nova marca ou anotação',
	'mv_mang_layers'                 => 'Gerir Camadas',
	'mv_mang_layers_title'           => "Gerir o conjunto de visualização de camadas para a 'stream' actual",
	'mv_protect_source_material'     => 'Material fonte original protegido contra edições',
);

/** Russian (Русский)
 * @author .:Ajvol:.
 * @author Siebrand
 */
$messages['ru'] = array(
	'metavid'                        => 'Страница Metavid',
	'mv_missing_stream'              => 'Ошибка в потоке: $1',
	'mv_ogg_low_quality'             => 'Веб-поток ogg theora, находится на metavid',
	'mv_ogg_high_quality'            => 'Высококачественный ogg theora, находится на metavid',
	'mv_archive_org_link'            => 'Ссылки на Archive.org mpeg2 оригиналы',
	'mv_error_stream_missing'        => '<span class="error">Ошибка. Нет видео-файла, связанного с этим потоком.</span><br />Пожалуйста, сообщите об этом администратору сайта.',
	'mv_stream_meta'                 => 'Страница потока',
	'mv_add_stream'                  => 'Metavid добавить поток',
	'mv_edit_stream'                 => 'Metavid править поток',
	'mvexportsearch'                 => 'Экспорт Metavid',
	'mvexportsequence'               => 'Последовательность экспорта Metavid',
	'mvexportstream'                 => 'Поток экспорта Metavid',
	'mv_add_stream_page'             => 'Mv добавить поток',
	'mv_edit_strea_docu'             => '<p>Править поток. <b>Администратор</b><br />см. страницу $1 для обычного просмотра или правки',
	'mv_add_stream_docu'             => '<p>Добавить новый поток в поле ниже.</p><p>Более подробная информация даётся на <a href="$1">справочной странице о добавлении потока</a>.</p>',
	'mv_add_stream_submit'           => 'Добавить поток',
	'mv_no_stream_files'             => 'Нет существующих потоковых файлов',
	'mv_edit_stream_files'           => 'Править потоковые файлы',
	'mv_path_type_url_anx'           => 'полный адрес медиа',
	'mv_path_type_wiki_title'        => 'вики-название медиа',
	'mv_path_type_label'             => 'тип пути',
	'mv_base_offset_label'           => 'основное смещение',
	'mv_duration_label'              => 'длительность',
	'mv_file_desc_label'             => 'поток опис сбщ',
	'mv_delete_stream_file'          => 'удалить ссылку на потоковый файл',
	'mv_save_changes'                => 'Сохранить изменения',
	'mv_file_with_same_desc'         => 'Ошибка. Потоковый файл с таким же ключом описания <i>$1</i> уже существует.',
	'mv_updated_stream_files'        => 'Обновленная запись о потоковых файлах',
	'mv_removed_file_stream'         => 'Удалённый потоковый файл: $1',
	'mv_missing_stream_text'         => 'Запрошенный вами поток <b>$1</b> не доступен.<br />Вы можете просмотреть <a href="$2">список потоков</a><br />или <a href="$3">добавить поток</a>.',
	'mv_user_cant_edit'              => 'Вам следует $1 чтобы вносить правки, $2',
	'mv_add_stream_file'             => 'Добавить потоковый файл',
	'mv_media_path'                  => 'путь к медиа',
	'mv_file_list'                   => 'Потоковые файлы',
	'mv_label_stream_name'           => 'Имя потока',
	'mv_label_stream_desc'           => 'Описание потока',
	'add_stream_permission'          => 'У вас недостаточно прав, чтобы добавить новый поток',
	'edit_stream_missing'            => 'Ошибочное имя потока',
	'mv_missing_req_time'            => 'Ошибочное время запроса',
	'mv_missing_cat'                 => 'Ошибочное имя категории',
	'mv_stream_already_exists'       => 'Поток <a href="$2">$1</a> уже существует',
	'mv_summary_add_stream'          => 'поток добавлен через форму',
	'mv_error_stream_insert'         => 'ошибка при вставке потока',
	'mv_redirect_and_delete_reason'  => 'удалённая страница перенаправления',
	'mv_remove_reason'               => 'Причина удаления:',
	'mv_stream_delete_warrning'      => '<b>При удалении этого потока будут также удалены $1 частей связанных метаданных</b><br />',
	'mv_label_stream_type'           => 'Тип потока',
	'mv_metavid_file'                => 'Существующий файл на сервере',
	'mv_metavid_live'                => 'Установить живой поток',
	'mv_upload_file'                 => 'Загрузить файл',
	'mv_external_file'               => 'Внешний файл',
	'mv_stream_delete_warning'       => 'Удаление этого потока приведёт к удалению $1 страниц метаданных',
	'mv_tool_search'                 => 'Поиск',
	'mv_tool_search_title'           => 'Поиск в этом потоке',
	'mv_search_transcripts_for'      => 'Поиск стенограммы для',
	'mv_tool_navigate'               => 'Навигация',
	'mv_tool_navigate_title'         => 'Навигация по полному потоку',
	'mv_tool_export'                 => 'Экспорт',
	'mv_tool_export_title'           => 'Экспортирование метаданных потока',
	'mv_tool_embed'                  => 'Встроить',
	'mv_tool_embed_title'            => 'Настройки вставки текущего запрошенного куска',
	'mv_tool_overlay'                => 'Шаблонные наложения',
	'mv_tool_overlay_title'          => 'Наложения метаданных на основе шаблонов',
	'mv_results_found_for'           => 'Результаты поиска с <b>$1</b> по <b>$2</b> из <b>$3</b> для:',
	'mv_tool_mang_layers'            => 'Управление слоями',
	'mv_update_layers'               => 'обновить вид слоёв',
	'ht_en'                          => 'Стенограмма',
	'ht_en_desc'                     => 'Английская расшифровка стенограммы. Этот тип наложения предназначен для текста, который говорится в видео-потоке. Могут быть добавлены ссылки, но весь текст должен соответствовать тому, что говорят в видео-потоке.',
	'anno_en'                        => 'Аннотации и категории',
	'anno_en_desc'                   => 'Английские категоризации и аннотации. Это наложение может использоваться чтобы категоризовать части видео, или добавлять аннотации, не являющиеся проговоренным текстом.',
	'thomas_en'                      => 'Официальная стенограмма',
	'thomas_en_desc'                 => 'Официальная стенограмма Thomas из государственной службы записей THOMAS.
Время синхронизировано с помощью C-SPAN c-spanarchives.org',
	'mvd_default_mismatch'           => 'Ошибка в файле настроек',
	'mvd_default_mismatch_text'      => 'В вашем файле настроек обнаружена ошибка.
$mvMVDTypeDefaultDisp должен быть подмножеством $mvMVDTypeAllAvailable',
	'mv_data_page_title'             => '$1 для $2 из $3',
	'mv_time_separator'              => '$1 по $2',
	'mv_list_streams'                => 'Metavid список потоков',
	'mv_list_streams_page'           => 'Mv список потоков',
	'mv_list_streams_docu'           => 'Существуют следующие потоки:',
	'mv_list_streams_none'           => 'Потоков не существует',
	'mvvideofeed'                    => 'Metavid экспорт видео-канала',
	'video_feed_cat'                 => 'Видео-канал для категории:',
	'mv_cat_search_note'             => 'Замечание. Категории показывают только списки категорий верхнего уровня, для всех метаданных в диапазоне категорий ищите $1',
	'mv_mvd_linkback'                => 'Часть потока $1 <br />Перейти к просмотру потока: $2<br />',
	'mvBadMVDtitle'                  => 'ошибочный тип, поток отсутствует или неверный формат времени',
	'mvMVDFormat'                    => 'MVD-заголовок должен быть в следующем формате: mvd:тип:имя_потока/время_начала/время_окончания',
	'mv_play'                        => 'Воспроизвести',
	'mv_edit'                        => 'Править',
	'mv_history'                     => 'История',
	'mv_history_title'               => 'История правок и видео-регулировки',
	'mv_edit_title'                  => 'Править текст',
	'mv_edit_adjust_title'           => 'Правка текста и видео-регулировок',
	'mv_remove'                      => 'удалить',
	'mv_remove_title'                => 'удалить этот кусок метаданных',
	'mv_adjust'                      => 'настроить',
	'mv_adjust_submit'               => 'Сохранить настройку',
	'mv_adjust_title'                => 'Настройка времени начала и остановки',
	'mv_adjust_preview'              => 'Настройка предпросмотра',
	'mv_adjust_preview_stop'         => 'Остановить предпросмотр',
	'mv_adjust_default_reason'       => 'metavid настройка интерфейса',
	'mv_adjust_old_title_missing'    => 'Страницы $1, которую вы пытаетесь переименовать, не существует.',
	'mv_adjust_ok_move'              => 'Успешно, настройка...',
	'mv_start_desc'                  => 'Время начала',
	'mv_end_desc'                    => 'Время окончания',
	'mv_of'                          => '&#32;из&#32;',
	'mediasearch'                    => 'Поиск медиа',
	'mv_search_sel_t'                => 'Выбор типа поиска',
	'mv_run_search'                  => 'Запустить поиск',
	'mv_add_filter'                  => 'Добавить фильтр',
	'mv_search_match'                => 'Текст запроса',
	'mv_search_spoken_by'            => 'Говорит',
	'mv_search_category'             => 'Категория',
	'mv_search_smw_property'         => 'Семантические свойства',
	'mv_search_smw_property_numeric' => 'Числовое семантическое значение',
	'mv_search_and'                  => 'и',
	'mv_search_or'                   => 'или',
	'mv_search_not'                  => 'не',
	'mv_search_stream_name'          => 'Имя потока',
	'mv_search_date_range'           => 'Диапазон дат',
	'mv_stream_name'                 => 'имя потока',
	'mv_date_range'                  => 'диапазон дат',
	'mv_match'                       => 'соответствие',
	'mv_spoken_by'                   => 'говорит',
	'mv_category'                    => 'категория',
	'mv_search_no_results'           => 'Нет совпадений медиа',
	'mv_media_matches'               => 'Совпадения медиа',
	'mv_remove_filter'               => 'удалить фильтр',
	'mv_advaced_search'              => 'Расширенный поиск медиа',
	'mv_expand_play'                 => 'Расширить и воспроизвести на месте',
	'mv_view_in_stream_interface'    => 'Просмотреть в интерфейса потока',
	'mv_view_wiki_page'              => 'Просмотреть вики-страницу',
	'mv_error_mvd_not_found'         => 'Ошибка. Mvd не найден',
	'mv_match_text'                  => '~  $1 соответствий',
	'mv_match_text_one'              => '~ 1 соответствие',
	'mv_edit_sequence'               => 'Правка последовательности:$1',
	'mv_sequence_player_title'       => 'проигрыватель последовательности',
	'mv_save_sequence'               => 'Сохранить последовательность',
	'mv_sequence_page_desc'          => 'Сохранить текущую последовательность',
	'mv_sequence_add'                => 'Добавить клип',
	'mv_sequence_add_manual'         => 'Добавить по имени',
	'mv_sequence_add_manual_desc'    => 'Добавить клип по имени потока',
	'mv_sequence_add_search'         => 'Добавить поиском',
	'mv_sequence_add_search_desc'    => 'Добавить клипы с помощью поиска медиа',
	'mv_seq_add_end'                 => 'Добавить в конец последовательности',
	'mv_sequence_timeline'           => 'Шкала времени последовательности:',
	'mv_edit_sequence_desc_help'     => 'Описание последовательности',
	'mv_edithelpsequence'            => 'Справка:Правка последовательности',
	'mv_seq_summary'                 => 'Описание правки последовательности',
	'mv_add_clip_by_name'            => 'Добавление клипа по имени',
	'mv_export_cmml'                 => 'экспорт cmml',
	'mv_search_stream'               => 'Поиск потока',
	'mv_navigate_stream'             => 'Навигация по полному потоку',
	'mv_embed_options'               => 'Настройки вставки',
	'mv_overlay'                     => 'Управление наложениями',
	'mv_stream_tool_heading'         => 'Инструменты потока',
	'mv_tool_missing'                => 'запрос инструмента ($1) не существует',
	'mv_bad_tool_request'            => 'плохая инструментная строка, должен быть формат: название_инструмента|отображаемое_название_инструмента',
	'mv_search_stream_title'         => 'Искать текущий поток',
	'mv_new_ht_en'                   => 'Новая стенограмма',
	'mv_new_anno_en'                 => 'Новая метка или аннотация',
	'mv_mang_layers'                 => 'Управление слоями',
	'mv_mang_layers_title'           => 'Управление набором отображаемых слоёв для текущего потока',
	'mv_protect_source_material'     => 'Оригинальный исходный материал закрыт от правок',
);

/** Slovak (Slovenčina)
 * @author Helix84
 * @author Siebrand
 */
$messages['sk'] = array(
	'metavid'                        => 'Stránka Metavid',
	'mv_missing_stream'              => 'Chýbajúci stream: $1',
	'mv_ogg_low_quality'             => 'Streamovateľný ogg theora, hosťovaný na metavid',
	'mv_ogg_high_quality'            => 'Ogg theora vo vysokej kvalite, hosťovaný na metavid',
	'mv_archive_org_link'            => 'Odkazy do mpeg2 originálov na Archive.org',
	'mv_error_stream_missing'        => '<span class="error">Chyba: Neexistuje video súbor asociovaný s týmito metadátami.</span><br />
Prosím, oznámte to správcovi webovej lokality.',
	'mv_stream_meta'                 => 'Stránka streamu',
	'mv_add_stream'                  => 'Metavid Pridať stream',
	'mv_edit_stream'                 => 'Metavid Upraviť stream',
	'mvexportsearch'                 => 'Export Metavid',
	'mvexportsequence'               => 'Export Metavid sekvencie',
	'mvexportstream'                 => 'Export Metavid streamu',
	'mv_add_stream_page'             => 'Mv Pridať stream',
	'mv_edit_strea_docu'             => '<p>Upraviť stream, <b>správca</b><br />
prehliadanie/úprava pre bežného používateľa na stránke $1',
	'mv_add_stream_docu'             => '<p>V poli dolu pridajte nový stream.</p><p>Viac informácií na <a href="$1">stránke pomocníka pre pridanie nového streamu</a>.</p>',
	'mv_add_stream_submit'           => 'Pridať stream',
	'mv_no_stream_files'             => 'Žiadne existujúce súbory streamov',
	'mv_edit_stream_files'           => 'Upraviť súbory streamov',
	'mv_path_type_url_anx'           => 'plný url multimédia',
	'mv_path_type_wiki_title'        => 'názov wiki média',
	'mv_path_type_label'             => 'typ cesty',
	'mv_base_offset_label'           => 'ofset počiatku',
	'mv_duration_label'              => 'trvanie',
	'mv_file_desc_label'             => 'správa popisujúca stream',
	'mv_delete_stream_file'          => 'zmazať odkaz na súbor streamu',
	'mv_save_changes'                => 'Uložiť zmeny',
	'mv_file_with_same_desc'         => 'Chyba: súbor streamu s rovnakým popisným kľúčom <i>$1</i> už existuje',
	'mv_updated_stream_files'        => 'Záznam súborov streamu bol aktualizovaný',
	'mv_removed_file_stream'         => 'Bol odstránený súbor streamu: $1',
	'mv_missing_stream_text'         => 'Stream, ktorý ste žiadali <b>$1</b> nie je dostupný.<br />
Možno sa budete chcieť pozrieť do <a href="$2">Zoznamu streamov</a><br />
Alebo môžete <a href="$3">Pridať stream</a>.',
	'mv_user_cant_edit'              => 'Možno sa budete musieť $1, aby ste mohli upravovať; $2',
	'mv_add_stream_file'             => 'Pridať súbor streamu',
	'mv_media_path'                  => 'cesta k multimédiu',
	'mv_file_list'                   => 'Súbory streamu',
	'mv_label_stream_name'           => 'Názov streamu',
	'mv_label_stream_desc'           => 'Popis streamu',
	'add_stream_permission'          => 'Nemáte oprávnenie pridávať nový stream',
	'edit_stream_missing'            => 'Chýba názov streamu',
	'mv_missing_req_time'            => 'Chýba čas požiadavky',
	'mv_missing_cat'                 => 'Chýba názov kategórie',
	'mv_stream_already_exists'       => 'Stream <a href="$2">$1</a> už existuje',
	'mv_summary_add_stream'          => 'stream bol pridaný pomocou formulára',
	'mv_error_stream_insert'         => 'nepodarilo sa vložiť stream',
	'mv_redirect_and_delete_reason'  => 'stránka presmerovania odstránená',
	'mv_remove_reason'               => 'Dôvod zmazania:',
	'mv_stream_delete_warrning'      => '<b>Odstránením tohto streamu tiež odstránite $1 asociovaných metadát</b><br />',
	'mv_label_stream_type'           => 'Typ streamu',
	'mv_metavid_file'                => 'Existujúci súbor na serveri',
	'mv_metavid_live'                => 'Nastaviť live stream',
	'mv_upload_file'                 => 'Nahrať súbor',
	'mv_external_file'               => 'Externý súbor',
	'mv_stream_delete_warning'       => 'Zmazaním tohto streamu zmažete aj $1 stránok metadát',
	'mv_tool_search'                 => 'Hľadať',
	'mv_tool_search_title'           => 'Hľadať v rámci tohto streamu',
	'mv_search_transcripts_for'      => 'Hľadať v prepisoch',
	'mv_tool_navigate'               => 'Navigovať',
	'mv_tool_navigate_title'         => 'Navigovať v celom streame',
	'mv_tool_export'                 => 'Export',
	'mv_tool_export_title'           => 'Exportovať metadáta streamu',
	'mv_tool_embed'                  => 'Vložiť',
	'mv_tool_embed_title'            => 'Voľby pre vloženie momentálne vyžiadaného úseku',
	'mv_tool_overlay'                => 'Prekrývanie šablónami',
	'mv_tool_overlay_title'          => 'Prekrývanie metadát šablónami',
	'mv_results_found_for'           => 'Výsledny vyhľadávania <b>$1</b> až <b>$2</b> z <b>$3</b>:',
	'mv_tool_mang_layers'            => 'Spravovať vrstvy',
	'mv_update_layers'               => 'aktualizovať zobrazenie vrstiev',
	'mv_watch_clip'                  => 'Sledovať klip',
	'mv_close_clip'                  => 'Zatvoriť klip',
	'mv_improve_transcript'          => 'Vylepšiť prepis',
	'ht_en'                          => 'Prepis',
	'ht_en_desc'                     => 'Anglické prepisy. Tento typ prekladania je pre text, ktorý je v streame hovorený. Je možné pridávať odkazy, ale text by mal byť len to, čo sa hovorí vo video streame.',
	'anno_en'                        => 'Komentáre a kategórie',
	'anno_en_desc'                   => 'Anglická kategorizácia a poznámky. Toto preloženie je možné použiť na kategorizáciu úsekov videa alebo na pridanie popisnej informácie, ktorá nie je hovorený text.',
	'thomas_en'                      => 'Oficiálny prepis',
	'thomas_en_desc'                 => 'Oficiálny prepis z vládnej služby záznamov THOMAS. Synchronizácia zdrojového času C-SPAN (c-spanarchives.org).',
	'mvd_default_mismatch'           => 'Chyba v súbore nastavení',
	'mvd_default_mismatch_text'      => 'Vo vašom súbore nastavení je chyba, $mvMVDTypeDefaultDisp by malo byť podmnožinou $mvMVDTypeAllAvailable',
	'mv_data_page_title'             => '$1 pre $2 z $3',
	'mv_time_separator'              => '$1 až $2',
	'mv_list_streams'                => 'Zoznam streamov Metavid',
	'mv_list_streams_page'           => 'Mv Zoznam streamov',
	'mv_list_streams_docu'           => 'Existujú nasledovné streamy:',
	'mv_list_streams_none'           => 'Neexistujú žiadne streamy',
	'mvvideofeed'                    => 'Metavid Export videokanála',
	'mvexportask'                    => 'Export kanála Semantic Video',
	'video_feed_cat'                 => 'Videokanál kategórie:',
	'mv_cat_search_note'             => 'Pozn.: Medzi kategóriami sú iba kategórie najvyššej úrovne, všetky metadáta v kategórii nájdete vyhľadávaním $1',
	'mv_mvd_linkback'                => 'Časť streamu $1 <br />Prejsť na zobrazenie streamu: $2<br />',
	'mvBadMVDtitle'                  => 'chýbajúci typ, chýbajúci stream alebo neplatný formát času',
	'mvMVDFormat'                    => 'Názov MVD by mal byť vo formáte: mvd:typ:názov_streamu/čas_začiatku/čas_konca',
	'mv_play'                        => 'Prehrať',
	'mv_edit'                        => 'Upraviť',
	'mv_history'                     => 'História',
	'mv_history_title'               => 'História úprav a zarovnania videa',
	'mv_edit_title'                  => 'Upraviť text',
	'mv_edit_adjust_title'           => 'Upraviť text a zarovnanie videa',
	'mv_remove'                      => 'odstrániť',
	'mv_remove_title'                => 'odstrániť tento úsek metadát',
	'mv_adjust'                      => 'doladiť',
	'mv_adjust_submit'               => 'Uložiť doladenie',
	'mv_adjust_title'                => 'Doladiť čas začiatku a konca',
	'mv_adjust_preview'              => 'Náhľad doladenia',
	'mv_adjust_preview_stop'         => 'Zastaviť náhľad',
	'mv_adjust_default_reason'       => 'doladenia rozhrania metavid',
	'mv_adjust_old_title_missing'    => 'Stránka, ktorú sa pokúšate presunúť ($1) neexistuje',
	'mv_adjust_ok_move'              => 'Úspešné, dolaďuje sa...',
	'mv_start_desc'                  => 'Čas začiatku',
	'mv_end_desc'                    => 'Čas konca',
	'mv_of'                          => '&#32;z&#32;',
	'mediasearch'                    => 'Hľadanie multimédií',
	'mv_search_sel_t'                => 'Vyberte typ hľadania',
	'mv_run_search'                  => 'Spustiť hľadanie',
	'mv_add_filter'                  => 'Pridať filter',
	'mv_search_match'                => 'Hľadať text',
	'mv_search_spoken_by'            => 'Nahovoril',
	'mv_search_category'             => 'Kategória',
	'mv_search_smw_property'         => 'Sémantické vlastnosti',
	'mv_search_smw_property_numeric' => 'Číselná sémantická hodnota',
	'mv_search_and'                  => 'a',
	'mv_search_or'                   => 'alebo',
	'mv_search_not'                  => 'nie',
	'mv_search_stream_name'          => 'Názov streamu',
	'mv_search_date_range'           => 'Rozsah dátumov',
	'mv_stream_name'                 => 'názov streamu',
	'mv_date_range'                  => 'rozsah dátumov',
	'mv_match'                       => 'zhoda',
	'mv_spoken_by'                   => 'nahovoril',
	'mv_category'                    => 'kategória',
	'mv_search_no_results'           => 'Neboli nájdené vyhovujúce multimédiá',
	'mv_media_matches'               => 'Vyhovujúce multimédiá',
	'mv_remove_filter'               => 'odstrániť filter',
	'mv_advaced_search'              => 'Pokročilé hľadanie multimédií',
	'mv_expand_play'                 => 'Expandovať a prehrať inline',
	'mv_view_in_stream_interface'    => 'Zobraziť v rozhraní streamu',
	'mv_view_wiki_page'              => 'Zobraziť wiki stránku',
	'mv_error_mvd_not_found'         => 'Chyba: mvd nenájdené',
	'mv_match_text'                  => '~ $1 vyhovujúcich',
	'mv_match_text_one'              => '~ 1 zhoda',
	'mv_edit_sequence'               => 'Úprava sekvencie: $1',
	'mv_sequence_player_title'       => 'prehrávač sekvencií',
	'mv_save_sequence'               => 'Uložiť sekvenciu',
	'mv_sequence_page_desc'          => 'Uložiť aktuálnu sekvenciu',
	'mv_sequence_add'                => 'Pridať klipy',
	'mv_sequence_add_manual'         => 'Pridať podľa názvu',
	'mv_sequence_add_manual_desc'    => 'Pridať klipy podľa názvu',
	'mv_sequence_add_search'         => 'Pridať podľa hľadania',
	'mv_sequence_add_search_desc'    => 'Pridať klipy podľa Vyhľadávania multimédií',
	'mv_seq_add_end'                 => 'Pridať na koniec sekvencie',
	'mv_sequence_timeline'           => 'Časový prehľad sekvencie:',
	'mv_edit_sequence_desc_help'     => 'Popis sekvencie',
	'mv_edithelpsequence'            => 'Pomoc:Upravovanie_sekvencie',
	'mv_seq_summary'                 => 'Zhrnutie úprav sekvencie',
	'mv_add_clip_by_name'            => 'Pridať klip podľa názvu',
	'mv_export_cmml'                 => 'exportovať cmml',
	'mv_search_stream'               => 'Hľadať v streame',
	'mv_navigate_stream'             => 'Navigovať v plnom streame',
	'mv_embed_options'               => 'Voľby vloženia',
	'mv_overlay'                     => 'Ovládanie preloženia',
	'mv_stream_tool_heading'         => 'Nástroje streamu',
	'mv_tool_missing'                => 'požiadavka o nástroj ($1) neexistuje',
	'mv_bad_tool_request'            => 'chybný riadok nástroja, má byť v tvare: názov_nástroja|zobrazovaný_názov_nástroja',
	'mv_search_stream_title'         => 'Hľadať v aktuálnom streame',
	'mv_new_ht_en'                   => 'Nový prepis',
	'mv_new_anno_en'                 => 'Nová značka alebo poznámka',
	'mv_mang_layers'                 => 'Spravovať vrstvy',
	'mv_mang_layers_title'           => 'Spravovať množinu zobrazovaných vrstiev aktuálneho streamu',
	'mv_protect_source_material'     => 'Originálny zdrojový materiál zamknutý proti úpravám',
);

/** Serbian Cyrillic ekavian (ћирилица)
 * @author Sasa Stefanovic
 */
$messages['sr-ec'] = array(
	'mv_tool_search' => 'Претрага',
	'mv_tool_export' => 'Извоз',
	'mv_edit'        => 'Уреди',
	'mv_history'     => 'Историја',
	'mv_remove'      => 'уклони',
);

/** Swedish (Svenska)
 * @author M.M.S.
 * @author Lejonel
 */
$messages['sv'] = array(
	'metavid'                        => 'Metavid-sida',
	'mv_missing_stream'              => 'Missat dataflöde: $1',
	'mv_ogg_low_quality'             => 'Direktöverfört över nätet - Ogg Theora 300kbs',
	'mv_ogg_high_quality'            => 'Hög kvalitet - Ogg Theora 900kbs',
	'mv_archive_org_link'            => 'Länkar till mpeg2-orginal hos Archive.org',
	'mv_error_stream_missing'        => '<span class="error">Fel: Det är ingen videofil associerad med detta dataflöde.</span><br />Var god rapportera detta till sidoperatören.',
	'mv_stream_meta'                 => 'Dataflödessida',
	'mv_add_stream'                  => 'Metavid lägg till dataflöde',
	'mv_edit_stream'                 => 'Metavid redigera dataflöde',
	'mvexportsearch'                 => 'Metavid exportera',
	'mvexportsequence'               => 'Metavid exportera sekvens',
	'mvexportstream'                 => 'Metavid exportera dataflöde',
	'mv_add_stream_page'             => 'Mv lägg till dataflöde',
	'mv_edit_strea_docu'             => '<p>Redigera dataflöde <b>admin</b><br />för vanlig användarvisning/-redigering, se sidan $1',
	'mv_add_stream_docu'             => '<p>Lägg till ett nytt dataflöde med fältet nedan.</p><p>Mer information ges på <a href="$1">hjälpsidan för tilläggning av dataflöde</a>.</p>',
	'mv_add_stream_submit'           => 'Lägg till dataflöde',
	'mv_no_stream_files'             => 'Inga existerande dataflödesfiler',
	'mv_edit_stream_files'           => 'Redigera dataflödesfiler',
	'mv_path_type_url_anx'           => 'full media-URL',
	'mv_path_type_wiki_title'        => 'mediatitel på wiki',
	'mv_path_type_label'             => 'vägtyp',
	'mv_base_offset_label'           => 'grundmotvikt',
	'mv_duration_label'              => 'varaktighet',
	'mv_file_desc_label'             => 'beskrivningsmeddelande för dataflöde',
	'mv_delete_stream_file'          => 'radera dataflödesfilreferens',
	'mv_save_changes'                => 'Spara ändringar',
	'mv_file_with_same_desc'         => 'Fel: dataflödesfil med samma beskrivningsnyckel <i>$1</i>, finns redan',
	'mv_updated_stream_files'        => 'Uppdaterad dataflödesfilslogg',
	'mv_removed_file_stream'         => 'Raderad dataflödesfil: $1',
	'mv_missing_stream_text'         => 'Dataflödesfilen som du efterfrågade, <b>$1</b> är inte tillgänglig.<br />Du bör kontrollera <a href="$2">dataflödeslistan</a><br />Eller så kan du <a href="$3">lägga till dataflödet</a>.',
	'mv_user_cant_edit'              => 'Du måste kanske ha $1 för att redigera, $2',
	'mv_add_stream_file'             => 'Lägg till dataflödesfil',
	'mv_media_path'                  => 'mediaväg',
	'mv_file_list'                   => 'Dataflödesfiler',
	'mv_label_stream_name'           => 'Dataflödesnamn',
	'mv_label_stream_desc'           => 'Dataflödesbeskrivning',
	'add_stream_permission'          => 'Du har inte tillåtelse till att lägga till ett nytt dataflöde',
	'edit_stream_missing'            => 'Missat dataflyttsnamn',
	'mv_missing_req_time'            => 'Missad tid för efterfrågning',
	'mv_missing_cat'                 => 'Missat kategorinamn',
	'mv_stream_already_exists'       => 'Dataflödet <a href="$2">$1</a> finns redan',
	'mv_summary_add_stream'          => 'dataflöde tillaggt med formulär',
	'mv_error_stream_insert'         => 'insättning av dataflöde misslyckades',
	'mv_redirect_and_delete_reason'  => 'raderad omdirigeringssida',
	'mv_remove_reason'               => 'Anledning för radering:',
	'mv_stream_delete_warrning'      => '<b>Radering av detta dataflöde kommer också föra till radering av $1 delar av assosierat metadata</b><br />',
	'mv_label_stream_type'           => 'Dataflödestyp',
	'mv_metavid_file'                => 'Existerande fil på server',
	'mv_metavid_live'                => 'Sätt upp direktöverföring',
	'mv_upload_file'                 => 'Ladda upp fil',
	'mv_external_file'               => 'Extern fil',
	'mv_stream_delete_warning'       => 'Radering av detta dataflöde kommer också medföra till radering av $1 sidor med metadata',
	'mv_tool_search'                 => 'Sök',
	'mv_tool_search_title'           => 'Sök inom detta dataflöde',
	'mv_search_transcripts_for'      => 'Sök nedtecknande för',
	'mv_tool_navigate'               => 'Navigera',
	'mv_tool_navigate_title'         => 'Navigera hela dataflödet',
	'mv_tool_export'                 => 'Exportera',
	'mv_tool_export_title'           => 'Exportera dataflödesmetadata',
	'mv_tool_embed'                  => 'Inkludera',
	'mv_tool_embed_title'            => 'Inkludera valmöjligheter för det efterfrågade segmentet',
	'mv_tool_overlay'                => 'Mallöverdrag',
	'mv_tool_overlay_title'          => 'Mall baserad på metadataöverdrag',
	'mv_results_found_for'           => 'Sökresultat <b>$1</b> till <b>$2</b> av <b>$3</b> för:',
	'mv_tool_mang_layers'            => 'Behandla lager',
	'mv_update_layers'               => 'uppdatera lagervisning',
	'mv_watch_clip'                  => 'Se klipp',
	'mv_close_clip'                  => 'Stäng klipp',
	'mv_improve_transcript'          => 'Förbättra transkription',
	'ht_en'                          => 'Transkription',
	'ht_en_desc'                     => 'Engelska transkriptioner. Denna överläggstypen är för uppläst text',
	'anno_en'                        => 'Annoteringar och kategorier',
	'anno_en_desc'                   => 'Engelska kategoriseringar och annoteringar.
Denna överläggstyp kan användas för att kategorisera sektioner av videor eller till att lägga till annotationer som inte är uppläst text.',
	'thomas_en'                      => 'Officiell transkription',
	'thomas_en_desc'                 => 'Officiell Thomas-transkription från regeringens THOMAS-inspelningstjänst.
Källtid synkroniserad av C-SPANs c-spanarchives.org',
	'mvd_default_mismatch'           => 'Fel i inställningsfil',
	'mvd_default_mismatch_text'      => 'Det finns ett fel i din inställningsfil,
$mvMVDTypeDefaultDisp borde vara ett undersätt av $mvMVDTypeAllAvailable',
	'mv_data_page_title'             => '$1 för $2 från $3',
	'mv_time_separator'              => '$1 till $2',
	'mv_list_streams'                => 'Metavid listar dataflöder',
	'mv_list_streams_page'           => 'Mv listar dataflöden',
	'mv_list_streams_docu'           => 'Följande dataflöden finns:',
	'mv_list_streams_none'           => 'Inga dataflöden finns',
	'mvvideofeed'                    => 'Metavid exportering av videokälla',
	'mvexportask'                    => 'Semantisk videomatningsexportering',
	'video_feed_cat'                 => 'Video matning för kategori:',
	'mv_cat_search_note'             => 'Notera: Kategorier listar endast underkategorier i högsta nivå;
för alla metadata i ett kategoriområde, sök efter $1',
	'mv_mvd_linkback'                => 'Del av dataflödet $1 <br />
Hoppa till dataflödesvisning: $2',
	'mvBadMVDtitle'                  => 'missad typ, missat dataflöde eller ogiltigt tidsformat',
	'mvMVDFormat'                    => 'MVD-titel borde vara i formatet: mvd:typ:dataflödesnamn/starttid/sluttid',
	'mv_play'                        => 'Spela',
	'mv_edit'                        => 'Redigera',
	'mv_history'                     => 'Historik',
	'mv_history_title'               => 'Redigerings och vieojusteringshistorik',
	'mv_edit_title'                  => 'Redigera Text',
	'mv_edit_adjust_title'           => 'Redigera text och videojustering',
	'mv_remove'                      => 'radera',
	'mv_remove_title'                => 'ta bort det här metadatasegmentet',
	'mv_adjust'                      => 'ställ in',
	'mv_adjust_submit'               => 'Spara inställning',
	'mv_adjust_title'                => 'Ställ in start och sluttid',
	'mv_adjust_preview'              => 'Förhandsgranska inställning',
	'mv_adjust_preview_stop'         => 'Stoppa förhandsgranskning',
	'mv_adjust_default_reason'       => 'ställ in metavid-gränssnitt',
	'mv_adjust_old_title_missing'    => 'Sidan du prövar att flytta från ($1) finns inte',
	'mv_adjust_ok_move'              => 'Lyckad, ställer in...',
	'mv_start_desc'                  => 'Starta tid',
	'mv_end_desc'                    => 'Stoppa tid',
	'mv_of'                          => '&#32;av&#32;',
	'mediasearch'                    => 'Media sök',
	'mv_search_sel_t'                => 'Välj sök sätt',
	'mv_run_search'                  => 'Snabbsökning',
	'mv_add_filter'                  => 'Lägg till filter',
	'mv_search_match'                => 'Sök text',
	'mv_search_spoken_by'            => 'Uppläst av',
	'mv_search_category'             => 'Kategori',
	'mv_search_smw_property'         => 'Semanitska värden',
	'mv_search_smw_property_numeric' => 'Numeriskt semantiskt värde',
	'mv_search_and'                  => 'och',
	'mv_search_or'                   => 'eller',
	'mv_search_not'                  => 'inte',
	'mv_search_stream_name'          => 'Dataflödesnamn',
	'mv_search_date_range'           => 'Datumområde',
	'mv_stream_name'                 => 'dataflödesnamn',
	'mv_date_range'                  => 'datumområde',
	'mv_match'                       => 'träff',
	'mv_spoken_by'                   => 'uppläst av',
	'mv_category'                    => 'kategori',
	'mv_search_no_results'           => 'Inga mediaträffar',
	'mv_media_matches'               => 'Mediaträffar',
	'mv_remove_filter'               => 'ta bort filter',
	'mv_advaced_search'              => 'Avancerat Media Sök',
	'mv_expand_play'                 => 'Utvidga och spela integreterat',
	'mv_view_in_stream_interface'    => 'Visa i dataflödesgränssnitt',
	'mv_view_wiki_page'              => 'Visa wiki sida',
	'mv_error_mvd_not_found'         => 'Fel: mvd hittades inte',
	'mv_match_text'                  => '~ $1 matchningar',
	'mv_match_text_one'              => '~ 1 matchning',
	'mv_edit_sequence'               => 'Redigerar sekvens: $1',
	'mv_sequence_player_title'       => 'sekvensspelare',
	'mv_save_sequence'               => 'Spara sekvens',
	'mv_sequence_page_desc'          => 'Spara den nuvarande sekvensen',
	'mv_sequence_add'                => 'Lägg till klipp',
	'mv_sequence_add_manual'         => 'Lägg till efter namn',
	'mv_sequence_add_manual_desc'    => 'Lägg till klipp efter dataflödesnamn',
	'mv_sequence_add_search'         => 'Lägg till efter sökning',
	'mv_sequence_add_search_desc'    => 'Lägg till klipp efter mediasökning',
	'mv_seq_add_end'                 => 'Lägg till sekvensslut',
	'mv_sequence_timeline'           => 'Sekvenstidslinje:',
	'mv_edit_sequence_desc_help'     => 'Sekvensbeskrivning',
	'mv_edithelpsequence'            => 'Help:Sekvensredigering',
	'mv_seq_summary'                 => 'Sammandrag av sekvensredigering',
	'mv_add_clip_by_name'            => 'Lägg till klipp efter namn',
	'mv_export_cmml'                 => 'exportera cmml',
	'mv_search_stream'               => 'Sök dataflöde',
	'mv_navigate_stream'             => 'Navigera fulla dataflödet',
	'mv_embed_options'               => 'Inkluderingsalternativ',
	'mv_overlay'                     => 'Överläggskontroll',
	'mv_stream_tool_heading'         => 'Dataflödesverktyg',
	'mv_tool_missing'                => 'verktygsefterfrågning ($1) finns inte',
	'mv_bad_tool_request'            => 'dålig verktygslinje; borde vara i formen: verktygsnamn|visningsnamn',
	'mv_search_stream_title'         => 'Sök i det nuvarande dataflödet',
	'mv_new_ht_en'                   => 'Ny transkription',
	'mv_new_anno_en'                 => 'Ny tagg eller annotering',
	'mv_mang_layers'                 => 'Behandla lager',
	'mv_mang_layers_title'           => 'Behandla lagervisningsättet för det nuvarande dataflödet',
	'mv_protect_source_material'     => 'Orginalt källmaterial beskyddat mot redigeringar',
);

/** Silesian (ślůnski)
 * @author Pimke
 * @author Herr Kriss
 */
$messages['szl'] = array(
	'mv_tool_search' => 'Šnupej',
	'mv_edit'        => 'Sprowjéj',
);

/** Tamil (தமிழ்)
 * @author Trengarasu
 */
$messages['ta'] = array(
	'mv_save_changes' => 'மாற்றங்களைச் சேமி',
	'mv_tool_search'  => 'தேடுக',
);

/** Telugu (తెలుగు)
 * @author Veeven
 */
$messages['te'] = array(
	'mv_ogg_high_quality'           => 'ఉత్తమ నాణ్యత - ఓగ్ థియోరా 900kbs',
	'mv_duration_label'             => 'నిడివి',
	'mv_save_changes'               => 'మార్పులను భద్రపరచు',
	'mv_file_list'                  => 'స్ట్రీమ్ ఫైళ్ళు',
	'mv_label_stream_name'          => 'స్ట్రీమ్ పేరు',
	'mv_label_stream_desc'          => 'స్ట్రీమ్ వివరణ',
	'add_stream_permission'         => 'కొత్త స్ట్రీముని చేర్చడానికి మీరు అనుమతి లేదు.',
	'mv_missing_req_time'           => 'అభ్యర్థన సమయం తప్పింది',
	'mv_missing_cat'                => 'వర్గం పేరు తప్పింది',
	'mv_redirect_and_delete_reason' => 'దారిమార్పు పేజీని తొలగించారు',
	'mv_remove_reason'              => 'తొలగింపునకు కారణం:',
	'mv_metavid_file'               => 'సర్వరులో ఉన్న ఫైలు',
	'mv_upload_file'                => 'ఫైలుని ఎగుమతించండి',
	'mv_external_file'              => 'బయటి ఫైలు',
	'mv_tool_search'                => 'వెతుకు',
	'mv_tool_overlay'               => 'మూస పైపూతలు',
	'mv_results_found_for'          => 'మొత్తం <b>$3</b> ఫలితాల్లో <b>$1</b> నుండి <b>$2</b> వరకు, అన్వేషించినది:',
	'mvd_default_mismatch'          => 'అమరికల ఫైలులో పొరపాటు',
	'mv_data_page_title'            => '$3 నుండి $2కై $1',
	'mv_time_separator'             => '$1 నుండి $2 వరకు',
	'video_feed_cat'                => 'వర్గానికి వీడియో ఫీడు:',
	'mv_play'                       => 'ఆడించు',
	'mv_edit'                       => 'మార్చు',
	'mv_history'                    => 'చరిత్ర',
	'mv_edit_title'                 => 'పాఠ్యాన్ని మార్చండి',
	'mv_remove'                     => 'తొలగించు',
	'mv_adjust_submit'              => 'సర్దుబాటుని భద్రపరచండి',
	'mv_adjust_preview_stop'        => 'మునుజూపుని ఆపు',
	'mv_adjust_old_title_missing'   => 'మీరు తరలించాలనుకుంటున్న పేజీ ($1) లేనేలేదు',
	'mv_start_desc'                 => 'ప్రారంభ సమయం',
	'mv_end_desc'                   => 'ముగింపు సమయం',
	'mv_search_sel_t'               => 'అన్వేషణ రకాన్ని ఎంచుకోండి',
	'mv_run_search'                 => 'అన్వేషణని నడపండి',
	'mv_add_filter'                 => 'వడపోతని చేర్చండి',
	'mv_search_match'               => 'పాఠ్యంలో వెతకండి',
	'mv_search_spoken_by'           => 'మాట్లాడినది',
	'mv_search_category'            => 'వర్గం',
	'mv_search_and'                 => 'మరియు',
	'mv_search_or'                  => 'లేదా',
	'mv_spoken_by'                  => 'మాట్లాడినది',
	'mv_category'                   => 'వర్గం',
	'mv_remove_filter'              => 'వడపోతని తీసివేయి',
	'mv_advaced_search'             => 'నిశిత మాధ్యమ అన్వేషణ',
	'mv_view_wiki_page'             => 'వికీ పేజీని చూడండి',
	'mv_match_text'                 => '~  $1 పోలికలు',
	'mv_match_text_one'             => '~ 1 పోలిక',
	'mv_sequence_add_manual'        => 'పేరు ద్వారా చేర్చండి',
	'mv_embed_options'              => 'ఎంబెడ్ ఎంపికలు',
);

/** Tetum (Tetun)
 * @author MF-Warburg
 */
$messages['tet'] = array(
	'mv_tool_search'     => 'Buka',
	'mv_edit'            => 'Edita',
	'mv_search_category' => 'Kategoria',
	'mv_search_and'      => 'ho',
	'mv_category'        => 'kategoria',
);

/** Tajik (Тоҷикӣ/tojikī) */
$messages['tg'] = array(
	'mv_search_stream_name' => 'Номи ҷараён',
	'mv_stream_name'        => 'номи ҷараён',
);

/** Tajik (Cyrillic) (Тоҷикӣ/tojikī (Cyrillic))
 * @author Ibrahim
 * @author Siebrand
 */
$messages['tg-cyrl'] = array(
	'mv_stream_meta'              => 'Саҳифаи ҷараён',
	'mv_add_stream_submit'        => 'Иловаи ҷараён',
	'mv_no_stream_files'          => 'Парвандаҳои Ҷараёнии Мавҷудбуда нест',
	'mv_edit_stream_files'        => 'Вироиши парвандаҳои ҷараёнӣ',
	'mv_path_type_url_anx'        => 'нишонаи пурраи расона',
	'mv_path_type_wiki_title'     => 'унвони расонаи вики',
	'mv_path_type_label'          => 'навъи масир',
	'mv_duration_label'           => 'тӯл',
	'mv_save_changes'             => 'Захираи тағйирот',
	'mv_removed_file_stream'      => 'Парвандаи Ҷараёнии ҳазфшуда: $1',
	'mv_add_stream_file'          => 'Илова кардани парвандаи ҷараён',
	'mv_media_path'               => 'масири расона',
	'mv_file_list'                => 'Парвандаҳои ҷараён',
	'mv_label_stream_name'        => 'Номи ҷараён',
	'mv_label_stream_desc'        => 'Тавсифи ҷараён',
	'add_stream_permission'       => 'Шумо иҷозати илова кардани ҷараёни ҷадидро надоред',
	'mv_upload_file'              => 'Фиристодани парванда',
	'mv_tool_search'              => 'Ҷустуҷӯ',
	'ht_en'                       => 'Рӯнавишт',
	'thomas_en'                   => 'Рӯнавишти расмӣ',
	'mv_time_separator'           => '$1 то $2',
	'mv_edit'                     => 'Вироиш',
	'mv_history'                  => 'Таърих',
	'mv_edit_title'               => 'Вироиши матн',
	'mediasearch'                 => 'Ҷустуҷӯи расона',
	'mv_search_sel_t'             => 'Интихоби навъи ҷустуҷӯ',
	'mv_run_search'               => 'Рониши ҷустуҷӯ',
	'mv_search_match'             => 'Ҷустуҷӯи матн',
	'mv_search_category'          => 'Гурӯҳ',
	'mv_search_and'               => 'ва',
	'mv_search_or'                => 'ё',
	'mv_search_stream_name'       => 'Номи ҷараён',
	'mv_stream_name'              => 'номи ҷараён',
	'mv_category'                 => 'гурӯҳ',
	'mv_search_no_results'        => 'Ҳеҷ расонае рост намеояд',
	'mv_media_matches'            => 'Расона мутобиқат мекунад',
	'mv_remove_filter'            => 'бардоштани филтр',
	'mv_advaced_search'           => 'Ҷустуҷӯи пешрафтаи расона',
	'mv_view_wiki_page'           => 'Намоиши саҳифаи вики',
	'mv_match_text_one'           => '~ 1 мутобиқ',
	'mv_edit_sequence'            => 'Дар ҳоли вироиши тартиб:$1',
	'mv_sequence_player_title'    => 'пахшкунандаи тартиб',
	'mv_save_sequence'            => 'Захираи Тартиб',
	'mv_sequence_page_desc'       => 'Захираи тартиби кунунӣ',
	'mv_sequence_add'             => 'Иловаи клипҳо',
	'mv_sequence_add_manual'      => 'Илова тавассути Ном',
	'mv_sequence_add_manual_desc' => 'Иловаи клипҳои тавассути номи ҷараён',
	'mv_sequence_add_search'      => 'Илова тавассути Ҷустуҷӯ',
	'mv_sequence_add_search_desc' => 'Иловаи клипҳо тавассути ҷустуҷӯи расона',
	'mv_seq_add_end'              => 'Ба охири тартиб илова кунед',
	'mv_sequence_timeline'        => 'Хати вақти тартиб:',
	'mv_edit_sequence_desc_help'  => 'Тавсифи тартиб',
	'mv_edithelpsequence'         => 'Help:Вироиши_Тартиб',
	'mv_seq_summary'              => 'Хулосаи вироиши тартиб',
	'mv_add_clip_by_name'         => 'Иловаи клип тавассути ном',
	'mv_search_stream'            => 'Ҷустуҷӯи ҷараён',
	'mv_stream_tool_heading'      => 'Абзорҳои ҷараён',
	'mv_new_ht_en'                => 'Рӯнавишти ҷадид',
);

/** Vietnamese (Tiếng Việt)
 * @author Minh Nguyen
 */
$messages['vi'] = array(
	'mv_upload_file'     => 'Tải tập tin lên',
	'mv_tool_search'     => 'Tìm kiếm',
	'mv_edit'            => 'Sửa đổi',
	'mv_search_category' => 'Thể loại',
	'mv_search_and'      => 'và',
	'mv_category'        => 'thể loại',
);

/** Volapük (Volapük)
 * @author Malafaya
 */
$messages['vo'] = array(
	'mv_search_category' => 'Klad',
);

