/*  This file is part of MED.
 *
 *  COPYRIGHT (C) 1999 - 2011  EDF R&D, CEA/DEN
 *  MED is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  MED is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with MED.  If not, see <http://www.gnu.org/licenses/>.
 */


#include "med_config.h"
#include <med.h>
#include "med_outils.h"
#include <string.h>


void _MEDparameterInfoByName30(int dummy, ...) {

  va_list params;
  va_start(params,dummy);

  const med_idt              fid         = va_arg(params,const med_idt               );
  const char   *       const paramname   = va_arg(params,const char   *       const  );
  med_parameter_type * const paramtype   = va_arg(params,med_parameter_type * const  );
  char *               const description = va_arg(params,char *               const  );
  char *               const dtunit      = va_arg(params,char *               const  );
  med_int *            const nstep       = va_arg(params,med_int *            const  );
  med_err *                  fret         = va_arg(params,med_err *);

  med_err _ret = -1, _err = -1;
  med_int _paramtype = 0;
  med_idt _paramidt = 0;
  char    _parampath[MED_TAILLE_NUM_DATA+MED_NAME_SIZE+1]=MED_NUM_DATA;
  med_size _nstep=0;

  _MEDmodeErreurVerrouiller();

  /* On accede aux donnees */
  strcat(_parampath, paramname);
  if ((_paramidt = _MEDdatagroupOuvrir(fid,_parampath)) < 0) {
    MED_ERR_(_ret,MED_ERR_OPEN,MED_ERR_DATAGROUP,_parampath);
    goto ERROR;
  }

  /* on lit les infos : type, description, dtunit, nstep */
  if ( _MEDattrEntierLire(_paramidt,MED_NOM_TYP,&_paramtype) < 0) {
    MED_ERR_(_ret,MED_ERR_READ,MED_ERR_ATTRIBUTE,MED_ERR_PARAM_MSG);
    SSCRUTE(paramname);SSCRUTE(MED_NOM_TYP);
    goto ERROR;
  }
  *paramtype = (med_parameter_type) (_paramtype);

  if (_MEDattrStringLire(_paramidt,MED_NOM_DES,MED_COMMENT_SIZE, description) < 0) {
    MED_ERR_(_ret,MED_ERR_READ,MED_ERR_ATTRIBUTE,MED_ERR_PARAM_MSG);
    SSCRUTE(paramname);SSCRUTE(MED_NOM_DES);SSCRUTE(description);goto ERROR;
  }

  if (_MEDattrStringLire(_paramidt,MED_NOM_UNT,MED_SNAME_SIZE, dtunit) < 0) {
    MED_ERR_(_ret,MED_ERR_READ,MED_ERR_ATTRIBUTE,MED_ERR_MESH_MSG);
    SSCRUTE(paramname);SSCRUTE(MED_NOM_UNT);
    SSCRUTE(dtunit);goto ERROR;
  }

  if ((_err=_MEDnObjects(_paramidt,".",&_nstep)) <0)
    if ( _err == (MED_ERR_COUNT + MED_ERR_DATAGROUP) ) {
      MED_ERR_(_ret,MED_ERR_COUNT,MED_ERR_DATAGROUP,paramname);
      goto ERROR;
    }
  *nstep = (med_int) _nstep;

  _ret = 0;
 ERROR:

  if (_paramidt > 0)            if (_MEDdatagroupFermer(_paramidt) < 0) {
    MED_ERR_(_ret,MED_ERR_CLOSE,MED_ERR_DATAGROUP,_parampath);
    ISCRUTE_id(_paramidt);
  }

  va_end(params);
  *fret = _ret;
  return;
}
