/*************************************************************************
* COPYRIGHT (C) 1999 - 2007  EDF R&D, CEA/DEN
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/


/******************************************************************************
 * - Nom du fichier : test4.c
 *
 * - Description : ecriture des noeuds d'un maillage MED.
 *
 *****************************************************************************/

#include <med.h>
#define MESGERR
#include <med_utils.h> 

#ifdef DEF_LECT_ECR
#define MODE_ACCES MED_LECTURE_ECRITURE
#elif DEF_LECT_AJOUT
#define MODE_ACCES MED_LECTURE_AJOUT
#else
#define MODE_ACCES MED_CREATION
#endif

int main (int argc, char **argv)


{
  med_err ret = 0;
  med_idt fid;
  /* la dimension du maillage */
  med_int mdim = 2;
  /* nom du maillage de longueur maxi MED_TAILLE_NOM */
  char maa[MED_TAILLE_NOM+1] = "maa1";
  /* le nombre de noeuds */
  med_int nnoe = 4;
  /* table des coordonnees  
     profil : (dimension * nombre de noeuds) */
  med_float coo[8] = {0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0};
  /* tables des noms et des unites des coordonnees  
     profil : (dimension*MED_TAILLE_PNOM+1) */
  /*                                  12345678901234561234567890123456*/ 
  char nomcoo[2*MED_TAILLE_PNOM+1] = "x               y               ";
  char unicoo[2*MED_TAILLE_PNOM+1] = "cm              cm              ";
  /* tables des noms, numeros, numeros de familles des noeuds
     autant d'elements que de noeuds - les noms ont pout longueur
     MED_TAILLE_PNOM */
  /*                                  1234567890123456123456789012345612345678901234561234567890123456*/
  char nomnoe[4*MED_TAILLE_PNOM+1] = "nom1            nom2            nom3            nom4            ";
  med_int numnoe[4] = {1,2,3,4};
  med_int nufano[4] = {0,1,2,2};

  /* Creation du fichier "test4.med" */
  fid = MEDouvrir("test4.med",MODE_ACCES);
  if (fid < 0) {
    MESSAGE("Erreur a la creation du fichier test4.med");
    return -1;
  }

  /* Creation du maillage "maa" de type MED_NON_STRUCURE 
     et de dimension 2 */
  if (MEDmaaCr(fid,maa,mdim,MED_NON_STRUCTURE,
	       "un maillage pour test4") < 0) {
    MESSAGE("Erreur a la creation du maillage : "); SSCRUTE(maa);
    ret = -1;
  }

  /* Ecriture des coordonnees des noeuds en mode MED_FULL_INTERLACE :
     (X1,Y1, X2,Y2, X3,Y3, ...) dans un repere cartesien */
  if (MEDcoordEcr(fid,maa,mdim,coo,MED_FULL_INTERLACE,nnoe,
		  MED_CART,nomcoo,unicoo) < 0) {
    MESSAGE("Erreur a l'ecriture des coordonnees des noeuds");
    ret = -1;
  }

  /* Ecriture des noms des noeuds (optionnel dans un maillage MED) */
  if (MEDnomEcr(fid,maa,nomnoe,nnoe,MED_NOEUD,0) < 0) {
    MESSAGE("Erreur a l'ecriture des noms des noeuds");
    ret = -1;
  }

  /* Ecriture des numeros des noeuds (optionnel dans un maillage MED) */
  if (MEDnumEcr(fid,maa,numnoe,nnoe,MED_NOEUD,0) < 0) {
    MESSAGE("Erreur a l'ecriture des numeros des noeuds");
    ret = -1;
  }

  /* Ecriture des numeros de famille des noeuds */	      
  if (MEDfamEcr(fid,maa,nufano,nnoe,MED_NOEUD,0) < 0) {
    MESSAGE("Erreur a l'ecriture des numeros de familles des noeuds");
    ret = -1;
  }

  /* Fermeture du fichier */
  if (MEDfermer(fid) < 0) {
    MESSAGE("Erreur a la fermeture du fichier test4.med");
    return -1;
  }
  
  return ret;
}




