/*************************************************************************
* COPYRIGHT (C) 1999 - 2007  EDF R&D, CEA/DEN
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/


#include <med.h>
#include <med_config.h>
#include <med_outils.h>
#include <hdf5.h>

/*
 * - Nom de la fonction : _MEDdatagroupCreer
 * - Description : creation et ouverture d'un Datagroup HDF
 * - Parametres :
 *     - pid     (IN)    : l'ID de l'objet pere
 *     - nom     (IN)    : le nom de l'objet fils
 * - Resultat : l'ID du fils en cas de succes, -1 sinon
 */ 
med_idt
_MEDdatagroupCreer(med_idt pid, char *nom)
{
  med_idt id;
  med_err ret=0;
  med_mode_acces MED_MODE_ACCES;

  if ( (MED_MODE_ACCES = _MEDmodeAcces(pid) ) == MED_UNDEF_MODE_ACCES ) {
    MESSAGE("Impossible de dterminer le mode d'acces au fichier.");
    return -1;
  }

  if ( MED_MODE_ACCES == MED_LECTURE) {
    MESSAGE("Impossible de crer un datagroup en mode MED_LECTURE.");
    return -1;
  };


  id = _MEDdatagroupOuvrir(pid,nom);
  if (id > 0)
    if (MED_MODE_ACCES == MED_LECTURE_AJOUT) {
      MESSAGE("Cration d'un datagroup existant impossible en mode MED_LECTURE_AJOUT.");
      return -1;
    };
  /* sinon on le cre */
  if (id <= 0)
    if ((id = H5Gcreate(pid,nom,0)) < 0) {
      MESSAGE("Impossible de crer le datagroup : ");
      SSCRUTE(nom);
      return -1;
    }

  return id;
}
