/*************************************************************************
* COPYRIGHT (C) 1999 - 2007  EDF R&D, CEA/DEN
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#include <med.h>
#include <med_config.h>
#include <med_outils.h>

#include <string.h>
#include <stdlib.h>

void 
MEDjointCr232(int dummy,...) {


  med_idt   fid      ;
  char *    maa_lcl  ;
  char *    jn       ;
  char *    desc     ;
  med_int   dom      ;
  char *    maa_dist ;
  med_err * fret     ;
 
  med_idt root=0,jntid=0;
  med_err ret=-1;
  char chemin[MED_TAILLE_MAA+MED_TAILLE_JNT+MED_TAILLE_NOM+1];
  char tmp[MED_TAILLE_JNT+1];
  med_int nbc=0;
  med_mode_acces MED_MODE_ACCES;

  va_list params;
  va_start(params,dummy);

  fid      = va_arg(params,med_idt);
  maa_lcl  = va_arg(params,char *);
  jn       = va_arg(params,char *);
  desc     = va_arg(params,char *);
  dom      = va_arg(params,med_int);
  maa_dist = va_arg(params,char*);
  fret     = va_arg(params,med_err *);

  /*
   * On inhibe le gestionnaire d'erreur
   */
  _MEDmodeErreurVerrouiller();

  if ( (MED_MODE_ACCES = _MEDmodeAcces(fid) ) == MED_UNDEF_MODE_ACCES ) {
    MESSAGE("Impossible de dterminer le mode d'acces au fichier.");
    goto ERROR;
  }

  if ( MED_MODE_ACCES == MED_LECTURE ) {
    MESSAGE("Impossible de crer un joint en mode MED_LECTURE.");
    goto ERROR;
  };

  /* 
   * Si le Data Group "JNT" n'existe pas, on le cree
   */
  NOFINALBLANK(maa_lcl,ERROR);
  strcpy(chemin,MED_MAA);
  strcat(chemin,maa_lcl);
  strncpy(tmp,MED_JNT,MED_TAILLE_JNT-1);
  tmp[MED_TAILLE_JNT-1] = '\0';
  strcat(chemin,tmp);
  if ((root = _MEDdatagroupOuvrir(fid,chemin)) < 0)
    if ((root = _MEDdatagroupCreer(fid,chemin)) < 0) {
      MESSAGE("Erreur  la cration du datagroup : ");
      SSCRUTE(chemin);
      goto ERROR;
    }

  /*
   * Si un joint du meme nom existe => erreur
   * Sinon on le cree
   */
  NOFINALBLANK(jn,ERROR);
  if ((jntid = _MEDdatagroupCreer(root,jn)) < 0) {
    MESSAGE("Erreur  la cration du joint : ");
    SSCRUTE(jn);
    goto ERROR;
  }

  /*
   * L'attribut "DES"
   */
  if ((ret = _MEDattrStringEcrire(jntid,MED_NOM_DES,MED_TAILLE_DESC,desc)) < 0) {
    MESSAGE("Erreur  l'criture de la description du joint : ");
    SSCRUTE(desc);
    goto ERROR;
  }

  /*
   * L'attribut "MAI"
   */
  if ((ret = _MEDattrStringEcrire(jntid,MED_NOM_MAI,MED_TAILLE_NOM,maa_dist)) < 0) {
    MESSAGE("Erreur  l'criture du nom du maillage distant : ");
    SSCRUTE(maa_dist);
    goto ERROR;
  }

  /*
   * L'attribut "DOM"
   */
  if ((ret = _MEDattrEntierEcrire(jntid,MED_NOM_DOM,&dom)) < 0) {
    MESSAGE("Erreur  l'criture du domaine : ");
    ISCRUTE(dom);
    goto ERROR;
  }

  /*
   * On ferme tout 
   */
  ret=0;
 ERROR:

  if (jntid>0)     if (_MEDdatagroupFermer(jntid) < 0) {
    MESSAGE("Impossible de fermer le datagroup : ");
    ISCRUTE_id(jntid);ret = -1; 
  }
  
  if (root>0)     if (_MEDdatagroupFermer(root) < 0) {
    MESSAGE("Impossible de fermer le datagroup : ");
    ISCRUTE_id(root); ret = -1; 
  }

  va_end(params);
  *fret = ret;
  return;
}



