/*************************************************************************
* COPYRIGHT (C) 1999 - 2003  EDF R&D
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#include <med.h>
#include <med_config.h>
#include <med_outils.h>

#include <string.h>
#include <stdlib.h>

med_err 
MEDmaaCr(med_idt fid, char *maillage, med_int dim, med_maillage type,char *desc)
{
  med_idt maaid, root;
  char chemin[MED_TAILLE_MAA+1];
  med_err ret;
  med_int tmp;

  /*
   * On inhibe le gestionnaire d'erreur
   */
  _MEDmodeErreurVerrouiller();

  /*
   * Si la racine n'existe pas on la cree
   */
  strncpy(chemin,MED_MAA,strlen(MED_MAA)-1);
  chemin[MED_TAILLE_MAA-1] = '\0';
  if ((root = _MEDdatagroupOuvrir(fid,chemin)) < 0)
    if ((root = _MEDdatagroupCreer(fid,chemin)) < 0)
      return -1;

  /*
   * si le maillage existe deja => erreur
   */
  if ((maaid = _MEDdatagroupOuvrir(root,maillage)) > 0)
    return -1;

  /*
   * Creation du groupe HDF
   */
  if ((maaid = _MEDdatagroupCreer(root,maillage)) < 0)
    return -1;

  /*
   * Creation de l'attribut dimension
   */
  if ((ret = _MEDattrEntierEcrire(maaid,MED_NOM_DIM,&dim)) < 0)
    return -1;
  
  /*
   * La description associee au maillage
   */
  if ((ret = _MEDattrStringEcrire(maaid,MED_NOM_DES,MED_TAILLE_DESC,desc)) < 0)
    return -1;

  /*
   * Creation de l'attribut correspondant ay type du maillage (MED_STRUCTURE, MED_NON_STRUCTURE)
   */
  tmp = (med_int) type;
  if ((ret = _MEDattrEntierEcrire(maaid,MED_NOM_TYP,&tmp)) < 0)
    return -1;

  /* 
   * Nettoyages divers
   */
  if ((ret = _MEDdatagroupFermer(maaid)) < 0)
    return -1;
  if ((ret = _MEDdatagroupFermer(root)) < 0)
    return -1;

  return 0;
}
  

  
