/*
  MeCab -- Yet Another Part-of-Speech and Morphological Analyzer

  $Id: mecab.h,v 1.12 2006/07/09 15:18:41 taku-ku Exp $;

  Copyright (C) 2001-2006 Taku Kudo <taku@chasen.org>
  Copyright (C) 2004-2006 Nippon Telegraph and Telephone Corporation

*/
#ifndef MECAB_MECAB_H
#define MECAB_MECAB_H

/* C/C++ common data structures */

struct mecab_path_t
{
  struct mecab_node_t* rnode;
  struct mecab_path_t* rnext;
  struct mecab_node_t* lnode;
  struct mecab_path_t* lnext;
  int    cost;
  float  prob;
};

struct mecab_learner_path_t
{
  struct mecab_learner_node_t* rnode;
  struct mecab_learner_path_t* rnext;
  struct mecab_learner_node_t* lnode;
  struct mecab_learner_path_t* lnext;
  double cost;
  int   *fvector;
};

struct mecab_node_t
{
  struct mecab_node_t  *prev;
  struct mecab_node_t  *next;
  struct mecab_node_t  *enext;
  struct mecab_node_t  *bnext;
  struct mecab_path_t  *rpath;
  struct mecab_path_t  *lpath;
  char  *surface;
  char  *feature;
  unsigned int   id;
  unsigned short length;      /* length of morph */
  unsigned short rlength;     /* real length of morph (include white space before the morph) */
  unsigned short rcAttr;
  unsigned short lcAttr;
  unsigned short posid;
  unsigned char  char_type;
  unsigned char  stat;
  unsigned char  isbest;
  float          alpha;
  float          beta;
  float          prob;
  short          wcost;
  long           cost;
};

/* almost the same as mecab_node_t.
   used only for cost estimation */
struct mecab_learner_node_t
{
  struct mecab_learner_node_t  *prev;
  struct mecab_learner_node_t  *next;
  struct mecab_learner_node_t  *enext;
  struct mecab_learner_node_t  *bnext;
  struct mecab_learner_path_t  *rpath;
  struct mecab_learner_path_t  *lpath;
  struct mecab_learner_node_t  *anext;
  char  *surface;
  char  *feature;
  unsigned int   id;
  unsigned short length;
  unsigned short rlength;
  unsigned short rcAttr;
  unsigned short lcAttr;
  unsigned short posid;
  unsigned char  char_type;
  unsigned char  stat;
  unsigned char  isbest;
  double         alpha;
  double         beta;
  short          wcost2;
  double         wcost;
  double         cost;
  int            *fvector;
};

#define MECAB_NOR_NODE  0
#define MECAB_UNK_NODE  1
#define MECAB_BOS_NODE  2
#define MECAB_EOS_NODE  3

/* C interface  */
#ifdef __cplusplus
#include <cstdio>
#else
#include <stdio.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifdef _WIN32
#include <windows.h>
#  ifdef DLL_EXPORT
#    define MECAB_DLL_EXTERN  __declspec(dllexport)
#  else
#    define MECAB_DLL_EXTERN  __declspec(dllimport)
#  endif
#endif

#ifndef MECAB_DLL_EXTERN
#  define MECAB_DLL_EXTERN extern
#endif

  typedef struct mecab_t               mecab_t;
  typedef struct mecab_node_t          mecab_node_t;
  typedef struct mecab_learner_node_t  mecab_learner_node_t;
  typedef struct mecab_path_t          mecab_path_t;
  typedef struct mecab_learner_path_t  mecab_learner_path_t;

#ifndef SWIG
  /* C interface */
  MECAB_DLL_EXTERN int           mecab_do                  (int, char**);
  MECAB_DLL_EXTERN mecab_t*      mecab_new                 (int, char**);
  MECAB_DLL_EXTERN mecab_t*      mecab_new2                (const char*);
  MECAB_DLL_EXTERN const char*   mecab_version             ();
  MECAB_DLL_EXTERN const char*   mecab_strerror            (mecab_t*);
  MECAB_DLL_EXTERN void          mecab_destroy             (mecab_t*);
  MECAB_DLL_EXTERN const char*   mecab_sparse_tostr        (mecab_t*, const char*);
  MECAB_DLL_EXTERN const char*   mecab_sparse_tostr2       (mecab_t*, const char*, size_t);
  MECAB_DLL_EXTERN char*         mecab_sparse_tostr3       (mecab_t*, const char*, size_t, char*, size_t);
  MECAB_DLL_EXTERN mecab_node_t* mecab_sparse_tonode       (mecab_t*, const char*);
  MECAB_DLL_EXTERN mecab_node_t* mecab_sparse_tonode2      (mecab_t*, const char*, size_t);
  MECAB_DLL_EXTERN const char*   mecab_nbest_sparse_tostr  (mecab_t*, size_t, const char*);
  MECAB_DLL_EXTERN const char*   mecab_nbest_sparse_tostr2 (mecab_t*, size_t, const char*, size_t);
  MECAB_DLL_EXTERN char*         mecab_nbest_sparse_tostr3 (mecab_t*, size_t, const char*, size_t, char*, size_t);
  MECAB_DLL_EXTERN int           mecab_nbest_init          (mecab_t*, const char*);
  MECAB_DLL_EXTERN int           mecab_nbest_init2         (mecab_t*, const char*, size_t);
  MECAB_DLL_EXTERN const char*   mecab_nbest_next_tostr    (mecab_t*);
  MECAB_DLL_EXTERN char*         mecab_nbest_next_tostr2   (mecab_t*, char*, size_t);
  MECAB_DLL_EXTERN mecab_node_t* mecab_nbest_next_tonode   (mecab_t*);
  MECAB_DLL_EXTERN const char*   mecab_format_node         (mecab_t*, mecab_node_t*);
  MECAB_DLL_EXTERN int           mecab_dict_index          (int argc, char **argv);
  MECAB_DLL_EXTERN int           mecab_dict_gen            (int argc, char **argv);
  MECAB_DLL_EXTERN int           mecab_cost_train          (int argc, char **argv);
  MECAB_DLL_EXTERN int           mecab_system_eval         (int argc, char **argv);
  MECAB_DLL_EXTERN int           mecab_dict_info           (int argc, char **argv);
#endif

#ifdef __cplusplus
}
#endif

/* C++ interface */
#ifdef __cplusplus

namespace MeCab
{
  typedef struct mecab_path_t        Path;
  typedef struct mecab_node_t        Node;
  typedef struct mecab_learner_path_t  LearnerPath;
  typedef struct mecab_learner_node_t  LearnerNode;

  class Tagger {
  public:

#ifndef SWIG
    virtual const char* parse(const char*, size_t, char*, size_t) = 0;
    virtual const char* parse(const char*, size_t) = 0;
    virtual Node* parseToNode(const char*, size_t) = 0;
    virtual const char* parseNBest(size_t, const char*, size_t) = 0;
    virtual bool  parseNBestInit(const char*, size_t) = 0;
#endif

    virtual const char* parse(const char*) = 0;
    virtual Node* parseToNode(const char*) = 0;
    virtual const char* parseNBest(size_t, const char*) = 0;
    virtual bool  parseNBestInit(const char*) = 0;
    virtual Node*  nextNode() = 0;
    virtual const char* next() = 0;
    virtual const char* formatNode(Node *) = 0;

#ifndef SWIG
    virtual const char* next(char*, size_t) = 0;
    virtual const char* parseNBest(size_t, const char*,
                                   size_t, char *, size_t) = 0;
    virtual const char* formatNode(Node *, char *, size_t) = 0;
#endif

    virtual const char* what() = 0;

    virtual ~Tagger() {};

#ifndef SIWG
    static Tagger* create(int, char **);
    static Tagger* create(const char*);
#endif

    static const char *version();
  };

  /* factory method */
  MECAB_DLL_EXTERN Tagger *createTagger(int, char**);
  MECAB_DLL_EXTERN Tagger *createTagger(const char*);
  MECAB_DLL_EXTERN const char* getTaggerError();
}

#endif
#endif
