#include <stdio.h>

#ifdef _WIN32
#include <windows.h>

typedef void* (WINAPI *FPINIT)   (int, char **);
typedef char* (WINAPI *FPERR)    (void*);
typedef char* (WINAPI *FPPARSE)  (void*, char*);
typedef void (WINAPI *FPDEL)    ();

#endif
  
int main (int argc, char **argv)
{
#ifdef _WIN32
   char p[] = "Y͎YĂ{ԎqɓnB";
   HINSTANCE hLib = LoadLibrary ("libmecab.dll");

   if (hLib) {
      FPINIT  fpInit  = (FPINIT)  GetProcAddress(hLib, "mecab_new");
      FPERR   fpErr   = (FPERR)   GetProcAddress(hLib, "mecab_strerror");
      FPPARSE fpParse = (FPPARSE) GetProcAddress(hLib, "mecab_sparse_tostr");
      FPDEL   fpDel   = (FPDEL)   GetProcAddress(hLib, "mecab_destroy");
      
      if (fpInit && fpErr && fpParse && fpDel) {
	 void *c = (void *)(*fpInit)(argc, argv);
	 if (!c) {
	    fprintf (stderr, "Exception %s\n", (*fpErr)(c));
	    FreeLibrary(hLib);
	    return -1;
	 }
	 
	 printf ("INPUT: %s\n", p);
	 printf ("RESULT:\n%s", (char *)(*fpParse)(c, p));

	 (*fpDel)(c);
      }
      FreeLibrary(hLib);
   }
#endif   
   return 0;
}

