
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
/**
 * Project   : Mono
 * Namespace : System.Web.UI.MobileControls.Adapters
 * Class     : StyleStack
 * Author    : Gaurav Vaish
 *
 * Copyright : 2003 with Gaurav Vaish, and with
 *             Ximian Inc
 */

using System;
using System.Collections;
using System.Web.Mobile;

namespace System.Web.UI.MobileControls.Adapters
{
	class StyleStack
	{
		private HtmlMobileTextWriter writer;
		private Stack stack;

		protected StyleStack(HtmlMobileTextWriter writer)
		{
			this.writer = writer;
			stack = new Stack();
		}
		
		public int Count
		{
			get
			{
				return stack.Count;
			}
		}
		
		public WriterStyle Peek()
		{
			WriterStyle retVal = null;
			if(stack.Count > 0)
				retVal = (WriterStyle)stack.Peek();
			return retVal;
		}
		
		public WriterStyle Pop()
		{
			WriterStyle retVal = null;
			if(stack.Count > 0)
				retVal = (WriterStyle)stack.Pop();
			return retVal;
		}
		
		public void Push(WriterStyle style)
		{
			stack.Push(style);
			writer.ShouldEnsureStyle = true;
		}
	}
}
